/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.util.Err;
import gate.util.Files;
import gate.util.JarFiles;
import gate.util.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestFiles
extends TestCase {
    private static final boolean DEBUG = false;

    public TestFiles(String string) {
        super(string);
    }

    public void setUp() {
    }

    public void testGetResources() throws Exception {
        TestFiles.assertTrue((boolean)true);
        String string = "jape/combined/testloc.jape";
        String string2 = "// testloc.jape";
        InputStreamReader inputStreamReader = new InputStreamReader(Files.getGateResourceAsStream(string));
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        TestFiles.assertTrue((boolean)bufferedReader.readLine().equals(string2));
        inputStreamReader.close();
        String string3 = Files.getGateResourceAsString(string);
        TestFiles.assertTrue((boolean)string3.startsWith(string2));
        byte[] byArray = Files.getGateResourceAsByteArray(string);
        char[] cArray = new char[string2.length()];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)byArray[i];
        }
        string3 = new String(cArray);
        TestFiles.assertTrue((String)string3, (boolean)string3.equals(string2));
    }

    public void testWriteTempFile() throws Exception {
        TestFiles.assertTrue((boolean)true);
        String string = "jape/combined/testloc.jape";
        String string2 = "// testloc.jape";
        File file = Files.writeTempFile(Files.getGateResourceAsStream(string));
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string3 = bufferedReader.readLine();
        TestFiles.assertTrue((String)"first line from jape/combined/testloc.jape doesn't match", (boolean)string2.equals(string3));
        file.delete();
    }

    public static Test suite() {
        return new TestSuite(TestFiles.class);
    }

    public static void main(String[] stringArray) {
        TestFiles testFiles = new TestFiles("TestFiles");
        try {
            testFiles.testJarFiles();
            testFiles.testGetResources();
        }
        catch (Exception exception) {
            exception.printStackTrace(Err.getPrintWriter());
        }
    }

    public void testJarFiles() throws Exception {
        JarFiles jarFiles = new JarFiles();
        HashSet<String> hashSet = new HashSet<String>();
        String string = "jartest/ajartest.jar";
        String string2 = "jartest/bjartest.jar";
        String string3 = null;
        String string4 = null;
        String string5 = null;
        File file = null;
        File file2 = null;
        File file3 = null;
        FileInputStream fileInputStream = null;
        FileInputStream fileInputStream2 = null;
        file2 = Files.writeTempFile(Files.getGateResourceAsStream(string));
        file3 = Files.writeTempFile(Files.getGateResourceAsStream(string2));
        file = File.createTempFile("jarfinal", ".tmp");
        file.deleteOnExit();
        string3 = file2.getAbsolutePath();
        string4 = file3.getAbsolutePath();
        file2.deleteOnExit();
        file3.deleteOnExit();
        string5 = file.getAbsolutePath();
        hashSet.add(string3);
        hashSet.add(string4);
        fileInputStream = new FileInputStream(file2);
        fileInputStream2 = new FileInputStream(file3);
        fileInputStream.close();
        fileInputStream2.close();
        jarFiles.merge(hashSet, string5);
    }

    public void testFind() {
        String string = "z:/gate2/doc/.*.html";
        String string2 = "z:/gate2/doc";
        Files files = new Files();
        Set set = new HashSet();
        set = Files.Find(string, string2);
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                String string3 = iterator.next().toString();
            }
        }
    }

    public void testUpdateXmlElement() throws IOException {
        String string = Strings.getNl();
        String string2 = "GATECONFIG";
        String string3 = "<" + string2 + " FULLSIZE=\"yes\"/>";
        String string4 = "<?xml version=\"1.0\"?>" + string + "<!-- a comment -->" + string + "<GATE>" + string + "" + string + "<CREOLE-DIRECTORY>http://on.the.net/</CREOLE-DIRECTORY>" + string + "<!--- The next element may be overwritten by the GUI --->" + string;
        String string5 = "</GATE>" + string;
        String string6 = string4 + string3 + string + string5;
        TestFiles.assertTrue((String)"the GATECONFIG element doesn't match", (boolean)this.getEmptyElement(string6, string2).equals(string3));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("a", "1");
        hashMap.put("b", "2");
        hashMap.put("c", "3");
        String string7 = Files.updateXmlElement(new BufferedReader(new StringReader(string6)), string2, hashMap);
        TestFiles.assertTrue((String)("newXml doesn't match (1): " + string7.toString()), (string7.toString().startsWith(string4) && string7.toString().endsWith(string5) ? 1 : 0) != 0);
        File file = Files.writeTempFile(string6);
        string7 = Files.updateXmlElement(file, string2, hashMap);
        TestFiles.assertTrue((String)("newXml doesn't match (2): " + string7.toString()), (string7.toString().startsWith(string4) && string7.toString().endsWith(string5) ? 1 : 0) != 0);
        string7 = Files.getString(file);
        TestFiles.assertTrue((String)("newXml doesn't match (3): " + string7.toString()), (string7.toString().startsWith(string4) && string7.toString().endsWith(string5) ? 1 : 0) != 0);
    }

    String getEmptyElement(String string, String string2) {
        int n = string.indexOf("<" + string2);
        int n2 = string.indexOf(">", n);
        StringBuffer stringBuffer = new StringBuffer(string);
        String string3 = stringBuffer.substring(n, n2 + 1);
        return string3;
    }
}

