/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.AnnotationSet;
import gate.Document;
import gate.TextualDocument;

public class TestEqual {
    public static String message = "";

    public static boolean documentsEqual(Document document, Document document2) {
        message = "";
        if (document == null ^ document2 == null) {
            message = "Documents not equal: null<>non-null!";
            return false;
        }
        if (document == null) {
            return true;
        }
        if (!TestEqual.check(document.getContent(), document2.getContent())) {
            message = "Document contents different!";
            return false;
        }
        if (!TestEqual.check(document.getAnnotations(), document2.getAnnotations())) {
            message = "Documents default AS not equal!";
            return false;
        }
        if (document instanceof TextualDocument) {
            if (document2 instanceof TextualDocument) {
                if (!TestEqual.check(((TextualDocument)document).getEncoding(), ((TextualDocument)document2).getEncoding())) {
                    message = "Textual documents with different encodings!";
                    return false;
                }
            } else {
                message = "Documents not equal: textual<>non-textual!";
                return false;
            }
        }
        if (!TestEqual.check(document.getFeatures(), document2.getFeatures())) {
            message = "Documents features not equal!";
            return false;
        }
        if (!TestEqual.check(document.getNamedAnnotationSets(), document2.getNamedAnnotationSets())) {
            message = "Documents named annots not equal!";
            return false;
        }
        if (!TestEqual.check(document.getSourceUrl(), document2.getSourceUrl())) {
            message = "Documents sourceURLs not equal!";
            return false;
        }
        if (!TestEqual.check(document.getSourceUrlStartOffset(), document2.getSourceUrlStartOffset()) || !TestEqual.check(document.getSourceUrlEndOffset(), document2.getSourceUrlEndOffset())) {
            message = "Documents sourceURLOffsets not equal!";
            return false;
        }
        return true;
    }

    public static boolean annotationSetsEqual(AnnotationSet annotationSet, AnnotationSet annotationSet2) {
        if (annotationSet == null ^ annotationSet2 == null) {
            return false;
        }
        if (annotationSet == null) {
            return true;
        }
        if (annotationSet.size() != annotationSet2.size()) {
            return false;
        }
        try {
            if (!annotationSet.containsAll(annotationSet2)) {
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return TestEqual.check(annotationSet.getName(), annotationSet2.getName());
    }

    protected static boolean check(Object object, Object object2) {
        if (object == null || object2 == null) {
            return object == object2;
        }
        return object.equals(object2);
    }
}

