/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.Annotation;
import gate.Controller;
import gate.Corpus;
import gate.CreoleRegister;
import gate.DataStoreRegister;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Main;
import gate.ProcessingResource;
import gate.creole.SerialAnalyserController;
import gate.creole.ir.DefaultIndexDefinition;
import gate.creole.ir.IndexField;
import gate.creole.ir.IndexedCorpus;
import gate.creole.ir.PropertyReader;
import gate.creole.ir.lucene.LuceneIREngine;
import gate.creole.tokeniser.DefaultTokeniser;
import gate.gui.MainFrame;
import gate.persist.SerialDataStore;
import gate.util.GateException;
import gate.util.OffsetComparator;
import gate.util.Out;
import gate.util.persistence.PersistenceManager;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class Scratch {
    private static final boolean DEBUG = false;
    protected static Random randomiser = new Random();

    public static void docFromString() {
        try {
            Gate.init();
            SerialAnalyserController serialAnalyserController = (SerialAnalyserController)PersistenceManager.loadObjectFromFile(new File("d:/tmp/annie.gapp"));
            Corpus corpus = Factory.newCorpus("A Corpus");
            Document document = Factory.newDocument("US President George W Bush has said he is seeking a $600m (\u00a3323m) boost in aid to nations hit by the Asian tsunami.");
            corpus.add(document);
            serialAnalyserController.setCorpus(corpus);
            serialAnalyserController.execute();
            Iterator<Annotation> iterator = document.getAnnotations().iterator();
            while (iterator.hasNext()) {
                System.out.println(iterator.next());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("Text fg: " + UIManager.getColor("Tree.textForeground"));
        System.out.println("Text bg: " + UIManager.getColor("Tree.textBackground"));
        System.out.println("Tree fg: " + UIManager.getColor("Tree.foreground"));
        System.out.println("Tree bg: " + UIManager.getColor("Tree.background"));
        System.out.println("Tree DC fg: " + UIManager.getColor("Tree.dropCellForeground"));
        System.out.println("Tree DC bg: " + UIManager.getColor("Tree.dropCellBackground"));
        System.out.println("Tree Sel bg: " + UIManager.getColor("Tree.selectionBackground"));
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        System.out.println(uIDefaults.keySet());
    }

    public static void exitTimeHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                System.out.println("shutting down");
                System.out.flush();
                File file = new File("z:\\tmp", "GateGuiState.gzsr");
                try {
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(file)));
                    System.out.println("writing main frame");
                    System.out.flush();
                    objectOutputStream.writeObject(Main.getMainFrame());
                    objectOutputStream.close();
                }
                catch (Exception exception) {
                    System.out.println("Couldn't write to state file: " + exception);
                }
                System.out.println("done");
                System.out.flush();
            }
        });
    }

    public static void dumpGuiState() {
        System.out.println("dumping gui state...");
        System.out.flush();
        File file = new File("z:\\tmp", "GateGuiState.gzsr");
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(file)));
            MainFrame mainFrame = Main.getMainFrame();
            long l = System.currentTimeMillis();
            long l2 = System.currentTimeMillis();
            while (l2 - l < 3000L) {
                try {
                    Thread.sleep(150L);
                    l2 = System.currentTimeMillis();
                }
                catch (InterruptedException interruptedException) {}
            }
            System.out.println("writing main frame");
            System.out.flush();
            objectOutputStream.writeObject(mainFrame);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Couldn't write to state file: " + exception);
        }
        System.out.println("...done gui dump");
        System.out.flush();
    }

    public void runNerc() throws Exception {
        Closeable closeable;
        long l = System.currentTimeMillis();
        Out.prln("gate init");
        Gate.setLocalWebServer(false);
        Gate.setNetConnected(false);
        Gate.init();
        Out.prln((double)(System.currentTimeMillis() - l) / 1000.0 + " seconds");
        Out.prln("creating resources");
        Controller controller = (Controller)Factory.createResource("gate.creole.SerialController", Factory.newFeatureMap());
        controller.setName("Scratch controller");
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("sourceUrl", Gate.getUrl("tests/doc0.html"));
        featureMap.put("markupAware", "false");
        Document document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        featureMap = Factory.newFeatureMap();
        featureMap.put("tokeniserRulesURL", "gate:/creole/tokeniser/DefaultTokeniser.rules");
        featureMap.put("encoding", "UTF-8");
        featureMap.put("document", document);
        ProcessingResource processingResource = (ProcessingResource)Factory.createResource("gate.creole.tokeniser.DefaultTokeniser", featureMap);
        featureMap = Factory.newFeatureMap();
        featureMap.put("document", document);
        featureMap.put("listsURL", "gate:/creole/gazeteer/default/lists.def");
        ProcessingResource processingResource2 = (ProcessingResource)Factory.createResource("gate.creole.gazetteer.DefaultGazetteer", featureMap);
        featureMap = Factory.newFeatureMap();
        featureMap.put("document", document);
        ProcessingResource processingResource3 = (ProcessingResource)Factory.createResource("gate.creole.Transducer", featureMap);
        controller.getPRs().add(processingResource);
        controller.getPRs().add(processingResource2);
        controller.getPRs().add(processingResource3);
        Out.prln((double)(System.currentTimeMillis() - l) / 1000.0 + " seconds");
        Out.prln("dumping state");
        File file = new File("z:\\tmp", "SerialisedGateState.gzsr");
        try {
            closeable = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(file)));
            closeable.writeObject(new SessionState());
            closeable.close();
        }
        catch (IOException iOException) {
            throw new GateException("Couldn't write to state file: " + iOException);
        }
        Out.prln(System.getProperty("user.home"));
        Out.prln((double)(System.currentTimeMillis() - l) / 1000.0 + " seconds");
        Out.prln("reinstating");
        try {
            closeable = new FileInputStream(file);
            GZIPInputStream gZIPInputStream = new GZIPInputStream((InputStream)closeable);
            ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
            SessionState sessionState = (SessionState)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (IOException iOException) {
            throw new GateException("Couldn't read file " + file + ": " + iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new GateException("Couldn't find class: " + classNotFoundException);
        }
        Out.prln((double)(System.currentTimeMillis() - l) / 1000.0 + " seconds");
        Out.prln("done");
    }

    protected static int random() {
        return randomiser.nextInt(9999);
    }

    public static void createIndex() throws Exception {
        String string = "file:///d:/temp/ds";
        String string2 = "d:/temp/ds.idx";
        Gate.init();
        SerialDataStore serialDataStore = (SerialDataStore)Factory.openDataStore("gate.persist.SerialDataStore", string);
        serialDataStore.open();
        List list = serialDataStore.getLrIds("gate.corpora.SerialCorpusImpl");
        IndexedCorpus indexedCorpus = (IndexedCorpus)serialDataStore.getLr("gate.corpora.SerialCorpusImpl", list.get(0));
        DefaultIndexDefinition defaultIndexDefinition = new DefaultIndexDefinition();
        defaultIndexDefinition.setIrEngineClassName(LuceneIREngine.class.getName());
        defaultIndexDefinition.setIndexLocation(string2);
        defaultIndexDefinition.addIndexField(new IndexField("body", new ContentPropertyReader(), false));
        indexedCorpus.setIndexDefinition(defaultIndexDefinition);
        Out.prln("removing old index");
        indexedCorpus.getIndexManager().deleteIndex();
        Out.prln("building new index");
        indexedCorpus.getIndexManager().createIndex();
        Out.prln("optimising new index");
        indexedCorpus.getIndexManager().optimizeIndex();
        Out.prln("saving corpus");
        serialDataStore.sync(indexedCorpus);
        Out.prln("done!");
    }

    public static void tokeniseFile(File file) throws Exception {
        Gate.init();
        Document document = Factory.newDocument(file.toURI().toURL());
        DefaultTokeniser defaultTokeniser = (DefaultTokeniser)Factory.createResource("gate.creole.tokeniser.DefaultTokeniser");
        defaultTokeniser.setParameterValue("document", document);
        defaultTokeniser.execute();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("Token");
        hashSet.add("SpaceToken");
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>(document.getAnnotations().get(hashSet));
        Collections.sort(arrayList, new OffsetComparator());
        for (Annotation annotation : arrayList) {
            System.out.println("Annotation: (" + annotation.getStartNode().getOffset().toString() + ", " + annotation.getEndNode().getOffset().toString() + "[type: " + annotation.getType() + ", features: " + annotation.getFeatures().toString() + "]");
        }
    }

    public static class ContentPropertyReader
    implements PropertyReader {
        public String getPropertyValue(Document document) {
            return document.getContent().toString();
        }
    }

    class SessionState
    implements Serializable {
        CreoleRegister cr = Gate.getCreoleRegister();
        DataStoreRegister dsr = Gate.getDataStoreRegister();

        SessionState() {
        }
    }
}

