/*
 * Decompiled with CFR 0.152.
 */
package gate.swing;

import gate.util.ObjectComparator;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class XJTable
extends JTable {
    private boolean componentSizedProperly = false;
    protected SortingModel sortingModel;
    protected ObjectComparator defaultComparator;
    protected int sortedColumn = -1;
    protected boolean ascending = true;
    protected boolean sortable = true;
    protected List<ColumnData> columnData;
    protected HeaderMouseListener headerMouseListener;

    public XJTable() {
        this(null);
    }

    public XJTable(TableModel tableModel) {
        if (tableModel != null) {
            this.setModel(tableModel);
        }
    }

    public void setModel(TableModel tableModel) {
        this.sortingModel = new SortingModel(tableModel);
        super.setModel(this.sortingModel);
        this.newColumns();
    }

    protected void newColumns() {
        this.columnData = new ArrayList<ColumnData>(this.dataModel.getColumnCount());
        for (int i = 0; i < this.dataModel.getColumnCount(); ++i) {
            this.columnData.add(new ColumnData(i));
        }
    }

    public void setTableHeader(JTableHeader jTableHeader) {
        JTableHeader jTableHeader2 = this.getTableHeader();
        if (jTableHeader2 != null && this.headerMouseListener != null) {
            jTableHeader2.removeMouseListener(this.headerMouseListener);
        }
        super.setTableHeader(jTableHeader);
        if (this.headerMouseListener == null) {
            this.headerMouseListener = new HeaderMouseListener();
        }
        if (jTableHeader != null) {
            jTableHeader.addMouseListener(this.headerMouseListener);
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    protected void calculatePreferredSize() {
        int n;
        int n2 = this.getColumnModel().getColumnCount();
        for (n = 0; n < n2; ++n) {
            Component component;
            TableColumn tableColumn = this.getColumnModel().getColumn(n);
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            if (tableCellRenderer == null) {
                component = this.getTableHeader();
                if (component == null) {
                    component = new JTableHeader();
                }
                tableCellRenderer = ((JTableHeader)component).getDefaultRenderer();
                tableColumn.setHeaderRenderer(tableCellRenderer);
            }
            if (tableCellRenderer != null) {
                component = tableCellRenderer.getTableCellRendererComponent(this, tableColumn.getHeaderValue(), false, false, 0, 0);
                tableColumn.setMinWidth(component.getMinimumSize().width);
                tableColumn.setPreferredWidth(component.getPreferredSize().width);
                continue;
            }
            tableColumn.setMinWidth(1);
            tableColumn.setPreferredWidth(1);
        }
        for (n = 0; n < this.getRowCount(); ++n) {
            this.setRowHeight(n, 1);
        }
        for (n = 0; n < this.getRowCount(); ++n) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.prepareRenderer(this.getCellRenderer(n, i), n, i);
            }
        }
        this.componentSizedProperly = true;
    }

    public Dimension getPreferredSize() {
        if (!this.componentSizedProperly) {
            this.calculatePreferredSize();
        }
        return super.getPreferredSize();
    }

    public boolean getScrollableTracksViewportWidth() {
        if (super.getScrollableTracksViewportWidth()) {
            Container container = this.getParent();
            if (container instanceof JViewport) {
                return ((JViewport)container).getExtentSize().width >= this.getMinimumSize().width;
            }
            return true;
        }
        return false;
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Dimension dimension;
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        TableColumn tableColumn = this.getColumnModel().getColumn(n2);
        n2 = this.convertColumnIndexToModel(n2);
        ColumnData columnData = this.columnData.get(n2);
        Dimension dimension2 = this.getIntercellSpacing();
        if (columnData.isHidden()) {
            tableColumn.setMinWidth(10 + dimension2.width);
            tableColumn.setPreferredWidth(10 + dimension2.width);
        } else {
            dimension = component.getMinimumSize();
            if (tableColumn.getMinWidth() < dimension.width + dimension2.width) {
                tableColumn.setMinWidth(dimension.width + dimension2.width);
            }
            dimension = component.getPreferredSize();
            if (tableColumn.getPreferredWidth() < dimension.width + dimension2.width) {
                tableColumn.setPreferredWidth(dimension.width + dimension2.width);
            }
        }
        dimension = component.getPreferredSize();
        if (this.getRowHeight(n) < dimension.height + dimension2.height) {
            this.setRowHeight(n, dimension.height + dimension2.height);
        }
        return component;
    }

    public int rowModelToView(int n) {
        return this.sortingModel.sourceToTarget(n);
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public boolean isColumnHidden(int n) {
        return this.columnData.get(n).isHidden();
    }

    public void setAscending(boolean bl) {
        this.ascending = bl;
    }

    public int rowViewToModel(int n) {
        return this.sortingModel.targetToSource(n);
    }

    public void setComparator(int n, Comparator comparator) {
        this.columnData.get((int)n).comparator = comparator;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(boolean bl) {
        this.sortable = bl;
    }

    public int getSortedColumn() {
        return this.sortedColumn;
    }

    public void setSortedColumn(int n) {
        this.sortedColumn = n;
    }

    public int getTableRow(int n) {
        return this.sortingModel.sourceToTarget(n);
    }

    protected class ColumnData {
        JCheckBoxMenuItem autoSizeMenuItem;
        JCheckBoxMenuItem hideMenuItem;
        JPopupMenu popup;
        int column;
        int columnWidth;
        boolean hidden;
        Comparator comparator;
        private static final int HIDDEN_WIDTH = 10;

        public ColumnData(int n) {
            this.column = n;
            this.popup = new JPopupMenu();
            this.hideMenuItem = new JCheckBoxMenuItem("Hide", false);
            this.popup.add(this.hideMenuItem);
            this.hidden = false;
            this.initListeners();
        }

        protected void initListeners() {
            this.hideMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TableColumn tableColumn = XJTable.this.getColumnModel().getColumn(ColumnData.this.column);
                    if (!ColumnData.this.hideMenuItem.isSelected()) {
                        if (tableColumn.getHeaderRenderer() == null) {
                            TableCellRenderer tableCellRenderer = XJTable.this.getDefaultRenderer(Object.class);
                            if (tableCellRenderer != null) {
                                Component component = tableCellRenderer.getTableCellRendererComponent(XJTable.this, tableColumn.getHeaderValue(), false, false, 0, 0);
                                tableColumn.setMinWidth(component.getMinimumSize().width);
                                tableColumn.setPreferredWidth(component.getPreferredSize().width);
                            } else {
                                tableColumn.setMinWidth(1);
                                tableColumn.setPreferredWidth(1);
                            }
                        } else {
                            tableColumn.sizeWidthToFit();
                        }
                    }
                }
            });
        }

        public boolean isHidden() {
            return this.hideMenuItem.isSelected();
        }
    }

    protected class HeaderMouseListener
    extends MouseAdapter {
        protected HeaderMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.process(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.process(mouseEvent);
        }

        protected void process(MouseEvent mouseEvent) {
            int n = XJTable.this.columnModel.getColumnIndexAtX(mouseEvent.getX());
            if (n != -1) {
                int n2 = XJTable.this.convertColumnIndexToModel(n);
                ColumnData columnData = XJTable.this.columnData.get(n2);
                if (mouseEvent.isPopupTrigger()) {
                    columnData.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getID() == 500 && mouseEvent.getButton() == 1 && XJTable.this.sortable && n2 != -1) {
                    XJTable.this.ascending = n2 == XJTable.this.sortedColumn ? !XJTable.this.ascending : true;
                    XJTable.this.sortedColumn = n2;
                    XJTable.this.sortingModel.sort();
                }
            }
        }
    }

    protected class SortingModel
    extends AbstractTableModel
    implements TableModelListener {
        protected int[] sourceToTarget;
        protected int[] targetToSource;
        protected TableModel sourceModel;
        protected ValueHolderComparator compWrapper = new ValueHolderComparator();

        public SortingModel(TableModel tableModel) {
            this.init(tableModel);
        }

        protected void init(TableModel tableModel) {
            if (this.sourceModel != null) {
                this.sourceModel.removeTableModelListener(this);
            }
            this.sourceModel = tableModel;
            int n = tableModel.getRowCount();
            this.sourceToTarget = new int[n];
            this.targetToSource = new int[n];
            for (int i = 0; i < n; ++i) {
                this.sourceToTarget[i] = i;
                this.targetToSource[i] = i;
            }
            tableModel.addTableModelListener(this);
            if (XJTable.this.isSortable() && XJTable.this.sortedColumn == -1) {
                XJTable.this.setSortedColumn(0);
            }
            XJTable.this.componentSizedProperly = false;
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            int n = tableModelEvent.getType();
            int n2 = tableModelEvent.getFirstRow();
            int n3 = tableModelEvent.getLastRow();
            int n4 = tableModelEvent.getColumn();
            switch (n) {
                case 0: {
                    if (n2 == -1) {
                        this.init(this.sourceModel);
                        XJTable.this.newColumns();
                        this.fireTableStructureChanged();
                        if (!XJTable.this.isSortable()) break;
                        this.sort();
                        break;
                    }
                    if (n3 == Integer.MAX_VALUE) {
                        this.init(this.sourceModel);
                        if (XJTable.this.isSortable()) {
                            this.sort();
                            break;
                        }
                        this.fireTableDataChanged();
                        break;
                    }
                    if (XJTable.this.isSortable() && (n4 == XJTable.this.sortedColumn || n4 == -1)) {
                        this.sort();
                        break;
                    }
                    this.fireTableChanged(new TableModelEvent(this, this.sourceToTarget(n2), this.sourceToTarget(n3), n4, n));
                    break;
                }
                case 1: {
                    this.init(this.sourceModel);
                    if (n2 != -1 && n2 == n3) {
                        if (XJTable.this.isSortable()) {
                            this.sort();
                            break;
                        }
                        this.fireTableChanged(new TableModelEvent(this, this.sourceToTarget(n2), this.sourceToTarget(n3), n4, n));
                        break;
                    }
                    if (XJTable.this.isSortable()) {
                        this.sort();
                        break;
                    }
                    this.fireTableDataChanged();
                    break;
                }
                case -1: {
                    this.init(this.sourceModel);
                    if (XJTable.this.isSortable()) {
                        this.sort();
                        break;
                    }
                    this.fireTableDataChanged();
                }
            }
        }

        public int getRowCount() {
            return this.sourceToTarget.length;
        }

        public int getColumnCount() {
            return this.sourceModel.getColumnCount();
        }

        public String getColumnName(int n) {
            return this.sourceModel.getColumnName(n);
        }

        public Class getColumnClass(int n) {
            return this.sourceModel.getColumnClass(n);
        }

        public boolean isCellEditable(int n, int n2) {
            return this.sourceModel.isCellEditable(this.targetToSource(n), n2);
        }

        public void setValueAt(Object object, int n, int n2) {
            this.sourceModel.setValueAt(object, this.targetToSource(n), n2);
        }

        public Object getValueAt(int n, int n2) {
            try {
                return this.sourceModel.getValueAt(this.targetToSource(n), n2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
        }

        public void sort() {
            try {
                int n;
                int[] nArray = XJTable.this.getSelectedRows();
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = XJTable.this.rowViewToModel(nArray[i]);
                }
                XJTable.this.clearSelection();
                ArrayList<ValueHolder> arrayList = new ArrayList<ValueHolder>(this.sourceModel.getRowCount());
                for (int i = 0; i < this.sourceModel.getRowCount(); ++i) {
                    Object object = this.sourceModel.getValueAt(i, XJTable.this.sortedColumn);
                    arrayList.add(new ValueHolder(object, i));
                }
                Comparator comparator = XJTable.this.columnData.get((int)XJTable.this.sortedColumn).comparator;
                if (comparator == null) {
                    if (XJTable.this.defaultComparator == null) {
                        XJTable.this.defaultComparator = new ObjectComparator();
                    }
                    comparator = XJTable.this.defaultComparator;
                }
                this.compWrapper.setComparator(comparator);
                Collections.sort(arrayList, this.compWrapper);
                for (n = 0; n < arrayList.size(); ++n) {
                    int n2 = n;
                    int n3 = ((ValueHolder)arrayList.get(n)).index;
                    this.sourceToTarget[n3] = n2;
                    this.targetToSource[n2] = n3;
                }
                arrayList.clear();
                this.fireTableDataChanged();
                for (n = 0; n < nArray.length; ++n) {
                    nArray[n] = XJTable.this.rowModelToView(nArray[n]);
                    XJTable.this.getSelectionModel().addSelectionInterval(nArray[n], nArray[n]);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }

        public int sourceToTarget(int n) {
            return this.sourceToTarget[n];
        }

        public int targetToSource(int n) {
            return this.targetToSource[n];
        }

        protected void buildTargetToSourceIndex() {
            this.targetToSource = new int[this.sourceToTarget.length];
            for (int i = 0; i < this.sourceToTarget.length; ++i) {
                this.targetToSource[this.sourceToTarget[i]] = i;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class ValueHolderComparator
        implements Comparator<ValueHolder> {
            private Comparator comparator;

            protected ValueHolderComparator() {
            }

            protected Comparator getComparator() {
                return this.comparator;
            }

            protected void setComparator(Comparator comparator) {
                this.comparator = comparator;
            }

            @Override
            public int compare(ValueHolder valueHolder, ValueHolder valueHolder2) {
                return XJTable.this.ascending ? this.comparator.compare(valueHolder.value, valueHolder2.value) : this.comparator.compare(valueHolder.value, valueHolder2.value) * -1;
            }
        }

        protected class ValueHolder {
            private Object value;
            private int index;

            public ValueHolder(Object object, int n) {
                this.value = object;
                this.index = n;
            }
        }
    }
}

