/*
 * Decompiled with CFR 0.152.
 */
package gate.swing;

import gate.event.StatusListener;
import gate.gui.MainFrame;
import gate.util.Err;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class XJEditorPane
extends JEditorPane {
    protected LinkedList backUrls;
    protected LinkedList forwardUrls;
    protected Action backAction;
    protected Action forwardAction;
    private transient Vector statusListeners;

    public XJEditorPane() {
        this.init();
    }

    public XJEditorPane(String string) throws IOException {
        super(string);
        this.init();
    }

    public XJEditorPane(URL uRL) throws IOException {
        super(uRL);
        this.init();
    }

    protected void init() {
        this.initLocalData();
        this.initListeners();
    }

    protected void initLocalData() {
        this.backUrls = new LinkedList();
        this.forwardUrls = new LinkedList();
        try {
            this.backAction = new BackAction();
            this.forwardAction = new ForwardAction();
        }
        catch (IOException iOException) {
            Err.prln("Resource mising! Is your classpath OK?");
            iOException.printStackTrace(Err.getPrintWriter());
        }
    }

    protected void initListeners() {
        this.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                        HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                        HTMLDocument hTMLDocument = (HTMLDocument)XJEditorPane.this.getDocument();
                        hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
                    } else {
                        try {
                            XJEditorPane.this.backUrls.addLast(XJEditorPane.this.getPage());
                            XJEditorPane.this.forwardUrls.clear();
                            XJEditorPane.this.setPage(hyperlinkEvent.getURL());
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace(Err.getPrintWriter());
                        }
                    }
                } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    XJEditorPane.this.fireStatusChanged(hyperlinkEvent.getURL().toExternalForm());
                } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    XJEditorPane.this.fireStatusChanged("");
                }
            }
        });
    }

    public Action getForwardAction() {
        return this.forwardAction;
    }

    public Action getBackAction() {
        return this.backAction;
    }

    public void setPage(URL uRL) throws IOException {
        try {
            super.setPage(uRL);
        }
        catch (Exception exception) {
            this.fireStatusChanged(exception.toString());
            exception.printStackTrace(Err.getPrintWriter());
        }
        this.updateEnableState();
    }

    protected void updateEnableState() {
        this.forwardAction.setEnabled(!this.forwardUrls.isEmpty());
        this.backAction.setEnabled(!this.backUrls.isEmpty());
    }

    public synchronized void removeStatusListener(StatusListener statusListener) {
        if (this.statusListeners != null && this.statusListeners.contains(statusListener)) {
            Vector vector = (Vector)this.statusListeners.clone();
            vector.removeElement(statusListener);
            this.statusListeners = vector;
        }
    }

    public synchronized void addStatusListener(StatusListener statusListener) {
        Vector vector;
        Vector vector2 = vector = this.statusListeners == null ? new Vector(2) : (Vector)this.statusListeners.clone();
        if (!vector.contains(statusListener)) {
            vector.addElement(statusListener);
            this.statusListeners = vector;
        }
    }

    protected void fireStatusChanged(String string) {
        if (this.statusListeners != null) {
            Vector vector = this.statusListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((StatusListener)vector.elementAt(i)).statusChanged(string);
            }
        }
    }

    class BackAction
    extends AbstractAction {
        private BackAction() throws IOException {
            super("Back", new ImageIcon(new URL("gate:/img/back")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XJEditorPane.this.forwardUrls.addFirst(XJEditorPane.this.getPage());
            try {
                XJEditorPane.this.setPage((URL)XJEditorPane.this.backUrls.removeLast());
            }
            catch (IOException iOException) {
                iOException.printStackTrace(Err.getPrintWriter());
            }
        }
    }

    class ForwardAction
    extends AbstractAction {
        private ForwardAction() throws IOException {
            super("Forward", MainFrame.getIcon("forward"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XJEditorPane.this.backUrls.addLast(XJEditorPane.this.getPage());
            try {
                XJEditorPane.this.setPage((URL)XJEditorPane.this.forwardUrls.removeFirst());
            }
            catch (IOException iOException) {
                iOException.printStackTrace(Err.getPrintWriter());
            }
        }
    }
}

