/*
 * Decompiled with CFR 0.152.
 */
package gate.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.Serializable;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class MenuLayout
implements LayoutManager {
    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        int n = container.getComponentCount();
        Dimension[] dimensionArray = new Dimension[n];
        for (int i = 0; i < n; ++i) {
            dimensionArray[i] = container.getComponent(i).getPreferredSize();
        }
        Dimension dimension = this.getCompositeSize(container, dimensionArray);
        return dimension;
    }

    protected Dimension getCompositeSize(Container container, Dimension[] dimensionArray) {
        Object object;
        Point point = new Point(0, 0);
        if (container.isShowing()) {
            point = container.getLocationOnScreen();
        } else if (container instanceof JPopupMenu && (object = ((JPopupMenu)container).getInvoker()) != null) {
            point = ((Component)object).getLocationOnScreen();
        }
        if (point.x < 0 || point.y < 0) {
            point.x = Math.max(0, point.x);
            point.y = Math.max(0, point.y);
        }
        object = Toolkit.getDefaultToolkit();
        Rectangle rectangle = new Rectangle(((Toolkit)object).getScreenSize());
        Insets insets = new Insets(0, 0, 0, 0);
        GraphicsConfiguration graphicsConfiguration = this.findGraphicsConfiguration(container);
        if (graphicsConfiguration != null) {
            rectangle = graphicsConfiguration.getBounds();
            insets = ((Toolkit)object).getScreenInsets(graphicsConfiguration);
        }
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        rectangle.height = Math.max(point.y, rectangle.height - point.y);
        Insets insets2 = container.getInsets();
        rectangle.width -= insets2.left + insets2.right;
        rectangle.height -= insets2.top + insets2.bottom;
        Dimension dimension = new Dimension(0, 0);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < dimensionArray.length; ++i) {
            if (dimension.height + dimensionArray[i].height <= rectangle.height) {
                dimension.height += dimensionArray[i].height;
                dimension.width = Math.max(dimension.width, dimensionArray[i].width);
                continue;
            }
            n += dimension.width;
            n2 = Math.max(n2, dimension.height);
            dimension.height = dimensionArray[i].height;
            dimension.width = dimensionArray[i].width;
        }
        dimension.height = Math.max(n2, dimension.height);
        dimension.width += n;
        dimension.width += insets2.left + insets2.right;
        dimension.height += insets2.top + insets2.bottom;
        return dimension;
    }

    protected GraphicsConfiguration findGraphicsConfiguration(Component serializable) {
        Serializable serializable2;
        GraphicsConfiguration graphicsConfiguration = null;
        if (!serializable.isShowing() && serializable instanceof JPopupMenu && (serializable2 = ((JPopupMenu)serializable).getInvoker()) != null) {
            serializable = serializable2;
        }
        if (serializable.isShowing()) {
            serializable2 = serializable.getLocationOnScreen();
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            graphicsConfiguration = serializable.getGraphicsConfiguration();
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
            for (int i = 0; i < graphicsDeviceArray.length; ++i) {
                GraphicsConfiguration graphicsConfiguration2;
                if (graphicsDeviceArray[i].getType() != 0 || !(graphicsConfiguration2 = graphicsDeviceArray[i].getDefaultConfiguration()).getBounds().contains((Point)serializable2)) continue;
                graphicsConfiguration = graphicsConfiguration2;
                break;
            }
        }
        return graphicsConfiguration;
    }

    public Dimension minimumLayoutSize(Container container) {
        int n = container.getComponentCount();
        Dimension[] dimensionArray = new Dimension[n];
        for (int i = 0; i < n; ++i) {
            dimensionArray[i] = container.getComponent(i).getMinimumSize();
        }
        return this.getCompositeSize(container, dimensionArray);
    }

    public void layoutContainer(Container container) {
        int n;
        int n2;
        Insets insets = container.getInsets();
        Rectangle rectangle = container.getBounds();
        if (container.isShowing()) {
            Point point = container.getLocationOnScreen();
            if (point.x < 0 || point.y < 0) {
                Window window = SwingUtilities.getWindowAncestor(container);
                n2 = Math.max(0, point.x);
                n = Math.max(0, point.y);
                window.setLocation(n2, n);
            }
        }
        int n3 = rectangle.height - insets.bottom;
        int n4 = container.getComponentCount();
        n2 = insets.top;
        n = insets.left;
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension = component.getPreferredSize();
            component.setSize(dimension);
            if (n2 + dimension.height <= n3) {
                component.setLocation(n, n2);
                n2 += dimension.height;
                n5 = Math.max(n5, dimension.width);
                continue;
            }
            n += n5;
            n5 = 0;
            n2 = insets.top;
            component.setLocation(n, n2);
            n2 += dimension.height;
            n5 = Math.max(n5, dimension.width);
        }
    }
}

