/*
 * Decompiled with CFR 0.152.
 */
package gate.swing;

import gate.swing.TreeTableModel;
import gate.swing.XJTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;

public class JTreeTable
extends XJTable {
    protected CustomJTree tree;
    protected TreeTableModel treeTableModel;

    public JTreeTable(TreeTableModel treeTableModel) {
        this.treeTableModel = treeTableModel;
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
        super.setSortable(false);
    }

    protected void initLocalData() {
    }

    protected void initGuiComponents() {
        this.tree = new CustomJTree();
        this.tree.setModel(this.treeTableModel);
        this.tree.setEditable(false);
        super.setModel(new TreeTableModelAdapter(this.treeTableModel));
        this.tree.setSelectionModel(new DefaultTreeSelectionModel(){
            {
                JTreeTable.this.setSelectionModel(this.listSelectionModel);
            }
        });
        this.setAutoCreateColumnsFromModel(false);
        this.getColumnModel().getColumn(0).setCellRenderer(new TreeTableCellRenderer());
        this.getColumnModel().getColumn(0).setCellEditor(new TreeTableCellEditor());
        this.setShowGrid(false);
    }

    protected void initListeners() {
        this.addMouseListener(new MouseHandler());
        this.getColumnModel().getColumn(0).addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("width")) {
                    int n = ((Number)propertyChangeEvent.getNewValue()).intValue();
                    int n2 = JTreeTable.this.tree.getSize().height;
                    JTreeTable.this.tree.setSize(n, n2);
                }
            }
        });
    }

    public void setSortable(boolean bl) {
        throw new UnsupportedOperationException("A JTreeTable component cannot be sortable!\nThe rows order is defined by the tree structure.");
    }

    public JTree getTree() {
        return this.tree;
    }

    public void expandPath(TreePath treePath) {
        this.tree.expandPath(treePath);
    }

    public void expandRow(int n) {
        this.tree.expandRow(n);
    }

    class CustomJTree
    extends JTree {
        protected int visibleRow;

        CustomJTree() {
        }

        public void updateUI() {
            super.updateUI();
            this.setRowHeight(0);
        }

        public void setVisibleRow(int n) {
            this.visibleRow = n;
        }

        public void paint(Graphics graphics) {
            Rectangle rectangle = this.getRowBounds(this.visibleRow);
            Rectangle rectangle2 = graphics.getClipBounds();
            graphics.translate(0, -rectangle.y);
            graphics.setClip(rectangle2.x, rectangle.y, rectangle2.width, rectangle.height);
            super.paint(graphics);
        }

        public Dimension getPreferredSize() {
            return new Dimension(super.getPreferredSize().width, this.getRowBounds((int)this.visibleRow).height);
        }

        public void validate() {
        }

        public void revalidate() {
        }

        public void repaint(long l, int n, int n2, int n3, int n4) {
        }

        public void repaint(Rectangle rectangle) {
        }
    }

    class TreeTableModelAdapter
    extends AbstractTableModel {
        public TreeTableModelAdapter(TreeTableModel treeTableModel) {
            JTreeTable.this.tree.addTreeExpansionListener(new TreeExpansionListener(){

                public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }

                public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }
            });
            JTreeTable.this.tree.getModel().addTreeModelListener(new TreeModelListener(){

                public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }

                public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }

                public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }

                public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }
            });
        }

        public int getColumnCount() {
            return JTreeTable.this.treeTableModel.getColumnCount();
        }

        public String getColumnName(int n) {
            return JTreeTable.this.treeTableModel.getColumnName(n);
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return TreeTableModel.class;
            }
            return JTreeTable.this.treeTableModel.getColumnClass(n);
        }

        public int getRowCount() {
            return JTreeTable.this.tree.getRowCount();
        }

        protected Object nodeForRow(int n) {
            TreePath treePath = JTreeTable.this.tree.getPathForRow(n);
            return treePath.getLastPathComponent();
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return JTreeTable.this.treeTableModel;
            }
            return JTreeTable.this.treeTableModel.getValueAt(this.nodeForRow(n), n2);
        }

        public boolean isCellEditable(int n, int n2) {
            return JTreeTable.this.treeTableModel.isCellEditable(this.nodeForRow(n), n2);
        }

        public void setValueAt(Object object, int n, int n2) {
            Object object2 = this.nodeForRow(n);
            JTreeTable.this.treeTableModel.setValueAt(object, object2, n2);
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (JTreeTable.this.columnAtPoint(mouseEvent.getPoint()) == 0) {
                JTreeTable.this.tree.dispatchEvent(this.convertEvent(mouseEvent));
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (JTreeTable.this.columnAtPoint(mouseEvent.getPoint()) == 0) {
                JTreeTable.this.tree.dispatchEvent(this.convertEvent(mouseEvent));
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (JTreeTable.this.columnAtPoint(mouseEvent.getPoint()) == 0) {
                JTreeTable.this.tree.dispatchEvent(this.convertEvent(mouseEvent));
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (JTreeTable.this.columnAtPoint(mouseEvent.getPoint()) == 0) {
                JTreeTable.this.tree.dispatchEvent(this.convertEvent(mouseEvent));
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (JTreeTable.this.columnAtPoint(mouseEvent.getPoint()) == 0) {
                JTreeTable.this.tree.dispatchEvent(this.convertEvent(mouseEvent));
            }
        }

        protected MouseEvent convertEvent(MouseEvent mouseEvent) {
            int n = 0;
            int n2 = JTreeTable.this.rowAtPoint(mouseEvent.getPoint());
            Rectangle rectangle = JTreeTable.this.getCellRect(n2, n, false);
            Rectangle rectangle2 = JTreeTable.this.tree.getRowBounds(n2);
            int n3 = 0;
            if (rectangle != null) {
                n3 = -rectangle.x;
            }
            int n4 = 0;
            if (rectangle != null && rectangle2 != null) {
                n4 = rectangle2.y - rectangle.y;
            }
            mouseEvent.translatePoint(n3, n4);
            return new MouseEvent(JTreeTable.this.tree, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        }
    }

    class TreeTableCellEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        TreeCellEditor editor;
        Component editorComponent;

        TreeTableCellEditor() {
            super(new JTextField());
            this.editor = JTreeTable.this.tree.getCellEditor();
            this.setClickCountToStart(0);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.editor = JTreeTable.this.tree.getCellEditor();
            this.editor.addCellEditorListener(new CellEditorListener(){

                public void editingStopped(ChangeEvent changeEvent) {
                    TreeTableCellEditor.this.fireEditingStopped();
                }

                public void editingCanceled(ChangeEvent changeEvent) {
                    TreeTableCellEditor.this.fireEditingCanceled();
                }
            });
            this.editorComponent = this.editor.getTreeCellEditorComponent(JTreeTable.this.tree, JTreeTable.this.tree.getPathForRow(n).getLastPathComponent(), bl, JTreeTable.this.tree.isExpanded(n), JTreeTable.this.tree.getModel().isLeaf(JTreeTable.this.tree.getPathForRow(n).getLastPathComponent()), n);
            Box box = Box.createHorizontalBox();
            box.add(Box.createHorizontalStrut(JTreeTable.this.tree.getRowBounds((int)n).x));
            box.add(this.editorComponent);
            return box;
        }

        public Object getCellEditorValue() {
            return this.editor == null ? null : this.editor.getCellEditorValue();
        }

        public boolean stopCellEditing() {
            return this.editor == null ? true : this.editor.stopCellEditing();
        }

        public void cancelCellEditing() {
            if (this.editor != null) {
                this.editor.cancelCellEditing();
            }
        }
    }

    public class TreeTableCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTreeTable.this.tree.setVisibleRow(n);
            return JTreeTable.this.tree;
        }
    }
}

