/*
 * Decompiled with CFR 0.152.
 */
package gate.swing;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class JFontChooser
extends JPanel {
    JComboBox familyCombo;
    JCheckBox italicChk;
    JCheckBox boldChk;
    JComboBox sizeCombo;
    JTextArea sampleTextArea;
    private Font fontValue;

    public JFontChooser() {
        this(UIManager.getFont("Button.font"));
    }

    public JFontChooser(Font font) {
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
        this.setFontValue(font);
    }

    public static Font showDialog(Component component, String string, Font font) {
        Window window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        if (window == null) {
            throw new IllegalArgumentException("The supplied parent component has no window ancestor");
        }
        final JDialog jDialog = window instanceof Frame ? new JDialog((Frame)window, string, true) : new JDialog((Dialog)window, string, true);
        jDialog.getContentPane().setLayout(new BoxLayout(jDialog.getContentPane(), 1));
        final JFontChooser jFontChooser = new JFontChooser(font);
        jDialog.getContentPane().add(jFontChooser);
        JButton jButton = new JButton("OK");
        JButton jButton2 = new JButton("Cancel");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jButton);
        jPanel.add(Box.createHorizontalStrut(30));
        jPanel.add(jButton2);
        jPanel.add(Box.createHorizontalGlue());
        jDialog.getContentPane().add(jPanel);
        jDialog.pack();
        jFontChooser.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                jDialog.pack();
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
                jFontChooser.setFontValue(null);
            }
        });
        jDialog.setVisible(true);
        return jFontChooser.getFontValue();
    }

    protected void initLocalData() {
    }

    protected void initGuiComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.familyCombo = new JComboBox<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        this.familyCombo.setSelectedItem(UIManager.getFont("Label.font").getFamily());
        this.sizeCombo = new JComboBox<String>(new String[]{"6", "8", "10", "12", "14", "16", "18", "20", "22", "24", "26"});
        this.sizeCombo.setSelectedItem(new Integer(UIManager.getFont("Label.font").getSize()).toString());
        this.italicChk = new JCheckBox("<html><i>Italic</i></html>", false);
        this.boldChk = new JCheckBox("<html><i=b>Bold</b></html>", false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.familyCombo);
        jPanel.add(this.sizeCombo);
        jPanel.setBorder(BorderFactory.createTitledBorder(" Font "));
        this.add(jPanel);
        this.add(Box.createVerticalStrut(10));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.italicChk);
        jPanel2.add(this.boldChk);
        jPanel2.setBorder(BorderFactory.createTitledBorder(" Effects "));
        this.add(jPanel2);
        this.add(Box.createVerticalStrut(10));
        this.sampleTextArea = new JTextArea("Type your sample here...");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(this.sampleTextArea);
        jPanel3.setBorder(BorderFactory.createTitledBorder(" Sample "));
        this.add(jPanel3);
        this.add(Box.createVerticalStrut(10));
    }

    protected void initListeners() {
        this.familyCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFontChooser.this.updateFont();
            }
        });
        this.sizeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFontChooser.this.updateFont();
            }
        });
        this.boldChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFontChooser.this.updateFont();
            }
        });
        this.italicChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFontChooser.this.updateFont();
            }
        });
    }

    protected void updateFont() {
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
        hashMap.put(TextAttribute.FAMILY, (String)this.familyCombo.getSelectedItem());
        hashMap.put(TextAttribute.SIZE, new Float((String)this.sizeCombo.getSelectedItem()));
        if (this.boldChk.isSelected()) {
            hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        } else {
            hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
        }
        if (this.italicChk.isSelected()) {
            hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        } else {
            hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
        }
        Font font = new Font(hashMap);
        Font font2 = this.fontValue;
        this.fontValue = font;
        this.sampleTextArea.setFont(font);
        String string = this.sampleTextArea.getText();
        this.sampleTextArea.setText("");
        this.sampleTextArea.setText(string);
        this.sampleTextArea.repaint(100L);
        this.firePropertyChange("fontValue", font2, font);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        final JFrame jFrame = new JFrame("Foo frame");
        jFrame.setDefaultCloseOperation(2);
        JButton jButton = new JButton("Show dialog");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println(JFontChooser.showDialog(jFrame, "Fonter", UIManager.getFont("Button.font")));
            }
        });
        jFrame.getContentPane().add(jButton);
        jFrame.setSize(new Dimension(300, 300));
        jFrame.setVisible(true);
        System.out.println("Font: " + UIManager.getFont("Button.font"));
        JFontChooser.showDialog(jFrame, "Fonter", UIManager.getFont("Button.font"));
    }

    public void setFontValue(Font font) {
        this.boldChk.setSelected(font.isBold());
        this.italicChk.setSelected(font.isItalic());
        this.familyCombo.setSelectedItem(font.getName());
        this.sizeCombo.setSelectedItem(Integer.toString(font.getSize()));
        this.fontValue = font;
    }

    public Font getFontValue() {
        return this.fontValue;
    }
}

