/*
 * Decompiled with CFR 0.152.
 */
package gate.security;

import gate.event.GateEvent;
import gate.event.ObjectModificationEvent;
import gate.event.ObjectModificationListener;
import gate.persist.DBHelper;
import gate.persist.PersistenceException;
import gate.security.AccessControllerImpl;
import gate.security.Group;
import gate.security.SecurityException;
import gate.security.Session;
import gate.security.User;
import gate.util.MethodNotImplementedException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import junit.framework.Assert;

public class UserImpl
implements User,
ObjectModificationListener {
    private Long id;
    private String name;
    private List groups;
    private Connection conn;
    private int dbType;
    private AccessControllerImpl ac;
    private Vector omModificationListeners;
    private Vector omCreationListeners;
    private Vector omDeletionListeners;

    public UserImpl(Long l, String string, List list, AccessControllerImpl accessControllerImpl, Connection connection) {
        this.id = l;
        this.name = string;
        this.groups = list;
        this.ac = accessControllerImpl;
        this.conn = connection;
        try {
            String string2 = connection.getMetaData().getURL();
            this.dbType = DBHelper.getDatabaseType(string2);
            Assert.assertTrue((this.dbType == 101 || this.dbType == 102 ? 1 : 0) != 0);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.omModificationListeners = new Vector();
        this.omCreationListeners = new Vector();
        this.omDeletionListeners = new Vector();
        this.ac.registerObjectModificationListener(this, 1002);
    }

    public Long getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List getGroups() {
        Vector vector = new Vector();
        vector.addAll(this.groups);
        return vector;
    }

    public void setName(String string, Session session) throws PersistenceException, SecurityException {
        Object object;
        block11: {
            block12: {
                PreparedStatement preparedStatement;
                block10: {
                    if (!this.ac.isValidSession(session)) {
                        throw new SecurityException("invalid session supplied");
                    }
                    if (session.getID() != this.id && !session.isPrivilegedSession()) {
                        throw new SecurityException("insufficient privileges");
                    }
                    CallableStatement callableStatement = null;
                    preparedStatement = null;
                    if (this.dbType != 101) break block10;
                    try {
                        callableStatement = this.conn.prepareCall("{ call gateadmin.security.set_user_name(?,?)} ");
                        callableStatement.setLong(1, (long)this.id);
                        callableStatement.setString(2, string);
                        callableStatement.execute();
                    }
                    catch (SQLException sQLException) {
                        try {
                            throw new PersistenceException("can't change user name in DB: [" + sQLException.getMessage() + "]");
                        }
                        catch (Throwable throwable) {
                            DBHelper.cleanup(callableStatement);
                            throw throwable;
                        }
                    }
                    DBHelper.cleanup(callableStatement);
                    break block11;
                }
                if (this.dbType != 102) break block12;
                try {
                    object = "select security_set_user_name(?,?)";
                    preparedStatement = this.conn.prepareStatement((String)object);
                    preparedStatement.setLong(1, this.id);
                    preparedStatement.setString(2, string);
                    preparedStatement.execute();
                }
                catch (SQLException sQLException) {
                    try {
                        throw new PersistenceException("can't change user name in DB: [" + sQLException.getMessage() + "]");
                    }
                    catch (Throwable throwable) {
                        DBHelper.cleanup(preparedStatement);
                        throw throwable;
                    }
                }
                DBHelper.cleanup(preparedStatement);
                break block11;
            }
            throw new IllegalArgumentException();
        }
        object = new ObjectModificationEvent(this, 1001, 1001);
        this.name = string;
        this.fireObjectModifiedEvent((ObjectModificationEvent)object);
    }

    public void setPassword(String string, Session session) throws PersistenceException, SecurityException {
        block11: {
            block12: {
                PreparedStatement preparedStatement;
                block10: {
                    if (!this.ac.isValidSession(session)) {
                        throw new SecurityException("invalid session supplied");
                    }
                    if (!session.isPrivilegedSession() && session.getID() != this.id) {
                        throw new SecurityException("insuffieicent privileges");
                    }
                    CallableStatement callableStatement = null;
                    preparedStatement = null;
                    if (this.dbType != 101) break block10;
                    try {
                        callableStatement = this.conn.prepareCall("{ call gateadmin.security.set_user_password(?,?)} ");
                        callableStatement.setLong(1, (long)this.id);
                        callableStatement.setString(2, string);
                        callableStatement.execute();
                    }
                    catch (SQLException sQLException) {
                        try {
                            throw new PersistenceException("can't change user password in DB: [" + sQLException.getMessage() + "]");
                        }
                        catch (Throwable throwable) {
                            DBHelper.cleanup(callableStatement);
                            throw throwable;
                        }
                    }
                    DBHelper.cleanup(callableStatement);
                    break block11;
                }
                if (this.dbType != 102) break block12;
                try {
                    String string2 = "select security_set_user_password(?,?)";
                    preparedStatement = this.conn.prepareStatement(string2);
                    preparedStatement.setLong(1, this.id);
                    preparedStatement.setString(2, string);
                    preparedStatement.execute();
                }
                catch (SQLException sQLException) {
                    try {
                        throw new PersistenceException("can't change user password in DB: [" + sQLException.getMessage() + "]");
                    }
                    catch (Throwable throwable) {
                        DBHelper.cleanup(preparedStatement);
                        throw throwable;
                    }
                }
                DBHelper.cleanup(preparedStatement);
                break block11;
            }
            throw new IllegalArgumentException();
        }
    }

    public boolean equals(Object object) {
        Assert.assertTrue((boolean)(object instanceof User));
        User user = (User)object;
        return this.id.equals(user.getID());
    }

    public void registerObjectModificationListener(ObjectModificationListener objectModificationListener, int n) {
        if (n != 1002 && n != 1001) {
            throw new IllegalArgumentException();
        }
        switch (n) {
            case 1000: {
                this.omCreationListeners.add(objectModificationListener);
                break;
            }
            case 1002: {
                this.omDeletionListeners.add(objectModificationListener);
                break;
            }
            case 1001: {
                this.omModificationListeners.add(objectModificationListener);
                break;
            }
            default: {
                Assert.fail();
            }
        }
    }

    public void unregisterObjectModificationListener(ObjectModificationListener objectModificationListener, int n) {
        if (n != 1002 && n != 1001) {
            throw new IllegalArgumentException();
        }
        switch (n) {
            case 1000: {
                this.omCreationListeners.remove(objectModificationListener);
                break;
            }
            case 1002: {
                this.omDeletionListeners.remove(objectModificationListener);
                break;
            }
            case 1001: {
                this.omModificationListeners.remove(objectModificationListener);
                break;
            }
            default: {
                Assert.fail();
            }
        }
    }

    private void fireObjectModifiedEvent(ObjectModificationEvent objectModificationEvent) {
        if (objectModificationEvent.getType() != 1001) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.omModificationListeners.size(); ++i) {
            ((ObjectModificationListener)this.omModificationListeners.elementAt(i)).objectModified(objectModificationEvent);
        }
    }

    public void objectCreated(ObjectModificationEvent objectModificationEvent) {
    }

    public void objectModified(ObjectModificationEvent objectModificationEvent) {
        Assert.assertTrue((objectModificationEvent.getSubType() == 1002 || objectModificationEvent.getSubType() == 1003 || objectModificationEvent.getSubType() == 1001 ? 1 : 0) != 0);
        Group group = (Group)objectModificationEvent.getSource();
        switch (objectModificationEvent.getSubType()) {
            case 1002: {
                Assert.assertTrue((false == this.groups.contains(group) ? 1 : 0) != 0);
                Assert.assertTrue((boolean)(group instanceof Group));
                this.groups.add(group);
                break;
            }
            case 1003: {
                Assert.assertTrue((true == this.groups.contains(group) ? 1 : 0) != 0);
                this.groups.remove(group);
                break;
            }
            case 1001: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void objectDeleted(ObjectModificationEvent objectModificationEvent) {
        Group group;
        if (objectModificationEvent.getSource() instanceof Group && this.groups.contains(group = (Group)objectModificationEvent.getSource())) {
            this.groups.remove(group);
        }
    }

    public void processGateEvent(GateEvent gateEvent) {
        throw new MethodNotImplementedException();
    }

    void setGroups(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Long l = (Long)vector.elementAt(i);
            Group group = null;
            try {
                group = this.ac.findGroup(l);
            }
            catch (SecurityException securityException) {
                Assert.fail();
            }
            catch (PersistenceException persistenceException) {
                Assert.fail();
            }
            Assert.assertNotNull((Object)group);
            Assert.assertTrue((boolean)(group instanceof Group));
            this.groups.add(group);
        }
    }
}

