/*
 * Decompiled with CFR 0.152.
 */
package gate.security;

import gate.DataStoreRegister;
import gate.Factory;
import gate.Gate;
import gate.security.AccessController;
import gate.security.Group;
import gate.security.SecurityException;
import gate.security.Session;
import gate.security.User;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSecurity
extends TestCase {
    private static final boolean DEBUG = false;
    private static final int ADMIN_GROUP_ID = 0;
    private static final int ADMIN_USER_ID = 0;
    private static final int SUAHILI_GROUP_ID = 101;
    private static final int ENGLISH_GROUP_ID = 101;
    private static String JDBC_URL;
    private boolean exceptionThrown = false;

    public TestSecurity(String string) throws GateException {
        super(string);
    }

    public void setUp() throws Exception {
        if (!DataStoreRegister.getConfigData().containsKey("url-test")) {
            throw new GateRuntimeException("DB URL not configured in gate.xml");
        }
        JDBC_URL = (String)DataStoreRegister.getConfigData().get("url-test");
    }

    public void tearDown() throws Exception {
    }

    public void testSecurityTables() throws Exception {
        AccessController accessController = Factory.createAccessController(JDBC_URL);
        accessController.open();
        User user = accessController.findUser("kalina");
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((String)user.getName(), (String)"kalina");
        List list = user.getGroups();
        Assert.assertNotNull((Object)list);
        for (int i = 0; i < list.size(); ++i) {
            Group group = (Group)list.get(i);
            if (i == 0) {
                Assert.assertEquals((String)group.getName(), (String)"English Language Group");
                continue;
            }
            if (i != 1) continue;
            Assert.assertEquals((String)group.getName(), (String)"Suahili Group");
        }
        Session session = accessController.login("kalina", "sesame", accessController.findGroup("English Language Group").getID());
        Assert.assertNotNull((Object)session);
    }

    public void testUserGroupManipulation() throws Exception {
        Object object;
        User user;
        AccessController accessController = Factory.createAccessController(JDBC_URL);
        accessController.open();
        List list = accessController.listGroups();
        Assert.assertNotNull((Object)list);
        List list2 = accessController.listUsers();
        Assert.assertNotNull((Object)list2);
        Session session = accessController.login("ADMIN", "sesame", new Long(0L));
        Assert.assertNotNull((Object)session);
        Assert.assertTrue((true == accessController.isValidSession(session) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)session.isPrivilegedSession());
        try {
            user = accessController.createUser("myUser", "myPassword", session);
        }
        catch (SecurityException securityException) {
            session = accessController.login("ADMIN", "sesame", accessController.findGroup("ADMINS").getID());
            Assert.assertTrue((boolean)session.isPrivilegedSession());
            user = accessController.createUser("myUser", "myPassword", session);
        }
        Assert.assertNotNull((Object)accessController.findUser("myUser"));
        Assert.assertEquals((Object)user, (Object)accessController.findUser("myUser"));
        Assert.assertEquals((String)user.getName(), (String)accessController.findUser("myUser").getName());
        Group group = accessController.createGroup("myGroup", session);
        Assert.assertNotNull((Object)accessController.findGroup("myGroup"));
        Assert.assertEquals((Object)group, (Object)accessController.findGroup("myGroup"));
        Assert.assertEquals((String)group.getName(), (String)"myGroup");
        group.addUser(user, session);
        Assert.assertTrue((boolean)group.getUsers().contains(user));
        Assert.assertTrue((boolean)user.getGroups().contains(group));
        String string = group.getName();
        group.setName("my new group", session);
        Assert.assertEquals((String)"my new group", (String)group.getName());
        Assert.assertNotNull((Object)accessController.findGroup("my new group"));
        this.exceptionThrown = false;
        try {
            accessController.findGroup(string);
        }
        catch (SecurityException securityException) {
            this.exceptionThrown = true;
        }
        Assert.assertTrue((boolean)this.exceptionThrown);
        string = user.getName();
        user.setName("my new user", session);
        Assert.assertEquals((String)"my new user", (String)user.getName());
        Assert.assertNotNull((Object)accessController.findUser("my new user"));
        this.exceptionThrown = false;
        try {
            accessController.findUser(string);
        }
        catch (SecurityException securityException) {
            this.exceptionThrown = true;
        }
        Assert.assertTrue((boolean)this.exceptionThrown);
        user.setName(string, session);
        List list3 = group.getUsers();
        Assert.assertNotNull((Object)list3);
        for (int i = 0; i < list3.size(); ++i) {
            object = accessController.findUser(((User)list3.get(i)).getID());
            Assert.assertTrue((boolean)object.getGroups().contains(group));
        }
        group.setName("my new group again", session);
        Assert.assertEquals((String)"my new group again", (String)group.getName());
        Session session2 = accessController.login("myUser", "myPassword", accessController.findGroup("my new group again").getID());
        Assert.assertNotNull((Object)session2);
        Assert.assertTrue((true == accessController.isValidSession(session2) ? 1 : 0) != 0);
        accessController.logout(session2);
        Assert.assertTrue((false == accessController.isValidSession(session2) ? 1 : 0) != 0);
        this.exceptionThrown = false;
        try {
            group.removeUser(user, session2);
        }
        catch (SecurityException securityException) {
            this.exceptionThrown = true;
        }
        Assert.assertTrue((true == this.exceptionThrown ? 1 : 0) != 0);
        session2 = accessController.login("myUser", "myPassword", accessController.findGroup("my new group again").getID());
        Assert.assertNotNull((Object)session2);
        Assert.assertTrue((true == accessController.isValidSession(session2) ? 1 : 0) != 0);
        accessController.deleteGroup(group, session);
        this.exceptionThrown = false;
        try {
            accessController.findGroup(group.getName());
        }
        catch (SecurityException securityException) {
            this.exceptionThrown = true;
        }
        Assert.assertTrue((boolean)this.exceptionThrown);
        Assert.assertTrue((false == user.getGroups().contains(group) ? 1 : 0) != 0);
        Assert.assertTrue((false == accessController.isValidSession(session2) ? 1 : 0) != 0);
        object = accessController.findGroup(new Long(101L));
        Assert.assertNotNull((Object)object);
        object.addUser(user, session);
        Assert.assertTrue((boolean)object.getUsers().contains(user));
        Assert.assertTrue((boolean)user.getGroups().contains(object));
        Session session3 = accessController.login("myUser", "myPassword", object.getID());
        Assert.assertTrue((boolean)accessController.isValidSession(session3));
        accessController.deleteUser(user, session);
        this.exceptionThrown = false;
        try {
            accessController.findUser(user.getName());
        }
        catch (SecurityException securityException) {
            this.exceptionThrown = true;
        }
        Assert.assertTrue((boolean)this.exceptionThrown);
        Assert.assertTrue((false == object.getUsers().contains(user) ? 1 : 0) != 0);
        Assert.assertTrue((false == accessController.isValidSession(session3) ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(TestSecurity.class);
    }

    public static void main(String[] stringArray) {
        try {
            Gate.setLocalWebServer(false);
            Gate.setNetConnected(false);
            Gate.init();
            TestSecurity testSecurity = new TestSecurity("");
            testSecurity.setUp();
            testSecurity.testSecurityTables();
            testSecurity.tearDown();
            testSecurity.setUp();
            testSecurity.testUserGroupManipulation();
            testSecurity.tearDown();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

