/*
 * Decompiled with CFR 0.152.
 */
package gate.persist;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Corpus;
import gate.DataStore;
import gate.DataStoreRegister;
import gate.Document;
import gate.DocumentContent;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.LanguageResource;
import gate.Resource;
import gate.annotation.AnnotationSetImpl;
import gate.corpora.DatabaseCorpusImpl;
import gate.corpora.DatabaseDocumentImpl;
import gate.corpora.DocumentContentImpl;
import gate.corpora.DocumentImpl;
import gate.corpora.EventAwareDocument;
import gate.corpora.TestDocument;
import gate.creole.AbstractResource;
import gate.event.DatastoreListener;
import gate.persist.DBHelper;
import gate.persist.DatabaseDataStore;
import gate.persist.Dummy;
import gate.persist.JDBCDataStore;
import gate.persist.OracleDataStore;
import gate.persist.PersistenceException;
import gate.persist.PostgresDataStore;
import gate.persist.SerialDataStore;
import gate.security.AccessController;
import gate.security.Group;
import gate.security.SecurityInfo;
import gate.security.Session;
import gate.security.User;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.SimpleFeatureMapImpl;
import gate.util.TestEqual;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestPersist
extends TestCase {
    private static String JDBC_URL_1;
    private static String JDBC_URL_2;
    private static String JDBC_URL;
    private static final boolean DEBUG = false;
    private static Long sampleDoc_lrID;
    private static Long sampleCorpus_lrID;
    private static Corpus sampleCorpus;
    private static int dbType;
    private static AnnotationSet sample_defaultASet;
    private static String sample_name;
    private static FeatureMap sample_docFeatures;
    private static URL sample_sourceURL;
    private static Long sample_startOffset;
    private static Long sample_endOffset;
    private static Boolean sample_markupAware;
    private static DocumentContent sample_content;
    private static String sample_encoding;
    private static Map sample_namedASets;
    private static final String UNICODE_STRING = "\u0915\u0932\u094d\u0907\u0928\u0643\u0637\u0628\u041a\u0430\u043b\u0438\u043d\u0430 Kalina";
    private static final String ASCII_STRING = "Never mistake motion for action (Ernest Hemingway)";
    private final String VERY_LONG_STRING = "The memory of Father came back to her. Ever since she had seen him retreat from those twelve-year-old boys she often imagined him in this situation: he is on a sinking ship; there are only a few lifeboats and there isn't enough room for everyone; there is a furious stampede on the deck. At first Father rushes along with the others, but when he sees how they push and shove, ready to trample each other under foot, and a wild-eyed woman strikes him with her fist because he is in her way, he suddenly stops and steps aside. And in the end he merely watches the overloaded lifeboats as they are slowly lowered amid shouts and curses, towards the raging waves. [p.111-113]";

    public TestPersist(String string) throws GateException {
        super(string);
    }

    public void setUp() throws Exception {
        if (!DataStoreRegister.getConfigData().containsKey("url-test")) {
            throw new GateRuntimeException("DB URL not configured in gate.xml");
        }
        JDBC_URL_1 = (String)DataStoreRegister.getConfigData().get("url-test");
        JDBC_URL_2 = (String)DataStoreRegister.getConfigData().get("url-test1");
    }

    public void tearDown() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaveRestore() throws Exception {
        File file = File.createTempFile("TestPersist__", "__StorageDir");
        file.delete();
        file.mkdir();
        SerialDataStore serialDataStore = new SerialDataStore(file.toURI().toURL().toString());
        serialDataStore.create();
        serialDataStore.open();
        String string = TestDocument.getTestServerName();
        TestPersist.assertNotNull((Object)string);
        Document document = Factory.newDocument(new URL(string + "tests/doc0.html"));
        TestPersist.assertNotNull((Object)document);
        document.getFeatures().put("hi there", new Integer(23232));
        document.getAnnotations().add(new Long(0L), new Long(20L), "thingymajig", Factory.newFeatureMap());
        boolean bl = false;
        try {
            serialDataStore.sync(document);
        }
        catch (PersistenceException persistenceException) {
            bl = true;
        }
        if (!bl) {
            TestPersist.assertTrue((String)"doc synced ok before adoption", (boolean)false);
        }
        document.setDataStore(new SerialDataStore(new File("z:\\").toURI().toURL().toString()));
        try {
            serialDataStore.adopt(document, null);
        }
        catch (PersistenceException persistenceException) {
            bl = true;
        }
        if (!bl) {
            TestPersist.assertTrue((String)"doc adopted but in other datastore already", (boolean)false);
        }
        document.setDataStore(null);
        document.setName("Alicia Tonbridge, a Document");
        Document document2 = (Document)serialDataStore.adopt(document, null);
        serialDataStore.sync(document2);
        Object object = document2.getLRPersistenceId();
        List list = serialDataStore.getLrTypes();
        TestPersist.assertTrue((String)"wrong number of types in SDS", (list.size() == 1 ? 1 : 0) != 0);
        TestPersist.assertTrue((String)"wrong type LR in SDS", (boolean)list.get(0).equals("gate.corpora.DocumentImpl"));
        Iterator iterator = serialDataStore.getLrNames("gate.corpora.DocumentImpl").iterator();
        String string2 = (String)iterator.next();
        TestPersist.assertEquals((String)string2, (String)"Alicia Tonbridge, a Document");
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("LRPersistenceId", object);
        featureMap.put("DataStore", serialDataStore);
        Document document3 = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        Document document4 = (Document)serialDataStore.getLr("gate.corpora.DocumentImpl", object);
        try {
            boolean bl2 = TestEqual.documentsEqual(document4, document3);
            TestPersist.assertTrue((String)TestEqual.message, (boolean)bl2);
            bl2 = TestEqual.documentsEqual(document2, document3);
            TestPersist.assertTrue((String)TestEqual.message, (boolean)bl2);
        }
        finally {
            serialDataStore.delete();
        }
    }

    public void testSimple() throws Exception {
        File file = File.createTempFile("TestPersist__", "__StorageDir");
        file.delete();
        DataStore dataStore = Factory.createDataStore("gate.persist.SerialDataStore", file.toURI().toURL().toString());
        List list = dataStore.getLrTypes();
        String string = TestDocument.getTestServerName();
        Document document = Factory.newDocument(new URL(string + "tests/doc0.html"));
        document.getFeatures().put("hi there", new Integer(23232));
        document.getAnnotations().add(new Long(5L), new Long(25L), "ThingyMaJig", Factory.newFeatureMap());
        Document document2 = (Document)dataStore.adopt(document, null);
        dataStore.sync(document2);
        Object object = document2.getLRPersistenceId();
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("LRPersistenceId", object);
        featureMap.put("DataStore", dataStore);
        Document document3 = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        TestPersist.assertTrue((boolean)TestEqual.documentsEqual(document2, document3));
        dataStore.delete();
    }

    public void testMultipleLrs() throws Exception {
        Object object;
        Object object2;
        Object object32;
        File file = File.createTempFile("TestPersist__", "__StorageDir");
        file.delete();
        SerialDataStore serialDataStore = new SerialDataStore(file.toURI().toURL().toString());
        serialDataStore.create();
        serialDataStore.open();
        String string = TestDocument.getTestServerName();
        Document document = Factory.newDocument(new URL(string + "tests/doc0.html"));
        document.getFeatures().put("hi there", new Integer(23232));
        document.getAnnotations().add(new Long(5L), new Long(25L), "ThingyMaJig", Factory.newFeatureMap());
        Document document2 = Factory.newDocument(new URL(string + "tests/html/test1.htm"));
        document.getFeatures().put("hi there again", new Integer(23232));
        document.getAnnotations().add(new Long(5L), new Long(25L), "dog poo irritates", Factory.newFeatureMap());
        Corpus corpus = Factory.newCorpus("Hamish test corpus");
        corpus.add(document);
        corpus.add(document2);
        LanguageResource languageResource = serialDataStore.adopt(corpus, null);
        serialDataStore.sync(languageResource);
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        List list = serialDataStore.getLrIds("gate.corpora.SerialCorpusImpl");
        for (Object object32 : list) {
            object2 = Factory.newFeatureMap();
            object2.put("DataStore", serialDataStore);
            object2.put("LRPersistenceId", object32);
            object = Factory.createResource("gate.corpora.SerialCorpusImpl", (FeatureMap)object2);
            arrayList.add((Resource)object);
        }
        object32 = (Corpus)arrayList.get(0);
        object2 = (Document)object32.get(0);
        TestPersist.assertTrue((String)"corp name != mem name", (boolean)corpus.getName().equals(object32.getName()));
        TestPersist.assertTrue((String)"corp feat != mem feat", (boolean)corpus.getFeatures().equals(object32.getFeatures()));
        TestPersist.assertTrue((String)"doc annotations from disk not equal to memory version", (boolean)TestEqual.annotationSetsEqual(document.getAnnotations(), object2.getAnnotations()));
        TestPersist.assertTrue((String)"doc from disk not equal to memory version", (boolean)TestEqual.documentsEqual(document, (Document)object2));
        object = object32.iterator();
        while (object.hasNext()) {
            object.next();
        }
        serialDataStore.delete();
    }

    public void testDelete() throws Exception {
        File file = File.createTempFile("TestPersist__", "__StorageDir");
        file.delete();
        SerialDataStore serialDataStore = new SerialDataStore();
        serialDataStore.setStorageUrl(file.toURI().toURL().toString());
        serialDataStore.create();
        serialDataStore.open();
        String string = TestDocument.getTestServerName();
        Document document = Factory.newDocument(new URL(string + "tests/doc0.html"));
        document.getFeatures().put("hi there", new Integer(23232));
        document.getAnnotations().add(new Long(5L), new Long(25L), "ThingyMaJig", Factory.newFeatureMap());
        Document document2 = (Document)serialDataStore.adopt(document, null);
        serialDataStore.sync(document2);
        Object object = document2.getLRPersistenceId();
        serialDataStore.delete("gate.corpora.DocumentImpl", object);
        TestPersist.assertTrue((serialDataStore.getLrIds("gate.corpora.DocumentImpl").size() == 0 ? 1 : 0) != 0);
        serialDataStore.delete();
    }

    public void testDSR() throws Exception {
        DataStoreRegister dataStoreRegister = Gate.getDataStoreRegister();
        TestPersist.assertTrue((String)("DSR has wrong number elements (not 0): " + dataStoreRegister.size()), (dataStoreRegister.size() == 0 ? 1 : 0) != 0);
        File file = File.createTempFile("TestPersist__", "__StorageDir");
        file.delete();
        DataStore dataStore = Factory.createDataStore("gate.persist.SerialDataStore", file.toURI().toURL().toString());
        String string = TestDocument.getTestServerName();
        Document document = Factory.newDocument(new URL(string + "tests/doc0.html"));
        document.getFeatures().put("hi there", new Integer(23232));
        document.getAnnotations().add(new Long(5L), new Long(25L), "ThingyMaJig", Factory.newFeatureMap());
        Document document2 = (Document)dataStore.adopt(document, null);
        dataStore.sync(document2);
        TestPersist.assertTrue((String)("DSR has wrong number elements (expected 1): " + dataStoreRegister.size()), (dataStoreRegister.size() == 1 ? 1 : 0) != 0);
        file = File.createTempFile("TestPersist__", "__StorageDir");
        file.delete();
        DataStore dataStore2 = Factory.createDataStore("gate.persist.SerialDataStore", file.toURI().toURL().toString());
        TestPersist.assertTrue((String)("DSR has wrong number elements: " + dataStoreRegister.size()), (dataStoreRegister.size() == 2 ? 1 : 0) != 0);
        for (DataStore dataStore3 : dataStoreRegister) {
            TestPersist.assertNotNull((String)"null ds in ds reg", (Object)dataStore3);
        }
        dataStore.close();
        TestPersist.assertTrue((String)("DSR has wrong number elements (expected 1): " + dataStoreRegister.size()), (dataStoreRegister.size() == 1 ? 1 : 0) != 0);
        dataStore.delete();
        TestPersist.assertTrue((String)("DSR has wrong number elements (expected 1): " + dataStoreRegister.size()), (dataStoreRegister.size() == 1 ? 1 : 0) != 0);
        dataStore2.delete();
        TestPersist.assertTrue((String)("DSR has wrong number elements (expected 0): " + dataStoreRegister.size()), (dataStoreRegister.size() == 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(TestPersist.class);
    }

    private Document createTestDocument() throws Exception {
        String string = TestDocument.getTestServerName();
        TestPersist.assertNotNull((Object)string);
        Document document = Factory.newDocument(new URL(string + "tests/doc0.html"));
        TestPersist.assertNotNull((Object)document);
        document.getFeatures().put("hi there", new Integer(23232));
        document.getFeatures().put("LONG STRING feature", this.VERY_LONG_STRING);
        document.getFeatures().put("NULL feature", null);
        document.getFeatures().put("BINARY feature", new Dummy(101, "101", true, 101.101f));
        document.getFeatures().put("LONG feature", new Long(101L));
        document.getFeatures().put("ASCII feature", ASCII_STRING);
        document.getFeatures().put("UNICODE feature", UNICODE_STRING);
        Vector<String> vector = new Vector<String>();
        vector.add("string 1");
        vector.add("string 2");
        vector.add("string 3");
        vector.add("string 4");
        vector.add("string 5");
        document.getFeatures().put("complex feature", vector);
        FeatureMap featureMap = Factory.newFeatureMap();
        document.getAnnotations().add(new Long(0L), new Long(20L), "thingymajig", featureMap);
        document.setName("DB test Document---");
        return document;
    }

    private Corpus createTestCorpus() throws Exception {
        String string = TestDocument.getTestServerName();
        TestPersist.assertNotNull((Object)string);
        Document document = Factory.newDocument(new URL(string + "tests/doc0.html"));
        TestPersist.assertNotNull((Object)document);
        document.getFeatures().put("hi there", new Integer(23232));
        document.getAnnotations().add(new Long(0L), new Long(20L), "thingymajig", Factory.newFeatureMap());
        document.setName("DB test Document1");
        Document document2 = Factory.newDocument(new URL(string + "tests/html/test1.htm"));
        document2.getFeatures().put("hi there again", new Integer(23232));
        document2.getAnnotations().add(new Long(5L), new Long(25L), "dog poo irritates", Factory.newFeatureMap());
        document2.setName("DB test Document2");
        Corpus corpus = Factory.newCorpus("My test corpus");
        corpus.add(document);
        corpus.add(document2);
        corpus.getFeatures().put("my STRING feature ", new String("string string"));
        corpus.getFeatures().put("my BOOL feature ", new Boolean("false"));
        corpus.getFeatures().put("my INT feature ", new Integer("1234"));
        corpus.getFeatures().put("my LONG feature ", new Long("123456789"));
        corpus.getFeatures().put("my LONG STRING feature", this.VERY_LONG_STRING);
        corpus.getFeatures().put("my NULL feature", null);
        corpus.getFeatures().put("my BINARY feature", new Dummy(101, "101", true, 101.101f));
        return corpus;
    }

    private DatabaseDataStore _createDS() {
        JDBCDataStore jDBCDataStore = null;
        if (dbType == 101) {
            jDBCDataStore = new OracleDataStore();
        } else if (dbType == 102) {
            jDBCDataStore = new PostgresDataStore();
        } else {
            throw new IllegalArgumentException();
        }
        Assert.assertNotNull((Object)jDBCDataStore);
        return jDBCDataStore;
    }

    private void prepareDB(String string) {
        JDBC_URL = JDBC_URL_1.indexOf(string) > 0 ? JDBC_URL_1 : JDBC_URL_2;
        Assert.assertNotNull((String)"jdbc url not set for Oracle or Postgres", (Object)JDBC_URL);
        dbType = DBHelper.getDatabaseType(JDBC_URL);
    }

    private void _testDB_UseCase01() throws Exception {
        Object object2;
        DatabaseDataStore databaseDataStore = this._createDS();
        Assert.assertNotNull((Object)databaseDataStore);
        databaseDataStore.setStorageUrl(JDBC_URL);
        databaseDataStore.open();
        Document document = this.createTestDocument();
        Assert.assertNotNull((Object)document);
        AccessController accessController = Factory.createAccessController(JDBC_URL);
        accessController.open();
        Assert.assertNotNull((Object)accessController);
        User user = accessController.findUser("kalina");
        Assert.assertNotNull((Object)user);
        Group group = (Group)user.getGroups().get(0);
        Assert.assertNotNull((Object)group);
        Session session = accessController.login("kalina", "sesame", group.getID());
        Assert.assertNotNull((Object)session);
        Assert.assertTrue((boolean)accessController.isValidSession(session));
        SecurityInfo securityInfo = new SecurityInfo(1, user, group);
        databaseDataStore.setSession(session);
        sample_defaultASet = new AnnotationSetImpl(document.getAnnotations());
        sample_name = document.getName();
        sample_docFeatures = document.getFeatures();
        sample_sourceURL = document.getSourceUrl();
        sample_startOffset = document.getSourceUrlStartOffset();
        sample_endOffset = document.getSourceUrlEndOffset();
        sample_markupAware = document.getMarkupAware();
        sample_content = document.getContent();
        sample_encoding = (String)document.getParameterValue("encoding");
        sample_namedASets = new HashMap();
        Map map = document.getNamedAnnotationSets();
        for (Object object2 : map.keySet()) {
            AnnotationSet annotationSet = (AnnotationSet)map.get(object2);
            AnnotationSetImpl annotationSetImpl = new AnnotationSetImpl(annotationSet);
            sample_namedASets.put(annotationSet.getName(), annotationSetImpl);
        }
        object2 = databaseDataStore.adopt(document, securityInfo);
        Assert.assertTrue((boolean)(object2 instanceof DatabaseDocumentImpl));
        Assert.assertNotNull((Object)object2.getDataStore());
        Assert.assertTrue((boolean)(object2.getDataStore() instanceof DatabaseDataStore));
        Assert.assertEquals((Object)sample_defaultASet, (Object)((DatabaseDocumentImpl)object2).getAnnotations());
        sampleDoc_lrID = (Long)object2.getLRPersistenceId();
        accessController.close();
        databaseDataStore.close();
    }

    private void _testDB_UseCase02() throws Exception {
        Object object3;
        Object object22;
        LanguageResource languageResource = null;
        DatabaseDataStore databaseDataStore = this._createDS();
        Assert.assertNotNull((Object)databaseDataStore);
        databaseDataStore.setStorageUrl(JDBC_URL);
        databaseDataStore.open();
        AccessController accessController = Factory.createAccessController(JDBC_URL);
        Assert.assertNotNull((Object)accessController);
        accessController.open();
        User user = accessController.findUser("kalina");
        Assert.assertNotNull((Object)user);
        Group group = (Group)user.getGroups().get(0);
        Assert.assertNotNull((Object)group);
        Session session = accessController.login("kalina", "sesame", group.getID());
        Assert.assertNotNull((Object)session);
        Assert.assertTrue((boolean)accessController.isValidSession(session));
        SecurityInfo securityInfo = new SecurityInfo(1, user, group);
        databaseDataStore.setSession(session);
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("DataStore", databaseDataStore);
        featureMap.put("LRPersistenceId", sampleDoc_lrID);
        languageResource = (LanguageResource)Factory.createResource("gate.corpora.DatabaseDocumentImpl", featureMap);
        String string = languageResource.getName();
        Assert.assertNotNull((Object)string);
        Assert.assertEquals((String)string, (String)sample_name);
        FeatureMap featureMap2 = languageResource.getFeatures();
        Assert.assertNotNull((Object)featureMap2);
        Assert.assertNotNull((Object)sample_docFeatures);
        Assert.assertTrue((featureMap2.size() == sample_docFeatures.size() ? 1 : 0) != 0);
        for (Object object22 : featureMap2.keySet()) {
            Assert.assertTrue((boolean)sample_docFeatures.containsKey(object22));
            Assert.assertEquals(featureMap2.get(object22), sample_docFeatures.get(object22));
        }
        object22 = (DatabaseDocumentImpl)languageResource;
        Assert.assertEquals((Object)((DocumentImpl)object22).getSourceUrl(), (Object)sample_sourceURL);
        Assert.assertEquals((Object)((DocumentImpl)object22).getSourceUrlStartOffset(), (Object)sample_startOffset);
        Assert.assertEquals((Object)((DocumentImpl)object22).getSourceUrlEndOffset(), (Object)sample_endOffset);
        Assert.assertEquals((Object)((DocumentImpl)object22).getMarkupAware(), (Object)sample_markupAware);
        DocumentContent documentContent = ((DatabaseDocumentImpl)object22).getContent();
        Assert.assertEquals((Object)documentContent, (Object)sample_content);
        Assert.assertEquals((Object)documentContent, (Object)sample_content);
        String string2 = (String)((AbstractResource)object22).getParameterValue("encoding");
        String string3 = sample_encoding;
        Assert.assertEquals((String)string2, (String)string3);
        AnnotationSet annotationSet = ((DatabaseDocumentImpl)object22).getAnnotations();
        AnnotationSet annotationSet2 = sample_defaultASet;
        Assert.assertNotNull((Object)annotationSet);
        Assert.assertTrue((annotationSet.size() == annotationSet2.size() ? 1 : 0) != 0);
        Assert.assertEquals((Object)annotationSet, (Object)annotationSet2);
        for (Object object3 : sample_namedASets.keySet()) {
            AnnotationSet annotationSet3 = (AnnotationSet)sample_namedASets.get(object3);
            Object object4 = ((DatabaseDocumentImpl)object22).getAnnotations((String)object3);
            Assert.assertNotNull((Object)object4);
            Assert.assertTrue((object4.size() == annotationSet3.size() ? 1 : 0) != 0);
            Assert.assertEquals((Object)object4.get(), (Object)annotationSet3.get());
        }
        object3 = ((DatabaseDocumentImpl)object22).getNamedAnnotationSets();
        Assert.assertNotNull((Object)object3);
        Assert.assertTrue((object3.size() == sample_namedASets.size() ? 1 : 0) != 0);
        for (Object object4 : object3.keySet()) {
            AnnotationSet annotationSet4 = (AnnotationSet)object3.get(object4);
            AnnotationSet annotationSet5 = (AnnotationSet)sample_namedASets.get(object4);
            Assert.assertNotNull((Object)annotationSet4);
            Assert.assertNotNull((Object)annotationSet5);
            Assert.assertEquals((Object)annotationSet4.get(), (Object)annotationSet5.get());
        }
        databaseDataStore.removeDatastoreListener((DatastoreListener)((Object)languageResource));
        languageResource = null;
        databaseDataStore.close();
        accessController.close();
    }

    private void _testDB_UseCase03() throws Exception {
        Object object;
        Object object2;
        Object object32;
        LanguageResource languageResource = null;
        AccessController accessController = Factory.createAccessController(JDBC_URL);
        Assert.assertNotNull((Object)accessController);
        accessController.open();
        User user = accessController.findUser("kalina");
        Assert.assertNotNull((Object)user);
        Group group = (Group)user.getGroups().get(0);
        Assert.assertNotNull((Object)group);
        Session session = accessController.login("kalina", "sesame", group.getID());
        Assert.assertNotNull((Object)session);
        Assert.assertTrue((boolean)accessController.isValidSession(session));
        DatabaseDataStore databaseDataStore = this._createDS();
        Assert.assertNotNull((Object)databaseDataStore);
        databaseDataStore.setStorageUrl(JDBC_URL);
        databaseDataStore.open();
        databaseDataStore.setSession(session);
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("DataStore", databaseDataStore);
        featureMap.put("LRPersistenceId", sampleDoc_lrID);
        languageResource = (LanguageResource)Factory.createResource("gate.corpora.DatabaseDocumentImpl", featureMap);
        Document document = (Document)languageResource;
        Document document2 = null;
        if (!databaseDataStore.lockLr(languageResource)) {
            throw new PersistenceException("document is locked by another user");
        }
        String string = document.getName();
        String string2 = string + "__UPD";
        document.setName(string2);
        document.sync();
        featureMap.clear();
        featureMap.put("DataStore", databaseDataStore);
        featureMap.put("LRPersistenceId", sampleDoc_lrID);
        document2 = (Document)Factory.createResource("gate.corpora.DatabaseDocumentImpl", featureMap);
        Assert.assertEquals((String)string2, (String)document.getName());
        Assert.assertEquals((String)string2, (String)document2.getName());
        Factory.deleteResource(document2);
        document2 = null;
        FeatureMap featureMap2 = document.getFeatures();
        for (Object object32 : featureMap2.keySet()) {
            object2 = featureMap2.get(object32);
            object = null;
            if (object2 instanceof Long) {
                object = new Long(101010101L);
            } else if (object2 instanceof Integer) {
                object = new Integer(2121212);
            } else if (object2 instanceof String) {
                object = new String("UPD__").concat((String)object2).concat("__UPD");
            }
            if (object == null) continue;
            featureMap2.put(object32, object);
        }
        document.sync();
        featureMap.clear();
        featureMap.put("DataStore", databaseDataStore);
        featureMap.put("LRPersistenceId", sampleDoc_lrID);
        document2 = (Document)Factory.createResource("gate.corpora.DatabaseDocumentImpl", featureMap);
        Assert.assertEquals((Object)featureMap2, (Object)document.getFeatures());
        Assert.assertEquals((Object)featureMap2, (Object)document2.getFeatures());
        Factory.deleteResource(document2);
        document2 = null;
        object32 = document.getSourceUrl();
        object2 = null;
        object2 = new URL(((URL)object32).toString() + ".UPDATED");
        document.setSourceUrl((URL)object2);
        document.sync();
        featureMap.clear();
        featureMap.put("DataStore", databaseDataStore);
        featureMap.put("LRPersistenceId", sampleDoc_lrID);
        document2 = (Document)Factory.createResource("gate.corpora.DatabaseDocumentImpl", featureMap);
        Assert.assertEquals(object2, (Object)document.getSourceUrl());
        Assert.assertEquals(object2, (Object)document2.getSourceUrl());
        Factory.deleteResource(document2);
        document2 = null;
        object = new Long(123L);
        Long l = new Long(789L);
        document.setSourceUrlStartOffset((Long)object);
        document.setSourceUrlEndOffset(l);
        document.sync();
        featureMap.clear();
        featureMap.put("DataStore", databaseDataStore);
        featureMap.put("LRPersistenceId", sampleDoc_lrID);
        document2 = (Document)Factory.createResource("gate.corpora.DatabaseDocumentImpl", featureMap);
        Assert.assertEquals((Object)object, (Object)document.getSourceUrlStartOffset());
        Assert.assertEquals((Object)object, (Object)document2.getSourceUrlStartOffset());
        Assert.assertEquals((Object)l, (Object)document.getSourceUrlEndOffset());
        Assert.assertEquals((Object)l, (Object)document2.getSourceUrlEndOffset());
        Factory.deleteResource(document2);
        document2 = null;
        Boolean bl = document.getMarkupAware();
        Boolean bl2 = bl != false ? Boolean.FALSE : Boolean.TRUE;
        document.setMarkupAware(bl2);
        document.sync();
        featureMap.clear();
        featureMap.put("DataStore", databaseDataStore);
        featureMap.put("LRPersistenceId", sampleDoc_lrID);
        document2 = (Document)Factory.createResource("gate.corpora.DatabaseDocumentImpl", featureMap);
        Assert.assertEquals((Object)bl2, (Object)document2.getMarkupAware());
        Assert.assertEquals((Object)bl2, (Object)document.getMarkupAware());
        Factory.deleteResource(document2);
        document2 = null;
        DocumentContent documentContent = document.getContent();
        DocumentContentImpl documentContentImpl = new DocumentContentImpl(new String("UPDATED__").concat(documentContent.toString().concat("__UPDATED")));
        document.setContent(documentContentImpl);
        document.sync();
        featureMap.clear();
        featureMap.put("DataStore", databaseDataStore);
        featureMap.put("LRPersistenceId", sampleDoc_lrID);
        document2 = (Document)Factory.createResource("gate.corpora.DatabaseDocumentImpl", featureMap);
        Assert.assertEquals((Object)documentContentImpl, (Object)document.getContent());
        Assert.assertEquals((Object)documentContentImpl, (Object)document2.getContent());
        Factory.deleteResource(document2);
        document2 = null;
        String string3 = (String)document.getParameterValue("encoding");
        document.setParameterValue("encoding", "XXX");
        document.sync();
        featureMap.clear();
        featureMap.put("DataStore", databaseDataStore);
        featureMap.put("LRPersistenceId", sampleDoc_lrID);
        document2 = (Document)Factory.createResource("gate.corpora.DatabaseDocumentImpl", featureMap);
        String string4 = (String)document2.getParameterValue("encoding");
        Assert.assertEquals((String)string4, (String)string3);
        Factory.deleteResource(document2);
        document2 = null;
        AnnotationSet annotationSet = document.getAnnotations("TEST SET");
        Assert.assertNotNull((Object)annotationSet);
        SimpleFeatureMapImpl simpleFeatureMapImpl = new SimpleFeatureMapImpl();
        simpleFeatureMapImpl.put("string key", "string value");
        Integer n = annotationSet.add(new Long(0L), new Long(10L), "TEST TYPE", (FeatureMap)simpleFeatureMapImpl);
        document.sync();
        featureMap.clear();
        featureMap.put("DataStore", databaseDataStore);
        featureMap.put("LRPersistenceId", sampleDoc_lrID);
        document2 = (Document)Factory.createResource("gate.corpora.DatabaseDocumentImpl", featureMap);
        AnnotationSet annotationSet2 = document2.getAnnotations("TEST SET");
        Assert.assertTrue((annotationSet.size() == annotationSet2.size() ? 1 : 0) != 0);
        Factory.deleteResource(document2);
        document2 = null;
        Annotation annotation = annotationSet.get(n);
        SimpleFeatureMapImpl simpleFeatureMapImpl2 = new SimpleFeatureMapImpl();
        simpleFeatureMapImpl2.put("string2", "uuuuuu");
        simpleFeatureMapImpl2.put("int2", new Integer(98989898));
        Integer n2 = annotationSet.add(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset(), annotation.getType() + "__XX", (FeatureMap)simpleFeatureMapImpl2);
        Annotation annotation2 = annotationSet.get(n2);
        document.sync();
        featureMap.clear();
        featureMap.put("DataStore", databaseDataStore);
        featureMap.put("LRPersistenceId", sampleDoc_lrID);
        document2 = (Document)Factory.createResource("gate.corpora.DatabaseDocumentImpl", featureMap);
        annotationSet2 = document2.getAnnotations("TEST SET");
        Assert.assertTrue((annotationSet.size() == annotationSet2.size() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)TestEqual.annotationSetsEqual(annotationSet2, annotationSet));
        Assert.assertTrue((boolean)annotationSet2.contains(annotation2));
        Factory.deleteResource(document2);
        document2 = null;
        String string5 = "--NO--SUCH--SET--";
        AnnotationSet annotationSet3 = document.getAnnotations(string5);
        annotationSet3.addAll(document.getAnnotations());
        document.sync();
        featureMap.clear();
        featureMap.put("DataStore", databaseDataStore);
        featureMap.put("LRPersistenceId", sampleDoc_lrID);
        document2 = (Document)Factory.createResource("gate.corpora.DatabaseDocumentImpl", featureMap);
        Assert.assertTrue((boolean)document.getNamedAnnotationSets().containsKey(string5));
        Assert.assertTrue((boolean)document2.getNamedAnnotationSets().containsKey(string5));
        AnnotationSet annotationSet4 = (AnnotationSet)document.getNamedAnnotationSets().get(string5);
        AnnotationSet annotationSet5 = (AnnotationSet)document2.getNamedAnnotationSets().get(string5);
        Assert.assertTrue((boolean)document.getNamedAnnotationSets().containsValue(annotationSet3));
        Assert.assertTrue((boolean)TestEqual.annotationSetsEqual(annotationSet4, annotationSet5));
        Assert.assertTrue((document.getNamedAnnotationSets().size() == document2.getNamedAnnotationSets().size() ? 1 : 0) != 0);
        Factory.deleteResource(document2);
        document2 = null;
        document.removeAnnotationSet(string5);
        document.sync();
        Assert.assertTrue((false == ((EventAwareDocument)((Object)document)).getLoadedAnnotationSets().contains(string5) ? 1 : 0) != 0);
        Assert.assertTrue((false == document.getNamedAnnotationSets().containsKey(string5) ? 1 : 0) != 0);
        featureMap.clear();
        featureMap.put("DataStore", databaseDataStore);
        featureMap.put("LRPersistenceId", sampleDoc_lrID);
        document2 = (Document)Factory.createResource("gate.corpora.DatabaseDocumentImpl", featureMap);
        Assert.assertTrue((false == document2.getNamedAnnotationSets().containsKey(string5) ? 1 : 0) != 0);
        Factory.deleteResource(document2);
        document2 = null;
        databaseDataStore.unlockLr(languageResource);
        databaseDataStore.sync(languageResource);
        Factory.deleteResource(document);
        document = null;
        accessController.close();
        databaseDataStore.close();
    }

    private void _testDB_UseCase04() throws Exception {
        LanguageResource languageResource = null;
        AccessController accessController = Factory.createAccessController(JDBC_URL);
        Assert.assertNotNull((Object)accessController);
        accessController.open();
        User user = accessController.findUser("kalina");
        Assert.assertNotNull((Object)user);
        Group group = (Group)user.getGroups().get(0);
        Assert.assertNotNull((Object)group);
        Session session = accessController.login("kalina", "sesame", group.getID());
        Assert.assertNotNull((Object)session);
        Assert.assertTrue((boolean)accessController.isValidSession(session));
        DatabaseDataStore databaseDataStore = this._createDS();
        Assert.assertNotNull((Object)databaseDataStore);
        databaseDataStore.setStorageUrl(JDBC_URL);
        databaseDataStore.open();
        databaseDataStore.setSession(session);
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("DataStore", databaseDataStore);
        featureMap.put("LRPersistenceId", sampleDoc_lrID);
        languageResource = (LanguageResource)Factory.createResource("gate.corpora.DatabaseDocumentImpl", featureMap);
        if (!databaseDataStore.lockLr(languageResource)) {
            throw new PersistenceException("document is locked by another user");
        }
        databaseDataStore.delete("gate.corpora.DatabaseDocumentImpl", languageResource.getLRPersistenceId());
        databaseDataStore.close();
        accessController.close();
    }

    private void _testDB_UseCase101() throws Exception {
        AccessController accessController = Factory.createAccessController(JDBC_URL);
        Assert.assertNotNull((Object)accessController);
        accessController.open();
        User user = accessController.findUser("kalina");
        Assert.assertNotNull((Object)user);
        Group group = (Group)user.getGroups().get(0);
        Assert.assertNotNull((Object)group);
        Session session = accessController.login("kalina", "sesame", group.getID());
        Assert.assertNotNull((Object)session);
        Assert.assertTrue((boolean)accessController.isValidSession(session));
        DatabaseDataStore databaseDataStore = this._createDS();
        Assert.assertNotNull((Object)databaseDataStore);
        databaseDataStore.setStorageUrl(JDBC_URL);
        databaseDataStore.open();
        databaseDataStore.setSession(session);
        Corpus corpus = this.createTestCorpus();
        Assert.assertNotNull((Object)corpus);
        SecurityInfo securityInfo = new SecurityInfo(1, user, group);
        Corpus corpus2 = (Corpus)databaseDataStore.adopt(corpus, securityInfo);
        Assert.assertNotNull((Object)corpus2);
        Assert.assertTrue((boolean)(corpus2 instanceof DatabaseCorpusImpl));
        Assert.assertNotNull((Object)corpus2.getLRPersistenceId());
        sampleCorpus = corpus2;
        sampleCorpus_lrID = (Long)corpus2.getLRPersistenceId();
        accessController.close();
        databaseDataStore.close();
    }

    private void _testDB_UseCase102() throws Exception {
        LanguageResource languageResource = null;
        AccessController accessController = Factory.createAccessController(JDBC_URL);
        Assert.assertNotNull((Object)accessController);
        accessController.open();
        User user = accessController.findUser("kalina");
        Assert.assertNotNull((Object)user);
        Group group = (Group)user.getGroups().get(0);
        Assert.assertNotNull((Object)group);
        Session session = accessController.login("kalina", "sesame", group.getID());
        Assert.assertNotNull((Object)session);
        Assert.assertTrue((boolean)accessController.isValidSession(session));
        DatabaseDataStore databaseDataStore = this._createDS();
        Assert.assertNotNull((Object)databaseDataStore);
        databaseDataStore.setStorageUrl(JDBC_URL);
        databaseDataStore.open();
        databaseDataStore.setSession(session);
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("DataStore", databaseDataStore);
        featureMap.put("LRPersistenceId", sampleCorpus_lrID);
        languageResource = (LanguageResource)Factory.createResource("gate.corpora.DatabaseCorpusImpl", featureMap);
        String string = languageResource.getName();
        Assert.assertNotNull((Object)string);
        Assert.assertEquals((String)string, (String)sampleCorpus.getName());
        FeatureMap featureMap2 = languageResource.getFeatures();
        FeatureMap featureMap3 = sampleCorpus.getFeatures();
        Assert.assertNotNull((Object)featureMap2);
        Assert.assertNotNull((Object)featureMap3);
        Assert.assertTrue((featureMap2.size() == featureMap3.size() ? 1 : 0) != 0);
        for (String string2 : featureMap2.keySet()) {
            Assert.assertTrue((boolean)featureMap3.containsKey(string2));
            Assert.assertEquals(featureMap2.get(string2), featureMap3.get(string2));
        }
        databaseDataStore.close();
    }

    private void _testDB_UseCase103() throws Exception {
        LanguageResource languageResource = null;
        AccessController accessController = Factory.createAccessController(JDBC_URL);
        Assert.assertNotNull((Object)accessController);
        accessController.open();
        User user = accessController.findUser("kalina");
        Assert.assertNotNull((Object)user);
        Group group = (Group)user.getGroups().get(0);
        Assert.assertNotNull((Object)group);
        Session session = accessController.login("kalina", "sesame", group.getID());
        Assert.assertNotNull((Object)session);
        Assert.assertTrue((boolean)accessController.isValidSession(session));
        DatabaseDataStore databaseDataStore = this._createDS();
        Assert.assertNotNull((Object)databaseDataStore);
        databaseDataStore.setStorageUrl(JDBC_URL);
        databaseDataStore.open();
        databaseDataStore.setSession(session);
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("DataStore", databaseDataStore);
        featureMap.put("LRPersistenceId", sampleCorpus_lrID);
        languageResource = (LanguageResource)Factory.createResource("gate.corpora.DatabaseCorpusImpl", featureMap);
        Corpus corpus = (Corpus)languageResource;
        Corpus corpus2 = null;
        String string = corpus.getName();
        String string2 = string + "__UPD";
        corpus.setName(string2);
        corpus.sync();
        corpus2 = (Corpus)databaseDataStore.getLr("gate.corpora.DatabaseCorpusImpl", sampleCorpus_lrID);
        Assert.assertEquals((String)string2, (String)corpus.getName());
        Assert.assertEquals((String)string2, (String)corpus2.getName());
        FeatureMap featureMap2 = corpus.getFeatures();
        for (String string3 : featureMap2.keySet()) {
            Object v = featureMap2.get(string3);
            Object object = null;
            if (v instanceof Long) {
                object = new Long(101010101L);
            } else if (v instanceof Integer) {
                object = new Integer(2121212);
            } else if (v instanceof String) {
                object = new String("UPD__").concat((String)v).concat("__UPD");
            }
            if (object == null) continue;
            featureMap2.put(string3, object);
        }
        corpus.sync();
        corpus2 = (Corpus)databaseDataStore.getLr("gate.corpora.DatabaseCorpusImpl", sampleCorpus_lrID);
        Assert.assertEquals((Object)featureMap2, (Object)corpus.getFeatures());
        Assert.assertEquals((Object)featureMap2, (Object)corpus2.getFeatures());
        databaseDataStore.close();
    }

    public static void main(String[] stringArray) {
        try {
            Gate.setLocalWebServer(false);
            Gate.setNetConnected(false);
            Gate.init();
            TestPersist testPersist = new TestPersist("");
            testPersist.setUp();
            testPersist.testDelete();
            testPersist.tearDown();
            testPersist.setUp();
            testPersist.testDSR();
            testPersist.tearDown();
            testPersist.setUp();
            testPersist.testMultipleLrs();
            testPersist.tearDown();
            testPersist.setUp();
            testPersist.tearDown();
            testPersist.setUp();
            testPersist.testSimple();
            testPersist.tearDown();
            testPersist.setUp();
            testPersist.testMultipleLrs();
            testPersist.tearDown();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        sampleDoc_lrID = null;
        sampleCorpus_lrID = null;
        sampleCorpus = null;
        sample_defaultASet = null;
        sample_name = null;
        sample_docFeatures = null;
        sample_sourceURL = null;
        sample_startOffset = null;
        sample_endOffset = null;
        sample_markupAware = null;
        sample_content = null;
        sample_encoding = null;
        sample_namedASets = null;
    }
}

