/*
 * Decompiled with CFR 0.152.
 */
package gate.persist;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Corpus;
import gate.Document;
import gate.DocumentContent;
import gate.FeatureMap;
import gate.LanguageResource;
import gate.Node;
import gate.corpora.DatabaseCorpusImpl;
import gate.corpora.DatabaseDocumentImpl;
import gate.persist.DBHelper;
import gate.persist.DatabaseDataStore;
import gate.persist.JDBCDataStore;
import gate.persist.PersistenceException;
import gate.security.SecurityException;
import gate.security.SecurityInfo;
import gate.util.MethodNotImplementedException;
import gate.util.SimpleFeatureMapImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import junit.framework.Assert;

public class PostgresDataStore
extends JDBCDataStore {
    private static final String DS_COMMENT = "GATE PostgreSQL datastore";
    public static final String DS_ICON_NAME = "pgsql_ds";
    private static final boolean DEBUG = true;

    public PostgresDataStore() {
        this.datastoreComment = DS_COMMENT;
        this.iconName = DS_ICON_NAME;
    }

    public void setSecurityInfo(LanguageResource languageResource, SecurityInfo securityInfo) throws PersistenceException, SecurityException {
        throw new MethodNotImplementedException();
    }

    public List findLrIds(List list, String string) throws PersistenceException {
        throw new MethodNotImplementedException();
    }

    public List findLrIds(List list) throws PersistenceException {
        throw new MethodNotImplementedException();
    }

    public void unlockLr(LanguageResource languageResource) throws PersistenceException, SecurityException {
        Assert.assertNotNull((Object)languageResource);
        Assert.assertTrue((languageResource instanceof DatabaseDocumentImpl || languageResource instanceof DatabaseCorpusImpl ? 1 : 0) != 0);
        Assert.assertNotNull((Object)languageResource.getLRPersistenceId());
        Assert.assertEquals((Object)languageResource.getDataStore(), (Object)this);
        if (null == this.session) {
            throw new SecurityException("session not set");
        }
        if (!this.ac.isValidSession(this.session)) {
            throw new SecurityException("invalid session supplied");
        }
        if (!this.canWriteLR(languageResource.getLRPersistenceId())) {
            throw new SecurityException("no write access granted to the user");
        }
        PreparedStatement preparedStatement = null;
        boolean bl = false;
        try {
            String string = " select persist_unlock_lr(?,?) ";
            preparedStatement = this.jdbcConn.prepareStatement(string);
            preparedStatement.setLong(1, (Long)languageResource.getLRPersistenceId());
            preparedStatement.setLong(2, this.session.getUser().getID());
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            try {
                switch (sQLException.getErrorCode()) {
                    case 20106: {
                        throw new PersistenceException("invalid LR ID supplied [" + sQLException.getMessage() + "]");
                    }
                }
                throw new PersistenceException("can't unlock LR in DB : [" + sQLException.getMessage() + "]");
            }
            catch (Throwable throwable) {
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
        }
        DBHelper.cleanup(preparedStatement);
    }

    protected boolean canAccessLR(Long l, int n) throws PersistenceException, SecurityException {
        boolean bl;
        Assert.assertTrue((0 == n || 1 == n ? 1 : 0) != 0);
        if (null == this.session) {
            throw new SecurityException("user session not set");
        }
        if (!this.ac.isValidSession(this.session)) {
            throw new SecurityException("invalid session supplied");
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string = "select security_has_access_to_lr(?,?,?,?)";
            preparedStatement = this.jdbcConn.prepareStatement(string);
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, this.session.getUser().getID());
            preparedStatement.setLong(3, this.session.getGroup().getID());
            preparedStatement.setLong(4, n);
            preparedStatement.execute();
            resultSet = preparedStatement.getResultSet();
            if (!resultSet.next()) {
                throw new PersistenceException("empty result set");
            }
            bl = resultSet.getBoolean(1);
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException("can't check permissions in DB: [" + sQLException.getMessage() + "]");
            }
            catch (Throwable throwable) {
                DBHelper.cleanup(resultSet);
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(preparedStatement);
        return bl;
    }

    public boolean lockLr(LanguageResource languageResource) throws PersistenceException, SecurityException {
        Assert.assertNotNull((Object)languageResource);
        Assert.assertTrue((languageResource instanceof DatabaseDocumentImpl || languageResource instanceof DatabaseCorpusImpl ? 1 : 0) != 0);
        Assert.assertNotNull((Object)languageResource.getLRPersistenceId());
        Assert.assertEquals((Object)languageResource.getDataStore(), (Object)this);
        return this._lockLr((Long)languageResource.getLRPersistenceId());
    }

    private boolean _lockLr(Long l) throws PersistenceException, SecurityException {
        Assert.assertNotNull((Object)l);
        if (null == this.session) {
            throw new SecurityException("session not set");
        }
        if (!this.ac.isValidSession(this.session)) {
            throw new SecurityException("invalid session supplied");
        }
        if (!this.canWriteLR(l)) {
            throw new SecurityException("no write access granted to the user");
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        boolean bl = false;
        try {
            preparedStatement = this.jdbcConn.prepareStatement(" select persist_lock_lr(?,?,?) ");
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, this.session.getUser().getID());
            preparedStatement.setLong(3, this.session.getGroup().getID());
            preparedStatement.execute();
            resultSet = preparedStatement.getResultSet();
            if (!resultSet.next()) {
                throw new PersistenceException("empty result set");
            }
            bl = resultSet.getBoolean(1);
        }
        catch (SQLException sQLException) {
            try {
                switch (sQLException.getErrorCode()) {
                    case 20106: {
                        throw new PersistenceException("invalid LR ID supplied [" + sQLException.getMessage() + "]");
                    }
                }
                throw new PersistenceException("can't lock LR in DB : [" + sQLException.getMessage() + "]");
            }
            catch (Throwable throwable) {
                DBHelper.cleanup(resultSet);
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(preparedStatement);
        return bl;
    }

    protected Long createLR(String string, String string2, SecurityInfo securityInfo, Long l) throws PersistenceException, SecurityException {
        Long l2;
        Assert.assertNotNull((Object)string2);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            Long l3;
            String string3 = " select persist_create_lr(?,?,?,?,?,?) ";
            preparedStatement = this.jdbcConn.prepareStatement(string3);
            preparedStatement.setLong(1, securityInfo.getUser().getID());
            preparedStatement.setLong(2, securityInfo.getGroup().getID());
            preparedStatement.setString(3, string);
            preparedStatement.setString(4, string2);
            preparedStatement.setInt(5, securityInfo.getAccessMode());
            if (null == l) {
                preparedStatement.setNull(6, 4);
            } else {
                preparedStatement.setLong(6, l);
            }
            preparedStatement.execute();
            resultSet = preparedStatement.getResultSet();
            if (!resultSet.next()) {
                throw new PersistenceException("empty result set");
            }
            l2 = l3 = new Long(resultSet.getLong(1));
        }
        catch (SQLException sQLException) {
            try {
                switch (sQLException.getErrorCode()) {
                    case 20113: {
                        throw new PersistenceException("can't create LR [step 3] in DB, invalid LR Type");
                    }
                }
                throw new PersistenceException("can't create LR [step 3] in DB : [" + sQLException.getMessage() + "]");
            }
            catch (Throwable throwable) {
                DBHelper.cleanup(resultSet);
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(preparedStatement);
        return l2;
    }

    protected Long createDoc(Long l, URL uRL, String string, Long l2, Long l3, Boolean bl, Long l4) throws PersistenceException {
        Long l5;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Long l6 = null;
        try {
            preparedStatement = this.jdbcConn.prepareStatement(" select persist_create_document(?,?,?,?,?,?,?) ");
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, uRL != null ? uRL.toString() : "");
            if (null == string) {
                preparedStatement.setNull(3, 12);
            } else {
                preparedStatement.setString(3, string);
            }
            if (null == l2) {
                preparedStatement.setNull(4, 4);
            } else {
                preparedStatement.setLong(4, l2);
            }
            if (null == l3) {
                preparedStatement.setNull(5, 4);
            } else {
                preparedStatement.setLong(5, l3);
            }
            preparedStatement.setBoolean(6, bl);
            if (null == l4) {
                preparedStatement.setNull(7, -5);
            } else {
                preparedStatement.setLong(7, l4);
            }
            preparedStatement.execute();
            resultSet = preparedStatement.getResultSet();
            if (!resultSet.next()) {
                throw new PersistenceException("empty result set");
            }
            l5 = l6 = new Long(resultSet.getLong(1));
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException("can't create document [step 4] in DB: [" + sQLException.getMessage() + "]");
            }
            catch (Throwable throwable) {
                DBHelper.cleanup(resultSet);
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(preparedStatement);
        return l5;
    }

    protected void createAnnotationSet(Long l, AnnotationSet annotationSet) throws PersistenceException {
        String string;
        String string2 = annotationSet.getName();
        Long l2 = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            string = "select persist_create_annotation_set(?,?)";
            preparedStatement = this.jdbcConn.prepareStatement(string);
            preparedStatement.setLong(1, l);
            if (null == string2) {
                preparedStatement.setNull(2, 12);
            } else {
                preparedStatement.setString(2, string2);
            }
            preparedStatement.execute();
            resultSet = preparedStatement.getResultSet();
            if (!resultSet.next()) {
                throw new PersistenceException("empty result set");
            }
            l2 = new Long(resultSet.getLong(1));
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException("can't create a-set [step 1] in DB: [" + sQLException.getMessage() + "]");
            }
            catch (Throwable throwable) {
                DBHelper.cleanup(resultSet);
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(preparedStatement);
        try {
            string = "select persist_create_annotation(?,?,?,?,?,?,?,?) ";
            preparedStatement = this.jdbcConn.prepareStatement(string);
            for (Annotation annotation : annotationSet) {
                Node node = annotation.getStartNode();
                Node node2 = annotation.getEndNode();
                String string3 = annotation.getType();
                Long l3 = null;
                preparedStatement.setLong(1, l);
                preparedStatement.setLong(2, annotation.getId().longValue());
                preparedStatement.setLong(3, l2);
                preparedStatement.setLong(4, node.getId().longValue());
                preparedStatement.setLong(5, node.getOffset());
                preparedStatement.setLong(6, node2.getId().longValue());
                preparedStatement.setLong(7, node2.getOffset());
                preparedStatement.setString(8, string3);
                preparedStatement.execute();
                resultSet = preparedStatement.getResultSet();
                if (!resultSet.next()) {
                    throw new PersistenceException("empty result set");
                }
                l3 = new Long(resultSet.getLong(1));
                DBHelper.cleanup(resultSet);
                FeatureMap featureMap = annotation.getFeatures();
                Assert.assertNotNull((Object)featureMap);
                this.createFeatures(l3, 3, featureMap);
            }
        }
        catch (SQLException sQLException) {
            switch (sQLException.getErrorCode()) {
                case 20114: {
                    throw new PersistenceException("can't create annotation in DB, [invalid annotation type]");
                }
            }
            throw new PersistenceException("can't create annotation in DB: [" + sQLException.getMessage() + "]");
        }
        finally {
            DBHelper.cleanup(preparedStatement);
        }
    }

    protected void updateDocumentContent(Long l, DocumentContent documentContent) throws PersistenceException {
        PreparedStatement preparedStatement = null;
        try {
            String string = " update  t_doc_content  set     dc_character_content = ?,           dc_content_type = ?  where   dc_id = (select doc_content_id                    from t_document                    where doc_id = ?) ";
            preparedStatement = this.jdbcConn.prepareStatement(string);
            preparedStatement.setString(1, documentContent.toString());
            preparedStatement.setInt(2, 1);
            preparedStatement.setLong(3, l);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException("can't update document content in DB : [" + sQLException.getMessage() + "]");
            }
            catch (Throwable throwable) {
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
        }
        DBHelper.cleanup(preparedStatement);
    }

    private void createFeature(Long l, int n, String string, Object object, PreparedStatement preparedStatement) throws PersistenceException {
        Iterator iterator;
        int n2 = this.findFeatureType(object);
        Vector<Object> vector = new Vector<Object>();
        switch (n2) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                vector.add(object);
                break;
            }
            default: {
                List list = (List)object;
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    vector.add(iterator.next());
                }
                if (n2 == 111) {
                    n2 = 105;
                    break;
                }
                if (n2 == 109) {
                    n2 = 103;
                    break;
                }
                if (n2 == 112) {
                    n2 = 106;
                    break;
                }
                if (n2 == 107) {
                    n2 = 101;
                    break;
                }
                if (n2 == 108) {
                    n2 = 102;
                    break;
                }
                if (n2 != 110) break;
                n2 = 104;
            }
        }
        for (int i = 0; i < vector.size(); ++i) {
            iterator = vector.elementAt(i);
            Long l2 = this._createFeature(l, n, string, iterator, n2, preparedStatement);
        }
    }

    protected void createFeatures(Long l, int n, FeatureMap featureMap) throws PersistenceException {
        Object object;
        PreparedStatement preparedStatement = null;
        try {
            object = "select persist_create_feature(?,?,?,?,?,?,?,?) ";
            preparedStatement = this.jdbcConn.prepareStatement((String)object);
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        object = featureMap.entrySet();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            this.createFeature(l, n, string, v, preparedStatement);
        }
        DBHelper.cleanup(preparedStatement);
    }

    protected void createFeaturesBulk(Long l, int n, FeatureMap featureMap) throws PersistenceException {
        throw new MethodNotImplementedException();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Long _createFeature(Long l, int n, String string, Object object, int n2, PreparedStatement preparedStatement) throws PersistenceException {
        Long l2 = null;
        ResultSet resultSet = null;
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.setInt(2, n);
            preparedStatement.setString(3, string);
            preparedStatement.setNull(4, -5);
            preparedStatement.setNull(5, 8);
            preparedStatement.setNull(6, -1);
            preparedStatement.setNull(7, -4);
            preparedStatement.setInt(8, n2);
            switch (n2) {
                case 100: {
                    break;
                }
                case 103: {
                    boolean bl = (Boolean)object;
                    preparedStatement.setLong(4, bl ? 1L : 0L);
                    break;
                }
                case 101: {
                    preparedStatement.setLong(4, ((Integer)object).intValue());
                    break;
                }
                case 102: {
                    preparedStatement.setLong(4, (Long)object);
                    break;
                }
                case 106: {
                    Double d = (Double)object;
                    preparedStatement.setDouble(5, d);
                    break;
                }
                case 105: {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                    objectOutputStream.writeObject(object);
                    objectOutputStream.close();
                    byteArrayOutputStream.close();
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    preparedStatement.setBinaryStream(7, (InputStream)byteArrayInputStream, byArray.length);
                    byteArrayInputStream.close();
                    break;
                }
                case 104: {
                    String string2 = (String)object;
                    preparedStatement.setString(6, string2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsuppoeted feature type");
                }
            }
            preparedStatement.execute();
            resultSet = preparedStatement.getResultSet();
            if (!resultSet.next()) {
                throw new PersistenceException("empty result set");
            }
            l2 = new Long(resultSet.getLong(1));
        }
        catch (IOException iOException) {
            try {
                throw new PersistenceException("can't write binary data [" + iOException.getMessage() + "]");
                catch (SQLException sQLException) {
                    switch (sQLException.getErrorCode()) {
                        case 20115: {
                            throw new PersistenceException("can't create feature [step 1],[invalid feature type] in DB: [" + sQLException.getMessage() + "]");
                        }
                    }
                    throw new PersistenceException("can't create feature [step 1] in DB: [" + sQLException.getMessage() + "]");
                }
            }
            catch (Throwable throwable) {
                DBHelper.cleanup(resultSet);
                throw throwable;
            }
        }
        DBHelper.cleanup(resultSet);
        return l2;
    }

    protected void _syncLR(LanguageResource languageResource) throws PersistenceException, SecurityException {
        Assert.assertTrue((languageResource instanceof DatabaseDocumentImpl || languageResource instanceof DatabaseCorpusImpl ? 1 : 0) != 0);
        Assert.assertNotNull((Object)languageResource.getLRPersistenceId());
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.jdbcConn.prepareStatement("select persist_update_lr(?,?,?)");
            preparedStatement.setLong(1, (Long)languageResource.getLRPersistenceId());
            preparedStatement.setString(2, languageResource.getName());
            if (languageResource instanceof Document && null != languageResource.getParent()) {
                preparedStatement.setLong(3, (Long)languageResource.getParent().getLRPersistenceId());
            } else {
                preparedStatement.setNull(3, -5);
            }
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            try {
                switch (sQLException.getErrorCode()) {
                    case 20106: {
                        throw new PersistenceException("can't set LR name in DB: [invalid LR ID]");
                    }
                }
                throw new PersistenceException("can't set LR name in DB: [" + sQLException.getMessage() + "]");
            }
            catch (Throwable throwable) {
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
        }
        DBHelper.cleanup(preparedStatement);
    }

    protected void _syncDocumentHeader(Document document) throws PersistenceException {
        Long l = (Long)document.getLRPersistenceId();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.jdbcConn.prepareStatement("select persist_update_document(?,?,?,?,?)");
            preparedStatement.setLong(1, l);
            if (document.getSourceUrl() != null) {
                preparedStatement.setString(2, document.getSourceUrl().toString());
            } else {
                preparedStatement.setString(2, "");
            }
            if (null == document.getSourceUrlStartOffset()) {
                preparedStatement.setNull(3, 4);
            } else {
                preparedStatement.setLong(3, document.getSourceUrlStartOffset());
            }
            if (null == document.getSourceUrlEndOffset()) {
                preparedStatement.setNull(4, 4);
            } else {
                preparedStatement.setLong(4, document.getSourceUrlEndOffset());
            }
            preparedStatement.setBoolean(5, document.getMarkupAware());
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            try {
                switch (sQLException.getErrorCode()) {
                    case 20106: {
                        throw new PersistenceException("invalid LR supplied: no such document: [" + sQLException.getMessage() + "]");
                    }
                }
                throw new PersistenceException("can't change document data: [" + sQLException.getMessage() + "]");
            }
            catch (Throwable throwable) {
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
        }
        DBHelper.cleanup(preparedStatement);
    }

    protected void _syncDocumentContent(Document document) throws PersistenceException {
        Assert.assertNotNull((Object)document);
        Assert.assertNotNull((Object)document.getLRPersistenceId());
        Assert.assertTrue((boolean)(document instanceof DatabaseDocumentImpl));
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.jdbcConn.prepareStatement("select persist_update_document_content(?,?)");
            preparedStatement.setLong(1, (Long)document.getLRPersistenceId());
            DocumentContent documentContent = document.getContent();
            if (documentContent.size() > 0L) {
                preparedStatement.setString(2, documentContent.toString());
            } else {
                preparedStatement.setNull(2, -1);
            }
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException("Cannot update document content [" + sQLException.getMessage() + "]");
            }
            catch (Throwable throwable) {
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
        }
        DBHelper.cleanup(preparedStatement);
    }

    protected void _syncFeatures(LanguageResource languageResource) throws PersistenceException {
        int n;
        Assert.assertNotNull((Object)languageResource);
        Assert.assertNotNull((Object)languageResource.getLRPersistenceId());
        Assert.assertEquals((String)((DatabaseDataStore)languageResource.getDataStore()).getDatabaseID(), (String)this.getDatabaseID());
        Assert.assertTrue((languageResource instanceof Document || languageResource instanceof Corpus ? 1 : 0) != 0);
        Long l = (Long)languageResource.getLRPersistenceId();
        PreparedStatement preparedStatement = null;
        try {
            Assert.assertTrue((false == this.jdbcConn.getAutoCommit() ? 1 : 0) != 0);
            preparedStatement = this.jdbcConn.prepareStatement("select persist_delete_features(?,?) ");
            preparedStatement.setLong(1, l);
            if (languageResource instanceof Document) {
                n = 2;
            } else if (languageResource instanceof Corpus) {
                n = 1;
            } else {
                throw new IllegalArgumentException();
            }
            preparedStatement.setInt(2, n);
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException("can't delete features in DB: [" + sQLException.getMessage() + "]");
            }
            catch (Throwable throwable) {
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
        }
        DBHelper.cleanup(preparedStatement);
        this.createFeatures(l, n, languageResource.getFeatures());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected FeatureMap readFeatures(Long l, int n) throws PersistenceException {
        SimpleFeatureMapImpl simpleFeatureMapImpl;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block25: {
            Assert.assertNotNull((Object)l);
            Assert.assertTrue((n == 3 || n == 1 || n == 2 ? 1 : 0) != 0);
            preparedStatement = null;
            resultSet = null;
            simpleFeatureMapImpl = new SimpleFeatureMapImpl();
            try {
                String string = " select ftkey.fk_string,         ft.ft_value_type,         ft.ft_int_value,         ft.ft_float_value,         ft.ft_binary_value,         ft.ft_character_value  from   t_feature ft,         t_feature_key ftkey  where  ft.ft_entity_id = ?         and ft.ft_entity_type = ?         and ft.ft_key_id = ftkey.fk_id  order by ftkey.fk_string,ft.ft_id";
                preparedStatement = this.jdbcConn.prepareStatement(string);
                preparedStatement.setLong(1, l);
                preparedStatement.setLong(2, n);
                preparedStatement.execute();
                resultSet = preparedStatement.getResultSet();
                Vector<Object> vector = new Vector<Object>();
                String string2 = null;
                String string3 = null;
                Object object = null;
                while (resultSet.next()) {
                    string3 = resultSet.getString("fk_string");
                    Long l2 = new Long(resultSet.getLong("ft_value_type"));
                    Comparable<Boolean> comparable = null;
                    switch (l2.intValue()) {
                        case 103: {
                            comparable = new Boolean(resultSet.getBoolean("ft_int_value"));
                            break;
                        }
                        case 106: {
                            comparable = new Double(resultSet.getDouble("ft_float_value"));
                            break;
                        }
                        case 101: {
                            comparable = new Integer(resultSet.getInt("ft_int_value"));
                            break;
                        }
                        case 102: {
                            comparable = new Long(resultSet.getLong("ft_int_value"));
                            break;
                        }
                    }
                    InputStream inputStream = resultSet.getBinaryStream("ft_binary_value");
                    String string4 = resultSet.getString("ft_character_value");
                    switch (l2.intValue()) {
                        case 100: {
                            object = null;
                            break;
                        }
                        case 101: 
                        case 102: 
                        case 103: 
                        case 106: {
                            object = comparable;
                            break;
                        }
                        case 105: {
                            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                            object = objectInputStream.readObject();
                            objectInputStream.close();
                            inputStream.close();
                            break;
                        }
                        case 104: {
                            object = string4;
                            break;
                        }
                        default: {
                            throw new PersistenceException("Invalid feature type found in DB, type is [" + l2.intValue() + "]");
                        }
                    }
                    if (string3.equals(string2) && string2 != null) {
                        vector.add(object);
                        continue;
                    }
                    if (vector.size() > 1) {
                        simpleFeatureMapImpl.put(string2, new Vector(vector));
                    } else if (vector.size() == 1) {
                        simpleFeatureMapImpl.put(string2, vector.elementAt(0));
                    }
                    vector.clear();
                    string2 = string3;
                    vector.add(object);
                }
                if (vector.size() > 1) {
                    simpleFeatureMapImpl.put(string3, vector);
                    break block25;
                }
                if (vector.size() == 1) {
                    simpleFeatureMapImpl.put(string3, vector.elementAt(0));
                }
            }
            catch (SQLException sQLException) {
                try {
                    throw new PersistenceException("can't read features from DB: [" + sQLException.getMessage() + "]");
                    catch (IOException iOException) {
                        throw new PersistenceException("can't read features from DB: [" + iOException.getMessage() + "]");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new PersistenceException("can't read features from DB: [" + classNotFoundException.getMessage() + "]");
                    }
                }
                catch (Throwable throwable) {
                    DBHelper.cleanup(resultSet);
                    DBHelper.cleanup(preparedStatement);
                    throw throwable;
                }
            }
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(preparedStatement);
        return simpleFeatureMapImpl;
    }

    protected void deleteDocument(Long l) throws PersistenceException {
        Assert.assertNotNull((Object)l);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.jdbcConn.prepareStatement("select persist_delete_document(?) ");
            preparedStatement.setLong(1, l);
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException("can't delete LR from DB: [" + sQLException.getMessage() + "]");
            }
            catch (Throwable throwable) {
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
        }
        DBHelper.cleanup(preparedStatement);
    }

    protected void deleteCorpus(Long l) throws PersistenceException {
        Long l2 = l;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.jdbcConn.prepareStatement("select persist_delete_corpus(?)");
            preparedStatement.setLong(1, l2);
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            try {
                throw new PersistenceException("can't delete LR from DB: [" + sQLException.getMessage() + "]");
            }
            catch (Throwable throwable) {
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
        }
        DBHelper.cleanup(preparedStatement);
    }

    protected void _syncRemovedDocumentsFromCorpus(List list, Long l) throws PersistenceException {
        Assert.assertNotNull((Object)list);
        Assert.assertNotNull((Object)l);
        Assert.assertTrue((list.size() > 0 ? 1 : 0) != 0);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.jdbcConn.prepareStatement("select persist_remove_doc_from_corpus(?,?)");
            for (Long l2 : list) {
                preparedStatement.setLong(1, l2);
                preparedStatement.setLong(2, l);
                preparedStatement.execute();
            }
        }
        catch (SQLException sQLException) {
            try {
                switch (sQLException.getErrorCode()) {
                    case 20106: {
                        throw new PersistenceException("invalid LR supplied: no such document: [" + sQLException.getMessage() + "]");
                    }
                }
                throw new PersistenceException("can't change document data: [" + sQLException.getMessage() + "]");
            }
            catch (Throwable throwable) {
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
        }
        DBHelper.cleanup(preparedStatement);
    }

    protected void addDocumentToCorpus(Long l, Long l2) throws PersistenceException, SecurityException {
        Assert.assertNotNull((Object)l);
        Assert.assertNotNull((Object)l2);
        if (null == this.session) {
            throw new SecurityException("session not set");
        }
        if (!this.ac.isValidSession(this.session)) {
            throw new SecurityException("invalid session supplied");
        }
        if (!this.canWriteLR(l2)) {
            throw new SecurityException("no write access granted to the user");
        }
        if (!this.canWriteLR(l)) {
            throw new SecurityException("no write access granted to the user");
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.jdbcConn.prepareStatement("select persist_add_document_to_corpus(?,?) ");
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l2);
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            try {
                switch (sQLException.getErrorCode()) {
                    case 20106: {
                        throw new PersistenceException("invalid LR ID supplied [" + sQLException.getMessage() + "]");
                    }
                }
                throw new PersistenceException("can't add document to corpus : [" + sQLException.getMessage() + "]");
            }
            catch (Throwable throwable) {
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
        }
        DBHelper.cleanup(preparedStatement);
    }
}

