/*
 * Decompiled with CFR 0.152.
 */
package gate.persist;

import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.LanguageResource;
import gate.corpora.SerialCorpusImpl;
import gate.creole.ResourceInstantiationException;
import gate.creole.annic.Hit;
import gate.creole.annic.IndexException;
import gate.creole.annic.Indexer;
import gate.creole.annic.SearchException;
import gate.creole.annic.SearchableDataStore;
import gate.creole.annic.Searcher;
import gate.creole.annic.lucene.LuceneIndexer;
import gate.creole.annic.lucene.LuceneSearcher;
import gate.event.CorpusEvent;
import gate.event.CorpusListener;
import gate.persist.PersistenceException;
import gate.persist.SerialDataStore;
import gate.security.SecurityException;
import gate.util.GateRuntimeException;
import gate.util.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LuceneDataStoreImpl
extends SerialDataStore
implements SearchableDataStore,
CorpusListener {
    private static final long serialVersionUID = 3618696392336421680L;
    protected Indexer indexer;
    protected Map indexParameters;
    protected URL indexURL;
    protected Searcher searcher;
    protected Map searchParameters;

    public void open() throws PersistenceException {
        super.open();
        try {
            FileReader fileReader = new FileReader(this.getVersionFile());
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            currentProtocolVersion = bufferedReader.readLine();
            String string = bufferedReader.readLine();
            if (string != null && string.trim().length() > 1) {
                this.indexURL = new URL(string);
                this.indexer = new LuceneIndexer(this.indexURL);
                this.searcher = new LuceneSearcher();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new PersistenceException("Invalid storage directory: " + iOException);
        }
        if (!this.isValidProtocolVersion(currentProtocolVersion)) {
            throw new PersistenceException("Invalid protocol version number: " + currentProtocolVersion);
        }
    }

    public void delete(String string, Object object) throws PersistenceException {
        block11: {
            super.delete(string, object);
            try {
                if (!Corpus.class.isAssignableFrom(Class.forName(string, true, Gate.getClassLoader()))) break block11;
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("INDEX_LOCATION_URL", this.indexURL);
                hashMap.put("CORPUS_ID", object.toString());
                try {
                    boolean bl = this.getSearcher().search("nothing", hashMap);
                    if (!bl) {
                        return;
                    }
                    Hit[] hitArray = this.getSearcher().next(-1);
                    if (hitArray == null || hitArray.length == 0) {
                        return;
                    }
                    for (int i = 0; i < hitArray.length; ++i) {
                        String string2 = hitArray[i].getDocumentID();
                        FeatureMap featureMap = Factory.newFeatureMap();
                        featureMap.put("DataStore", this);
                        featureMap.put("LRPersistenceId", string2);
                        Document document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(string2);
                        this.indexer.remove(arrayList);
                        ArrayList<Document> arrayList2 = new ArrayList<Document>();
                        arrayList2.add(document);
                        this.indexer.add(null, arrayList2);
                        Factory.deleteResource(document);
                    }
                }
                catch (SearchException searchException) {
                    throw new PersistenceException(searchException);
                }
                catch (ResourceInstantiationException resourceInstantiationException) {
                    throw new PersistenceException(resourceInstantiationException);
                }
                catch (IndexException indexException) {
                    throw new PersistenceException(indexException);
                }
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        try {
            this.indexer.remove(arrayList);
        }
        catch (IndexException indexException) {
            throw new PersistenceException(indexException);
        }
    }

    public LanguageResource getLr(String string, Object object) throws PersistenceException, SecurityException {
        LanguageResource languageResource = super.getLr(string, object);
        if (languageResource instanceof Corpus) {
            ((Corpus)languageResource).addCorpusListener(this);
        }
        return languageResource;
    }

    public void sync(LanguageResource languageResource) throws PersistenceException {
        super.sync(languageResource);
        if (languageResource instanceof Document) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (languageResource.getLRPersistenceId() != null) {
                arrayList.add(languageResource.getLRPersistenceId());
                try {
                    this.indexer.remove(arrayList);
                }
                catch (IndexException indexException) {
                    throw new PersistenceException(indexException);
                }
            }
            ArrayList<Document> arrayList2 = new ArrayList<Document>();
            arrayList2.add((Document)languageResource);
            try {
                String string = null;
                if (languageResource.getLRPersistenceId() != null) {
                    Object object;
                    List<LanguageResource> list = Gate.getCreoleRegister().getLrInstances(SerialCorpusImpl.class.getName());
                    if (list != null) {
                        object = list.iterator();
                        while (object.hasNext()) {
                            SerialCorpusImpl serialCorpusImpl = (SerialCorpusImpl)object.next();
                            if (serialCorpusImpl == null || !serialCorpusImpl.contains(languageResource)) continue;
                            string = serialCorpusImpl.getLRPersistenceId().toString();
                            break;
                        }
                    }
                    if (string == null && (object = this.getLrIds(SerialCorpusImpl.class.getName())) != null) {
                        for (int i = 0; i < object.size(); ++i) {
                            Object e = object.get(i);
                            FeatureMap featureMap = Factory.newFeatureMap();
                            featureMap.put("DataStore", this);
                            featureMap.put("LRPersistenceId", e);
                            FeatureMap featureMap2 = Factory.newFeatureMap();
                            Gate.setHiddenAttribute(featureMap2, true);
                            SerialCorpusImpl serialCorpusImpl = (SerialCorpusImpl)Factory.createResource(SerialCorpusImpl.class.getCanonicalName(), featureMap, featureMap2);
                            if (serialCorpusImpl == null) continue;
                            if (serialCorpusImpl.contains(languageResource)) {
                                string = serialCorpusImpl.getLRPersistenceId().toString();
                            }
                            Factory.deleteResource(serialCorpusImpl);
                            if (string != null) break;
                        }
                    }
                }
                this.indexer.add(string, arrayList2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setIndexer(Indexer indexer, Map map) throws IndexException {
        this.indexer = indexer;
        this.indexParameters = map;
        this.indexURL = (URL)this.indexParameters.get("INDEX_LOCATION_URL");
        this.indexer.createIndex(this.indexParameters);
        try {
            File file = this.getVersionFile();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(file));
            outputStreamWriter.write(this.versionNumber + Strings.getNl());
            outputStreamWriter.write(this.indexURL.toString());
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            throw new IndexException("couldn't write version file: " + iOException);
        }
    }

    public Indexer getIndexer() {
        return this.indexer;
    }

    public void setSearcher(Searcher searcher) throws SearchException {
        this.searcher = searcher;
    }

    public Searcher getSearcher() {
        return this.searcher;
    }

    public boolean search(String string, Map map) throws SearchException {
        return this.searcher.search(string, map);
    }

    public Hit[] next(int n) throws SearchException {
        return this.searcher.next(n);
    }

    public void documentRemoved(CorpusEvent corpusEvent) {
        Document document = corpusEvent.getDocument();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (document.getLRPersistenceId() != null) {
            arrayList.add(document.getLRPersistenceId());
            try {
                this.indexer.remove(arrayList);
            }
            catch (IndexException indexException) {
                throw new GateRuntimeException(indexException);
            }
        }
        ArrayList<Document> arrayList2 = new ArrayList<Document>();
        arrayList2.add(document);
        try {
            this.indexer.add(null, arrayList2);
        }
        catch (Exception exception) {
            throw new GateRuntimeException(exception);
        }
    }

    public void documentAdded(CorpusEvent corpusEvent) {
    }
}

