/*
 * Decompiled with CFR 0.152.
 */
package gate.persist;

import gate.persist.ConnectionPool;
import gate.persist.PersistenceException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

public class DBHelper {
    private static final String jdbcOracleDriverName = "oracle.jdbc.driver.OracleDriver";
    private static final String jdbcPostgresDriverName = "org.postgresql.Driver";
    public static final int CHINK_SIZE_SMALL = 30;
    public static final int CHINK_SIZE_MEDIUM = 60;
    public static final int CHINK_SIZE_LARGE = 100;
    public static final int X_ORACLE_START = 20100;
    public static final int X_ORACLE_DUPLICATE_GROUP_NAME = 20101;
    public static final int X_ORACLE_DUPLICATE_USER_NAME = 20102;
    public static final int X_ORACLE_INVALID_USER_NAME = 20103;
    public static final int X_ORACLE_INVALID_USER_PASS = 20104;
    public static final int X_ORACLE_INVALID_USER_GROUP = 20105;
    public static final int X_ORACLE_INVALID_LR = 20106;
    public static final int X_ORACLE_INVALID_ACCESS_MODE = 20107;
    public static final int X_ORACLE_INVALID_ARGUMENT = 20108;
    public static final int X_ORACLE_NOT_IMPLEMENTED = 20109;
    public static final int X_ORACLE_GROUP_OWNS_RESOURCES = 20110;
    public static final int X_ORACLE_USER_OWNS_RESOURCES = 20111;
    public static final int X_ORACLE_INCOMPLETE_DATA = 20112;
    public static final int X_ORACLE_INVALID_LR_TYPE = 20113;
    public static final int X_ORACLE_INVALID_ANNOTATION_TYPE = 20114;
    public static final int X_ORACLE_INVALID_FEATURE_TYPE = 20115;
    public static final int X_ORACLE_INVALID_CONTENT_TYPE = 20116;
    public static final int X_ORACLE_INVALID_ANNOTATION = 20117;
    public static final int X_ORACLE_INSUFFICIENT_PRIVILEGES = 20118;
    public static final int X_ORACLE_INVALID_ANNOTATION_SET = 20119;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int CHARACTER_CONTENT = 1;
    public static final int BINARY_CONTENT = 2;
    public static final int EMPTY_CONTENT = 3;
    public static final String DOCUMENT_CLASS = "gate.corpora.DatabaseDocumentImpl";
    public static final String CORPUS_CLASS = "gate.corpora.DatabaseCorpusImpl";
    public static final String DB_PARAMETER_GUID = "DB_GUID";
    public static final String DUMMY_FEATURE_KEY = "--NO--SUCH--KEY--";
    public static final String DUMMY_ENCODING = "-!-";
    public static final int READ_ACCESS = 0;
    public static final int WRITE_ACCESS = 1;
    public static final Long DUMMY_ID = new Long(Long.MIN_VALUE);
    protected static final int FEATURE_OWNER_CORPUS = 1;
    protected static final int FEATURE_OWNER_DOCUMENT = 2;
    protected static final int FEATURE_OWNER_ANNOTATION = 3;
    public static final int VALUE_TYPE_NULL = 100;
    public static final int VALUE_TYPE_INTEGER = 101;
    public static final int VALUE_TYPE_LONG = 102;
    public static final int VALUE_TYPE_BOOLEAN = 103;
    public static final int VALUE_TYPE_STRING = 104;
    public static final int VALUE_TYPE_BINARY = 105;
    public static final int VALUE_TYPE_FLOAT = 106;
    public static final int VALUE_TYPE_INTEGER_ARR = 107;
    public static final int VALUE_TYPE_LONG_ARR = 108;
    public static final int VALUE_TYPE_BOOLEAN_ARR = 109;
    public static final int VALUE_TYPE_STRING_ARR = 110;
    public static final int VALUE_TYPE_BINARY_ARR = 111;
    public static final int VALUE_TYPE_FLOAT_ARR = 112;
    public static final int VALUE_TYPE_EMPTY_ARR = 113;
    public static final int ORACLE_DB = 101;
    public static final int POSTGRES_DB = 102;
    private static final boolean DEBUG = false;
    private static boolean driversLoaded = false;
    private static HashMap pools = new HashMap();
    private static final int POOL_SIZE = 20;

    protected DBHelper() {
    }

    private static synchronized void loadDrivers() throws ClassNotFoundException {
        if (!driversLoaded) {
            Class.forName(jdbcOracleDriverName);
            Class.forName(jdbcPostgresDriverName);
            driversLoaded = true;
        }
    }

    public static void cleanup(ResultSet resultSet) throws PersistenceException {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceException("an SQL exception occured [" + sQLException.getMessage() + "]");
        }
    }

    public static void cleanup(Statement statement) throws PersistenceException {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceException("an SQL exception occured [" + sQLException.getMessage() + "]");
        }
    }

    public static Connection connect(String string) throws SQLException, ClassNotFoundException {
        DBHelper.loadDrivers();
        Connection connection = DriverManager.getConnection(string);
        return connection;
    }

    public static Connection connect(String string, String string2, String string3) throws SQLException, ClassNotFoundException {
        DBHelper.loadDrivers();
        Connection connection = DriverManager.getConnection(string, string2, string3);
        return connection;
    }

    public static void disconnect(Connection connection) throws PersistenceException {
        try {
            connection.rollback();
            connection.close();
        }
        catch (SQLException sQLException) {
            throw new PersistenceException("cannot close JDBC connection, DB error is [" + sQLException.getMessage() + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection connect(String string, boolean bl) throws SQLException, ClassNotFoundException {
        if (!bl) {
            return DBHelper.connect(string);
        }
        ConnectionPool connectionPool = null;
        HashMap hashMap = pools;
        synchronized (hashMap) {
            if (!pools.containsKey(string)) {
                connectionPool = new ConnectionPool(20, string);
                pools.put(string, connectionPool);
            } else {
                connectionPool = (ConnectionPool)pools.get(string);
            }
        }
        return connectionPool.get();
    }

    public static void disconnect(Connection connection, boolean bl) throws PersistenceException {
        if (!bl) {
            DBHelper.disconnect(connection);
        } else {
            String string = null;
            try {
                string = connection.getMetaData().getURL();
                connection.rollback();
            }
            catch (SQLException sQLException) {
                throw new PersistenceException(sQLException);
            }
            ConnectionPool connectionPool = (ConnectionPool)pools.get(string);
            connectionPool.put(connection);
        }
    }

    public static String getSchemaPrefix(String string) {
        if (string.startsWith("jdbc:oracle")) {
            return "gateadmin.";
        }
        if (string.startsWith("jdbc:postgres")) {
            return "";
        }
        throw new IllegalArgumentException();
    }

    public static int getDatabaseType(String string) {
        if (string.startsWith("jdbc:oracle")) {
            return 101;
        }
        if (string.startsWith("jdbc:postgres")) {
            return 102;
        }
        throw new IllegalArgumentException();
    }
}

