/*
 * Decompiled with CFR 0.152.
 */
package gate.lexicon;

import gate.lexicon.LexKBSynset;
import gate.lexicon.LexKBWordSense;
import gate.lexicon.MutableLexKBSynset;
import gate.lexicon.MutableLexKBWordSense;
import gate.lexicon.MutableLexKBWordSenseImpl;
import gate.lexicon.MutableWord;
import gate.util.Out;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MutableWordImpl
implements MutableWord,
Serializable {
    private String lemma = "";
    private List senseList = new ArrayList();
    static final long serialVersionUID = -2448794632943663270L;

    public MutableWordImpl(String string) {
        this.lemma = string;
    }

    public LexKBWordSense addSense(MutableLexKBSynset mutableLexKBSynset) {
        return this.addSense(this.senseList.size(), mutableLexKBSynset);
    }

    public LexKBWordSense addSense(int n, MutableLexKBSynset mutableLexKBSynset) {
        MutableLexKBSynset mutableLexKBSynset2 = mutableLexKBSynset;
        if (mutableLexKBSynset2 == null) {
            throw new RuntimeException("A valid synset must be provided!");
        }
        MutableLexKBWordSenseImpl mutableLexKBWordSenseImpl = new MutableLexKBWordSenseImpl(this, mutableLexKBSynset2, n, mutableLexKBSynset2.getWordSenses().size());
        this.senseList.add(n, mutableLexKBWordSenseImpl);
        mutableLexKBSynset2.addWordSense(mutableLexKBWordSenseImpl);
        return mutableLexKBWordSenseImpl;
    }

    public List getWordSenses() {
        return this.senseList;
    }

    public String getLemma() {
        return this.lemma;
    }

    public int getSenseCount() {
        return this.senseList.size();
    }

    public void removeSenses() {
        for (int i = this.senseList.size() - 1; i >= 0; --i) {
            LexKBWordSense lexKBWordSense = (LexKBWordSense)this.senseList.get(i);
            this.removeSense(lexKBWordSense);
        }
    }

    public void removeSense(LexKBWordSense lexKBWordSense) {
        if (!(lexKBWordSense instanceof MutableLexKBWordSense)) {
            Out.prln("Could not remove sense: " + lexKBWordSense + "because it is not mutable");
            return;
        }
        LexKBSynset lexKBSynset = ((MutableLexKBWordSense)lexKBWordSense).getSynset();
        if (!(lexKBSynset instanceof MutableLexKBSynset)) {
            Out.prln("Could not remove sense: " + lexKBWordSense + "because it is not mutable");
            return;
        }
        ((MutableLexKBSynset)lexKBSynset).removeSense(lexKBWordSense);
        for (int i = lexKBWordSense.getSenseNumber() + 1; i < this.senseList.size(); ++i) {
            LexKBWordSense lexKBWordSense2 = (LexKBWordSense)this.senseList.get(i);
            if (!(lexKBWordSense2 instanceof MutableLexKBWordSense)) continue;
            ((MutableLexKBWordSense)lexKBWordSense2).setSenseNumber(lexKBWordSense2.getSenseNumber() - 1);
        }
        this.senseList.remove(lexKBWordSense);
    }
}

