/*
 * Decompiled with CFR 0.152.
 */
package gate.lexicon;

import gate.Resource;
import gate.creole.AbstractLanguageResource;
import gate.creole.ResourceInstantiationException;
import gate.lexicon.LexKBSynset;
import gate.lexicon.LexKBWordSense;
import gate.lexicon.MutableLexKBSynset;
import gate.lexicon.MutableLexKBSynsetImpl;
import gate.lexicon.MutableLexicalKnowledgeBase;
import gate.lexicon.MutableWord;
import gate.lexicon.MutableWordImpl;
import gate.lexicon.Word;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class MutableLexicalKnowledgeBaseImpl
extends AbstractLanguageResource
implements MutableLexicalKnowledgeBase {
    private String version = "1.0";
    protected List synsets = new ArrayList();
    protected HashMap words = new HashMap();
    protected List posTypes = new ArrayList();
    static final long serialVersionUID = -2543190013851016324L;
    private Object lexId = "MIAKT Lexical KB Lexicon";

    public MutableLexicalKnowledgeBaseImpl() {
        for (int i = 0; i < POS_TYPES.length; ++i) {
            this.posTypes.add(POS_TYPES[i]);
        }
    }

    public Resource init() throws ResourceInstantiationException {
        return this;
    }

    public Iterator getSynsets() {
        return this.synsets.iterator();
    }

    public Iterator getSynsets(Object object) {
        if (object == null) {
            return null;
        }
        ArrayList<LexKBSynset> arrayList = new ArrayList<LexKBSynset>();
        for (int i = 0; i < this.synsets.size(); ++i) {
            LexKBSynset lexKBSynset = (LexKBSynset)this.synsets.get(i);
            if (!object.equals(lexKBSynset.getPOS())) continue;
            arrayList.add(lexKBSynset);
        }
        return arrayList.iterator();
    }

    public List lookupWord(String string) {
        if (string == null) {
            return null;
        }
        Word word = (Word)this.words.get(string);
        if (word == null) {
            return null;
        }
        return word.getWordSenses();
    }

    public List lookupWord(String string, Object object) {
        if (string == null || object == null) {
            return null;
        }
        Word word = (Word)this.words.get(string);
        if (word == null) {
            return null;
        }
        ArrayList<LexKBWordSense> arrayList = new ArrayList<LexKBWordSense>();
        for (LexKBWordSense lexKBWordSense : word.getWordSenses()) {
            if (!lexKBWordSense.getPOS().equals(object)) continue;
            arrayList.add(lexKBWordSense);
        }
        return arrayList;
    }

    public MutableWord addWord(String string) {
        if (this.words.containsKey(string)) {
            return (MutableWord)this.words.get(string);
        }
        MutableWordImpl mutableWordImpl = new MutableWordImpl(string);
        this.words.put(string, mutableWordImpl);
        return mutableWordImpl;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getVersion() {
        return this.version;
    }

    public MutableLexKBSynset addSynset() {
        MutableLexKBSynsetImpl mutableLexKBSynsetImpl = new MutableLexKBSynsetImpl();
        this.synsets.add(mutableLexKBSynsetImpl);
        return mutableLexKBSynsetImpl;
    }

    public Object[] getPOSTypes() {
        return this.posTypes.toArray();
    }

    public void addPOSType(Object object) {
        if (object == null) {
            return;
        }
        this.posTypes.add(object);
    }

    public void removeWord(MutableWord mutableWord) {
        if (mutableWord == null) {
            return;
        }
        mutableWord.removeSenses();
        this.words.remove(mutableWord.getLemma());
    }

    public void removeSynset(MutableLexKBSynset mutableLexKBSynset) {
        if (mutableLexKBSynset == null) {
            return;
        }
        List list = mutableLexKBSynset.getWordSenses();
        for (int i = 0; i < list.size(); ++i) {
            LexKBWordSense lexKBWordSense = (LexKBWordSense)list.get(i);
            ((MutableWord)lexKBWordSense.getWord()).removeSense(lexKBWordSense);
        }
        mutableLexKBSynset.removeSenses();
        this.synsets.remove(mutableLexKBSynset);
    }

    public Object getLexiconId() {
        return this.lexId;
    }

    public void setLexiconId(Object object) {
        this.lexId = object;
    }
}

