/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.AnnotationSet;
import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.corpora.TestDocument;
import gate.creole.ResourceInstantiationException;
import gate.creole.gazetteer.DefaultGazetteer;
import gate.creole.tokeniser.DefaultTokeniser;
import gate.jape.Batch;
import gate.jape.JapeException;
import gate.util.Err;
import gate.util.Files;
import gate.util.GateException;
import gate.util.InvalidOffsetException;
import gate.util.Out;
import java.io.IOException;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestJape
extends TestCase {
    private static final boolean DEBUG = false;

    public TestJape(String string) {
        super(string);
    }

    public void setUp() {
    }

    public void _testCombined() throws IOException, GateException, Exception {
        this.DoTestBigGrammar("AveShort");
    }

    public void testBatch() throws Exception {
        Object object;
        Corpus corpus = Factory.newCorpus("TestJape corpus");
        corpus.add(Factory.newDocument(Files.getGateResourceAsString("texts/doc0.html")));
        Document document = (Document)corpus.get(0);
        AnnotationSet annotationSet = document.getAnnotations();
        try {
            object = Factory.newFeatureMap();
            annotationSet.add(new Long(2L), new Long(4L), "A", (FeatureMap)object);
            annotationSet.add(new Long(4L), new Long(6L), "B", (FeatureMap)object);
            annotationSet.add(new Long(6L), new Long(8L), "C", (FeatureMap)object);
            annotationSet.add(new Long(8L), new Long(10L), "C", (FeatureMap)object);
        }
        catch (InvalidOffsetException invalidOffsetException) {
            invalidOffsetException.printStackTrace(Err.getPrintWriter());
        }
        object = new Batch(Files.getGateResource("/jape/TestABC.jape"), "UTF-8");
        ((Batch)object).transduce(corpus);
        document = (Document)corpus.get(0);
    }

    public void DoTestBigGrammar(String string) throws GateException, Exception {
        Object object;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        Out.print("Procesing " + string + "...\n" + "Started at: " + new Date() + "\n");
        l = System.currentTimeMillis();
        Out.print("Loading corpus... ");
        Corpus corpus = Factory.newCorpus("Jape Corpus");
        try {
            corpus.add(Factory.newDocument(Files.getGateResourceAsString("jape/InputTexts/" + string)));
        }
        catch (IOException iOException) {
            iOException.printStackTrace(Err.getPrintWriter());
        }
        if (corpus.isEmpty()) {
            Err.println("Missing corpus !");
            return;
        }
        DefaultTokeniser defaultTokeniser = null;
        try {
            FeatureMap featureMap = Factory.newFeatureMap();
            defaultTokeniser = (DefaultTokeniser)Factory.createResource("gate.creole.tokeniser.DefaultTokeniser", featureMap);
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            resourceInstantiationException.printStackTrace(Err.getPrintWriter());
        }
        l2 = System.currentTimeMillis();
        Out.print(": " + (l2 - l) + "ms\n");
        Out.print("Tokenizing the corpus... ");
        boolean bl = false;
        int n = corpus.size();
        for (Document document : corpus) {
            defaultTokeniser.setDocument(document);
            defaultTokeniser.setAnnotationSetName(null);
            defaultTokeniser.execute();
            TestDocument.verifyNodeIdConsistency(document);
        }
        l5 = System.currentTimeMillis();
        Out.print(": " + (l5 - l2) + "ms\n");
        DefaultGazetteer defaultGazetteer = null;
        l3 = l4 = System.currentTimeMillis();
        Out.print("Loading gazeteer lists...");
        try {
            object = Factory.newFeatureMap();
            defaultGazetteer = (DefaultGazetteer)Factory.createResource("gate.creole.gazetteer.DefaultGazetteer", (FeatureMap)object);
            defaultGazetteer.init();
            l4 = System.currentTimeMillis();
            Out.print(": " + (l4 - l3) + "ms\n");
            Out.print("Doing gazeteer lookup... ");
            for (Document document : corpus) {
                defaultGazetteer.setDocument(document);
                defaultGazetteer.execute();
                TestDocument.verifyNodeIdConsistency(document);
            }
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            Err.println("Cannot read the gazeteer lists!\nAre the GATE resources in place?\n" + resourceInstantiationException);
        }
        l5 = System.currentTimeMillis();
        Out.print(": " + (l5 - l4) + "ms\n");
        Gate.init();
        try {
            Out.print("Opening Jape grammar... ");
            object = new Batch(Files.getGateResource("/jape/combined/main.jape"), "UTF-8");
            l6 = new Date().getTime();
            Out.print(": " + (l6 - l5) + "ms\n");
            Out.print("Transducing the corpus... ");
            ((Batch)object).transduce(corpus);
            l7 = System.currentTimeMillis();
            Out.print(": " + (l7 - l6) + "ms\n");
        }
        catch (JapeException japeException) {
            japeException.printStackTrace(Err.getPrintWriter());
        }
    }

    public void testRhsErrorMessages() {
        boolean bl = false;
        try {
            Batch batch = new Batch(Gate.getUrl("tests/RhsError.jape"), "UTF-8");
            Document document = Factory.newDocument("This is a Small Document.");
            FeatureMap featureMap = Factory.newFeatureMap();
            featureMap.put("orth", "upperInitial");
            document.getAnnotations().add(new Long(0L), new Long(8L), "Token", featureMap);
            batch.transduce(document);
        }
        catch (Exception exception) {
            bl = true;
        }
        TestJape.assertTrue((String)"Bad JAPE grammar didn't throw an exception", (boolean)bl);
    }

    public static Test suite() {
        return new TestSuite(TestJape.class);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < 6; ++i) {
            System.gc();
            Out.println("Run " + i + "   ==============");
            try {
                TestJape testJape = new TestJape("Test Jape");
                testJape.setUp();
                if (stringArray.length < 1) {
                    testJape.DoTestBigGrammar("AveShort");
                    continue;
                }
                testJape.DoTestBigGrammar(stringArray[0]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace(Err.getPrintWriter());
            }
        }
    }
}

