/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import debugger.resources.PhaseController;
import debugger.resources.SPTLock;
import debugger.resources.pr.RuleTrace;
import debugger.resources.pr.TraceContainer;
import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Gate;
import gate.Node;
import gate.annotation.AnnotationSetImpl;
import gate.creole.ExecutionException;
import gate.creole.ExecutionInterruptedException;
import gate.event.ProgressListener;
import gate.fsm.FSM;
import gate.fsm.FSMInstance;
import gate.fsm.State;
import gate.fsm.Transition;
import gate.jape.Constraint;
import gate.jape.JapeConstants;
import gate.jape.JapeException;
import gate.jape.PrioritisedRuleList;
import gate.jape.RightHandSide;
import gate.jape.Rule;
import gate.jape.Transducer;
import gate.util.GateRuntimeException;
import gate.util.Javac;
import gate.util.Out;
import gate.util.SimpleSortedSet;
import gate.util.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class SinglePhaseTransducer
extends Transducer
implements JapeConstants,
Serializable {
    private static final boolean DEBUG = false;
    PhaseController phaseController = null;
    TraceContainer rulesTrace = null;
    RuleTrace currRuleTrace = null;
    protected int ruleApplicationStyle = 1;
    protected PrioritisedRuleList rules;
    protected FSM fsm;
    private HashMap optionSettings = new HashMap();
    protected boolean finishedAlready;
    public Set input = new HashSet();
    private transient Vector progressListeners;

    public PhaseController getPhaseController() {
        return this.phaseController;
    }

    public void setPhaseController(PhaseController phaseController) {
        this.phaseController = phaseController;
    }

    public SinglePhaseTransducer(String string) {
        this.name = string;
        this.rules = new PrioritisedRuleList();
        this.finishedAlready = false;
    }

    public void setRuleApplicationStyle(int n) {
        this.ruleApplicationStyle = n;
    }

    public FSM getFSM() {
        return this.fsm;
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
    }

    public void setOption(String string, String string2) {
        this.optionSettings.put(string, string2);
    }

    public String getOption(String string) {
        return (String)this.optionSettings.get(string);
    }

    public void finish() {
        if (this.finishedAlready) {
            return;
        }
        this.finishedAlready = true;
        HashMap<String, String> hashMap = new HashMap<String, String>(this.rules.size());
        for (Rule rule : this.rules) {
            rule.finish();
            hashMap.put(rule.getRHS().getActionClassName(), rule.getRHS().getActionClassString());
        }
        try {
            Javac.loadClasses(hashMap);
        }
        catch (Exception exception) {
            throw new GateRuntimeException(exception);
        }
        this.fsm = this.createFSM();
        this.rules.clear();
        this.rules = null;
    }

    protected FSM createFSM() {
        return new FSM(this);
    }

    private void addAnnotationsByOffset(SimpleSortedSet simpleSortedSet, Set set) {
        for (Annotation annotation : set) {
            long l = annotation.getStartNode().getOffset();
            if (l == annotation.getEndNode().getOffset()) continue;
            simpleSortedSet.add(l, annotation);
        }
    }

    public void transduce(Document document, AnnotationSet annotationSet, AnnotationSet annotationSet2) throws JapeException, ExecutionException {
        Cloneable cloneable;
        Object object;
        SimpleSortedSet simpleSortedSet;
        this.interrupted = false;
        this.fireProgressChanged(0);
        SimpleSortedSet simpleSortedSet2 = simpleSortedSet = new SimpleSortedSet();
        if (this.input.isEmpty()) {
            this.addAnnotationsByOffset(simpleSortedSet, annotationSet);
        } else {
            object = this.input.iterator();
            cloneable = null;
            while (object.hasNext()) {
                cloneable = annotationSet.get((String)object.next());
                if (cloneable == null) continue;
                this.addAnnotationsByOffset(simpleSortedSet, (Set)((Object)cloneable));
            }
        }
        if (simpleSortedSet2.isEmpty()) {
            this.fireProcessFinished();
            return;
        }
        simpleSortedSet2.sort();
        object = new ArrayList();
        cloneable = new ArrayList();
        Node node = ((Annotation)((ArrayList)simpleSortedSet2.get(simpleSortedSet.first())).get(0)).getStartNode();
        long l = document.getContent().size();
        long l2 = node.getOffset();
        SearchState searchState = new SearchState(node, l2, 0L);
        if (Gate.isEnableJapeDebug() && null != this.phaseController) {
            this.rulesTrace = new TraceContainer();
            this.rulesTrace.putPhaseCut(this, annotationSet);
        }
        while (searchState.startNodeOff != -1L) {
            boolean bl;
            FSMInstance fSMInstance = new FSMInstance(this.fsm, this.fsm.getInitialState(), searchState.startNode, searchState.startNode, new HashMap(), document);
            ((ArrayList)object).clear();
            ((ArrayList)cloneable).clear();
            ((ArrayList)object).add(fSMInstance);
            while (!(((ArrayList)object).isEmpty() || (bl = this.attemptAdvance((ArrayList)object, (ArrayList)cloneable, simpleSortedSet, simpleSortedSet2, document)) && this.ruleApplicationStyle == 3)) {
            }
            bl = this.fireRule((ArrayList)cloneable, searchState, l, simpleSortedSet, annotationSet, annotationSet2, document, simpleSortedSet2);
            if (bl) continue;
            return;
        }
        this.fireProcessFinished();
    }

    protected boolean attemptAdvance(ArrayList arrayList, ArrayList arrayList2, SimpleSortedSet simpleSortedSet, SimpleSortedSet simpleSortedSet2, Document document) throws ExecutionInterruptedException {
        SimpleSortedSet simpleSortedSet3;
        long l;
        if (this.interrupted) {
            throw new ExecutionInterruptedException("The execution of the \"" + this.getName() + "\" Jape transducer has been abruptly interrupted!");
        }
        FSMInstance fSMInstance = (FSMInstance)arrayList.remove(0);
        if (fSMInstance.getFSMPosition().isFinal()) {
            arrayList2.add(fSMInstance.clone());
            if (this.ruleApplicationStyle == 3) {
                return true;
            }
        }
        if ((l = (simpleSortedSet3 = simpleSortedSet.tailSet(fSMInstance.getAGPosition().getOffset())).first()) < 0L) {
            return false;
        }
        ArrayList arrayList3 = (ArrayList)simpleSortedSet2.get(l);
        if (arrayList3.isEmpty()) {
            return false;
        }
        Iterator iterator = arrayList3.iterator();
        State state = fSMInstance.getFSMPosition();
        while (iterator.hasNext()) {
            Serializable serializable = (Annotation)iterator.next();
            block1: for (Transition transition : state.getTransitions()) {
                Constraint[] constraintArray = transition.getConstraints().getConstraints();
                if (!serializable.getType().equals(constraintArray[0].getAnnotType()) || !serializable.getFeatures().subsumes(this.ontology, constraintArray[0].getAttributeSeq())) continue;
                Object object = constraintArray[0];
                if (constraintArray.length > 1) {
                    int n = serializable.getEndNode().getOffset().intValue();
                    block2: for (int i = 1; i < constraintArray.length; ++i) {
                        Constraint constraint = constraintArray[i];
                        for (Serializable serializable2 : arrayList3) {
                            if (!serializable2.getType().equals(constraint.getAnnotType()) || !serializable2.getFeatures().subsumes(this.ontology, constraint.getAttributeSeq())) continue;
                            if (serializable2.getEndNode().getOffset().intValue() <= n) continue block2;
                            serializable = serializable2;
                            object = constraint;
                            n = serializable2.getEndNode().getOffset().intValue();
                            continue block2;
                        }
                        continue block1;
                    }
                }
                FSMInstance fSMInstance2 = (FSMInstance)fSMInstance.clone();
                fSMInstance2.setAGPosition(serializable.getEndNode());
                fSMInstance2.setFSMPosition(transition.getTarget());
                if (Gate.isEnableJapeDebug() && null != this.phaseController) {
                    this.currRuleTrace = this.rulesTrace.getStateContainer(fSMInstance.getFSMPosition());
                    if (this.currRuleTrace == null) {
                        this.currRuleTrace = new RuleTrace(fSMInstance2.getFSMPosition(), document);
                        this.currRuleTrace.addAnnotation((Annotation)serializable);
                        this.currRuleTrace.putPattern((Annotation)serializable, ((Constraint)object).getAttributeSeq());
                        this.rulesTrace.add(this.currRuleTrace);
                    } else {
                        this.currRuleTrace.addState(fSMInstance2.getFSMPosition());
                        this.currRuleTrace.addAnnotation((Annotation)serializable);
                        this.currRuleTrace.putPattern((Annotation)serializable, ((Constraint)object).getAttributeSeq());
                    }
                }
                HashMap hashMap = fSMInstance2.getBindings();
                for (Object object2 : transition.getBindings()) {
                    Serializable serializable2;
                    serializable2 = (AnnotationSet)hashMap.get(object2);
                    AnnotationSetImpl annotationSetImpl = serializable2 != null ? new AnnotationSetImpl((AnnotationSet)serializable2) : new AnnotationSetImpl(document);
                    annotationSetImpl.add((Annotation)serializable);
                    hashMap.put(object2, annotationSetImpl);
                }
                arrayList.add(fSMInstance2);
            }
        }
        return false;
    }

    protected boolean fireRule(ArrayList arrayList, SearchState searchState, long l, SimpleSortedSet simpleSortedSet, AnnotationSet annotationSet, AnnotationSet annotationSet2, Document document, SimpleSortedSet simpleSortedSet2) throws JapeException, ExecutionException {
        FSMInstance fSMInstance;
        Object object;
        Node node = searchState.startNode;
        long l2 = searchState.startNodeOff;
        long l3 = searchState.oldStartNodeOff;
        long l4 = -1L;
        if (arrayList.isEmpty()) {
            l4 = l2 + 1L;
        } else if (this.ruleApplicationStyle == 1 || this.ruleApplicationStyle == 5) {
            object = arrayList.iterator();
            l4 = node.getOffset();
            while (object.hasNext()) {
                long l5;
                SPTLock sPTLock;
                fSMInstance = (FSMInstance)object.next();
                RightHandSide rightHandSide = fSMInstance.getFSMPosition().getAction();
                if (Gate.isEnableJapeDebug() && null != this.phaseController) {
                    sPTLock = new SPTLock();
                    this.phaseController.TraceTransit(this.rulesTrace);
                    this.rulesTrace = new TraceContainer();
                    this.phaseController.RuleMatched(sPTLock, this, rightHandSide, document, fSMInstance.getBindings(), annotationSet, annotationSet2);
                }
                rightHandSide.transduce(document, fSMInstance.getBindings(), annotationSet, annotationSet2, this.ontology);
                if (Gate.isEnableJapeDebug() && null != this.phaseController) {
                    sPTLock = new SPTLock();
                    this.phaseController.RuleFinished(sPTLock, this, rightHandSide, document, fSMInstance.getBindings(), annotationSet, annotationSet2);
                }
                if (this.ruleApplicationStyle != 1 || (l5 = fSMInstance.getAGPosition().getOffset().longValue()) <= l4) continue;
                l4 = l5;
            }
            if (this.ruleApplicationStyle == 5) {
                ++l4;
            }
        } else if (this.ruleApplicationStyle == 2 || this.ruleApplicationStyle == 3 || this.ruleApplicationStyle == 4) {
            Object object2;
            Cloneable cloneable;
            Object object3;
            Collections.sort(arrayList, Collections.reverseOrder());
            object = arrayList.iterator();
            fSMInstance = (FSMInstance)object.next();
            if (this.isDebugMode()) {
                object3 = arrayList.iterator();
                cloneable = new ArrayList<Object>();
                while (object3.hasNext() && ((FSMInstance)(object2 = (FSMInstance)object3.next())).equals(fSMInstance)) {
                    cloneable.add(object2);
                }
                if (cloneable.size() > 1) {
                    Out.prln("\nConflicts found during matching:\n================================");
                    object3 = cloneable.iterator();
                    int n = 0;
                    while (object3.hasNext()) {
                        Out.prln(n++ + ") " + object3.next().toString());
                    }
                }
            }
            object3 = fSMInstance.getFSMPosition().getAction();
            if (Gate.isEnableJapeDebug() && null != this.phaseController) {
                object2 = new SPTLock();
                this.rulesTrace.leaveLast((RightHandSide)object3);
                this.phaseController.TraceTransit(this.rulesTrace);
                this.rulesTrace = new TraceContainer();
                this.phaseController.RuleMatched((SPTLock)object2, this, (RightHandSide)object3, document, fSMInstance.getBindings(), annotationSet, annotationSet2);
            }
            ((RightHandSide)object3).transduce(document, fSMInstance.getBindings(), annotationSet, annotationSet2, this.ontology);
            if (Gate.isEnableJapeDebug() && null != this.phaseController) {
                object2 = new SPTLock();
                this.phaseController.RuleFinished((SPTLock)object2, this, (RightHandSide)object3, document, fSMInstance.getBindings(), annotationSet, annotationSet2);
            }
            if (this.isMatchGroupMode()) {
                object2 = null;
                while (object.hasNext() && ((FSMInstance)(cloneable = (FSMInstance)object.next())).compareTo(fSMInstance) == 0) {
                    if (((FSMInstance)cloneable).equals(fSMInstance)) continue;
                    if (this.isDebugMode()) {
                        if (object2 == null) {
                            object2 = fSMInstance.toString();
                            Out.prln("~Jape Grammar Transducer : \nConcurrent Patterns by length,priority and index (all transduced):");
                            Out.prln((String)object2);
                            Out.prln("bindings : " + fSMInstance.getBindings());
                            Out.prln("Rivals Follow: ");
                        }
                        Out.prln(cloneable);
                        Out.prln("bindings : " + ((FSMInstance)cloneable).getBindings());
                    }
                    object3 = ((FSMInstance)cloneable).getFSMPosition().getAction();
                    if (Gate.isEnableJapeDebug() && null != this.phaseController) {
                        SPTLock sPTLock = new SPTLock();
                        this.rulesTrace.leaveLast((RightHandSide)object3);
                        this.phaseController.TraceTransit(this.rulesTrace);
                        this.rulesTrace = new TraceContainer();
                        this.phaseController.RuleMatched(sPTLock, this, (RightHandSide)object3, document, ((FSMInstance)cloneable).getBindings(), annotationSet, annotationSet2);
                    }
                    ((RightHandSide)object3).transduce(document, ((FSMInstance)cloneable).getBindings(), annotationSet, annotationSet2, this.ontology);
                    if (!Gate.isEnableJapeDebug() || null == this.phaseController) continue;
                    SPTLock sPTLock = new SPTLock();
                    this.phaseController.RuleFinished(sPTLock, this, (RightHandSide)object3, document, ((FSMInstance)cloneable).getBindings(), annotationSet, annotationSet2);
                }
            }
            if (this.ruleApplicationStyle == 4) {
                searchState.startNodeOff = l2;
                return false;
            }
            l4 = fSMInstance.getAGPosition().getOffset();
        } else {
            throw new RuntimeException("Unknown rule application style!");
        }
        object = simpleSortedSet.tailSet(l4);
        long l6 = ((SimpleSortedSet)object).first();
        if (l6 < 0L) {
            l2 = -1L;
            this.fireProcessFinished();
        } else {
            long l7 = l6;
            node = ((Annotation)((ArrayList)simpleSortedSet2.get(l7)).get(0)).getStartNode();
            l2 = node.getOffset();
            if (l3 == l2) {
                l4 = l2 + 1L;
                object = simpleSortedSet.tailSet(l4);
                l6 = ((SimpleSortedSet)object).first();
                if (l6 < 0L) {
                    l2 = -1L;
                    this.fireProcessFinished();
                } else {
                    l7 = l6;
                    node = ((Annotation)((List)simpleSortedSet2.get(l6)).get(0)).getStartNode();
                    l2 = node.getOffset();
                }
            }
            if (l2 - l3 > 256L) {
                if (this.isInterrupted()) {
                    throw new ExecutionInterruptedException("The execution of the \"" + this.getName() + "\" Jape transducer has been abruptly interrupted!");
                }
                this.fireProgressChanged((int)(100L * l2 / l));
                l3 = l2;
            }
        }
        searchState.oldStartNodeOff = l3;
        searchState.startNodeOff = l2;
        searchState.startNode = node;
        return true;
    }

    public void cleanUp() {
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        String string2 = Strings.getNl();
        String string3 = Strings.addPadding(string, 4);
        StringBuffer stringBuffer = new StringBuffer(string + "SPT: name(" + this.name + "); ruleApplicationStyle(");
        switch (this.ruleApplicationStyle) {
            case 2: {
                stringBuffer.append("APPELT_STYLE); ");
                break;
            }
            case 1: {
                stringBuffer.append("BRILL_STYLE); ");
                break;
            }
        }
        stringBuffer.append("rules(" + string2);
        Iterator iterator = this.rules.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((Rule)iterator.next()).toString(string3) + " ");
        }
        stringBuffer.append(string2 + string + ")." + string2);
        return stringBuffer.toString();
    }

    public PrioritisedRuleList getRules() {
        return this.rules;
    }

    public void addInput(String string) {
        this.input.add(string);
    }

    public boolean hasInput(String string) {
        return this.input.isEmpty() || this.input.contains(string);
    }

    public boolean isInputRestricted() {
        return !this.input.isEmpty();
    }

    public synchronized void removeProgressListener(ProgressListener progressListener) {
        if (this.progressListeners != null && this.progressListeners.contains(progressListener)) {
            Vector vector = (Vector)this.progressListeners.clone();
            vector.removeElement(progressListener);
            this.progressListeners = vector;
        }
    }

    public synchronized void addProgressListener(ProgressListener progressListener) {
        Vector vector;
        Vector vector2 = vector = this.progressListeners == null ? new Vector(2) : (Vector)this.progressListeners.clone();
        if (!vector.contains(progressListener)) {
            vector.addElement(progressListener);
            this.progressListeners = vector;
        }
    }

    protected void fireProgressChanged(int n) {
        if (this.progressListeners != null) {
            Vector vector = this.progressListeners;
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                ((ProgressListener)vector.elementAt(i)).progressChanged(n);
            }
        }
    }

    protected void fireProcessFinished() {
        if (this.progressListeners != null) {
            Vector vector = this.progressListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ProgressListener)vector.elementAt(i)).processFinished();
            }
        }
    }

    public int getRuleApplicationStyle() {
        return this.ruleApplicationStyle;
    }

    protected static class SearchState {
        Node startNode;
        long startNodeOff;
        long oldStartNodeOff;

        SearchState(Node node, long l, long l2) {
            this.startNode = node;
            this.startNodeOff = l;
            this.oldStartNodeOff = l2;
        }
    }
}

