/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.AnnotationSet;
import gate.Document;
import gate.Gate;
import gate.creole.ontology.Ontology;
import gate.jape.JapeConstants;
import gate.jape.JapeException;
import gate.jape.LeftHandSide;
import gate.jape.RhsAction;
import gate.util.GateRuntimeException;
import gate.util.Javac;
import gate.util.Strings;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;

public class RightHandSide
implements JapeConstants,
Serializable {
    private static final boolean DEBUG = false;
    private transient Object theActionObject;
    private StringBuffer actionClassString;
    private byte[] actionClassBytes;
    private String actionClassName;
    private static String actionsDirName = "japeactionclasses";
    private String actionClassQualifiedName;
    private String actionClassJavaFileName;
    private String actionClassClassFileName;
    private static int actionClassNumber = 0;
    private HashSet blockNames;
    private LeftHandSide lhs;
    private static ArrayList tempFiles = new ArrayList();
    private final String nl = Strings.getNl();
    static final boolean debug = false;
    private String phaseName;
    private String ruleName;

    public static void setActionClassNumber(int n) {
        actionClassNumber = n;
    }

    public String getActionClassString() {
        return this.actionClassString.toString();
    }

    public String getActionClassName() {
        return this.actionClassQualifiedName;
    }

    public RightHandSide(String string, String string2, LeftHandSide leftHandSide) {
        this.lhs = leftHandSide;
        this.phaseName = string;
        this.ruleName = string2;
        this.actionClassName = new String(string + string2 + "ActionClass" + actionClassNumber++);
        this.blockNames = new HashSet();
        this.actionClassString = new StringBuffer("// " + this.actionClassName + this.nl + "package " + actionsDirName + "; " + this.nl + "import java.io.*;" + this.nl + "import java.util.*;" + this.nl + "import gate.*;" + this.nl + "import gate.jape.*;" + this.nl + "import gate.creole.ontology.Ontology;" + this.nl + "import gate.annotation.*;" + this.nl + "import gate.util.*;" + this.nl + this.nl + "public class " + this.actionClassName + this.nl + "implements java.io.Serializable, RhsAction { " + this.nl + "  public void doit(Document doc, java.util.Map bindings, " + this.nl + "                   AnnotationSet annotations, " + this.nl + "                   AnnotationSet inputAS, AnnotationSet outputAS, " + this.nl + "                   Ontology ontology) {" + this.nl);
        this.actionClassJavaFileName = actionsDirName + File.separator + this.actionClassName.replace('.', File.separatorChar) + ".java";
        this.actionClassQualifiedName = actionsDirName.replace(File.separatorChar, '.').replace('/', '.').replace('\\', '.') + "." + this.actionClassName;
        this.actionClassClassFileName = this.actionClassQualifiedName.replace('.', File.separatorChar) + ".class";
    }

    public void addBlock(String string) {
        this.actionClassString.append(this.nl);
        this.actionClassString.append("{");
        this.actionClassString.append(string);
        this.actionClassString.append(this.nl);
        this.actionClassString.append("}");
        this.actionClassString.append(this.nl);
    }

    public void addBlock(String string, String string2) {
        if (string == null) {
            this.addBlock(string2);
            return;
        }
        if (this.blockNames.add(string)) {
            this.actionClassString.append("    AnnotationSet " + string + "Annots = (AnnotationSet)bindings.get(\"" + string + "\"); " + this.nl);
        }
        this.actionClassString.append("    if(" + string + "Annots != null && " + string + "Annots.size() != 0) { " + this.nl + "      " + string2 + this.nl + "    }" + this.nl);
    }

    public void createActionClass() throws JapeException {
        this.actionClassString.append("  }" + this.nl + "}" + this.nl);
    }

    public void instantiateActionClass() throws JapeException {
        try {
            this.theActionObject = Gate.getClassLoader().loadClass(this.actionClassQualifiedName).newInstance();
        }
        catch (Exception exception) {
            throw new JapeException("couldn't create instance of action class " + this.actionClassName + ": " + exception.getMessage());
        }
    }

    public static void cleanUp() {
        if (tempFiles.size() == 0) {
            return;
        }
        ListIterator listIterator = tempFiles.listIterator(tempFiles.size() - 1);
        while (listIterator.hasPrevious()) {
            File file = (File)listIterator.previous();
            file.delete();
        }
        tempFiles.clear();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        try {
            Class<?> clazz = Gate.getClassLoader().loadClass(this.actionClassQualifiedName);
            System.out.println(clazz.getName());
            objectOutputStream.writeObject(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new GateRuntimeException(classNotFoundException);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        String string = this.getActionClassName();
        if (Gate.getClassLoader().findExistingClass(this.getActionClassName()) == null) {
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put(this.getActionClassName(), this.getActionClassString());
                Javac.loadClasses(hashMap);
            }
            catch (Exception exception) {
                throw new GateRuntimeException(exception);
            }
        }
    }

    public void transduce(Document document, Map map, AnnotationSet annotationSet, AnnotationSet annotationSet2, Ontology ontology) throws JapeException {
        if (this.theActionObject == null) {
            this.instantiateActionClass();
        }
        try {
            ((RhsAction)this.theActionObject).doit(document, map, annotationSet2, annotationSet, annotationSet2, ontology);
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            throw new JapeException("Couldn't run RHS action: " + Strings.getNl() + stringWriter.getBuffer().toString() + Strings.addLineNumbers(this.actionClassString.toString()));
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        String string2 = Strings.getNl();
        StringBuffer stringBuffer = new StringBuffer(string + "RHS: actionClassName(" + this.actionClassName + "); ");
        stringBuffer.append("actionClassClassFileName(" + string2 + this.actionClassClassFileName + string2);
        stringBuffer.append("actionClassJavaFileName(" + string2 + this.actionClassJavaFileName + string2);
        stringBuffer.append("actionClassQualifiedName(" + string2 + this.actionClassQualifiedName + string2);
        stringBuffer.append("blockNames(" + this.blockNames.toString() + "); ");
        stringBuffer.append(string2 + string + ") RHS." + string2);
        return stringBuffer.toString();
    }

    public String shortDesc() {
        String string = "" + this.actionClassName;
        return string;
    }

    public void setPhaseName(String string) {
        this.phaseName = string;
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public void setRuleName(String string) {
        this.ruleName = string;
    }

    public String getRuleName() {
        return this.ruleName;
    }
}

