/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.AnnotationSet;
import gate.Document;
import gate.creole.ExecutionException;
import gate.creole.ExecutionInterruptedException;
import gate.creole.ontology.Ontology;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import gate.jape.JapeConstants;
import gate.jape.JapeException;
import gate.jape.Transducer;
import gate.util.Err;
import gate.util.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class MultiPhaseTransducer
extends Transducer
implements JapeConstants,
Serializable {
    private static final boolean DEBUG = false;
    private ArrayList phases = new ArrayList();

    public MultiPhaseTransducer(String string) {
        this();
        this.setName(string);
    }

    public synchronized void interrupt() {
        this.interrupted = true;
        Iterator iterator = this.phases.iterator();
        while (iterator.hasNext()) {
            ((Transducer)iterator.next()).interrupt();
        }
    }

    public MultiPhaseTransducer() {
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setOntology(Ontology ontology) {
        super.setOntology(ontology);
        Iterator iterator = this.phases.iterator();
        while (iterator.hasNext()) {
            ((Transducer)iterator.next()).setOntology(ontology);
        }
    }

    public void addPhase(String string, Transducer transducer) {
        this.phases.add(transducer);
    }

    public void orderPhases(String[] stringArray) {
        Err.println("oops: MPT.orderPhases not done yet :-(");
    }

    public void finish() {
        Iterator iterator = this.phases.iterator();
        while (iterator.hasNext()) {
            ((Transducer)iterator.next()).finish();
        }
    }

    public void transduce(Document document, AnnotationSet annotationSet, AnnotationSet annotationSet2) throws JapeException, ExecutionException {
        this.interrupted = false;
        ProgressListener progressListener = null;
        StatusListener statusListener = null;
        progressListener = new ProgressListener(){
            int phasesCnt;
            int donePhases;
            {
                this.phasesCnt = MultiPhaseTransducer.this.phases.size();
                this.donePhases = 0;
            }

            public void processFinished() {
                ++this.donePhases;
                if (this.donePhases == this.phasesCnt) {
                    MultiPhaseTransducer.this.fireProcessFinished();
                }
            }

            public void progressChanged(int n) {
                int n2 = (this.donePhases * 100 + n) / this.phasesCnt;
                MultiPhaseTransducer.this.fireProgressChanged(n2);
            }
        };
        statusListener = new StatusListener(){

            public void statusChanged(String string) {
                MultiPhaseTransducer.this.fireStatusChanged(string);
            }
        };
        for (Transducer transducer : this.phases) {
            if (this.isInterrupted()) {
                throw new ExecutionInterruptedException("The execution of the \"" + this.getName() + "\" Jape transducer has been abruptly interrupted!");
            }
            try {
                this.fireStatusChanged("Transducing " + document.getName() + " (Phase: " + transducer.getName() + ")...");
                transducer.addProgressListener(progressListener);
                transducer.addStatusListener(statusListener);
                transducer.transduce(document, annotationSet, annotationSet2);
                transducer.removeProgressListener(progressListener);
                transducer.removeStatusListener(statusListener);
                this.fireStatusChanged("");
            }
            catch (JapeException japeException) {
                String string = new String("Error transducing document " + document.getName() + ", phase " + transducer.getName() + Strings.getNl() + japeException.getMessage());
                throw new JapeException(string);
            }
        }
        this.cleanUp();
    }

    public void setEnableDebugging(boolean bl) {
        this.enableDebugging = bl;
        for (int i = 0; i < this.phases.size(); ++i) {
            ((Transducer)this.phases.get(i)).setEnableDebugging(bl);
        }
    }

    public void cleanUp() {
        Iterator iterator = this.phases.iterator();
        while (iterator.hasNext()) {
            ((Transducer)iterator.next()).cleanUp();
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        String string2 = Strings.getNl();
        StringBuffer stringBuffer = new StringBuffer(string + "MPT: name(" + this.name + "); phases(" + string2 + string);
        Iterator iterator = this.phases.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((Transducer)iterator.next()).toString(Strings.addPadding(string, 4)) + " ");
        }
        stringBuffer.append(string2 + string + ")." + string2);
        return stringBuffer.toString();
    }

    public ArrayList getPhases() {
        return this.phases;
    }

    public void setPhases(ArrayList arrayList) {
        this.phases = arrayList;
    }
}

