/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.AnnotationSet;
import gate.Document;
import gate.jape.ComplexPatternElement;
import gate.jape.ConstraintGroup;
import gate.jape.JapeConstants;
import gate.jape.JapeException;
import gate.jape.Matcher;
import gate.jape.MutableInteger;
import gate.util.Strings;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class LeftHandSide
implements Matcher,
JapeConstants,
Serializable {
    private static final boolean DEBUG = false;
    private ConstraintGroup constraintGroup;
    private HashMap bindingTable;
    private boolean hasMatched = false;

    public LeftHandSide(ConstraintGroup constraintGroup) {
        this.constraintGroup = constraintGroup;
        this.bindingTable = new HashMap();
        this.hasMatched = false;
    }

    public void addBinding(String string, ComplexPatternElement complexPatternElement, HashSet hashSet, boolean bl) throws JapeException {
        if (this.bindingTable.get(string) != null) {
            throw new JapeException("LeftHandSide.addBinding: " + string + " already bound");
        }
        this.bindingTable.put(string, complexPatternElement);
        hashSet.add(string);
        if (bl) {
            Iterator iterator = complexPatternElement.getCPEs();
            while (iterator.hasNext()) {
                complexPatternElement = (ComplexPatternElement)iterator.next();
                string = complexPatternElement.getBindingName();
                if (string == null) continue;
                if (this.bindingTable.get(string) != null) {
                    throw new JapeException("LeftHandSide.addBinding: " + string + " already bound");
                }
                this.bindingTable.put(string, complexPatternElement);
                hashSet.add(string);
            }
        }
    }

    public void finish() {
        this.constraintGroup.finish();
    }

    public AnnotationSet getBoundAnnots(String string) {
        ComplexPatternElement complexPatternElement = (ComplexPatternElement)this.bindingTable.get(string);
        if (complexPatternElement == null) {
            return null;
        }
        return complexPatternElement.getMatchedAnnots();
    }

    AnnotationSet getMatchedAnnots() {
        return this.constraintGroup.getMatchedAnnots();
    }

    public void reset() {
        this.constraintGroup.reset();
        this.hasMatched = false;
    }

    public boolean hasMatched() {
        return this.hasMatched;
    }

    public boolean matches(Document document, int n, MutableInteger mutableInteger) {
        boolean bl = this.constraintGroup.matches(document, n, mutableInteger);
        if (!bl) {
            this.constraintGroup.reset();
            this.hasMatched = false;
        } else {
            this.hasMatched = true;
        }
        return bl;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        String string2 = Strings.getNl();
        String string3 = Strings.addPadding(string, 4);
        StringBuffer stringBuffer = new StringBuffer(string + "LHS: hasMatched(" + this.hasMatched + "); constraintGroup(" + string2 + this.constraintGroup.toString(string3) + string2 + string + "); bindingTable(" + string2 + string);
        for (String string4 : this.bindingTable.keySet()) {
            ComplexPatternElement complexPatternElement = (ComplexPatternElement)this.bindingTable.get(string4);
            stringBuffer.append(string + "bT.bn(" + string4 + "), cpe.bn(" + complexPatternElement.getBindingName() + ")");
        }
        stringBuffer.append(string2 + string + ") LHS." + string2);
        return stringBuffer.toString();
    }

    public ConstraintGroup getConstraintGroup() {
        return this.constraintGroup;
    }
}

