/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.FeatureMap;
import gate.jape.JapeConstants;
import gate.jape.JdmAttribute;
import gate.util.SimpleFeatureMapImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class Constraint
implements JapeConstants,
Serializable,
Cloneable {
    private static final boolean DEBUG = false;
    private String annotType;
    private boolean negated = false;
    private FeatureMap attrs1;
    private JdmAttribute[] attrs2;

    public Constraint(String string) {
        this(string, new SimpleFeatureMapImpl());
    }

    public Constraint(String string, FeatureMap featureMap) {
        this.annotType = string;
        this.attrs1 = featureMap;
    }

    public Constraint(String string, ArrayList arrayList) {
        this(string, new SimpleFeatureMapImpl());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.attrs1.put(((JdmAttribute)iterator.next()).getName(), ((JdmAttribute)iterator.next()).getValue());
        }
    }

    public void negate() {
        this.negated = true;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public String getAnnotType() {
        return this.annotType;
    }

    public FeatureMap getAttributeSeq() {
        return this.attrs1;
    }

    public JdmAttribute[] getAttributeArray() {
        return this.attrs2;
    }

    public void addAttribute(JdmAttribute jdmAttribute) {
        this.attrs1.put(jdmAttribute.getName(), jdmAttribute.getValue());
    }

    public void addAttribute(String string, Object object) {
        this.attrs1.put(string, object);
    }

    public Object clone() {
        Constraint constraint = null;
        try {
            constraint = (Constraint)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
        constraint.annotType = this.annotType;
        constraint.attrs1 = (FeatureMap)((SimpleFeatureMapImpl)this.attrs1).clone();
        return constraint;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Constraint)) {
            return super.equals(object);
        }
        Constraint constraint = (Constraint)object;
        return constraint.negated == this.negated && constraint.annotType.equals(this.annotType) && constraint.attrs1.toString().equals(this.attrs1.toString());
    }

    public int hashCode() {
        int n = this.negated ? 0 : 629;
        n = 37 * n + this.annotType.hashCode();
        n = 37 * n + this.attrs1.hashCode();
        return n;
    }

    public void finish() {
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string + "Constraint: " + this.annotType + (this.negated ? "!=" : "="));
        stringBuffer.append(this.attrs1 == null ? Arrays.asList(this.attrs2).toString() : this.attrs1.toString());
        return stringBuffer.toString();
    }

    public String shortDesc() {
        String string = this.annotType + "(";
        if (this.attrs1 == null) {
            for (int i = 0; i < this.attrs2.length; ++i) {
                string = string + " " + this.attrs2[i];
            }
        } else {
            string = string + this.attrs1.toString();
        }
        string = string + ")";
        return string;
    }
}

