/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.AnnotationSet;
import gate.Document;
import gate.jape.ConstraintGroup;
import gate.jape.JapeConstants;
import gate.jape.MutableInteger;
import gate.jape.PatternElement;
import gate.util.Strings;
import java.io.Serializable;
import java.util.Iterator;

public class ComplexPatternElement
extends PatternElement
implements JapeConstants,
Serializable {
    private static final boolean DEBUG = false;
    private int kleeneOp = 0;
    private String bindingName = null;
    private ConstraintGroup constraintGroup;

    public String getBindingName() {
        return this.bindingName;
    }

    protected Iterator getCPEs() {
        return this.constraintGroup.getCPEs();
    }

    public ComplexPatternElement(ConstraintGroup constraintGroup, int n, String string) {
        this.constraintGroup = constraintGroup;
        this.kleeneOp = n;
        this.bindingName = string;
    }

    public Object clone() {
        ComplexPatternElement complexPatternElement = (ComplexPatternElement)super.clone();
        complexPatternElement.constraintGroup = (ConstraintGroup)this.constraintGroup.clone();
        return complexPatternElement;
    }

    public void finish() {
        this.constraintGroup.finish();
    }

    public AnnotationSet getMatchedAnnots() {
        return this.constraintGroup.getMatchedAnnots();
    }

    public void reset() {
        this.constraintGroup.reset();
        super.reset();
    }

    public void rollback(int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = (Integer)this.matchHistory.pop();
            this.constraintGroup.rollback(n2);
        }
    }

    public boolean matches(Document document, int n, MutableInteger mutableInteger) {
        int n2 = 0;
        boolean bl = this.constraintGroup.matches(document, n, mutableInteger);
        if (bl) {
            ++n2;
        }
        int n3 = document.getContent().size().intValue();
        if (this.kleeneOp == 0) {
            if (bl) {
                this.matchHistory.push(new Integer(n2));
            }
            return bl;
        }
        if (this.kleeneOp == 3) {
            if (bl) {
                this.matchHistory.push(new Integer(n2));
            }
            return true;
        }
        if (this.kleeneOp == 2) {
            if (!bl) {
                return false;
            }
        } else if (this.kleeneOp == 1 && !bl) {
            this.matchHistory.push(new Integer(n2));
            return true;
        }
        while (this.constraintGroup.matches(document, mutableInteger.value, mutableInteger)) {
            ++n2;
            if (mutableInteger.value < n3) continue;
        }
        this.matchHistory.push(new Integer(n2));
        return true;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        String string2 = Strings.getNl();
        StringBuffer stringBuffer = new StringBuffer(string + "CPE: bindingName(" + this.bindingName + "); kleeneOp(");
        switch (this.kleeneOp) {
            case 0: {
                stringBuffer.append("NO_KLEENE_OP");
                break;
            }
            case 1: {
                stringBuffer.append("KLEENE_STAR");
                break;
            }
            case 3: {
                stringBuffer.append("KLEENE_QUERY");
                break;
            }
            case 2: {
                stringBuffer.append("KLEENE_PLUS");
                break;
            }
        }
        stringBuffer.append("); constraintGroup(" + string2 + this.constraintGroup.toString(Strings.addPadding(string, 4)) + string2 + string + ") CPE." + string2);
        return stringBuffer.toString();
    }

    public int getKleeneOp() {
        return this.kleeneOp;
    }

    public ConstraintGroup getConstraintGroup() {
        return this.constraintGroup;
    }
}

