/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.Factory;
import gate.jape.JapeException;
import gate.jape.MultiPhaseTransducer;
import gate.jape.Transducer;
import gate.jape.parser.ParseCpsl;
import gate.jape.parser.ParseException;
import gate.util.Err;
import gate.util.Out;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class Compiler {
    private static final boolean DEBUG = false;
    private static boolean verbose = false;
    static String defaultEncoding = "UTF-8";

    public static void main(String[] stringArray) {
        int n = 0;
        while (stringArray[n].toCharArray()[0] == '-') {
            if (!stringArray[n++].equals("-v")) continue;
            verbose = true;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while (n < stringArray.length) {
            arrayList.add(stringArray[n]);
            ++n;
        }
        Compiler.compile(arrayList);
        Compiler.message("done");
    }

    public static void compile(String string, String string2) {
        Compiler.message("parsing " + string);
        Transducer transducer = null;
        try {
            transducer = Compiler.parseJape(string, string2);
        }
        catch (JapeException japeException) {
            Compiler.emessage("couldn't compile " + string + ": " + japeException);
            return;
        }
        Compiler.message("saving " + string);
        try {
            Compiler.saveJape(string, transducer);
        }
        catch (JapeException japeException) {
            Compiler.emessage("couldn't save " + string + ": " + japeException);
        }
        Compiler.message("finished " + string);
    }

    public static void compile(ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Compiler.compile((String)iterator.next(), defaultEncoding);
        }
    }

    public static Transducer parseJape(String string, String string2) throws JapeException {
        MultiPhaseTransducer multiPhaseTransducer = null;
        try {
            ParseCpsl parseCpsl = Factory.newJapeParser(new File(string).toURI().toURL(), string2);
            multiPhaseTransducer = parseCpsl.MultiPhaseTransducer();
        }
        catch (ParseException parseException) {
            throw new JapeException(parseException.toString());
        }
        catch (IOException iOException) {
            throw new JapeException(iOException.toString());
        }
        return multiPhaseTransducer;
    }

    public static void saveJape(String string, Transducer transducer) throws JapeException {
        String string2 = Compiler.japeNameToSaveName(string);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(transducer);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            throw new JapeException(iOException.toString());
        }
    }

    static String japeNameToSaveName(String string) {
        String string2 = string;
        if (string.endsWith(".jape") || string.endsWith(".JAPE")) {
            string2 = string.substring(0, string.length() - 5);
        }
        return string2 + ".ser";
    }

    public static void message(String string) {
        if (verbose) {
            Out.println("JAPE compiler: " + string);
        }
    }

    public static void emessage(String string) {
        Err.println("JAPE compiler error: " + string);
    }
}

