/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.AnnotationSet;
import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.creole.ExecutionException;
import gate.creole.ontology.Ontology;
import gate.event.ProgressListener;
import gate.event.StatusListener;
import gate.jape.JapeConstants;
import gate.jape.JapeException;
import gate.jape.Transducer;
import gate.jape.parser.ParseCpsl;
import gate.jape.parser.ParseException;
import gate.util.Err;
import gate.util.Out;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.Vector;

public class Batch
implements JapeConstants {
    private static final boolean DEBUG = false;
    private URL japeURL;
    private String encoding;
    private Transducer transducer;
    private boolean verbose = false;
    private FeatureMap features;
    private transient Vector progressListeners;
    private transient Vector statusListeners;
    private boolean enableDebugging;

    private Batch() {
    }

    public Batch(URL uRL, String string) throws JapeException {
        this.japeURL = uRL;
        this.encoding = string;
        this.parseJape();
        this.linkListeners();
    }

    public Batch(URL uRL, String string, StatusListener statusListener) throws JapeException {
        this.addStatusListener(statusListener);
        this.japeURL = uRL;
        this.encoding = string;
        this.parseJape();
        this.linkListeners();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.linkListeners();
    }

    protected void linkListeners() {
        if (this.transducer != null) {
            this.transducer.addStatusListener(new StatusListener(){

                public void statusChanged(String string) {
                    Batch.this.fireStatusChanged(string);
                }
            });
            this.transducer.addProgressListener(new ProgressListener(){

                public void progressChanged(int n) {
                    Batch.this.fireProgressChanged(n);
                }

                public void processFinished() {
                    Batch.this.fireProcessFinished();
                }
            });
        }
    }

    public synchronized void interrupt() {
        this.transducer.interrupt();
    }

    public Transducer getTransducer() {
        return this.transducer;
    }

    private void parseJape() throws JapeException {
        try {
            ParseCpsl parseCpsl = Factory.newJapeParser(this.japeURL, this.encoding);
            StatusListener statusListener = null;
            statusListener = new StatusListener(){

                public void statusChanged(String string) {
                    Batch.this.fireStatusChanged(string);
                }
            };
            parseCpsl.addStatusListener(statusListener);
            this.transducer = parseCpsl.MultiPhaseTransducer();
            parseCpsl.removeStatusListener(statusListener);
            this.transducer.addStatusListener(statusListener);
            this.transducer.finish();
            this.transducer.removeStatusListener(statusListener);
        }
        catch (ParseException parseException) {
            throw new JapeException("Batch: error parsing transducer: " + parseException.getMessage());
        }
        catch (IOException iOException) {
            throw new JapeException("Batch: couldn't open JAPE file: " + iOException.getMessage());
        }
    }

    public void transduce(Corpus corpus) throws JapeException, ExecutionException {
        for (Document document : corpus) {
            this.transduce(document, document.getAnnotations(), document.getAnnotations());
        }
    }

    public void transduce(Document document) throws JapeException, ExecutionException {
        this.transducer.transduce(document, document.getAnnotations(), document.getAnnotations());
    }

    public void transduce(Document document, AnnotationSet annotationSet, AnnotationSet annotationSet2) throws JapeException, ExecutionException {
        if (annotationSet == null || annotationSet.isEmpty()) {
            return;
        }
        this.transducer.transduce(document, annotationSet, annotationSet2);
    }

    public static void main(String[] stringArray) {
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void usage(String string) {
        String string2 = "usage: java gate.jape.Batch.main [-v] -j japefile(.ser|.jape|.jar) (-c CollectionName | filenames)";
        Err.println(string);
        Err.println(string2);
    }

    public void message(String string) {
        if (this.verbose) {
            Out.println("Batch: " + string);
        }
    }

    public void setFeatures(FeatureMap featureMap) {
        this.features = featureMap;
    }

    public FeatureMap getFeatures() {
        return this.features;
    }

    public synchronized void removeProgressListener(ProgressListener progressListener) {
        if (this.progressListeners != null && this.progressListeners.contains(progressListener)) {
            Vector vector = (Vector)this.progressListeners.clone();
            vector.removeElement(progressListener);
            this.progressListeners = vector;
        }
    }

    public synchronized void addProgressListener(ProgressListener progressListener) {
        Vector vector;
        Vector vector2 = vector = this.progressListeners == null ? new Vector(2) : (Vector)this.progressListeners.clone();
        if (!vector.contains(progressListener)) {
            vector.addElement(progressListener);
            this.progressListeners = vector;
        }
    }

    protected void fireProgressChanged(int n) {
        if (this.progressListeners != null) {
            Vector vector = this.progressListeners;
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                ((ProgressListener)vector.elementAt(i)).progressChanged(n);
            }
        }
    }

    protected void fireProcessFinished() {
        if (this.progressListeners != null) {
            Vector vector = this.progressListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ProgressListener)vector.elementAt(i)).processFinished();
            }
        }
    }

    public synchronized void removeStatusListener(StatusListener statusListener) {
        if (this.statusListeners != null && this.statusListeners.contains(statusListener)) {
            Vector vector = (Vector)this.statusListeners.clone();
            vector.removeElement(statusListener);
            this.statusListeners = vector;
        }
    }

    public synchronized void addStatusListener(StatusListener statusListener) {
        Vector vector;
        Vector vector2 = vector = this.statusListeners == null ? new Vector(2) : (Vector)this.statusListeners.clone();
        if (!vector.contains(statusListener)) {
            vector.addElement(statusListener);
            this.statusListeners = vector;
        }
    }

    protected void fireStatusChanged(String string) {
        if (this.statusListeners != null) {
            Vector vector = this.statusListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((StatusListener)vector.elementAt(i)).statusChanged(string);
            }
        }
    }

    public void setOntology(Ontology ontology) {
        this.transducer.setOntology(ontology);
    }

    public boolean isEnableDebugging() {
        return this.enableDebugging;
    }

    public void setEnableDebugging(boolean bl) {
        this.enableDebugging = bl;
        if (this.transducer != null) {
            this.transducer.setEnableDebugging(bl);
        }
    }
}

