/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.annotation.AnnotationSetImpl;
import gate.jape.Constraint;
import gate.jape.JapeConstants;
import gate.jape.JdmAttribute;
import gate.jape.MutableBoolean;
import gate.jape.MutableInteger;
import gate.jape.PatternElement;
import gate.util.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicPatternElement
extends PatternElement
implements JapeConstants,
Serializable {
    private static final boolean DEBUG = false;
    private ArrayList<Constraint> constraints1;
    private Constraint[] constraints2;
    private HashMap constraintsMap = new HashMap();
    private int lastFailurePoint = -1;
    private AnnotationSet matchedAnnots;

    @Override
    public AnnotationSet getMatchedAnnots() {
        return this.matchedAnnots;
    }

    public BasicPatternElement() {
        this.constraints1 = new ArrayList();
        this.matchedAnnots = new AnnotationSetImpl((Document)null);
    }

    @Override
    public Object clone() {
        BasicPatternElement basicPatternElement = (BasicPatternElement)super.clone();
        basicPatternElement.constraintsMap = (HashMap)this.constraintsMap.clone();
        basicPatternElement.constraints1 = new ArrayList();
        int n = this.constraints1.size();
        for (int i = 0; i < n; ++i) {
            basicPatternElement.constraints1.add((Constraint)this.constraints1.get(i).clone());
        }
        return basicPatternElement;
    }

    public void addConstraint(Constraint constraint) {
        String string = constraint.getAnnotType();
        Constraint constraint2 = (Constraint)this.constraintsMap.get(string);
        if (constraint2 == null) {
            this.constraintsMap.put(string, constraint);
            this.constraints1.add(constraint);
        } else {
            FeatureMap featureMap = constraint.getAttributeSeq();
            FeatureMap featureMap2 = constraint2.getAttributeSeq();
            featureMap2.putAll(featureMap);
            if (constraint.isNegated()) {
                constraint2.negate();
            }
        }
    }

    public boolean isMultiType() {
        return this.constraints2 != null ? this.constraints2.length > 1 : (this.constraints1 != null ? this.constraints1.size() > 1 : false);
    }

    @Override
    public void finish() {
        int n = 0;
        this.constraints2 = new Constraint[this.constraints1.size()];
        Iterator<Constraint> iterator = this.constraints1.iterator();
        while (iterator.hasNext()) {
            Constraint constraint;
            this.constraints2[n] = constraint = iterator.next();
            this.constraints2[n++].finish();
        }
        this.constraints1 = null;
    }

    @Override
    public void reset() {
        super.reset();
        this.lastFailurePoint = -1;
        this.matchedAnnots = new AnnotationSetImpl((Document)null);
    }

    @Override
    public void rollback(int n) {
        for (int i = 0; i < n; ++i) {
            this.matchedAnnots.removeAll((AnnotationSet)this.matchHistory.pop());
        }
    }

    @Override
    public boolean matches(Document document, int n, MutableInteger mutableInteger) {
        int n2 = this.matchedAnnots.size();
        AnnotationSetImpl annotationSetImpl = new AnnotationSetImpl((Document)null);
        int n3 = -1;
        int n4 = document.getContent().size().intValue();
        MutableInteger mutableInteger2 = new MutableInteger();
        int n5 = -1;
        for (Constraint constraint : this.constraints2) {
            String string = constraint.getAnnotType();
            JdmAttribute[] jdmAttributeArray = constraint.getAttributeArray();
            MutableBoolean mutableBoolean = new MutableBoolean();
            FeatureMap featureMap = Factory.newFeatureMap();
            for (int i = jdmAttributeArray.length - 1; i >= 0; --i) {
                featureMap.put(jdmAttributeArray[i].getName(), jdmAttributeArray[i].getValue());
            }
            AnnotationSet annotationSet = document.getAnnotations().get(string, featureMap, new Long(Math.max(n, this.lastFailurePoint)));
            if (n5 == -1) {
                n5 = mutableInteger2.value;
            }
            if (!mutableBoolean.value) {
                if (annotationSet != null) {
                    throw new RuntimeException("BPE: no more annots but found one!");
                }
                this.lastFailurePoint = n4;
                mutableInteger.value = n4;
            }
            int n6 = -1;
            if (annotationSet != null) {
                n6 = annotationSet.lastNode().getOffset().intValue();
                if (n3 == -1) {
                    n3 = n6;
                } else if (annotationSet.firstNode().getOffset().intValue() >= n3) {
                    this.lastFailurePoint = n6;
                    annotationSet = null;
                } else if (n3 < n6) {
                    n3 = n6;
                }
            }
            if (constraint.isNegated()) {
                if (annotationSet == null) continue;
                this.lastFailurePoint = n6;
                annotationSet = null;
            }
            if (annotationSet == null) {
                mutableInteger.value = Math.max(n + 1, n5);
                this.lastFailurePoint = mutableInteger2.value;
                this.matchedAnnots.removeAll(annotationSetImpl);
                return false;
            }
            this.matchedAnnots.addAll(annotationSet);
            annotationSetImpl.addAll(annotationSet);
            mutableInteger.value = Math.max(mutableInteger.value, n6);
        }
        this.matchHistory.push(annotationSetImpl);
        if (mutableInteger.value == n) {
            ++mutableInteger.value;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        Constraint[] constraintArray = this.getConstraints();
        for (int i = 0; i < constraintArray.length; ++i) {
            stringBuffer.append(constraintArray[i].shortDesc() + ",");
        }
        stringBuffer.setCharAt(stringBuffer.length() - 1, '}');
        return stringBuffer.toString();
    }

    @Override
    public String toString(String string) {
        String string2 = Strings.getNl();
        String string3 = Strings.addPadding(string, 4);
        StringBuffer stringBuffer = new StringBuffer(string + "BPE: lastFailurePoint(" + this.lastFailurePoint + "); constraints(");
        if (this.constraints1 != null) {
            int n = this.constraints1.size();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(string2 + this.constraints1.get(i).toString(string3));
            }
        } else {
            int n = this.constraints2.length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(string2 + this.constraints2[i].toString(string3));
            }
        }
        stringBuffer.append(string2 + string + "matchedAnnots: " + this.matchedAnnots + string2 + string + ") BPE.");
        return stringBuffer.toString();
    }

    public String shortDesc() {
        String string = "";
        if (this.constraints1 != null) {
            int n = this.constraints1.size();
            for (int i = 0; i < n; ++i) {
                string = string + this.constraints1.get(i).toString();
            }
        } else {
            int n = this.constraints2.length;
            for (int i = 0; i < n; ++i) {
                string = string + this.constraints2[i].shortDesc();
            }
        }
        return string;
    }

    public ArrayList<Constraint> getUnfinishedConstraints() {
        return this.constraints1;
    }

    public Constraint[] getConstraints() {
        return this.constraints2;
    }
}

