/*
 * Decompiled with CFR 0.152.
 */
package gate.html;

import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.corpora.DocumentContentImpl;
import gate.corpora.RepositioningInfo;
import gate.event.StatusListener;
import gate.util.Err;
import gate.util.InvalidOffsetException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;

public class HtmlDocumentHandler
extends HTMLEditorKit.ParserCallback {
    private static final boolean DEBUG = false;
    private RepositioningInfo reposInfo = null;
    private RepositioningInfo ampCodingInfo = null;
    private boolean isInsideStyleTag = false;
    static final int ELEMENTS_RATE = 128;
    private Map markupElementsMap = null;
    private StringBuffer tmpDocContent = null;
    private Stack stack = null;
    private Document doc = null;
    private AnnotationSet basicAS;
    protected List myStatusListeners = new LinkedList();
    private int elements = 0;
    protected long customObjectsId = 0L;
    private LinkedList colector = null;

    public HtmlDocumentHandler(Document document, Map map) {
        this(document, map, null);
    }

    public HtmlDocumentHandler(Document document, Map map, AnnotationSet annotationSet) {
        this.stack = new Stack();
        this.tmpDocContent = new StringBuffer(document.getContent().size().intValue());
        this.colector = new LinkedList();
        this.doc = document;
        this.markupElementsMap = map;
        this.basicAS = annotationSet;
        this.customObjectsId = 0L;
    }

    public void setRepositioningInfo(RepositioningInfo repositioningInfo) {
        this.reposInfo = repositioningInfo;
    }

    public RepositioningInfo getRepositioningInfo() {
        return this.reposInfo;
    }

    public void setAmpCodingInfo(RepositioningInfo repositioningInfo) {
        this.ampCodingInfo = repositioningInfo;
    }

    public RepositioningInfo getAmpCodingInfo() {
        return this.ampCodingInfo;
    }

    public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
        Object object;
        if (0 == ++this.elements % 128) {
            this.fireStatusChangedEvent("Processed elements : " + this.elements);
        }
        if (HTML.Tag.STYLE.equals(tag)) {
            this.isInsideStyleTag = true;
        }
        FeatureMap featureMap = Factory.newFeatureMap();
        if (0 != mutableAttributeSet.getAttributeCount()) {
            Enumeration<?> enumeration = mutableAttributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                featureMap.put(object.toString(), mutableAttributeSet.getAttribute(object).toString());
            }
        }
        this.customizeAppearanceOfDocumentWithStartTag(tag);
        int n2 = this.tmpDocContent.length();
        if (n2 != 0 && !Character.isWhitespace(this.tmpDocContent.charAt(n2 - 1))) {
            this.tmpDocContent.append(" ");
        }
        object = new Long(this.tmpDocContent.length());
        CustomObject customObject = new CustomObject(tag.toString(), featureMap, (Long)object, (Long)object);
        this.stack.push(customObject);
    }

    public void handleEndTag(HTML.Tag tag, int n) {
        CustomObject customObject = null;
        if (HTML.Tag.STYLE.equals(tag)) {
            this.isInsideStyleTag = false;
        }
        if (!this.stack.isEmpty()) {
            customObject = (CustomObject)this.stack.pop();
            if (customObject.getStart().equals(customObject.getEnd())) {
                customObject.getFM().put("isEmptyAndSpan", "true");
            }
            this.colector.add(customObject);
        }
        if (customObject != null && customObject.getStart().longValue() != customObject.getEnd().longValue()) {
            this.customizeAppearanceOfDocumentWithEndTag(tag);
        }
        if (tag == HTML.Tag.HTML) {
            this.doc.setContent(new DocumentContentImpl(this.tmpDocContent.toString()));
            if (this.basicAS == null) {
                this.basicAS = this.doc.getAnnotations("Original markups");
            }
            Collections.sort(this.colector);
            while (!this.colector.isEmpty()) {
                customObject = (CustomObject)this.colector.getFirst();
                this.colector.remove(customObject);
                try {
                    if (this.markupElementsMap == null) {
                        this.basicAS.add(customObject.getStart(), customObject.getEnd(), customObject.getElemName(), customObject.getFM());
                        continue;
                    }
                    String string = (String)this.markupElementsMap.get(customObject.getElemName());
                    if (string == null) continue;
                    this.basicAS.add(customObject.getStart(), customObject.getEnd(), string, customObject.getFM());
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    Err.prln("Error creating an annot :" + customObject + " Discarded...");
                }
            }
            this.fireStatusChangedEvent("Total elements : " + this.elements);
        }
    }

    public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
        Object object;
        Object object2;
        if (++this.elements % 128 == 0) {
            this.fireStatusChangedEvent("Processed elements : " + this.elements);
        }
        FeatureMap featureMap = Factory.newFeatureMap();
        if (0 != mutableAttributeSet.getAttributeCount()) {
            object2 = mutableAttributeSet.getAttributeNames();
            while (object2.hasMoreElements()) {
                object = object2.nextElement();
                featureMap.put(object.toString(), mutableAttributeSet.getAttribute(object).toString());
            }
        }
        object2 = new Long(this.tmpDocContent.length());
        object = new CustomObject(tag.toString(), featureMap, (Long)object2, (Long)object2);
        this.colector.add(object);
        this.customizeAppearanceOfDocumentWithSimpleTag(tag);
    }

    public void handleText(char[] cArray, int n) {
        if (this.isInsideStyleTag) {
            return;
        }
        String string = new String(cArray);
        String string2 = string.trim();
        if (string2.length() == 0) {
            return;
        }
        int n2 = string.indexOf(string2.charAt(0));
        string = string2;
        StringBuffer stringBuffer = new StringBuffer("");
        int n3 = this.tmpDocContent.length();
        boolean bl = false;
        if (n3 != 0 && string.length() != 0 && !Character.isWhitespace(string.charAt(0)) && !Character.isWhitespace(this.tmpDocContent.charAt(n3 - 1))) {
            stringBuffer.append(" ");
            bl = true;
        }
        if (this.reposInfo != null) {
            int n4 = this.tmpDocContent.length() + stringBuffer.length();
            this.addRepositioningInfo(string, n + n2, n4);
        }
        stringBuffer.append(string);
        Long l = new Long(this.tmpDocContent.length() + stringBuffer.length());
        CustomObject customObject2 = null;
        for (CustomObject customObject2 : this.stack) {
            if (bl && customObject2.getStart().equals(customObject2.getEnd())) {
                customObject2.setStart(new Long(customObject2.getStart() + 1L));
            }
            customObject2.setEnd(l);
        }
        this.tmpDocContent.append(stringBuffer.toString());
    }

    public void addRepositioningInfo(String string, int n, int n2) {
        long l;
        long l2;
        int n3 = string.length();
        RepositioningInfo.PositionInfo positionInfo = null;
        long l3 = n;
        long l4 = 0L;
        for (int i = 0; i < this.ampCodingInfo.size(); ++i) {
            positionInfo = (RepositioningInfo.PositionInfo)this.ampCodingInfo.get(i);
            long l5 = positionInfo.getOriginalPosition();
            if (l5 < l3) continue;
            if (l5 > (long)(n + n3) + l4) break;
            l2 = l5 - (l3 + l4);
            l = l3 - (long)n;
            if (l2 > 0L) {
                this.reposInfo.addPositionInfo(l3 + l4, l2, (long)n2 + l, l2);
            }
            this.reposInfo.addPositionInfo(l5, positionInfo.getOriginalLength(), (long)n2 + l + l2, positionInfo.getCurrentLength());
            l3 = l3 + l2 + positionInfo.getCurrentLength();
            l4 += positionInfo.getOriginalLength() - positionInfo.getCurrentLength();
        }
        if ((l2 = (long)n3 - (l = l3 - (long)n)) > 0L) {
            this.reposInfo.addPositionInfo(l3 + l4, l2, (long)n2 + l, l2);
        }
    }

    protected void customizeAppearanceOfDocumentWithSimpleTag(HTML.Tag tag) {
        boolean bl = false;
        if (HTML.Tag.BR == tag) {
            this.tmpDocContent.append("\n");
            bl = true;
        }
        if (bl) {
            Long l = new Long(this.tmpDocContent.length());
            for (CustomObject customObject : this.stack) {
                customObject.setEnd(l);
            }
        }
    }

    protected void customizeAppearanceOfDocumentWithStartTag(HTML.Tag tag) {
        int n;
        boolean bl = false;
        if (HTML.Tag.P == tag && (n = this.tmpDocContent.length()) >= 2 && '\n' != this.tmpDocContent.charAt(n - 2)) {
            this.tmpDocContent.append("\n");
            bl = true;
        }
        if (bl) {
            Long l = new Long(this.tmpDocContent.length());
            for (CustomObject customObject : this.stack) {
                customObject.setEnd(l);
            }
        }
    }

    protected void customizeAppearanceOfDocumentWithEndTag(HTML.Tag tag) {
        boolean bl = false;
        if (HTML.Tag.P == tag || HTML.Tag.H1 == tag || HTML.Tag.H2 == tag || HTML.Tag.H3 == tag || HTML.Tag.H4 == tag || HTML.Tag.H5 == tag || HTML.Tag.H6 == tag || HTML.Tag.TR == tag || HTML.Tag.CENTER == tag || HTML.Tag.LI == tag) {
            this.tmpDocContent.append("\n");
            bl = true;
        }
        if (HTML.Tag.TITLE == tag) {
            this.tmpDocContent.append("\n\n");
            bl = true;
        }
        if (bl) {
            Long l = new Long(this.tmpDocContent.length());
            for (CustomObject customObject : this.stack) {
                customObject.setEnd(l);
            }
        }
    }

    public void handleError(String string, int n) {
    }

    public void flush() throws BadLocationException {
    }

    public void handleComment(char[] cArray, int n) {
    }

    public void addStatusListener(StatusListener statusListener) {
        this.myStatusListeners.add(statusListener);
    }

    public void removeStatusListener(StatusListener statusListener) {
        this.myStatusListeners.remove(statusListener);
    }

    protected void fireStatusChangedEvent(String string) {
        Iterator iterator = this.myStatusListeners.iterator();
        while (iterator.hasNext()) {
            ((StatusListener)iterator.next()).statusChanged(string);
        }
    }

    class CustomObject
    implements Comparable {
        private String elemName = null;
        private FeatureMap fm = null;
        private Long start = null;
        private Long end = null;
        private Long id = null;

        public CustomObject(String string, FeatureMap featureMap, Long l, Long l2) {
            this.elemName = string;
            this.fm = featureMap;
            this.start = l;
            this.end = l2;
            this.id = new Long(HtmlDocumentHandler.this.customObjectsId++);
        }

        public int compareTo(Object object) {
            CustomObject customObject = (CustomObject)object;
            return this.id.compareTo(customObject.getId());
        }

        public String getElemName() {
            return this.elemName;
        }

        public FeatureMap getFM() {
            return this.fm;
        }

        public Long getStart() {
            return this.start;
        }

        public Long getEnd() {
            return this.end;
        }

        public Long getId() {
            return this.id;
        }

        public void setElemName(String string) {
            this.elemName = string;
        }

        public void setFM(FeatureMap featureMap) {
            this.fm = featureMap;
        }

        public void setStart(Long l) {
            this.start = l;
        }

        public void setEnd(Long l) {
            this.end = l;
        }
    }
}

