/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.ontology;

import gate.gui.MainFrame;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;

public class ValuesSelectionAction {
    protected final JComboBox domainBox = new JComboBox();
    protected JList list = null;
    protected JButton add;
    protected JButton remove;
    protected JPanel panel;
    protected String[] ontologyClasses;
    protected boolean allowValueOutsideDropDownList = true;

    public ValuesSelectionAction() {
        this.domainBox.setEditable(true);
        this.list = new JList(new DefaultListModel());
        this.list.setVisibleRowCount(7);
        this.add = new JButton("Add");
        this.remove = new JButton("Remove");
        this.panel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(this.panel, 1);
        this.panel.setLayout(boxLayout);
        this.panel.add(this.domainBox);
        this.domainBox.setEditable(true);
        this.domainBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                String string = ((JTextComponent)ValuesSelectionAction.this.domainBox.getEditor().getEditorComponent()).getText();
                if (string != null) {
                    if (keyEvent.getKeyCode() != 10) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        for (int i = 0; i < ValuesSelectionAction.this.ontologyClasses.length; ++i) {
                            String string2 = ValuesSelectionAction.this.ontologyClasses[i];
                            if (!string2.toLowerCase().startsWith(string.toLowerCase())) continue;
                            arrayList.add(string2);
                        }
                        Collections.sort(arrayList);
                        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(arrayList.toArray());
                        ValuesSelectionAction.this.domainBox.setModel(defaultComboBoxModel);
                        try {
                            if (!arrayList.isEmpty()) {
                                ValuesSelectionAction.this.domainBox.showPopup();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ((JTextComponent)ValuesSelectionAction.this.domainBox.getEditor().getEditorComponent()).setText(string);
                }
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(this.add);
        jPanel.add(this.remove);
        this.panel.add(jPanel);
        this.panel.add(new JScrollPane(this.list));
        this.add.addActionListener(new ActionListener(){
            final ValuesSelectionAction this$0;
            {
                this.this$0 = ValuesSelectionAction.this;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)ValuesSelectionAction.this.domainBox.getSelectedItem();
                if (!ValuesSelectionAction.this.allowValueOutsideDropDownList && !Arrays.asList(ValuesSelectionAction.this.ontologyClasses).contains(string)) {
                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "The value \"" + string + "\" is not in the drop down list!");
                    return;
                }
                if (((DefaultListModel)ValuesSelectionAction.this.list.getModel()).contains(string)) {
                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "Already added!");
                    return;
                }
                ((DefaultListModel)ValuesSelectionAction.this.list.getModel()).addElement(string);
            }
        });
        this.remove.addActionListener(new ActionListener(){
            final ValuesSelectionAction this$0;
            {
                this.this$0 = ValuesSelectionAction.this;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = ValuesSelectionAction.this.list.getSelectedValues();
                if (objectArray != null || objectArray.length > 0) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        ((DefaultListModel)ValuesSelectionAction.this.list.getModel()).removeElement(objectArray[i]);
                    }
                }
            }
        });
    }

    public void showGUI(String string, String[] stringArray, String[] stringArray2, boolean bl) {
        this.ontologyClasses = stringArray;
        this.allowValueOutsideDropDownList = bl;
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(stringArray);
        this.domainBox.setModel(defaultComboBoxModel);
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (int i = 0; i < stringArray2.length; ++i) {
            defaultListModel.addElement(stringArray2[i]);
        }
        this.list.setModel(defaultListModel);
        JOptionPane.showOptionDialog(MainFrame.getInstance(), this.panel, string, 0, 3, null, new String[]{"OK"}, "OK");
    }

    public String[] getSelectedValues() {
        DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
        String[] stringArray = new String[defaultListModel.getSize()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)defaultListModel.getElementAt(i);
        }
        return stringArray;
    }
}

