/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.ontology;

import gate.creole.ontology.OClass;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.TransitiveProperty;
import gate.creole.ontology.URI;
import gate.gui.ontology.OResourceNode;
import gate.gui.ontology.TreeNodeSelectionListener;
import gate.gui.ontology.Utils;
import gate.gui.ontology.ValuesSelectionAction;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransitivePropertyAction
extends AbstractAction
implements TreeNodeSelectionListener {
    private static final long serialVersionUID = 4049916060868227125L;
    protected JPanel nsPanel;
    protected JPanel propertyPanel;
    protected JPanel panel;
    protected JTextField nameSpace = new JTextField(20);
    protected JTextField propertyName;
    protected JButton domainB;
    protected JButton rangeB;
    protected ValuesSelectionAction domainAction;
    protected ValuesSelectionAction rangeAction;
    protected ArrayList<String> ontologyClassesURIs;
    protected ArrayList<DefaultMutableTreeNode> selectedNodes;
    protected Ontology ontology;
    protected JPanel subPropPanel;
    protected JCheckBox subPropertyCB;

    public TransitivePropertyAction(String string, Icon icon) {
        super(string, icon);
        this.nsPanel = new JPanel(new FlowLayout(0));
        this.nsPanel.add(new JLabel("Name Space:"));
        this.nsPanel.add(this.nameSpace);
        this.propertyName = new JTextField(20);
        this.domainB = new JButton("Domain");
        this.rangeB = new JButton("Range");
        this.domainAction = new ValuesSelectionAction();
        this.rangeAction = new ValuesSelectionAction();
        this.domainB.addActionListener(new ActionListener(){
            final TransitivePropertyAction this$0;
            {
                this.this$0 = TransitivePropertyAction.this;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray = new String[TransitivePropertyAction.this.ontologyClassesURIs.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = TransitivePropertyAction.this.ontologyClassesURIs.get(i);
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < TransitivePropertyAction.this.selectedNodes.size(); ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode = TransitivePropertyAction.this.selectedNodes.get(i);
                    if (!(((OResourceNode)defaultMutableTreeNode.getUserObject()).getResource() instanceof OClass)) continue;
                    arrayList.add(((OClass)((OResourceNode)defaultMutableTreeNode.getUserObject()).getResource()).getURI().toString());
                }
                String[] stringArray2 = new String[arrayList.size()];
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray2[i] = (String)arrayList.get(i);
                }
                TransitivePropertyAction.this.domainAction.showGUI("Domain", stringArray, stringArray2, false);
            }
        });
        this.rangeB.addActionListener(new ActionListener(){
            final TransitivePropertyAction this$0;
            {
                this.this$0 = TransitivePropertyAction.this;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray = new String[TransitivePropertyAction.this.ontologyClassesURIs.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = TransitivePropertyAction.this.ontologyClassesURIs.get(i);
                }
                TransitivePropertyAction.this.rangeAction.showGUI("Range", stringArray, new String[0], false);
            }
        });
        this.propertyPanel = new JPanel(new FlowLayout(0));
        this.propertyPanel.add(new JLabel("Property Name:"));
        this.propertyPanel.add(this.propertyName);
        this.propertyPanel.add(this.domainB);
        this.propertyPanel.add(this.rangeB);
        this.panel = new JPanel(new GridLayout(2, 1));
        ((GridLayout)this.panel.getLayout()).setVgap(0);
        this.panel.add(this.propertyPanel);
        this.panel.add(this.nsPanel);
        this.subPropPanel = new JPanel(new FlowLayout(0));
        this.subPropertyCB = new JCheckBox("sub property of the selected nodes?");
        this.subPropPanel.add(this.subPropertyCB);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>(this.selectedNodes);
        this.nameSpace.setText(this.ontology.getDefaultNameSpace());
        int n = JOptionPane.showOptionDialog(null, this.panel, "New Transitive Property", 2, 3, null, new String[]{"OK", "Cancel"}, "OK");
        if (n == 0) {
            Object object;
            String string = this.nameSpace.getText();
            if (!Utils.isValidNameSpace(string)) {
                JOptionPane.showMessageDialog(null, "Invalid NameSpace:" + string + "\n example: http://gate.ac.uk/example#");
                return;
            }
            if (!Utils.isValidOntologyResourceName(this.propertyName.getText())) {
                JOptionPane.showMessageDialog(null, "Invalid Property Name");
                return;
            }
            if (this.ontology.getOResourceFromMap(this.nameSpace.getText() + this.propertyName.getText()) != null) {
                JOptionPane.showMessageDialog(null, "A Resource with name \"" + (this.nameSpace.getText() + this.propertyName.getText()) + "\" already exists");
                return;
            }
            String[] stringArray = this.domainAction.getSelectedValues();
            HashSet<OClass> hashSet = new HashSet<OClass>();
            for (int i = 0; i < stringArray.length; ++i) {
                object = (OClass)this.ontology.getOResourceFromMap(stringArray[i]);
                hashSet.add((OClass)object);
            }
            String[] stringArray2 = this.rangeAction.getSelectedValues();
            object = new HashSet();
            for (int i = 0; i < stringArray2.length; ++i) {
                OClass oClass = (OClass)this.ontology.getOResourceFromMap(stringArray2[i]);
                ((HashSet)object).add(oClass);
            }
            TransitiveProperty transitiveProperty = this.ontology.addTransitiveProperty(new URI(this.nameSpace.getText() + this.propertyName.getText(), false), hashSet, (Set<OClass>)object);
        }
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public void setOntology(Ontology ontology) {
        this.ontology = ontology;
    }

    @Override
    public void selectionChanged(ArrayList<DefaultMutableTreeNode> arrayList) {
        this.selectedNodes = arrayList;
    }

    public ArrayList<String> getOntologyClassesURIs() {
        return this.ontologyClassesURIs;
    }

    public void setOntologyClassesURIs(ArrayList<String> arrayList) {
        this.ontologyClassesURIs = arrayList;
    }
}

