/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.ontology;

import gate.creole.ontology.OClass;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.URI;
import gate.gui.MainFrame;
import gate.gui.ontology.Utils;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TopClassAction
extends AbstractAction {
    private static final long serialVersionUID = 3258409543049359926L;
    protected JTextField nameSpace = new JTextField(20);
    protected JTextField className = new JTextField(20);
    protected JPanel labelPanel = new JPanel(new GridLayout(2, 1));
    protected JPanel textFieldsPanel = new JPanel(new GridLayout(2, 1));
    protected JPanel panel = new JPanel(new FlowLayout(0));
    protected Ontology ontology;

    public TopClassAction(String string, Icon icon) {
        super(string, icon);
        this.panel.add(this.labelPanel);
        this.panel.add(this.textFieldsPanel);
        this.labelPanel.add(new JLabel("Name Space :"));
        this.textFieldsPanel.add(this.nameSpace);
        this.labelPanel.add(new JLabel("Top Class Name :"));
        this.textFieldsPanel.add(this.className);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.nameSpace.setText(this.ontology.getDefaultNameSpace());
        int n = JOptionPane.showOptionDialog(MainFrame.getInstance(), this.panel, "New Top Class", 2, 3, null, new String[]{"OK", "Cancel"}, "OK");
        if (n == 0) {
            String string = this.nameSpace.getText();
            if (!Utils.isValidNameSpace(string)) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Invalid NameSpace:" + string + "\n example: http://gate.ac.uk/example#");
                return;
            }
            if (!Utils.isValidOntologyResourceName(this.className.getText())) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Invalid Classname");
                return;
            }
            OClass oClass = this.ontology.addOClass(new URI(this.nameSpace.getText() + this.className.getText(), false), (byte)0);
        }
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public void setOntology(Ontology ontology) {
        this.ontology = ontology;
    }
}

