/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.ontology;

import gate.creole.ontology.OClass;
import gate.creole.ontology.OResource;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.URI;
import gate.gui.MainFrame;
import gate.gui.ontology.OResourceNode;
import gate.gui.ontology.TreeNodeSelectionListener;
import gate.gui.ontology.Utils;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubClassAction
extends AbstractAction
implements TreeNodeSelectionListener {
    private static final long serialVersionUID = 3258409543049359926L;
    protected JTextField nameSpace = new JTextField(20);
    protected JTextField className = new JTextField(20);
    protected JPanel labelPanel = new JPanel(new GridLayout(2, 1));
    protected JPanel textFieldsPanel = new JPanel(new GridLayout(2, 1));
    protected JPanel panel = new JPanel(new FlowLayout(0));
    protected ArrayList<DefaultMutableTreeNode> selectedNodes;
    protected Ontology ontology;

    public SubClassAction(String string, Icon icon) {
        super(string, icon);
        this.panel.add(this.labelPanel);
        this.panel.add(this.textFieldsPanel);
        this.labelPanel.add(new JLabel("Name Space :"));
        this.textFieldsPanel.add(this.nameSpace);
        this.labelPanel.add(new JLabel("Sub Class Name :"));
        this.textFieldsPanel.add(this.className);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        int n;
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>(this.selectedNodes);
        if (arrayList.size() == 0) {
            JOptionPane.showMessageDialog(MainFrame.getInstance(), "Please select a class for which you want to create a new subclass");
            return;
        }
        OResource oResource = ((OResourceNode)arrayList.get(0).getUserObject()).getResource();
        String string = oResource.getURI().getNameSpace();
        if (gate.creole.ontology.owlim.Utils.hasSystemNameSpace(oResource.getURI().toString())) {
            string = this.ontology.getDefaultNameSpace();
        }
        this.nameSpace.setText(string);
        ArrayList<OClass> arrayList2 = new ArrayList<OClass>();
        for (n = 0; n < arrayList.size(); ++n) {
            object = ((OResourceNode)arrayList.get(n).getUserObject()).getResource();
            if (!(object instanceof OClass)) continue;
            arrayList2.add((OClass)object);
        }
        n = JOptionPane.showOptionDialog(MainFrame.getInstance(), this.panel, "New Sub Class:", 2, 3, null, new String[]{"OK", "Cancel"}, "OK");
        if (n == 0) {
            object = this.nameSpace.getText();
            if (!Utils.isValidNameSpace((String)object)) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Invalid NameSpace:" + (String)object + "\n example: http://gate.ac.uk/example#");
                return;
            }
            if (!Utils.isValidOntologyResourceName(this.className.getText())) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Invalid Classname");
                return;
            }
            if (this.ontology.getOResourceFromMap((String)object + this.className.getText()) != null) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Class :" + this.className.getText() + " already exists");
                return;
            }
            OClass oClass = this.ontology.addOClass(new URI((String)object + this.className.getText(), false), (byte)0);
            for (int i = 0; i < arrayList2.size(); ++i) {
                ((OClass)arrayList2.get(i)).addSubClass(oClass);
            }
        }
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public void setOntology(Ontology ontology) {
        this.ontology = ontology;
    }

    @Override
    public void selectionChanged(ArrayList<DefaultMutableTreeNode> arrayList) {
        this.selectedNodes = arrayList;
    }
}

