/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.ontology;

import gate.creole.ontology.InvalidValueException;
import gate.creole.ontology.OClass;
import gate.creole.ontology.OResource;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.OntologyUtilities;
import gate.creole.ontology.RDFProperty;
import gate.gui.MainFrame;
import gate.gui.ontology.OntologyItemComparator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class RestrictionAction
extends AbstractAction {
    protected JPanel mainPanel = new JPanel(new BorderLayout());
    protected JPanel restrictionTypes = new JPanel(new GridLayout(3, 2));
    protected JRadioButton minCard;
    protected JRadioButton maxCard;
    protected JRadioButton card;
    protected JRadioButton hasVal;
    protected JRadioButton allVals;
    protected JRadioButton someVals;
    protected JPanel middlePanel;
    protected JComboBox onPropertyChoice;
    protected JPanel bottomPanel;
    protected JPanel valuePanel;
    protected JPanel hasValuePanel;
    protected JTextField value;
    protected JComboBox hasValChoice;
    protected Ontology ontology;

    public RestrictionAction(String string, Icon icon) {
        super(string, icon);
        EnableDisableClass enableDisableClass = new EnableDisableClass();
        this.minCard = new JRadioButton("Minimum Cardinality");
        this.minCard.addActionListener(enableDisableClass);
        this.maxCard = new JRadioButton("Maximum Cardinality");
        this.maxCard.addActionListener(enableDisableClass);
        this.card = new JRadioButton("Cardinality");
        this.card.addActionListener(enableDisableClass);
        this.hasVal = new JRadioButton("Has Value");
        this.hasVal.addActionListener(enableDisableClass);
        this.allVals = new JRadioButton("All Values From");
        this.allVals.addActionListener(enableDisableClass);
        this.someVals = new JRadioButton("Some Values From");
        this.someVals.addActionListener(enableDisableClass);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.minCard);
        buttonGroup.add(this.maxCard);
        buttonGroup.add(this.card);
        buttonGroup.add(this.hasVal);
        buttonGroup.add(this.allVals);
        buttonGroup.add(this.someVals);
        this.restrictionTypes.add(this.card);
        this.restrictionTypes.add(this.hasVal);
        this.restrictionTypes.add(this.minCard);
        this.restrictionTypes.add(this.allVals);
        this.restrictionTypes.add(this.maxCard);
        this.restrictionTypes.add(this.someVals);
        this.restrictionTypes.setBorder(new TitledBorder("Restriction Types"));
        this.middlePanel = new JPanel(new FlowLayout());
        this.middlePanel.setBorder(new TitledBorder("On Property"));
        this.onPropertyChoice = new JComboBox(new DefaultComboBoxModel());
        this.onPropertyChoice.setPrototypeDisplayValue(new String("http://www.dcs.shef.ac.uk/owlim#SomeObjectProperty"));
        this.middlePanel.add(this.onPropertyChoice);
        this.bottomPanel = new JPanel(new GridLayout(2, 1));
        this.valuePanel = new JPanel(new FlowLayout());
        this.valuePanel.setBorder(new TitledBorder("Cardinality Value"));
        this.value = new JTextField("1", 20);
        this.valuePanel.add(this.value);
        this.hasValuePanel = new JPanel(new FlowLayout());
        this.hasValuePanel.setBorder(new TitledBorder("Has Value"));
        this.hasValChoice = new JComboBox(new DefaultComboBoxModel());
        this.hasValChoice.setPrototypeDisplayValue(new String("http://www.dcs.shef.ac.uk/owlim#SomeObjectProperty"));
        this.hasValuePanel.add(this.hasValChoice);
        this.bottomPanel.add(this.valuePanel);
        this.bottomPanel.add(this.hasValuePanel);
        this.mainPanel.add((Component)this.restrictionTypes, "North");
        this.mainPanel.add((Component)this.middlePanel, "Center");
        this.mainPanel.add((Component)this.bottomPanel, "South");
        this.card.setSelected(true);
        this.hasValChoice.setEnabled(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ArrayList<RDFProperty> arrayList = new ArrayList<RDFProperty>();
        arrayList.addAll(this.ontology.getObjectProperties());
        arrayList.addAll(this.ontology.getDatatypeProperties());
        Collections.sort(arrayList, new OntologyItemComparator());
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(arrayList.toArray());
        this.onPropertyChoice.setModel(defaultComboBoxModel);
        ArrayList<OClass> arrayList2 = new ArrayList<OClass>();
        arrayList2.addAll(this.ontology.getOClasses(false));
        Collections.sort(arrayList2, new OntologyItemComparator());
        DefaultComboBoxModel<Object> defaultComboBoxModel2 = new DefaultComboBoxModel<Object>(arrayList2.toArray());
        this.hasValChoice.setModel(defaultComboBoxModel2);
        int n = JOptionPane.showOptionDialog(MainFrame.getInstance(), this.mainPanel, "New Restriction", 2, 3, MainFrame.getIcon("empty"), new String[]{"OK", "Cancel"}, "OK");
        if (n == 0) {
            RDFProperty rDFProperty = (RDFProperty)this.onPropertyChoice.getSelectedItem();
            if (!this.value.isEnabled()) {
                OResource oResource = (OResource)this.hasValChoice.getSelectedItem();
                if (this.allVals.isSelected()) {
                    this.ontology.addAllValuesFromRestriction(rDFProperty, oResource);
                } else if (this.someVals.isSelected()) {
                    this.ontology.addSomeValuesFromRestriction(rDFProperty, oResource);
                } else {
                    this.ontology.addHasValueRestriction(rDFProperty, oResource);
                }
            } else {
                String string = this.value.getText();
                if (!OntologyUtilities.getDataType("http://www.w3.org/2001/XMLSchema#nonNegativeInteger").isValidValue(string)) {
                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "Invalid value " + string);
                    return;
                }
                try {
                    if (this.card.isSelected()) {
                        this.ontology.addCardinalityRestriction(rDFProperty, string);
                    } else if (this.minCard.isSelected()) {
                        this.ontology.addMinCardinalityRestriction(rDFProperty, string);
                    } else {
                        this.ontology.addMaxCardinalityRestriction(rDFProperty, string);
                    }
                }
                catch (InvalidValueException invalidValueException) {
                    JOptionPane.showMessageDialog(MainFrame.getInstance(), invalidValueException.getMessage());
                    invalidValueException.printStackTrace();
                    return;
                }
            }
        }
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public void setOntology(Ontology ontology) {
        this.ontology = ontology;
    }

    class EnableDisableClass
    implements ActionListener {
        EnableDisableClass() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (RestrictionAction.this.hasVal.isSelected() || RestrictionAction.this.allVals.isSelected() || RestrictionAction.this.someVals.isSelected()) {
                RestrictionAction.this.value.setEnabled(false);
                RestrictionAction.this.hasValChoice.setEnabled(true);
            } else {
                RestrictionAction.this.value.setEnabled(true);
                RestrictionAction.this.hasValChoice.setEnabled(false);
            }
        }
    }
}

