/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.ontology;

import gate.creole.ontology.AnnotationProperty;
import gate.creole.ontology.DatatypeProperty;
import gate.creole.ontology.OClass;
import gate.creole.ontology.OResource;
import gate.creole.ontology.ObjectProperty;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.RDFProperty;
import gate.creole.ontology.URI;
import gate.gui.ontology.OResourceNode;
import gate.gui.ontology.TreeNodeSelectionListener;
import gate.gui.ontology.Utils;
import gate.gui.ontology.ValuesSelectionAction;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDFPropertyAction
extends AbstractAction
implements TreeNodeSelectionListener {
    private static final long serialVersionUID = 4050487806914867506L;
    protected JPanel nsPanel;
    protected JPanel propertyPanel;
    protected JPanel panel;
    protected JTextField nameSpace = new JTextField(20);
    protected JTextField propertyName;
    protected JButton domainB;
    protected JButton rangeB;
    protected ValuesSelectionAction domainAction;
    protected ValuesSelectionAction rangeAction;
    protected ArrayList<DefaultMutableTreeNode> selectedNodes;
    protected List<OResource> resoucesList;
    protected Ontology ontology;
    protected JPanel subPropPanel;
    protected JCheckBox subPropertyCB;

    public RDFPropertyAction(String string, Icon icon) {
        super(string, icon);
        this.nsPanel = new JPanel(new FlowLayout(0));
        this.nsPanel.add(new JLabel("Name Space:"));
        this.nsPanel.add(this.nameSpace);
        this.propertyName = new JTextField(20);
        this.domainB = new JButton("Domain");
        this.rangeB = new JButton("Range");
        this.domainAction = new ValuesSelectionAction();
        this.rangeAction = new ValuesSelectionAction();
        this.domainB.addActionListener(new ActionListener(){
            final RDFPropertyAction this$0;
            {
                this.this$0 = RDFPropertyAction.this;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < RDFPropertyAction.this.selectedNodes.size(); ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode = RDFPropertyAction.this.selectedNodes.get(i);
                    if (!(((OResourceNode)defaultMutableTreeNode.getUserObject()).getResource() instanceof OClass)) continue;
                    arrayList.add(((OClass)((OResourceNode)defaultMutableTreeNode.getUserObject()).getResource()).getURI().toString());
                }
                String[] stringArray = new String[RDFPropertyAction.this.resoucesList.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = RDFPropertyAction.this.resoucesList.get(i).getURI().toString();
                }
                RDFPropertyAction.this.domainAction.showGUI("Domain", stringArray, new String[0], false);
            }
        });
        this.rangeB.addActionListener(new ActionListener(){
            final RDFPropertyAction this$0;
            {
                this.this$0 = RDFPropertyAction.this;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray = new String[RDFPropertyAction.this.resoucesList.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = RDFPropertyAction.this.resoucesList.get(i).getURI().toString();
                }
                RDFPropertyAction.this.rangeAction.showGUI("Range", stringArray, new String[0], false);
            }
        });
        this.propertyPanel = new JPanel(new FlowLayout(0));
        this.propertyPanel.add(new JLabel("Property Name:"));
        this.propertyPanel.add(this.propertyName);
        this.propertyPanel.add(this.domainB);
        this.propertyPanel.add(this.rangeB);
        this.panel = new JPanel(new GridLayout(2, 1));
        ((GridLayout)this.panel.getLayout()).setVgap(0);
        this.panel.add(this.propertyPanel);
        this.panel.add(this.nsPanel);
        this.subPropPanel = new JPanel(new FlowLayout(0));
        this.subPropertyCB = new JCheckBox("sub property of the selected nodes?");
        this.subPropPanel.add(this.subPropertyCB);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>(this.selectedNodes);
        this.nameSpace.setText(this.ontology.getDefaultNameSpace());
        int n = JOptionPane.showOptionDialog(null, this.panel, "New Property", 2, 3, null, new String[]{"OK", "Cancel"}, "OK");
        if (n == 0) {
            Object object;
            Object object2;
            String string = this.nameSpace.getText();
            if (!Utils.isValidNameSpace(string)) {
                JOptionPane.showMessageDialog(null, "Invalid NameSpace:" + string + "\n example: http://gate.ac.uk/example#");
                return;
            }
            if (!Utils.isValidOntologyResourceName(this.propertyName.getText())) {
                JOptionPane.showMessageDialog(null, "Invalid Property Name");
                return;
            }
            if (this.ontology.getOResourceFromMap(this.nameSpace.getText() + this.propertyName.getText()) != null) {
                JOptionPane.showMessageDialog(null, "A Resource with name \"" + (this.nameSpace.getText() + this.propertyName.getText()) + "\" already exists");
                return;
            }
            String[] stringArray = this.domainAction.getSelectedValues();
            HashSet<OResource> hashSet = new HashSet<OResource>();
            for (int i = 0; i < stringArray.length; ++i) {
                object2 = this.ontology.getOResourceFromMap(stringArray[i]);
                hashSet.add((OResource)object2);
            }
            String[] stringArray2 = this.rangeAction.getSelectedValues();
            object2 = new HashSet();
            for (int i = 0; i < stringArray2.length; ++i) {
                object = this.ontology.getOResourceFromMap(stringArray2[i]);
                ((HashSet)object2).add(object);
            }
            RDFProperty rDFProperty = this.ontology.addRDFProperty(new URI(this.nameSpace.getText() + this.propertyName.getText(), false), hashSet, (Set<OResource>)object2);
            if (this.subPropertyCB.isSelected()) {
                for (n = 0; n < arrayList.size(); ++n) {
                    object = arrayList.get(n);
                    OResource oResource = ((OResourceNode)((DefaultMutableTreeNode)object).getUserObject()).getResource();
                    if (!(oResource instanceof RDFProperty) || oResource instanceof ObjectProperty || oResource instanceof AnnotationProperty || oResource instanceof DatatypeProperty) continue;
                    ((ObjectProperty)oResource).addSubProperty(rDFProperty);
                    rDFProperty.addSubProperty((ObjectProperty)oResource);
                }
            }
        }
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public void setOntology(Ontology ontology) {
        this.ontology = ontology;
    }

    @Override
    public void selectionChanged(ArrayList<DefaultMutableTreeNode> arrayList) {
        this.selectedNodes = arrayList;
    }

    public void setResoucesList(List<OResource> list) {
        this.resoucesList = list;
    }
}

