/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.ontology;

import gate.creole.ontology.AnnotationProperty;
import gate.creole.ontology.DatatypeProperty;
import gate.creole.ontology.OResource;
import gate.creole.ontology.RDFProperty;
import gate.creole.ontology.SymmetricProperty;
import gate.creole.ontology.TransitiveProperty;
import gate.gui.ontology.DetailsGroup;
import gate.gui.ontology.KeyValuePair;
import gate.gui.ontology.OntologyItemComparator;
import gate.gui.ontology.PropertyValue;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.table.AbstractTableModel;

public class PropertyDetailsTableModel
extends AbstractTableModel {
    protected DetailsGroup resourceInfo = new DetailsGroup("Resource Information", true, null);
    protected DetailsGroup directSuperProps = new DetailsGroup("Direct Super Properties", true, null);
    protected DetailsGroup allSuperProps = new DetailsGroup("All Super Properties", true, null);
    protected DetailsGroup directSubProps = new DetailsGroup("Direct Sub Properties", true, null);
    protected DetailsGroup equivalentProps;
    protected DetailsGroup allSubProps = new DetailsGroup("All Sub Properties", true, null);
    protected DetailsGroup domain;
    protected DetailsGroup range;
    protected DetailsGroup propertyTypes;
    protected DetailsGroup propertyValues;
    protected DetailsGroup[] detailGroups;
    protected OntologyItemComparator itemComparator;
    public static final int COLUMN_COUNT = 4;
    public static final int EXPANDED_COLUMN = 0;
    public static final int LABEL_COLUMN = 1;
    public static final int VALUE_COLUMN = 2;
    public static final int DELETE_COLUMN = 3;

    public PropertyDetailsTableModel() {
        this.equivalentProps = new DetailsGroup("Equivalent Properties", true, null);
        this.domain = new DetailsGroup("Domain", true, null);
        this.range = new DetailsGroup("Range", true, null);
        this.propertyTypes = new DetailsGroup("Properties", true, null);
        this.propertyValues = new DetailsGroup("PropertyValues", true, null);
        this.detailGroups = new DetailsGroup[0];
        this.itemComparator = new OntologyItemComparator();
    }

    public int getColumnCount() {
        return 4;
    }

    public int getRowCount() {
        int n = this.detailGroups.length;
        for (int i = 0; i < this.detailGroups.length; ++i) {
            if (!this.detailGroups[i].isExpanded()) continue;
            n += this.detailGroups[i].getSize();
        }
        return n;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return "";
            }
            case 2: {
                return "";
            }
            case 3: {
                return "";
            }
        }
        return "";
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return Object.class;
            }
            case 2: {
                return Object.class;
            }
            case 3: {
                return Object.class;
            }
        }
        return Object.class;
    }

    public boolean isCellEditable(int n, int n2) {
        Object object = this.getItemForRow(n);
        return false;
    }

    public void setValueAt(Object object, int n, int n2) {
        Object object2 = this.getItemForRow(n);
        if (n2 == 0 && object2 instanceof DetailsGroup) {
            DetailsGroup detailsGroup = (DetailsGroup)object2;
            detailsGroup.setExpanded((Boolean)object);
        }
        this.fireTableDataChanged();
    }

    protected Object getItemForRow(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n2 <= n) {
            if (n2 == n) {
                return this.detailGroups[n3];
            }
            int n4 = 1 + (this.detailGroups[n3].isExpanded() ? this.detailGroups[n3].getSize() : 0);
            if (n2 + n4 > n) {
                return this.detailGroups[n3].getValueAt(n - n2 - 1);
            }
            n2 += n4;
            ++n3;
        }
        return null;
    }

    public Object getValueAt(int n, int n2) {
        Object object = this.getItemForRow(n);
        switch (n2) {
            case 0: {
                return object instanceof DetailsGroup ? new Boolean(((DetailsGroup)object).isExpanded()) : null;
            }
            case 1: {
                return object;
            }
            case 2: {
                return object;
            }
            case 3: {
                return object;
            }
        }
        return null;
    }

    public void setItem(Object object) {
        Set<OResource> set;
        Collection<Object> collection;
        this.detailGroups = new DetailsGroup[]{this.resourceInfo, this.directSuperProps, this.allSuperProps, this.directSubProps, this.allSubProps, this.equivalentProps, this.domain, this.range, this.propertyTypes, this.propertyValues};
        RDFProperty rDFProperty = (RDFProperty)object;
        this.resourceInfo.getValues().clear();
        this.directSuperProps.getValues().clear();
        this.allSuperProps.getValues().clear();
        this.directSubProps.getValues().clear();
        this.allSubProps.getValues().clear();
        this.equivalentProps.getValues().clear();
        this.domain.getValues().clear();
        this.range.getValues().clear();
        this.propertyTypes.getValues().clear();
        this.propertyValues.getValues().clear();
        this.resourceInfo.getValues().clear();
        this.resourceInfo.getValues().add(rDFProperty);
        this.resourceInfo.getValues().add(new KeyValuePair(rDFProperty, "URI", rDFProperty.getURI().toString(), false));
        Set<RDFProperty> set2 = rDFProperty.getPropertiesWithResourceAsDomain();
        this.propertyTypes.getValues().addAll(set2);
        Collections.sort(this.propertyTypes.getValues(), this.itemComparator);
        Set<AnnotationProperty> set22 = rDFProperty.getSetAnnotationProperties();
        if (set22 != null) {
            for (AnnotationProperty object22 : set22) {
                collection = rDFProperty.getAnnotationPropertyValues(object22);
                for (int i = 0; i < collection.size(); ++i) {
                    PropertyValue propertyValue = new PropertyValue(object22, collection.get(i));
                    this.propertyValues.getValues().add(propertyValue);
                }
            }
        }
        if (rDFProperty instanceof AnnotationProperty) {
            this.resourceInfo.getValues().add(new KeyValuePair(rDFProperty, "TYPE", "Annotation Property", false));
        } else if (rDFProperty instanceof DatatypeProperty) {
            this.resourceInfo.getValues().add(new KeyValuePair(rDFProperty, "TYPE", "Datatype Property", false));
        } else if (rDFProperty instanceof SymmetricProperty) {
            this.resourceInfo.getValues().add(new KeyValuePair(rDFProperty, "TYPE", "Symmetric Property", false));
        } else if (rDFProperty instanceof TransitiveProperty) {
            this.resourceInfo.getValues().add(new KeyValuePair(rDFProperty, "TYPE", "Transitive Property", false));
        } else {
            this.resourceInfo.getValues().add(new KeyValuePair(rDFProperty, "TYPE", "Object Property", false));
        }
        if (rDFProperty instanceof AnnotationProperty) {
            this.fireTableDataChanged();
            return;
        }
        Set<RDFProperty> set3 = rDFProperty.getSuperProperties((byte)0);
        if (set3 != null) {
            this.directSuperProps.getValues().addAll(set3);
            Collections.sort(this.directSuperProps.getValues(), this.itemComparator);
        }
        if ((set3 = rDFProperty.getSuperProperties((byte)1)) != null) {
            this.allSuperProps.getValues().addAll(set3);
            Collections.sort(this.allSuperProps.getValues(), this.itemComparator);
        }
        if ((set3 = rDFProperty.getSubProperties((byte)0)) != null) {
            this.directSubProps.getValues().addAll(set3);
            Collections.sort(this.directSubProps.getValues(), this.itemComparator);
        }
        if ((set3 = rDFProperty.getSubProperties((byte)1)) != null) {
            this.allSubProps.getValues().addAll(set3);
            Collections.sort(this.allSubProps.getValues(), this.itemComparator);
        }
        if ((set3 = rDFProperty.getEquivalentPropertyAs()) != null) {
            this.equivalentProps.getValues().addAll(set3);
            Collections.sort(this.equivalentProps.getValues(), this.itemComparator);
        }
        if ((set = rDFProperty.getDomain()) != null) {
            this.domain.getValues().addAll(set);
            Collections.sort(this.domain.getValues(), this.itemComparator);
        }
        if (rDFProperty instanceof DatatypeProperty) {
            this.fireTableDataChanged();
            return;
        }
        collection = rDFProperty.getRange();
        if (collection != null) {
            this.range.getValues().addAll(collection);
            Collections.sort(this.range.getValues(), this.itemComparator);
        }
        this.fireTableDataChanged();
    }
}

