/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.ontology;

import gate.creole.ontology.AnnotationProperty;
import gate.creole.ontology.DatatypeProperty;
import gate.creole.ontology.Literal;
import gate.creole.ontology.OClass;
import gate.creole.ontology.OInstance;
import gate.creole.ontology.OResource;
import gate.creole.ontology.ObjectProperty;
import gate.creole.ontology.RDFProperty;
import gate.creole.ontology.Restriction;
import gate.creole.ontology.SymmetricProperty;
import gate.creole.ontology.TransitiveProperty;
import gate.gui.MainFrame;
import gate.gui.ontology.DetailsGroup;
import gate.gui.ontology.KeyValuePair;
import gate.gui.ontology.PropertyDetailsTableModel;
import gate.gui.ontology.PropertyValue;
import java.awt.Component;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class PropertyDetailsTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 3257572784619337525L;
    protected PropertyDetailsTableModel propertyDetailsTableModel;

    public PropertyDetailsTableCellRenderer(PropertyDetailsTableModel propertyDetailsTableModel) {
        this.propertyDetailsTableModel = propertyDetailsTableModel;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = super.getTableCellRendererComponent(jTable, "", bl, bl2, n, n2);
        try {
            if (n2 == 0) {
                this.setText(null);
                if (object == null) {
                    this.setIcon(null);
                } else {
                    Object object2 = this.propertyDetailsTableModel.getValueAt(n, 1);
                    this.setIcon(MainFrame.getIcon((Boolean)object != false ? "expanded" : "closed"));
                    this.setEnabled(((DetailsGroup)object2).getSize() > 0);
                }
            } else if (n2 == 1) {
                if (object instanceof DetailsGroup) {
                    DetailsGroup detailsGroup = (DetailsGroup)object;
                    this.setIcon(null);
                    this.setFont(this.getFont().deriveFont(1));
                    this.setText(detailsGroup.getName());
                    this.setEnabled(detailsGroup.getSize() > 0);
                } else if (object instanceof KeyValuePair) {
                    KeyValuePair keyValuePair = (KeyValuePair)object;
                    this.setIcon(MainFrame.getIcon("empty"));
                    this.setFont(this.getFont().deriveFont(0));
                    this.setText(keyValuePair.getKey());
                    this.setEnabled(true);
                } else if (object instanceof Restriction) {
                    OClass oClass = (OClass)object;
                    this.setIcon(MainFrame.getIcon("ontology-restriction"));
                    this.setFont(this.getFont().deriveFont(0));
                    this.setText(oClass.getName());
                    this.setToolTipText(oClass.getURI().toString());
                    this.setEnabled(true);
                } else if (object instanceof OClass) {
                    OClass oClass = (OClass)object;
                    this.setIcon(MainFrame.getIcon("ontology-class"));
                    this.setFont(this.getFont().deriveFont(0));
                    this.setText(oClass.getName());
                    this.setToolTipText(oClass.getURI().toString());
                    this.setEnabled(true);
                } else if (object instanceof OInstance) {
                    OInstance oInstance = (OInstance)object;
                    this.setIcon(MainFrame.getIcon("ontology-instance"));
                    this.setFont(this.getFont().deriveFont(0));
                    this.setText(oInstance.getName());
                    this.setToolTipText(oInstance.getURI().toString());
                    this.setEnabled(true);
                } else if (object instanceof RDFProperty) {
                    RDFProperty rDFProperty = (RDFProperty)object;
                    String string = "RDF";
                    if (rDFProperty instanceof SymmetricProperty) {
                        this.setIcon(MainFrame.getIcon("ontology-symmetric-property"));
                        string = "Symmetric";
                    } else if (rDFProperty instanceof AnnotationProperty) {
                        this.setIcon(MainFrame.getIcon("ontology-annotation-property"));
                        string = "Annotation";
                    } else if (rDFProperty instanceof TransitiveProperty) {
                        this.setIcon(MainFrame.getIcon("ontology-transitive-property"));
                        string = "Transitive";
                    } else if (rDFProperty instanceof ObjectProperty) {
                        this.setIcon(MainFrame.getIcon("ontology-object-property"));
                        string = "Object";
                    } else if (rDFProperty instanceof DatatypeProperty) {
                        this.setIcon(MainFrame.getIcon("ontology-datatype-property"));
                        string = "Datatype";
                    } else {
                        this.setIcon(MainFrame.getIcon("ontology-rdf-property"));
                    }
                    this.setFont(this.getFont().deriveFont(0));
                    String string2 = rDFProperty.getName();
                    this.setText(string2);
                    this.setToolTipText("<HTML><b>" + string + " Property</b><br>" + rDFProperty.getURI() + "</html>");
                    this.setEnabled(true);
                } else if (object instanceof PropertyValue) {
                    PropertyValue propertyValue = (PropertyValue)object;
                    String string = "RDF";
                    if (propertyValue.getProperty() instanceof SymmetricProperty) {
                        this.setIcon(MainFrame.getIcon("ontology-symmetric-property"));
                        string = "Symmetric";
                    } else if (propertyValue.getProperty() instanceof AnnotationProperty) {
                        this.setIcon(MainFrame.getIcon("ontology-annotation-property"));
                        string = "Annotation";
                    } else if (propertyValue.getProperty() instanceof TransitiveProperty) {
                        this.setIcon(MainFrame.getIcon("ontology-transitive-property"));
                        string = "Transitive";
                    } else if (propertyValue.getProperty() instanceof ObjectProperty) {
                        this.setIcon(MainFrame.getIcon("ontology-object-property"));
                        string = "Object";
                    } else if (propertyValue.getProperty() instanceof DatatypeProperty) {
                        this.setIcon(MainFrame.getIcon("ontology-datatype-property"));
                        string = "Datatype";
                    } else {
                        this.setIcon(MainFrame.getIcon("ontology-rdf-property"));
                    }
                    this.setFont(this.getFont().deriveFont(0));
                    String string3 = propertyValue.getProperty().getName();
                    this.setText(string3);
                    this.setToolTipText("<HTML><b>" + string + " Property Value</b><br>" + propertyValue.getProperty().getURI() + "</html>");
                    this.setEnabled(true);
                }
            } else if (n2 == 2) {
                this.setIcon(null);
                if (object instanceof PropertyValue) {
                    PropertyValue propertyValue = (PropertyValue)object;
                    this.setFont(this.getFont().deriveFont(0));
                    String string = "";
                    string = propertyValue.getValue() instanceof Literal ? ((Literal)propertyValue.getValue()).getValue() : propertyValue.getValue().toString();
                    this.setText(string);
                    this.setEnabled(true);
                } else if (object instanceof KeyValuePair) {
                    KeyValuePair keyValuePair = (KeyValuePair)object;
                    this.setIcon(null);
                    this.setFont(this.getFont().deriveFont(0));
                    this.setText(keyValuePair.getValue().toString());
                    this.setEnabled(true);
                } else if (object instanceof RDFProperty) {
                    RDFProperty rDFProperty = (RDFProperty)object;
                    String string = "";
                    if (rDFProperty instanceof DatatypeProperty) {
                        string = ((DatatypeProperty)rDFProperty).getDataType().getXmlSchemaURI().toString();
                    } else if (rDFProperty instanceof ObjectProperty) {
                        Set<OResource> set = rDFProperty.getRange();
                        if (set == null || set.isEmpty()) {
                            string = "[ALL CLASSES]";
                        } else {
                            string = "[";
                            boolean bl3 = true;
                            for (OResource oResource : set) {
                                if (!bl3) {
                                    string = string + ",";
                                } else {
                                    bl3 = false;
                                }
                                string = string + oResource.getName();
                            }
                            string = string + "]";
                        }
                    } else {
                        string = "[ALL RESOURCES]";
                    }
                    this.setIcon(null);
                    this.setFont(this.getFont().deriveFont(0));
                    this.setText(string);
                    this.setEnabled(true);
                } else {
                    this.setIcon(null);
                    this.setFont(this.getFont().deriveFont(0));
                    this.setText("");
                    this.setEnabled(false);
                }
            } else if (n2 == 3) {
                if (object instanceof PropertyValue) {
                    this.setIcon(MainFrame.getIcon("delete"));
                    this.setText("");
                    this.setEnabled(true);
                    this.setFont(this.getFont().deriveFont(0));
                } else {
                    this.setIcon(null);
                    this.setText("");
                    this.setEnabled(false);
                    this.setFont(this.getFont().deriveFont(0));
                }
            } else {
                this.setIcon(null);
                this.setFont(this.getFont().deriveFont(0));
                this.setText("");
                this.setEnabled(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return component;
    }
}

