/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.ontology;

import gate.Resource;
import gate.creole.AbstractVisualResource;
import gate.creole.ResourceInstantiationException;
import gate.creole.ontology.AnnotationProperty;
import gate.creole.ontology.DatatypeProperty;
import gate.creole.ontology.InvalidValueException;
import gate.creole.ontology.Literal;
import gate.creole.ontology.OClass;
import gate.creole.ontology.OInstance;
import gate.creole.ontology.OResource;
import gate.creole.ontology.ObjectProperty;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.OntologyModificationListener;
import gate.creole.ontology.RDFProperty;
import gate.creole.ontology.URI;
import gate.event.GateEvent;
import gate.gui.MainFrame;
import gate.gui.ResizableVisualResource;
import gate.gui.ontology.AnnotationPropertyAction;
import gate.gui.ontology.DatatypePropertyAction;
import gate.gui.ontology.DeleteOntologyResourceAction;
import gate.gui.ontology.DetailsGroup;
import gate.gui.ontology.DetailsTableCellRenderer;
import gate.gui.ontology.DetailsTableModel;
import gate.gui.ontology.InstanceAction;
import gate.gui.ontology.OResourceNode;
import gate.gui.ontology.ObjectPropertyAction;
import gate.gui.ontology.OntoTreeCellRenderer;
import gate.gui.ontology.OntologyItemComparator;
import gate.gui.ontology.PropertyDetailsTableCellRenderer;
import gate.gui.ontology.PropertyDetailsTableModel;
import gate.gui.ontology.PropertyValue;
import gate.gui.ontology.RDFPropertyAction;
import gate.gui.ontology.RestrictionAction;
import gate.gui.ontology.SubClassAction;
import gate.gui.ontology.SymmetricPropertyAction;
import gate.gui.ontology.TopClassAction;
import gate.gui.ontology.TransitivePropertyAction;
import gate.gui.ontology.TreeNodeSelectionListener;
import gate.gui.ontology.ValuesSelectionAction;
import gate.swing.XJTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyEditor
extends AbstractVisualResource
implements ResizableVisualResource,
OntologyModificationListener {
    private static final long serialVersionUID = 3257847701214345265L;
    protected Ontology ontology;
    protected OntologyItemComparator itemComparator;
    protected DnDJTree tree;
    protected DnDJTree propertyTree;
    protected DefaultTreeModel treeModel;
    protected DefaultTreeModel propertyTreeModel;
    protected JTable detailsTable;
    protected JTable propertyDetailsTable;
    protected DetailsTableModel detailsTableModel;
    protected PropertyDetailsTableModel propertyDetailsTableModel;
    protected JSplitPane mainSplit;
    protected DefaultMutableTreeNode rootNode;
    protected DefaultMutableTreeNode propertyRootNode;
    protected JScrollPane detailsTableScroller;
    protected JScrollPane propertyDetailsTableScroller;
    protected JToolBar toolBar;
    protected JButton topClass;
    protected JButton subClass;
    protected JButton restriction;
    protected JButton instance;
    protected JButton rdfProperty;
    protected JButton annotationProperty;
    protected JButton datatypeProperty;
    protected JButton objectProperty;
    protected JButton symmetricProperty;
    protected JButton transitiveProperty;
    protected JButton delete;
    protected ArrayList<DefaultMutableTreeNode> selectedNodes;
    protected ArrayList<String> ontologyClassesURIs;
    protected TopClassAction topClassAction;
    protected SubClassAction subClassAction;
    protected InstanceAction instanceAction;
    protected RDFPropertyAction rdfPropertyAction;
    protected AnnotationPropertyAction annotationPropertyAction;
    protected DatatypePropertyAction datatypePropertyAction;
    protected ObjectPropertyAction objectPropertyAction;
    protected SymmetricPropertyAction symmetricPropertyAction;
    protected TransitivePropertyAction transitivePropertyAction;
    protected DeleteOntologyResourceAction deleteOntoResourceAction;
    protected RestrictionAction restrictionAction;
    protected ArrayList<TreeNodeSelectionListener> listeners;
    protected HashMap<String, ArrayList<DefaultMutableTreeNode>> uri2TreeNodesListMap;
    protected HashMap<DefaultMutableTreeNode, URI> reverseMap;
    protected JScrollPane propertyScroller;
    protected JScrollPane scroller;
    protected JTabbedPane tabbedPane;

    @Override
    public void setTarget(Object object) {
        this.ontology = (Ontology)object;
        this.selectedNodes = new ArrayList();
        this.detailsTableModel.setOntology(this.ontology);
        this.topClassAction.setOntology(this.ontology);
        this.subClassAction.setOntology(this.ontology);
        this.instanceAction.setOntology(this.ontology);
        this.rdfPropertyAction.setOntology(this.ontology);
        this.annotationPropertyAction.setOntology(this.ontology);
        this.datatypePropertyAction.setOntology(this.ontology);
        this.objectPropertyAction.setOntology(this.ontology);
        this.symmetricPropertyAction.setOntology(this.ontology);
        this.transitivePropertyAction.setOntology(this.ontology);
        this.deleteOntoResourceAction.setOntology(this.ontology);
        this.restrictionAction.setOntology(this.ontology);
        this.ontology.removeOntologyModificationListener(this);
        this.rebuildModel();
        this.ontology.addOntologyModificationListener(this);
    }

    @Override
    public Resource init() throws ResourceInstantiationException {
        super.init();
        this.initLocalData();
        this.initGUIComponents();
        this.initListeners();
        return this;
    }

    protected void initLocalData() {
        this.itemComparator = new OntologyItemComparator();
        this.listeners = new ArrayList();
    }

    protected void initGUIComponents() {
        this.setLayout(new BorderLayout());
        this.mainSplit = new JSplitPane(1);
        this.add((Component)this.mainSplit, "Center");
        this.tabbedPane = new JTabbedPane();
        this.mainSplit.setLeftComponent(this.tabbedPane);
        this.rootNode = new DefaultMutableTreeNode(null, true);
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new DnDJTree(this.treeModel);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new OntoTreeCellRenderer());
        this.tree.getSelectionModel().setSelectionMode(4);
        this.scroller = new JScrollPane(this.tree);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tabbedPane.addTab("Classes & Instances", this.scroller);
        this.scroller.setBorder(new TitledBorder("Classes and Instances"));
        this.propertyRootNode = new DefaultMutableTreeNode(null, true);
        this.propertyTreeModel = new DefaultTreeModel(this.propertyRootNode);
        this.propertyTree = new DnDJTree(this.propertyTreeModel);
        this.propertyTree.setRootVisible(false);
        this.propertyTree.setShowsRootHandles(true);
        this.propertyTree.setCellRenderer(new OntoTreeCellRenderer());
        this.propertyTree.getSelectionModel().setSelectionMode(4);
        this.propertyScroller = new JScrollPane(this.propertyTree);
        ToolTipManager.sharedInstance().registerComponent(this.propertyTree);
        this.tabbedPane.addTab("Properties", this.propertyScroller);
        this.propertyScroller.setBorder(new TitledBorder("Properties"));
        this.detailsTableModel = new DetailsTableModel();
        this.propertyDetailsTableModel = new PropertyDetailsTableModel();
        this.detailsTable = new XJTable(this.detailsTableModel);
        ((XJTable)this.detailsTable).setSortable(false);
        DetailsTableCellRenderer detailsTableCellRenderer = new DetailsTableCellRenderer(this.detailsTableModel);
        this.detailsTable.getColumnModel().getColumn(0).setCellRenderer(detailsTableCellRenderer);
        this.detailsTable.getColumnModel().getColumn(1).setCellRenderer(detailsTableCellRenderer);
        this.detailsTable.getColumnModel().getColumn(2).setCellRenderer(detailsTableCellRenderer);
        this.detailsTable.getColumnModel().getColumn(3).setCellRenderer(detailsTableCellRenderer);
        this.detailsTable.setShowGrid(false);
        this.detailsTable.setSelectionMode(0);
        this.detailsTable.setColumnSelectionAllowed(true);
        this.detailsTable.setRowSelectionAllowed(true);
        this.detailsTable.setTableHeader(null);
        this.detailsTable.setAutoResizeMode(0);
        this.detailsTableScroller = new JScrollPane(this.detailsTable);
        this.detailsTableScroller.getViewport().setOpaque(true);
        this.detailsTableScroller.getViewport().setBackground(this.detailsTable.getBackground());
        this.mainSplit.setRightComponent(this.detailsTableScroller);
        this.propertyDetailsTable = new XJTable(this.propertyDetailsTableModel);
        ((XJTable)this.propertyDetailsTable).setSortable(false);
        PropertyDetailsTableCellRenderer propertyDetailsTableCellRenderer = new PropertyDetailsTableCellRenderer(this.propertyDetailsTableModel);
        this.propertyDetailsTable.getColumnModel().getColumn(0).setCellRenderer(propertyDetailsTableCellRenderer);
        this.propertyDetailsTable.getColumnModel().getColumn(1).setCellRenderer(propertyDetailsTableCellRenderer);
        this.propertyDetailsTable.getColumnModel().getColumn(2).setCellRenderer(propertyDetailsTableCellRenderer);
        this.propertyDetailsTable.getColumnModel().getColumn(3).setCellRenderer(propertyDetailsTableCellRenderer);
        this.propertyDetailsTable.setShowGrid(false);
        this.propertyDetailsTable.setSelectionMode(0);
        this.propertyDetailsTable.setColumnSelectionAllowed(true);
        this.propertyDetailsTable.setRowSelectionAllowed(true);
        this.propertyDetailsTable.setTableHeader(null);
        this.propertyDetailsTable.setAutoResizeMode(0);
        this.propertyDetailsTableScroller = new JScrollPane(this.propertyDetailsTable);
        this.propertyDetailsTableScroller.getViewport().setOpaque(true);
        this.propertyDetailsTableScroller.getViewport().setBackground(this.propertyDetailsTable.getBackground());
        this.toolBar = new JToolBar(0);
        this.topClassAction = new TopClassAction("", MainFrame.getIcon("ontology-topclass"));
        this.topClass = new JButton(this.topClassAction);
        this.topClass.setToolTipText("Add New Top Class");
        this.subClassAction = new SubClassAction("", MainFrame.getIcon("ontology-subclass"));
        this.addTreeNodeSelectionListener(this.subClassAction);
        this.subClass = new JButton(this.subClassAction);
        this.subClass.setToolTipText("Add New Sub Class");
        this.instanceAction = new InstanceAction("", MainFrame.getIcon("ontology-instance"));
        this.addTreeNodeSelectionListener(this.instanceAction);
        this.instance = new JButton(this.instanceAction);
        this.instance.setToolTipText("Add New Instance");
        this.rdfPropertyAction = new RDFPropertyAction("", MainFrame.getIcon("ontology-rdf-property"));
        this.addTreeNodeSelectionListener(this.rdfPropertyAction);
        this.rdfProperty = new JButton(this.rdfPropertyAction);
        this.rdfProperty.setToolTipText("Add New RDF Property");
        this.annotationPropertyAction = new AnnotationPropertyAction("", MainFrame.getIcon("ontology-annotation-property"));
        this.addTreeNodeSelectionListener(this.annotationPropertyAction);
        this.annotationProperty = new JButton(this.annotationPropertyAction);
        this.annotationProperty.setToolTipText("Add New Annotation Property");
        this.datatypePropertyAction = new DatatypePropertyAction("", MainFrame.getIcon("ontology-datatype-property"));
        this.addTreeNodeSelectionListener(this.datatypePropertyAction);
        this.datatypeProperty = new JButton(this.datatypePropertyAction);
        this.datatypeProperty.setToolTipText("Add New Datatype Property");
        this.objectPropertyAction = new ObjectPropertyAction("", MainFrame.getIcon("ontology-object-property"));
        this.addTreeNodeSelectionListener(this.objectPropertyAction);
        this.objectProperty = new JButton(this.objectPropertyAction);
        this.objectProperty.setToolTipText("Add New Object Property");
        this.symmetricPropertyAction = new SymmetricPropertyAction("", MainFrame.getIcon("ontology-symmetric-property"));
        this.addTreeNodeSelectionListener(this.symmetricPropertyAction);
        this.symmetricProperty = new JButton(this.symmetricPropertyAction);
        this.symmetricProperty.setToolTipText("Add New Symmetric Property");
        this.transitivePropertyAction = new TransitivePropertyAction("", MainFrame.getIcon("ontology-transitive-property"));
        this.addTreeNodeSelectionListener(this.transitivePropertyAction);
        this.transitiveProperty = new JButton(this.transitivePropertyAction);
        this.transitiveProperty.setToolTipText("Add New Transitive Property");
        this.deleteOntoResourceAction = new DeleteOntologyResourceAction("", MainFrame.getIcon("delete"));
        this.restrictionAction = new RestrictionAction("", MainFrame.getIcon("ontology-restriction"));
        this.addTreeNodeSelectionListener(this.deleteOntoResourceAction);
        this.delete = new JButton(this.deleteOntoResourceAction);
        this.delete.setToolTipText("Delete the selected nodes");
        this.restriction = new JButton(this.restrictionAction);
        this.restriction.setToolTipText("Add New Restriction");
        this.toolBar.setFloatable(false);
        this.toolBar.add(this.topClass);
        this.toolBar.add(this.subClass);
        this.toolBar.add(this.restriction);
        this.toolBar.add(this.instance);
        this.toolBar.add(this.rdfProperty);
        this.toolBar.add(this.annotationProperty);
        this.toolBar.add(this.datatypeProperty);
        this.toolBar.add(this.objectProperty);
        this.toolBar.add(this.symmetricProperty);
        this.toolBar.add(this.transitiveProperty);
        this.toolBar.add(this.delete);
        this.add((Component)this.toolBar, "North");
    }

    private void updateSelection(JTree jTree, Component component) {
        int[] nArray = jTree.getSelectionRows();
        if (nArray != null && nArray.length > 0) {
            this.selectedNodes.clear();
            for (int i = 0; i < nArray.length; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getPathForRow(nArray[i]).getLastPathComponent();
                this.selectedNodes.add(defaultMutableTreeNode);
            }
            if (jTree == this.tree) {
                this.detailsTableModel.setItem(((OResourceNode)this.selectedNodes.get(0).getUserObject()).getResource());
            } else {
                this.propertyDetailsTableModel.setItem(((OResourceNode)this.selectedNodes.get(0).getUserObject()).getResource());
            }
            this.enableDisableToolBarComponents();
            this.fireTreeNodeSelectionChanged(this.selectedNodes);
            if (jTree == this.tree) {
                this.propertyTree.clearSelection();
            } else {
                this.tree.clearSelection();
            }
        }
        this.mainSplit.setRightComponent(component);
        this.mainSplit.updateUI();
    }

    protected void initListeners() {
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                OntologyEditor.this.updateSelection(OntologyEditor.this.tree, OntologyEditor.this.detailsTableScroller);
            }
        });
        this.propertyTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                OntologyEditor.this.updateSelection(OntologyEditor.this.propertyTree, OntologyEditor.this.propertyDetailsTableScroller);
            }
        });
        this.mainSplit.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                OntologyEditor.this.mainSplit.setDividerLocation(0.4);
            }

            public void componentShown(ComponentEvent componentEvent) {
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    if (OntologyEditor.this.selectedNodes.size() > 1) {
                        return;
                    }
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenu jMenu = new JMenu("Properties");
                    final OResource oResource = ((OResourceNode)OntologyEditor.this.selectedNodes.get(0).getUserObject()).getResource();
                    jPopupMenu.add(jMenu);
                    JMenuItem jMenuItem = new JMenuItem(oResource instanceof OClass ? "Equivalent Class" : "Same As Instance");
                    jPopupMenu.add(jMenuItem);
                    JMenuItem jMenuItem2 = new JMenuItem("Add SubClass", MainFrame.getIcon("ontology-subclass"));
                    JMenuItem jMenuItem3 = new JMenuItem("Add Instance", MainFrame.getIcon("ontology-instance"));
                    JMenuItem jMenuItem4 = new JMenuItem("Delete", MainFrame.getIcon("delete"));
                    if (oResource instanceof OClass) {
                        jPopupMenu.add(jMenuItem2);
                        jPopupMenu.add(jMenuItem3);
                        jMenuItem2.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                OntologyEditor.this.subClassAction.actionPerformed(actionEvent);
                            }
                        });
                        jMenuItem3.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                OntologyEditor.this.instanceAction.actionPerformed(actionEvent);
                            }
                        });
                        jMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                Set<OClass> set = OntologyEditor.this.ontology.getOClasses(false);
                                ArrayList<OClass> arrayList = new ArrayList<OClass>();
                                for (OClass object2 : set) {
                                    arrayList.add(object2);
                                }
                                arrayList.remove(oResource);
                                ValuesSelectionAction valuesSelectionAction = new ValuesSelectionAction();
                                String[] stringArray = new String[arrayList.size()];
                                for (int stringArray2 = 0; stringArray2 < stringArray.length; ++stringArray2) {
                                    stringArray[stringArray2] = ((OClass)arrayList.get(stringArray2)).getURI().toString();
                                }
                                valuesSelectionAction.showGUI(oResource.getName() + " is equivalent to :", stringArray, new String[0], false);
                                String[] stringArray2 = valuesSelectionAction.getSelectedValues();
                                for (int treePath = 0; treePath < stringArray2.length; ++treePath) {
                                    OClass oClass = (OClass)OntologyEditor.this.ontology.getOResourceFromMap(stringArray2[treePath]);
                                    if (oClass == null) continue;
                                    ((OClass)oResource).setEquivalentClassAs(oClass);
                                }
                                TreePath treePath = OntologyEditor.this.tree.getSelectionPath();
                                OntologyEditor.this.tree.setSelectionRow(0);
                                OntologyEditor.this.tree.setSelectionPath(treePath);
                            }
                        });
                    }
                    if (oResource instanceof OInstance) {
                        jMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                Set<OInstance> set = OntologyEditor.this.ontology.getOInstances();
                                ArrayList<OInstance> arrayList = new ArrayList<OInstance>();
                                for (OInstance object2 : set) {
                                    arrayList.add(object2);
                                }
                                arrayList.remove(oResource);
                                ValuesSelectionAction valuesSelectionAction = new ValuesSelectionAction();
                                String[] stringArray = new String[arrayList.size()];
                                for (int stringArray2 = 0; stringArray2 < stringArray.length; ++stringArray2) {
                                    stringArray[stringArray2] = ((OInstance)arrayList.get(stringArray2)).getURI().toString();
                                }
                                valuesSelectionAction.showGUI(oResource.getName() + " is same As :", stringArray, new String[0], false);
                                String[] stringArray2 = valuesSelectionAction.getSelectedValues();
                                for (int treePath = 0; treePath < stringArray2.length; ++treePath) {
                                    OInstance oInstance = (OInstance)OntologyEditor.this.ontology.getOResourceFromMap(stringArray2[treePath]);
                                    if (oInstance == null) continue;
                                    ((OInstance)oResource).setSameInstanceAs(oInstance);
                                }
                                TreePath treePath = OntologyEditor.this.tree.getSelectionPath();
                                OntologyEditor.this.tree.setSelectionRow(0);
                                OntologyEditor.this.tree.setSelectionPath(treePath);
                            }
                        });
                    }
                    jPopupMenu.add(jMenuItem4);
                    jMenuItem4.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            OntologyEditor.this.deleteOntoResourceAction.actionPerformed(actionEvent);
                        }
                    });
                    Set<RDFProperty> set = OntologyEditor.this.ontology.getPropertyDefinitions();
                    for (final RDFProperty rDFProperty : set) {
                        JMenuItem jMenuItem5;
                        if (rDFProperty instanceof AnnotationProperty) {
                            jMenuItem5 = new JMenuItem(rDFProperty.getName(), MainFrame.getIcon("ontology-annotation-property"));
                            jMenu.add(jMenuItem5);
                            jMenuItem5.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    String string = JOptionPane.showInputDialog(null, (Object)("Enter Value for property :" + rDFProperty.getName()));
                                    if (string != null) {
                                        oResource.addAnnotationPropertyValue((AnnotationProperty)rDFProperty, new Literal(string));
                                    }
                                    TreePath treePath = OntologyEditor.this.tree.getSelectionPath();
                                    OntologyEditor.this.tree.setSelectionRow(0);
                                    OntologyEditor.this.tree.setSelectionPath(treePath);
                                }
                            });
                            continue;
                        }
                        if (oResource instanceof OInstance && rDFProperty instanceof DatatypeProperty && rDFProperty.isValidDomain(oResource)) {
                            jMenuItem5 = new JMenuItem(rDFProperty.getName(), MainFrame.getIcon("ontology-datatype-property"));
                            jMenu.add(jMenuItem5);
                            jMenuItem5.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    String string = JOptionPane.showInputDialog(null, "Datatype : " + ((DatatypeProperty)rDFProperty).getDataType().getXmlSchemaURI().toString(), "Enter Value for property :" + rDFProperty.getName());
                                    if (string != null) {
                                        boolean bl = ((DatatypeProperty)rDFProperty).getDataType().isValidValue(string);
                                        if (!bl) {
                                            JOptionPane.showMessageDialog(null, "Incompatible value : " + string);
                                            return;
                                        }
                                        try {
                                            ((OInstance)oResource).addDatatypePropertyValue((DatatypeProperty)rDFProperty, new Literal(string, ((DatatypeProperty)rDFProperty).getDataType()));
                                        }
                                        catch (InvalidValueException invalidValueException) {
                                            JOptionPane.showMessageDialog(null, "Incompatible value");
                                            return;
                                        }
                                    }
                                    TreePath treePath = OntologyEditor.this.tree.getSelectionPath();
                                    OntologyEditor.this.tree.setSelectionRow(0);
                                    OntologyEditor.this.tree.setSelectionPath(treePath);
                                }
                            });
                            continue;
                        }
                        if (!(oResource instanceof OInstance) || !(rDFProperty instanceof ObjectProperty) || !rDFProperty.isValidDomain(oResource)) continue;
                        jMenuItem5 = new JMenuItem(rDFProperty.getName(), MainFrame.getIcon("ontology-object-property"));
                        jMenu.add(jMenuItem5);
                        jMenuItem5.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                Set<OInstance> set = OntologyEditor.this.ontology.getOInstances();
                                ArrayList<OInstance> arrayList = new ArrayList<OInstance>();
                                for (OInstance object2 : set) {
                                    if (!rDFProperty.isValidRange(object2)) continue;
                                    arrayList.add(object2);
                                }
                                ValuesSelectionAction valuesSelectionAction = new ValuesSelectionAction();
                                String[] stringArray = new String[arrayList.size()];
                                for (int stringArray2 = 0; stringArray2 < stringArray.length; ++stringArray2) {
                                    stringArray[stringArray2] = ((OInstance)arrayList.get(stringArray2)).getURI().toString();
                                }
                                valuesSelectionAction.showGUI("Select Values for the " + rDFProperty.getName(), stringArray, new String[0], false);
                                String[] stringArray2 = valuesSelectionAction.getSelectedValues();
                                for (int treePath = 0; treePath < stringArray2.length; ++treePath) {
                                    OInstance oInstance = (OInstance)OntologyEditor.this.ontology.getOResourceFromMap(stringArray2[treePath]);
                                    if (oInstance == null) continue;
                                    try {
                                        ((OInstance)oResource).addObjectPropertyValue((ObjectProperty)rDFProperty, oInstance);
                                        continue;
                                    }
                                    catch (InvalidValueException invalidValueException) {
                                        JOptionPane.showMessageDialog(null, "Incompatible value");
                                        return;
                                    }
                                }
                                TreePath treePath = OntologyEditor.this.tree.getSelectionPath();
                                OntologyEditor.this.tree.setSelectionRow(0);
                                OntologyEditor.this.tree.setSelectionPath(treePath);
                            }
                        });
                    }
                    jPopupMenu.show(OntologyEditor.this.tree, mouseEvent.getX(), mouseEvent.getY());
                    jPopupMenu.setVisible(true);
                }
            }
        });
        this.propertyTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    if (OntologyEditor.this.selectedNodes.size() > 1) {
                        return;
                    }
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    final OResource oResource = ((OResourceNode)OntologyEditor.this.selectedNodes.get(0).getUserObject()).getResource();
                    JMenuItem jMenuItem = new JMenuItem("Equivalent Property");
                    JMenuItem jMenuItem2 = new JMenuItem("Delete", MainFrame.getIcon("delete"));
                    final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Functional");
                    final JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("InverseFunctional");
                    jPopupMenu.add(jMenuItem);
                    if (oResource instanceof AnnotationProperty) {
                        return;
                    }
                    final HashSet<RDFProperty> hashSet = new HashSet<RDFProperty>();
                    if (oResource instanceof ObjectProperty) {
                        hashSet.addAll(OntologyEditor.this.ontology.getObjectProperties());
                        jCheckBoxMenuItem.setSelected(((ObjectProperty)oResource).isFunctional());
                        jCheckBoxMenuItem2.setSelected(((ObjectProperty)oResource).isInverseFunctional());
                        jCheckBoxMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                ((ObjectProperty)oResource).setFunctional(jCheckBoxMenuItem.isSelected());
                            }
                        });
                        jCheckBoxMenuItem2.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                ((ObjectProperty)oResource).setInverseFunctional(jCheckBoxMenuItem2.isSelected());
                            }
                        });
                        jPopupMenu.add(jCheckBoxMenuItem);
                        jPopupMenu.add(jCheckBoxMenuItem2);
                    } else if (oResource instanceof DatatypeProperty) {
                        hashSet.addAll(OntologyEditor.this.ontology.getDatatypeProperties());
                    } else {
                        hashSet.addAll(OntologyEditor.this.ontology.getRDFProperties());
                    }
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            hashSet.remove(oResource);
                            Iterator iterator = hashSet.iterator();
                            ValuesSelectionAction valuesSelectionAction = new ValuesSelectionAction();
                            String[] stringArray = new String[hashSet.size()];
                            for (int i = 0; i < stringArray.length; ++i) {
                                stringArray[i] = ((RDFProperty)iterator.next()).getURI().toString();
                            }
                            valuesSelectionAction.showGUI(oResource.getName() + " is equivalent to :", stringArray, new String[0], false);
                            String[] stringArray2 = valuesSelectionAction.getSelectedValues();
                            for (int i = 0; i < stringArray2.length; ++i) {
                                RDFProperty rDFProperty = (RDFProperty)OntologyEditor.this.ontology.getOResourceFromMap(stringArray2[i]);
                                if (rDFProperty == null) continue;
                                ((RDFProperty)oResource).setEquivalentPropertyAs(rDFProperty);
                            }
                            TreePath treePath = OntologyEditor.this.propertyTree.getSelectionPath();
                            OntologyEditor.this.propertyTree.setSelectionRow(0);
                            OntologyEditor.this.propertyTree.setSelectionPath(treePath);
                        }
                    });
                    jPopupMenu.add(jMenuItem2);
                    jMenuItem2.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            OntologyEditor.this.deleteOntoResourceAction.actionPerformed(actionEvent);
                        }
                    });
                    JMenu jMenu = new JMenu("Properties");
                    Set<RDFProperty> set = OntologyEditor.this.ontology.getPropertyDefinitions();
                    for (final RDFProperty rDFProperty : hashSet) {
                        if (!(rDFProperty instanceof AnnotationProperty)) continue;
                        JMenuItem jMenuItem3 = new JMenuItem(rDFProperty.getName(), MainFrame.getIcon("ontology-annotation-property"));
                        jMenu.add(jMenuItem3);
                        jMenuItem3.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                String string = JOptionPane.showInputDialog(null, (Object)("Enter Value for property :" + rDFProperty.getName()));
                                if (string != null) {
                                    oResource.addAnnotationPropertyValue((AnnotationProperty)rDFProperty, new Literal(string));
                                }
                                TreePath treePath = OntologyEditor.this.tree.getSelectionPath();
                                OntologyEditor.this.tree.setSelectionRow(0);
                                OntologyEditor.this.tree.setSelectionPath(treePath);
                            }
                        });
                    }
                    jPopupMenu.show(OntologyEditor.this.propertyTree, mouseEvent.getX(), mouseEvent.getY());
                    jPopupMenu.setVisible(true);
                }
            }
        });
        this.detailsTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    Object object;
                    Object object2;
                    int[] nArray = OntologyEditor.this.detailsTable.getSelectedRows();
                    int n = OntologyEditor.this.detailsTable.getSelectedColumn();
                    if (nArray == null || nArray.length == 0) {
                        return;
                    }
                    Object object3 = OntologyEditor.this.detailsTable.getModel().getValueAt(nArray[0], 1);
                    if (object3 instanceof DetailsGroup) {
                        return;
                    }
                    Object object4 = object3;
                    Object object5 = OntologyEditor.this.tree.getSelectionPath().getLastPathComponent();
                    if (object5 == null) {
                        JOptionPane.showMessageDialog(MainFrame.getInstance(), "No resource selected in the main ontology tree");
                        return;
                    }
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object5;
                    OResource oResource = ((OResourceNode)defaultMutableTreeNode.getUserObject()).getResource();
                    if (!(object4 instanceof PropertyValue && n != 1 || mouseEvent.getClickCount() != 2)) {
                        object2 = null;
                        object = null;
                        if (object4 instanceof OClass) {
                            object2 = (OResource)object4;
                            object = OntologyEditor.this.tree;
                        } else if (object4 instanceof RDFProperty) {
                            object2 = (RDFProperty)object4;
                            object = OntologyEditor.this.propertyTree;
                        } else if (object4 instanceof PropertyValue) {
                            object2 = ((PropertyValue)object4).getProperty();
                            object = OntologyEditor.this.propertyTree;
                        }
                        if (object2 != null) {
                            ((JTree)object).setSelectionPath(new TreePath(OntologyEditor.this.uri2TreeNodesListMap.get(object2.getURI().toString()).get(0).getPath()));
                            ((JTree)object).scrollPathToVisible(((JTree)object).getSelectionPath());
                            if (object == OntologyEditor.this.tree) {
                                OntologyEditor.this.tabbedPane.setSelectedComponent(OntologyEditor.this.scroller);
                            } else {
                                OntologyEditor.this.tabbedPane.setSelectedComponent(OntologyEditor.this.propertyScroller);
                            }
                            return;
                        }
                    }
                    if (object4 instanceof PropertyValue && n == 2 && mouseEvent.getClickCount() == 2) {
                        object2 = (PropertyValue)object4;
                        object = ((PropertyValue)object2).getProperty();
                        if (object instanceof AnnotationProperty) {
                            String string = JOptionPane.showInputDialog(MainFrame.getInstance(), ((Literal)((PropertyValue)object2).getValue()).getValue(), "Value for " + object.getName() + " property", 3);
                            if (string != null) {
                                oResource.removeAnnotationPropertyValue((AnnotationProperty)object, (Literal)((PropertyValue)object2).getValue());
                                oResource.addAnnotationPropertyValue((AnnotationProperty)object, new Literal(string));
                            }
                            TreePath treePath = OntologyEditor.this.tree.getSelectionPath();
                            OntologyEditor.this.tree.setSelectionRow(0);
                            OntologyEditor.this.tree.setSelectionPath(treePath);
                            return;
                        }
                        if (object instanceof DatatypeProperty) {
                            String string = JOptionPane.showInputDialog(MainFrame.getInstance(), "Datatype : " + ((DatatypeProperty)object).getDataType().getXmlSchemaURI().toString(), ((Literal)((PropertyValue)object2).getValue()).getValue());
                            if (string != null) {
                                boolean bl = ((DatatypeProperty)object).getDataType().isValidValue(string);
                                if (!bl) {
                                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "Incompatible value : " + object3);
                                    return;
                                }
                                try {
                                    ((OInstance)oResource).removeDatatypePropertyValue((DatatypeProperty)object, (Literal)((PropertyValue)object2).getValue());
                                    ((OInstance)oResource).addDatatypePropertyValue((DatatypeProperty)object, new Literal(string, ((DatatypeProperty)object).getDataType()));
                                }
                                catch (InvalidValueException invalidValueException) {
                                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "Incompatible value");
                                    return;
                                }
                            }
                            TreePath treePath = OntologyEditor.this.tree.getSelectionPath();
                            OntologyEditor.this.tree.setSelectionRow(0);
                            OntologyEditor.this.tree.setSelectionPath(treePath);
                            return;
                        }
                        if (object instanceof ObjectProperty) {
                            Set<OInstance> set = OntologyEditor.this.ontology.getOInstances();
                            ArrayList<OInstance> arrayList = new ArrayList<OInstance>();
                            for (OInstance object62 : set) {
                                if (!object.isValidRange(object62)) continue;
                                arrayList.add(object62);
                            }
                            ValuesSelectionAction valuesSelectionAction = new ValuesSelectionAction();
                            String[] stringArray = new String[arrayList.size()];
                            for (int stringArray2 = 0; stringArray2 < stringArray.length; ++stringArray2) {
                                stringArray[stringArray2] = ((OInstance)arrayList.get(stringArray2)).getURI().toString();
                            }
                            valuesSelectionAction.showGUI("Select Values for the " + object.getName(), stringArray, new String[0], false);
                            String[] stringArray2 = valuesSelectionAction.getSelectedValues();
                            ((OInstance)oResource).removeObjectPropertyValue((ObjectProperty)object, (OInstance)((PropertyValue)object2).getValue());
                            for (int treePath = 0; treePath < stringArray2.length; ++treePath) {
                                OInstance oInstance = (OInstance)OntologyEditor.this.ontology.getOResourceFromMap(stringArray2[treePath]);
                                if (oInstance == null) continue;
                                try {
                                    ((OInstance)oResource).addObjectPropertyValue((ObjectProperty)object, oInstance);
                                    continue;
                                }
                                catch (InvalidValueException invalidValueException) {
                                    JOptionPane.showMessageDialog(null, "Incompatible value");
                                    return;
                                }
                            }
                            TreePath treePath = OntologyEditor.this.tree.getSelectionPath();
                            OntologyEditor.this.tree.setSelectionRow(0);
                            OntologyEditor.this.tree.setSelectionPath(treePath);
                            return;
                        }
                    }
                    if (object4 instanceof PropertyValue && n == 3 && mouseEvent.getClickCount() == 1) {
                        object2 = (PropertyValue)object4;
                        try {
                            if (oResource instanceof OClass) {
                                if (((PropertyValue)object2).getProperty() instanceof AnnotationProperty) {
                                    ((OClass)oResource).removeAnnotationPropertyValue((AnnotationProperty)((PropertyValue)object2).getProperty(), (Literal)((PropertyValue)object2).getValue());
                                }
                            } else {
                                object = (OInstance)oResource;
                                if (((PropertyValue)object2).getProperty() instanceof AnnotationProperty) {
                                    object.removeAnnotationPropertyValue((AnnotationProperty)((PropertyValue)object2).getProperty(), (Literal)((PropertyValue)object2).getValue());
                                } else if (((PropertyValue)object2).getProperty() instanceof DatatypeProperty) {
                                    object.removeDatatypePropertyValue((DatatypeProperty)((PropertyValue)object2).getProperty(), (Literal)((PropertyValue)object2).getValue());
                                } else if (((PropertyValue)object2).getProperty() instanceof ObjectProperty) {
                                    object.removeObjectPropertyValue((ObjectProperty)((PropertyValue)object2).getProperty(), (OInstance)((PropertyValue)object2).getValue());
                                }
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    TreePath treePath = OntologyEditor.this.tree.getSelectionPath();
                                    OntologyEditor.this.tree.setSelectionRow(0);
                                    OntologyEditor.this.tree.setSelectionPath(treePath);
                                }
                            });
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(MainFrame.getInstance(), "Cannot delete the property value because \n" + exception.getMessage());
                            exception.printStackTrace();
                        }
                    }
                }
            }
        });
        this.propertyDetailsTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    Object object;
                    Object object2;
                    int[] nArray = OntologyEditor.this.propertyDetailsTable.getSelectedRows();
                    int n = OntologyEditor.this.propertyDetailsTable.getSelectedColumn();
                    if (nArray == null || nArray.length == 0) {
                        return;
                    }
                    Object object3 = OntologyEditor.this.propertyDetailsTable.getModel().getValueAt(nArray[0], 1);
                    if (object3 instanceof DetailsGroup) {
                        return;
                    }
                    Object object4 = object3;
                    Object object5 = OntologyEditor.this.propertyTree.getSelectionPath().getLastPathComponent();
                    if (object5 == null) {
                        JOptionPane.showMessageDialog(MainFrame.getInstance(), "No resource selected in the main ontology tree");
                        return;
                    }
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object5;
                    OResource oResource = ((OResourceNode)defaultMutableTreeNode.getUserObject()).getResource();
                    if (!(object4 instanceof PropertyValue && n != 1 || mouseEvent.getClickCount() != 2)) {
                        object2 = null;
                        object = null;
                        if (object4 instanceof OClass) {
                            object2 = (OResource)object4;
                            object = OntologyEditor.this.tree;
                        } else if (object4 instanceof RDFProperty) {
                            object2 = (RDFProperty)object4;
                            object = OntologyEditor.this.propertyTree;
                        } else if (object4 instanceof PropertyValue) {
                            object2 = ((PropertyValue)object4).getProperty();
                            object = OntologyEditor.this.propertyTree;
                        }
                        if (object2 != null) {
                            ((JTree)object).setSelectionPath(new TreePath(OntologyEditor.this.uri2TreeNodesListMap.get(object2.getURI().toString()).get(0).getPath()));
                            ((JTree)object).scrollPathToVisible(((JTree)object).getSelectionPath());
                            if (object == OntologyEditor.this.tree) {
                                OntologyEditor.this.tabbedPane.setSelectedComponent(OntologyEditor.this.scroller);
                            } else {
                                OntologyEditor.this.tabbedPane.setSelectedComponent(OntologyEditor.this.propertyScroller);
                            }
                            return;
                        }
                    }
                    if (object4 instanceof PropertyValue && n == 2 && mouseEvent.getClickCount() == 2 && (object = ((PropertyValue)(object2 = (PropertyValue)object4)).getProperty()) instanceof AnnotationProperty) {
                        String string = JOptionPane.showInputDialog(MainFrame.getInstance(), ((Literal)((PropertyValue)object2).getValue()).getValue(), "Value for " + object.getName() + " property", 3);
                        if (string != null) {
                            oResource.removeAnnotationPropertyValue((AnnotationProperty)object, (Literal)((PropertyValue)object2).getValue());
                            oResource.addAnnotationPropertyValue((AnnotationProperty)object, new Literal(string));
                        }
                        TreePath treePath = OntologyEditor.this.propertyTree.getSelectionPath();
                        OntologyEditor.this.propertyTree.setSelectionRow(0);
                        OntologyEditor.this.propertyTree.setSelectionPath(treePath);
                        return;
                    }
                    if (object4 instanceof PropertyValue && n == 3 && mouseEvent.getClickCount() == 1) {
                        object2 = (PropertyValue)object4;
                        try {
                            if (oResource instanceof RDFProperty && ((PropertyValue)object2).getProperty() instanceof AnnotationProperty) {
                                ((RDFProperty)oResource).removeAnnotationPropertyValue((AnnotationProperty)((PropertyValue)object2).getProperty(), (Literal)((PropertyValue)object2).getValue());
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    TreePath treePath = OntologyEditor.this.propertyTree.getSelectionPath();
                                    OntologyEditor.this.propertyTree.setSelectionRow(0);
                                    OntologyEditor.this.propertyTree.setSelectionPath(treePath);
                                }
                            });
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(MainFrame.getInstance(), "Cannot delete the property value because \n" + exception.getMessage());
                            exception.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    protected void expandNode(JTree jTree) {
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            jTree.expandRow(i);
        }
    }

    private void enableDisableToolBarComponents() {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        for (int i = 0; i < this.selectedNodes.size(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.selectedNodes.get(i);
            OResource oResource = ((OResourceNode)defaultMutableTreeNode.getUserObject()).getResource();
            if (oResource instanceof OClass) {
                bl2 = false;
                bl3 = false;
                continue;
            }
            if (oResource instanceof OInstance) {
                bl = false;
                bl2 = false;
                continue;
            }
            bl3 = false;
            bl = false;
        }
        if (bl) {
            this.topClass.setEnabled(true);
            this.subClass.setEnabled(true);
            this.instance.setEnabled(true);
            this.rdfProperty.setEnabled(true);
            this.annotationProperty.setEnabled(true);
            this.datatypeProperty.setEnabled(true);
            this.objectProperty.setEnabled(true);
            this.symmetricProperty.setEnabled(true);
            this.transitiveProperty.setEnabled(true);
            this.delete.setEnabled(true);
        } else if (bl3) {
            this.topClass.setEnabled(true);
            this.subClass.setEnabled(false);
            this.instance.setEnabled(false);
            this.rdfProperty.setEnabled(true);
            this.annotationProperty.setEnabled(true);
            this.datatypeProperty.setEnabled(false);
            this.objectProperty.setEnabled(false);
            this.symmetricProperty.setEnabled(false);
            this.transitiveProperty.setEnabled(false);
            this.delete.setEnabled(true);
        } else if (bl2) {
            this.topClass.setEnabled(false);
            this.subClass.setEnabled(false);
            this.instance.setEnabled(false);
            this.rdfProperty.setEnabled(true);
            this.annotationProperty.setEnabled(true);
            this.datatypeProperty.setEnabled(true);
            this.objectProperty.setEnabled(true);
            this.symmetricProperty.setEnabled(true);
            this.transitiveProperty.setEnabled(true);
            this.delete.setEnabled(true);
        } else {
            this.topClass.setEnabled(false);
            this.subClass.setEnabled(false);
            this.instance.setEnabled(false);
            this.rdfProperty.setEnabled(true);
            this.annotationProperty.setEnabled(true);
            this.datatypeProperty.setEnabled(false);
            this.objectProperty.setEnabled(false);
            this.symmetricProperty.setEnabled(false);
            this.transitiveProperty.setEnabled(false);
            this.delete.setEnabled(true);
        }
    }

    protected void rebuildModel() {
        this.rootNode.removeAllChildren();
        this.propertyRootNode.removeAllChildren();
        if (this.ontologyClassesURIs == null) {
            this.ontologyClassesURIs = new ArrayList();
        } else {
            this.ontologyClassesURIs.clear();
        }
        this.uri2TreeNodesListMap = new HashMap();
        this.reverseMap = new HashMap();
        ArrayList<OResource> arrayList = new ArrayList<OResource>(this.ontology.getOClasses(true));
        Collections.sort(arrayList, this.itemComparator);
        this.addChidrenRec(this.rootNode, arrayList, this.itemComparator);
        ArrayList<RDFProperty> arrayList2 = new ArrayList<RDFProperty>(this.ontology.getPropertyDefinitions());
        ArrayList<RDFProperty> arrayList3 = new ArrayList<RDFProperty>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            RDFProperty rDFProperty = (RDFProperty)arrayList2.get(i);
            if (rDFProperty instanceof AnnotationProperty) {
                arrayList3.add(rDFProperty);
                continue;
            }
            Set<RDFProperty> set = rDFProperty.getSuperProperties((byte)0);
            if (set != null && !set.isEmpty()) continue;
            arrayList3.add(rDFProperty);
        }
        Collections.sort(arrayList3, this.itemComparator);
        this.addPropertyChidrenRec(this.propertyRootNode, arrayList3, this.itemComparator);
        this.rdfPropertyAction.setResoucesList(this.ontology.getAllResources());
        this.datatypePropertyAction.setOntologyClassesURIs(this.ontologyClassesURIs);
        this.objectPropertyAction.setOntologyClassesURIs(this.ontologyClassesURIs);
        this.symmetricPropertyAction.setOntologyClassesURIs(this.ontologyClassesURIs);
        this.transitivePropertyAction.setOntologyClassesURIs(this.ontologyClassesURIs);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n;
                OntologyEditor.this.treeModel.nodeStructureChanged(OntologyEditor.this.rootNode);
                OntologyEditor.this.tree.setSelectionInterval(0, 0);
                OntologyEditor.this.tree.expandPath(new TreePath(OntologyEditor.this.rootNode));
                for (n = 0; n < OntologyEditor.this.tree.getRowCount(); ++n) {
                    OntologyEditor.this.tree.expandRow(n);
                }
                OntologyEditor.this.propertyTreeModel.nodeStructureChanged(OntologyEditor.this.propertyRootNode);
                OntologyEditor.this.propertyTree.expandPath(new TreePath(OntologyEditor.this.propertyRootNode));
                for (n = 0; n < OntologyEditor.this.propertyTree.getRowCount(); ++n) {
                    OntologyEditor.this.propertyTree.expandRow(n);
                }
            }
        });
    }

    protected void addChidrenRec(DefaultMutableTreeNode defaultMutableTreeNode, List<OResource> list, Comparator comparator) {
        for (OResource oResource : list) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new OResourceNode(oResource));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            ArrayList<DefaultMutableTreeNode> arrayList = this.uri2TreeNodesListMap.get(oResource.getURI().toString());
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.uri2TreeNodesListMap.put(oResource.getURI().toString(), arrayList);
            }
            arrayList.add(defaultMutableTreeNode2);
            this.reverseMap.put(defaultMutableTreeNode2, oResource.getURI());
            if (oResource instanceof OClass) {
                if (!this.ontologyClassesURIs.contains(oResource.getURI().toString())) {
                    this.ontologyClassesURIs.add(oResource.getURI().toString());
                }
                defaultMutableTreeNode2.setAllowsChildren(true);
                OClass oClass = (OClass)oResource;
                ArrayList<OResource> arrayList2 = new ArrayList<OResource>(oClass.getSubClasses((byte)0));
                Collections.sort(arrayList2, comparator);
                this.addChidrenRec(defaultMutableTreeNode2, arrayList2, comparator);
                arrayList2 = new ArrayList<OInstance>(this.ontology.getOInstances(oClass, (byte)0));
                Collections.sort(arrayList2, comparator);
                this.addChidrenRec(defaultMutableTreeNode2, arrayList2, comparator);
                continue;
            }
            if (!(oResource instanceof OInstance)) continue;
            defaultMutableTreeNode2.setAllowsChildren(false);
        }
    }

    protected void addPropertyChidrenRec(DefaultMutableTreeNode defaultMutableTreeNode, List<RDFProperty> list, Comparator comparator) {
        for (RDFProperty rDFProperty : list) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new OResourceNode(rDFProperty));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            ArrayList<DefaultMutableTreeNode> arrayList = this.uri2TreeNodesListMap.get(rDFProperty.getURI().toString());
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.uri2TreeNodesListMap.put(rDFProperty.getURI().toString(), arrayList);
            }
            arrayList.add(defaultMutableTreeNode2);
            this.reverseMap.put(defaultMutableTreeNode2, rDFProperty.getURI());
            if (rDFProperty instanceof AnnotationProperty) {
                defaultMutableTreeNode2.setAllowsChildren(false);
                continue;
            }
            defaultMutableTreeNode2.setAllowsChildren(true);
            ArrayList<RDFProperty> arrayList2 = new ArrayList<RDFProperty>(rDFProperty.getSubProperties((byte)0));
            Collections.sort(arrayList2, comparator);
            this.addPropertyChidrenRec(defaultMutableTreeNode2, arrayList2, comparator);
        }
    }

    public void processGateEvent(GateEvent gateEvent) {
    }

    protected void classIsAdded(OClass oClass) {
        Set<OClass> set = oClass.getSuperClasses((byte)0);
        ArrayList<OResource> arrayList = new ArrayList<OResource>();
        arrayList.add(oClass);
        if (set == null || set.isEmpty()) {
            this.addChidrenRec(this.rootNode, arrayList, this.itemComparator);
            this.treeModel.nodeStructureChanged(this.rootNode);
        } else {
            ArrayList<OClass> arrayList2 = new ArrayList<OClass>(set);
            Collections.sort(arrayList2, this.itemComparator);
            for (OClass oClass2 : arrayList2) {
                ArrayList<DefaultMutableTreeNode> arrayList3 = this.uri2TreeNodesListMap.get(oClass2.getURI().toString());
                if (arrayList3 == null) {
                    this.classIsAdded(oClass2);
                    continue;
                }
                for (int i = 0; i < arrayList3.size(); ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode = arrayList3.get(i);
                    this.addChidrenRec(defaultMutableTreeNode, arrayList, this.itemComparator);
                    this.treeModel.nodeStructureChanged(defaultMutableTreeNode);
                }
            }
        }
    }

    protected void propertyIsAdded(RDFProperty rDFProperty) {
        if (rDFProperty instanceof AnnotationProperty) {
            ArrayList<RDFProperty> arrayList = new ArrayList<RDFProperty>();
            arrayList.add(rDFProperty);
            this.addPropertyChidrenRec(this.propertyRootNode, arrayList, this.itemComparator);
            this.propertyTreeModel.nodeStructureChanged(this.propertyRootNode);
            return;
        }
        Set<RDFProperty> set = rDFProperty.getSuperProperties((byte)0);
        ArrayList<RDFProperty> arrayList = new ArrayList<RDFProperty>();
        arrayList.add(rDFProperty);
        if (set == null || set.isEmpty()) {
            this.addPropertyChidrenRec(this.propertyRootNode, arrayList, this.itemComparator);
            this.propertyTreeModel.nodeStructureChanged(this.propertyRootNode);
        } else {
            ArrayList<RDFProperty> arrayList2 = new ArrayList<RDFProperty>(set);
            Collections.sort(arrayList2, this.itemComparator);
            for (RDFProperty rDFProperty2 : arrayList2) {
                ArrayList<DefaultMutableTreeNode> arrayList3 = this.uri2TreeNodesListMap.get(rDFProperty2.getURI().toString());
                for (int i = 0; i < arrayList3.size(); ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode = arrayList3.get(i);
                    this.addPropertyChidrenRec(defaultMutableTreeNode, arrayList, this.itemComparator);
                    this.propertyTreeModel.nodeStructureChanged(defaultMutableTreeNode);
                }
            }
        }
    }

    protected void instanceIsAdded(OInstance oInstance) {
        ArrayList<OResource> arrayList;
        ArrayList<DefaultMutableTreeNode> arrayList2 = this.uri2TreeNodesListMap.get(oInstance.getURI().toString());
        if (arrayList2 != null) {
            for (int i = 0; i < arrayList2.size(); ++i) {
                arrayList = arrayList2.get(i);
                this.removeFromMap(this.treeModel, (DefaultMutableTreeNode)((Object)arrayList));
            }
        }
        Set<OClass> set = oInstance.getOClasses((byte)0);
        arrayList = new ArrayList<OInstance>();
        arrayList.add(oInstance);
        for (OClass oClass : set) {
            ArrayList<DefaultMutableTreeNode> arrayList3 = this.uri2TreeNodesListMap.get(oClass.getURI().toString());
            for (int i = 0; i < arrayList3.size(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = arrayList3.get(i);
                this.addChidrenRec(defaultMutableTreeNode, arrayList, this.itemComparator);
                this.treeModel.nodeStructureChanged(defaultMutableTreeNode);
            }
        }
    }

    private void removeFromMap(DefaultTreeModel defaultTreeModel, DefaultMutableTreeNode defaultMutableTreeNode) {
        ArrayList<Object> arrayList;
        Object object;
        if (!defaultMutableTreeNode.isLeaf()) {
            object = defaultMutableTreeNode.children();
            arrayList = new ArrayList();
            while (object.hasMoreElements()) {
                arrayList.add(object.nextElement());
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                this.removeFromMap(defaultTreeModel, (DefaultMutableTreeNode)arrayList.get(i));
            }
        }
        object = this.reverseMap.get(defaultMutableTreeNode);
        this.reverseMap.remove(defaultMutableTreeNode);
        arrayList = this.uri2TreeNodesListMap.get(((URI)object).toString());
        arrayList.remove(defaultMutableTreeNode);
        if (arrayList.isEmpty()) {
            this.uri2TreeNodesListMap.remove(((URI)object).toString());
        }
        defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
    }

    protected void subPropertyIsAdded(RDFProperty rDFProperty) {
        ArrayList<DefaultMutableTreeNode> arrayList = this.uri2TreeNodesListMap.get(rDFProperty.getURI().toString());
        Set<RDFProperty> set = rDFProperty.getSubProperties((byte)0);
        ArrayList<RDFProperty> arrayList2 = new ArrayList<RDFProperty>(set);
        Collections.sort(arrayList2, this.itemComparator);
        for (RDFProperty rDFProperty2 : arrayList2) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            int n;
            ArrayList<DefaultMutableTreeNode> arrayList3 = this.uri2TreeNodesListMap.get(rDFProperty2.getURI().toString());
            if (arrayList3 != null) {
                for (n = 0; n < arrayList3.size(); ++n) {
                    defaultMutableTreeNode = arrayList3.get(n);
                    this.removeFromMap(this.propertyTreeModel, defaultMutableTreeNode);
                    this.propertyTreeModel.nodeStructureChanged(defaultMutableTreeNode.getParent());
                }
            }
            if (arrayList3 == null || arrayList == null) continue;
            for (n = 0; n < arrayList.size(); ++n) {
                defaultMutableTreeNode = arrayList.get(n);
                ArrayList<RDFProperty> arrayList4 = new ArrayList<RDFProperty>();
                arrayList4.add(rDFProperty2);
                this.addPropertyChidrenRec(defaultMutableTreeNode, arrayList4, this.itemComparator);
                this.propertyTreeModel.nodeStructureChanged(defaultMutableTreeNode);
            }
        }
    }

    protected void subPropertyIsDeleted(RDFProperty rDFProperty) {
        Cloneable cloneable;
        ArrayList<DefaultMutableTreeNode> arrayList = this.uri2TreeNodesListMap.get(rDFProperty.getURI().toString());
        if (arrayList == null || arrayList.isEmpty()) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            cloneable = arrayList.get(i);
            this.removeFromMap(this.propertyTreeModel, (DefaultMutableTreeNode)cloneable);
            this.propertyTreeModel.nodeStructureChanged(((DefaultMutableTreeNode)cloneable).getParent());
        }
        Set<RDFProperty> set = rDFProperty.getSuperProperties((byte)0);
        cloneable = new ArrayList();
        cloneable.add(rDFProperty);
        if (set != null) {
            ArrayList<RDFProperty> arrayList2 = new ArrayList<RDFProperty>(set);
            Collections.sort(arrayList2, this.itemComparator);
            for (RDFProperty rDFProperty2 : arrayList2) {
                arrayList = this.uri2TreeNodesListMap.get(rDFProperty2.getURI().toString());
                for (int i = 0; i < arrayList.size(); ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode = arrayList.get(i);
                    this.addPropertyChidrenRec(defaultMutableTreeNode, (List<RDFProperty>)((Object)cloneable), this.itemComparator);
                    this.propertyTreeModel.nodeStructureChanged(defaultMutableTreeNode);
                }
            }
        } else {
            this.addPropertyChidrenRec(this.propertyRootNode, (List<RDFProperty>)((Object)cloneable), this.itemComparator);
            this.propertyTreeModel.nodeStructureChanged(this.propertyRootNode);
        }
    }

    protected void subClassIsAdded(OClass oClass) {
        ArrayList<DefaultMutableTreeNode> arrayList = this.uri2TreeNodesListMap.get(oClass.getURI().toString());
        Set<OClass> set = oClass.getSubClasses((byte)0);
        ArrayList<OClass> arrayList2 = new ArrayList<OClass>(set);
        Collections.sort(arrayList2, this.itemComparator);
        for (OClass oClass2 : arrayList2) {
            ArrayList<DefaultMutableTreeNode> arrayList3 = this.uri2TreeNodesListMap.get(oClass2.getURI().toString());
            if (arrayList3 != null) {
                for (int i = 0; i < arrayList3.size(); ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode = arrayList3.get(i);
                    this.removeFromMap(this.treeModel, defaultMutableTreeNode);
                    this.treeModel.nodeStructureChanged(defaultMutableTreeNode.getParent());
                }
            }
            if (arrayList3 == null || arrayList == null) continue;
            ArrayList<OResource> arrayList4 = new ArrayList<OResource>();
            arrayList4.add(oClass2);
            for (int i = 0; i < arrayList.size(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = arrayList.get(i);
                this.addChidrenRec(defaultMutableTreeNode, arrayList4, this.itemComparator);
                this.treeModel.nodeStructureChanged(defaultMutableTreeNode);
            }
        }
    }

    protected void subClassIsDeleted(OClass oClass) {
        Object object;
        Object object2;
        Enumeration<TreeNode> enumeration;
        Object object3;
        Cloneable cloneable;
        ArrayList<DefaultMutableTreeNode> arrayList = this.uri2TreeNodesListMap.get(oClass.getURI().toString());
        if (arrayList == null || arrayList.isEmpty()) {
            return;
        }
        ArrayList<OResource> arrayList2 = new ArrayList<OResource>();
        boolean bl = true;
        for (int i = 0; i < arrayList.size(); ++i) {
            cloneable = arrayList.get(i);
            if (bl) {
                object3 = (OClass)this.ontology.getOResourceFromMap(this.reverseMap.get(cloneable).toString());
                bl = false;
                enumeration = ((DefaultMutableTreeNode)cloneable).children();
                if (enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        object2 = (DefaultMutableTreeNode)enumeration.nextElement();
                        URI uRI = this.reverseMap.get(object2);
                        object = this.ontology.getOResourceFromMap(uRI.toString());
                        if (object == null || !(object instanceof OClass) || ((OClass)object).isSubClassOf((OClass)object3, (byte)0)) continue;
                        arrayList2.add((OClass)object);
                        break;
                    }
                }
            }
            this.removeFromMap(this.treeModel, (DefaultMutableTreeNode)cloneable);
            this.treeModel.nodeStructureChanged(((DefaultMutableTreeNode)cloneable).getParent());
        }
        Set<OClass> set = oClass.getSuperClasses((byte)0);
        cloneable = new ArrayList();
        cloneable.add(oClass);
        if (set != null && !set.isEmpty()) {
            object3 = new ArrayList<OClass>(set);
            Collections.sort(object3, this.itemComparator);
            enumeration = object3.iterator();
            while (enumeration.hasNext()) {
                object2 = (OClass)enumeration.next();
                arrayList = this.uri2TreeNodesListMap.get(object2.getURI().toString());
                for (int i = 0; i < arrayList.size(); ++i) {
                    object = arrayList.get(i);
                    this.addChidrenRec((DefaultMutableTreeNode)object, (List<OResource>)((Object)cloneable), this.itemComparator);
                    this.treeModel.nodeStructureChanged((TreeNode)object);
                }
            }
        } else {
            this.addChidrenRec(this.rootNode, (List<OResource>)((Object)cloneable), this.itemComparator);
            this.treeModel.nodeStructureChanged(this.rootNode);
        }
        if (!arrayList2.isEmpty()) {
            this.addChidrenRec(this.rootNode, arrayList2, this.itemComparator);
            this.treeModel.nodeStructureChanged(this.rootNode);
        }
    }

    @Override
    public void resourcesRemoved(Ontology ontology, final String[] stringArray) {
        Object object;
        if (this.ontology != ontology) {
            return;
        }
        String string = stringArray[stringArray.length - 1];
        DefaultMutableTreeNode defaultMutableTreeNode = this.uri2TreeNodesListMap.get(string).get(0);
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        defaultMutableTreeNode2 = defaultMutableTreeNode.getParent() == null ? ((object = ((OResourceNode)defaultMutableTreeNode.getUserObject()).getResource()) instanceof RDFProperty ? this.propertyRootNode : this.rootNode) : (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        object = defaultMutableTreeNode2;
        SwingUtilities.invokeLater(new Runnable((DefaultMutableTreeNode)object){
            final /* synthetic */ DefaultMutableTreeNode val$parentNode;
            {
                this.val$parentNode = defaultMutableTreeNode;
            }

            public void run() {
                OntologyEditor.this.scroller.getViewport().setView(new JLabel("PLease wait, updating..."));
                OntologyEditor.this.propertyScroller.getViewport().setView(new JLabel("Please wait, updating..."));
                Runnable runnable = new Runnable(){

                    public void run() {
                        OntologyEditor.this.ontologyClassesURIs.removeAll(Arrays.asList(stringArray));
                        for (int i = 0; i < stringArray.length; ++i) {
                            ArrayList<DefaultMutableTreeNode> arrayList = OntologyEditor.this.uri2TreeNodesListMap.get(stringArray[i]);
                            if (arrayList == null) continue;
                            for (int j = 0; j < arrayList.size(); ++j) {
                                DefaultMutableTreeNode defaultMutableTreeNode = arrayList.get(j);
                                DefaultTreeModel defaultTreeModel = ((OResourceNode)defaultMutableTreeNode.getUserObject()).getResource() instanceof RDFProperty ? OntologyEditor.this.propertyTreeModel : OntologyEditor.this.treeModel;
                                OntologyEditor.this.removeFromMap(defaultTreeModel, defaultMutableTreeNode);
                                defaultTreeModel.nodeStructureChanged(defaultMutableTreeNode.getParent());
                            }
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                OntologyEditor.this.scroller.getViewport().setView(OntologyEditor.this.tree);
                                OntologyEditor.this.propertyScroller.getViewport().setView(OntologyEditor.this.propertyTree);
                                OntologyEditor.this.tree.invalidate();
                                OntologyEditor.this.propertyTree.invalidate();
                                if (val$parentNode != OntologyEditor.this.rootNode && val$parentNode != OntologyEditor.this.propertyRootNode) {
                                    if (((OResourceNode)val$parentNode.getUserObject()).getResource() instanceof RDFProperty) {
                                        OntologyEditor.this.propertyTree.setSelectionPath(new TreePath(val$parentNode.getPath()));
                                    } else {
                                        OntologyEditor.this.tree.setSelectionPath(new TreePath(val$parentNode.getPath()));
                                    }
                                } else if (val$parentNode == OntologyEditor.this.rootNode) {
                                    if (OntologyEditor.this.tree.getRowCount() > 0) {
                                        OntologyEditor.this.tree.setSelectionRow(0);
                                    }
                                } else if (OntologyEditor.this.propertyTree.getRowCount() > 0) {
                                    OntologyEditor.this.propertyTree.setSelectionRow(0);
                                }
                            }
                        });
                    }
                };
                runnable.run();
            }
        });
    }

    @Override
    public void resourceAdded(Ontology ontology, OResource oResource) {
        if (this.ontology != ontology) {
            return;
        }
        boolean bl = true;
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            bl = false;
            treePath = this.propertyTree.getSelectionPath();
        }
        if (oResource instanceof OClass) {
            this.classIsAdded((OClass)oResource);
            this.expandNode(this.tree);
        } else if (oResource instanceof RDFProperty) {
            this.propertyIsAdded((RDFProperty)oResource);
            this.expandNode(this.propertyTree);
        } else if (oResource instanceof OInstance) {
            this.instanceIsAdded((OInstance)oResource);
            this.expandNode(this.tree);
        }
        this.rdfPropertyAction.setResoucesList(ontology.getAllResources());
        this.datatypePropertyAction.setOntologyClassesURIs(this.ontologyClassesURIs);
        this.objectPropertyAction.setOntologyClassesURIs(this.ontologyClassesURIs);
        this.symmetricPropertyAction.setOntologyClassesURIs(this.ontologyClassesURIs);
        this.transitivePropertyAction.setOntologyClassesURIs(this.ontologyClassesURIs);
        if (bl) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.uri2TreeNodesListMap.get(oResource.getURI().toString()).get(0);
            this.tree.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
        } else {
            DefaultMutableTreeNode defaultMutableTreeNode = this.uri2TreeNodesListMap.get(oResource.getURI().toString()).get(0);
            this.propertyTree.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
        }
    }

    @Override
    public void ontologyModified(Ontology ontology, OResource oResource, int n) {
        if (this.ontology != ontology) {
            return;
        }
        boolean bl = true;
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            bl = false;
            treePath = this.propertyTree.getSelectionPath();
        }
        switch (n) {
            case 18: {
                this.subPropertyIsAdded((RDFProperty)oResource);
                break;
            }
            case 20: {
                this.subPropertyIsDeleted((RDFProperty)oResource);
                break;
            }
            case 0: {
                this.subClassIsAdded((OClass)oResource);
                break;
            }
            case 2: {
                this.subClassIsDeleted((OClass)oResource);
            }
        }
        switch (n) {
            case 18: 
            case 20: {
                this.expandNode(this.propertyTree);
                break;
            }
            default: {
                this.expandNode(this.tree);
            }
        }
        this.rdfPropertyAction.setResoucesList(ontology.getAllResources());
        this.datatypePropertyAction.setOntologyClassesURIs(this.ontologyClassesURIs);
        this.objectPropertyAction.setOntologyClassesURIs(this.ontologyClassesURIs);
        this.symmetricPropertyAction.setOntologyClassesURIs(this.ontologyClassesURIs);
        this.transitivePropertyAction.setOntologyClassesURIs(this.ontologyClassesURIs);
        if (bl) {
            this.tree.setSelectionPath(treePath);
            DefaultMutableTreeNode defaultMutableTreeNode = this.uri2TreeNodesListMap.get(oResource.getURI().toString()).get(0);
            this.tree.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
        } else {
            this.propertyTree.setSelectionPath(treePath);
            DefaultMutableTreeNode defaultMutableTreeNode = this.uri2TreeNodesListMap.get(oResource.getURI().toString()).get(0);
            this.propertyTree.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
        }
    }

    @Override
    public void ontologyReset(Ontology ontology) {
        if (this.ontology != ontology) {
            return;
        }
        this.rebuildModel();
    }

    public void addTreeNodeSelectionListener(TreeNodeSelectionListener treeNodeSelectionListener) {
        this.listeners.add(treeNodeSelectionListener);
    }

    public void removeTreeNodeSelectionListener(TreeNodeSelectionListener treeNodeSelectionListener) {
        this.listeners.remove(treeNodeSelectionListener);
    }

    private void fireTreeNodeSelectionChanged(ArrayList<DefaultMutableTreeNode> arrayList) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).selectionChanged(arrayList);
        }
    }

    class DnDJTree
    extends JTree
    implements DragGestureListener,
    DropTargetListener,
    DragSourceListener {
        private DragSource dragSource;
        private DragSourceContext dragSourceContext;
        private DefaultMutableTreeNode selectedNode;
        private TreePath selectedTreePath;

        public DnDJTree(TreeModel treeModel) {
            super(treeModel);
            this.dragSource = null;
            this.dragSourceContext = null;
            this.selectedNode = null;
            this.selectedTreePath = null;
            this.dragSource = DragSource.getDefaultDragSource();
            DragGestureRecognizer dragGestureRecognizer = this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
            DropTarget dropTarget = new DropTarget(this, this);
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if (OntologyEditor.this.selectedNodes.isEmpty()) {
                this.selectedNode = null;
                this.selectedTreePath = null;
                return;
            }
            this.selectedNode = OntologyEditor.this.selectedNodes.get(0);
            this.selectedTreePath = new TreePath(this.selectedNode.getPath());
            DefaultMutableTreeNode defaultMutableTreeNode = this.selectedNode;
            if (defaultMutableTreeNode != null) {
                Transferable transferable = (Transferable)defaultMutableTreeNode.getUserObject();
                Cursor cursor = DragSource.DefaultCopyNoDrop;
                int n = dragGestureEvent.getDragAction();
                if (n == 2) {
                    cursor = DragSource.DefaultMoveNoDrop;
                }
                this.dragSource.startDrag(dragGestureEvent, cursor, transferable, this);
            }
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            int n = dropTargetDropEvent.getDropAction();
            dropTargetDropEvent.rejectDrop();
            dropTargetDropEvent.getDropTargetContext().dropComplete(false);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "This feature is being implemented and will be provided soon", "Coming Soon!", 1);
                }
            });
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }
    }
}

