/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.ontology;

import gate.creole.ontology.OClass;
import gate.creole.ontology.OInstance;
import gate.creole.ontology.OResource;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.URI;
import gate.gui.MainFrame;
import gate.gui.ontology.OResourceNode;
import gate.gui.ontology.TreeNodeSelectionListener;
import gate.gui.ontology.Utils;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceAction
extends AbstractAction
implements TreeNodeSelectionListener {
    private static final long serialVersionUID = 3257844402729529651L;
    JTextField nameSpace = new JTextField(20);
    JTextField instanceName = new JTextField(20);
    JPanel labelPanel = new JPanel(new GridLayout(2, 1));
    JPanel textFieldsPanel = new JPanel(new GridLayout(2, 1));
    JPanel panel = new JPanel(new FlowLayout(0));
    Ontology ontology;
    ArrayList<DefaultMutableTreeNode> selectedNodes;

    public InstanceAction(String string, Icon icon) {
        super(string, icon);
        this.panel.add(this.labelPanel);
        this.panel.add(this.textFieldsPanel);
        this.labelPanel.add(new JLabel("Name Space :"));
        this.textFieldsPanel.add(this.nameSpace);
        this.labelPanel.add(new JLabel("Instance Name :"));
        this.textFieldsPanel.add(this.instanceName);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>(this.selectedNodes);
        if (arrayList.size() == 0) {
            JOptionPane.showMessageDialog(MainFrame.getInstance(), "Please select a class for which you want to create a new instance");
            return;
        }
        OResource oResource = ((OResourceNode)arrayList.get(0).getUserObject()).getResource();
        String string = oResource.getURI().getNameSpace();
        if (gate.creole.ontology.owlim.Utils.hasSystemNameSpace(oResource.getURI().toString())) {
            string = this.ontology.getDefaultNameSpace();
        }
        this.nameSpace.setText(string);
        int n = JOptionPane.showOptionDialog(MainFrame.getInstance(), this.panel, "New Instance: ", 2, 3, null, new String[]{"OK", "Cancel"}, "OK");
        if (n == 0) {
            String string2 = this.nameSpace.getText();
            if (!Utils.isValidNameSpace(string2)) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Invalid NameSpace:" + string2 + "\n example: http://gate.ac.uk/example#");
                return;
            }
            if (!Utils.isValidOntologyResourceName(this.instanceName.getText())) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Invalid Instance Name");
                return;
            }
            if (this.ontology.getOResourceFromMap(this.nameSpace.getText() + this.instanceName.getText()) != null) {
                JOptionPane.showMessageDialog(MainFrame.getInstance(), "An instance with name \"" + (this.nameSpace.getText() + this.instanceName.getText()) + "\" already exists");
                return;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                OResource oResource2 = ((OResourceNode)arrayList.get(i).getUserObject()).getResource();
                if (!(oResource2 instanceof OClass)) continue;
                OInstance oInstance = this.ontology.addOInstance(new URI(this.nameSpace.getText() + this.instanceName.getText(), false), (OClass)oResource2);
            }
        }
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public void setOntology(Ontology ontology) {
        this.ontology = ontology;
    }

    @Override
    public void selectionChanged(ArrayList<DefaultMutableTreeNode> arrayList) {
        this.selectedNodes = arrayList;
    }
}

