/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.ontology;

import gate.creole.ontology.OClass;
import gate.creole.ontology.OInstance;
import gate.creole.ontology.OResource;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.RDFProperty;
import gate.gui.MainFrame;
import gate.gui.ontology.OResourceNode;
import gate.gui.ontology.TreeNodeSelectionListener;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteOntologyResourceAction
extends AbstractAction
implements TreeNodeSelectionListener {
    private static final long serialVersionUID = 3257289136439439920L;
    protected Ontology ontology;
    protected ArrayList<DefaultMutableTreeNode> selectedNodes = new ArrayList();

    public DeleteOntologyResourceAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>(this.selectedNodes);
        int n = JOptionPane.showConfirmDialog(MainFrame.getInstance(), "Are you sure?", "Resource deleting action", 0);
        if (n != 0) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = arrayList.get(i);
            OResource oResource = ((OResourceNode)defaultMutableTreeNode.getUserObject()).getResource();
            try {
                if (oResource instanceof OClass) {
                    if (!this.ontology.containsOClass(((OClass)oResource).getURI())) continue;
                    this.ontology.removeOClass((OClass)oResource);
                    continue;
                }
                if (oResource instanceof OInstance) {
                    if (this.ontology.getOInstance(((OInstance)oResource).getURI()) == null) continue;
                    this.ontology.removeOInstance((OInstance)oResource);
                    continue;
                }
                if (!(oResource instanceof RDFProperty) || this.ontology.getOResourceFromMap(((RDFProperty)oResource).getURI().toString()) == null) continue;
                this.ontology.removeProperty((RDFProperty)oResource);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(MainFrame.getInstance(), exception.getMessage() + "\nPlease see tab messages for more information!");
            }
        }
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public void setOntology(Ontology ontology) {
        this.ontology = ontology;
    }

    @Override
    public void selectionChanged(ArrayList<DefaultMutableTreeNode> arrayList) {
        this.selectedNodes = arrayList;
    }
}

