/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.ontology;

import gate.creole.ontology.DataType;
import gate.creole.ontology.OClass;
import gate.creole.ontology.OResource;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.OntologyUtilities;
import gate.creole.ontology.URI;
import gate.gui.ontology.OResourceNode;
import gate.gui.ontology.TreeNodeSelectionListener;
import gate.gui.ontology.Utils;
import gate.gui.ontology.ValuesSelectionAction;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatatypePropertyAction
extends AbstractAction
implements TreeNodeSelectionListener {
    private static final long serialVersionUID = 3257852073457235252L;
    protected JPanel nsPanel;
    protected JPanel propertyPanel;
    protected JPanel panel;
    protected JPanel dtPanel;
    protected JPanel subPropPanel;
    protected JCheckBox subPropertyCB;
    protected JComboBox datatypes;
    protected JTextField nameSpace = new JTextField(20);
    protected JTextField propertyName;
    protected JButton domainB;
    protected ValuesSelectionAction domainAction;
    protected ArrayList<String> ontologyClassesURIs;
    protected ArrayList<DefaultMutableTreeNode> selectedNodes;
    protected Ontology ontology;

    public DatatypePropertyAction(String string, Icon icon) {
        super(string, icon);
        this.nsPanel = new JPanel(new FlowLayout(0));
        this.nsPanel.add(new JLabel("Name Space:"));
        this.nsPanel.add(this.nameSpace);
        this.propertyName = new JTextField(20);
        this.domainB = new JButton("Domain");
        this.domainAction = new ValuesSelectionAction();
        this.datatypes = new JComboBox<String>(new DefaultComboBoxModel<String>(new String[]{"http://www.w3.org/2001/XMLSchema#boolean", "http://www.w3.org/2001/XMLSchema#byte", "http://www.w3.org/2001/XMLSchema#date", "http://www.w3.org/2001/XMLSchema#decimal", "http://www.w3.org/2001/XMLSchema#double", "http://www.w3.org/2001/XMLSchema#duration", "http://www.w3.org/2001/XMLSchema#float", "http://www.w3.org/2001/XMLSchema#int", "http://www.w3.org/2001/XMLSchema#integer", "http://www.w3.org/2001/XMLSchema#long", "http://www.w3.org/2001/XMLSchema#negativeInteger", "http://www.w3.org/2001/XMLSchema#nonNegativeInteger", "http://www.w3.org/2001/XMLSchema#nonPositiveInteger", "http://www.w3.org/2001/XMLSchema#positiveInteger", "http://www.w3.org/2001/XMLSchema#short", "http://www.w3.org/2001/XMLSchema#string", "http://www.w3.org/2001/XMLSchema#time", "http://www.w3.org/2001/XMLSchema#unsignedByte", "http://www.w3.org/2001/XMLSchema#unsignedInt", "http://www.w3.org/2001/XMLSchema#unsignedLong", "http://www.w3.org/2001/XMLSchema#unsignedShort"}));
        this.domainB.addActionListener(new ActionListener(){
            final DatatypePropertyAction this$0;
            {
                this.this$0 = DatatypePropertyAction.this;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray = new String[DatatypePropertyAction.this.ontologyClassesURIs.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = DatatypePropertyAction.this.ontologyClassesURIs.get(i);
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < DatatypePropertyAction.this.selectedNodes.size(); ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode = DatatypePropertyAction.this.selectedNodes.get(i);
                    OResource oResource = ((OResourceNode)defaultMutableTreeNode.getUserObject()).getResource();
                    if (!(oResource instanceof OClass)) continue;
                    arrayList.add(((OClass)oResource).getURI().toString());
                }
                String[] stringArray2 = new String[arrayList.size()];
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray2[i] = (String)arrayList.get(i);
                }
                DatatypePropertyAction.this.domainAction.showGUI("Domain", stringArray, stringArray2, false);
            }
        });
        this.propertyPanel = new JPanel(new FlowLayout(0));
        this.propertyPanel.add(new JLabel("Property Name:"));
        this.propertyPanel.add(this.propertyName);
        this.propertyPanel.add(this.domainB);
        this.dtPanel = new JPanel(new FlowLayout(0));
        this.dtPanel.add(new JLabel("Data Type :"));
        this.dtPanel.add(this.datatypes);
        this.panel = new JPanel(new GridLayout(3, 1));
        ((GridLayout)this.panel.getLayout()).setVgap(0);
        this.panel.add(this.propertyPanel);
        this.panel.add(this.nsPanel);
        this.panel.add(this.dtPanel);
        this.subPropPanel = new JPanel(new FlowLayout(0));
        this.subPropertyCB = new JCheckBox("sub property of the selected nodes?");
        this.subPropPanel.add(this.subPropertyCB);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>(this.selectedNodes);
        this.nameSpace.setText(this.ontology.getDefaultNameSpace());
        int n = JOptionPane.showOptionDialog(null, this.panel, "New Datatype Property", 2, 3, null, new String[]{"OK", "Cancel"}, "OK");
        if (n == 0) {
            OResource oResource;
            String string = this.nameSpace.getText();
            if (!Utils.isValidNameSpace(string)) {
                JOptionPane.showMessageDialog(null, "Invalid NameSpace:" + string + "\n example: http://gate.ac.uk/example#");
                return;
            }
            if (!Utils.isValidOntologyResourceName(this.propertyName.getText())) {
                JOptionPane.showMessageDialog(null, "Invalid Property Name");
                return;
            }
            if (this.ontology.getOResourceFromMap(this.nameSpace.getText() + this.propertyName.getText()) != null) {
                JOptionPane.showMessageDialog(null, "A Resource with name \"" + (this.nameSpace.getText() + this.propertyName.getText()) + "\" already exists");
                return;
            }
            String[] stringArray = this.domainAction.getSelectedValues();
            HashSet<OClass> hashSet = new HashSet<OClass>();
            for (int i = 0; i < stringArray.length; ++i) {
                oResource = (OClass)this.ontology.getOResourceFromMap(stringArray[i]);
                hashSet.add((OClass)oResource);
            }
            DataType dataType = OntologyUtilities.getDataType((String)this.datatypes.getSelectedItem());
            oResource = this.ontology.addDatatypeProperty(new URI(this.nameSpace.getText() + this.propertyName.getText(), false), hashSet, dataType);
        }
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public void setOntology(Ontology ontology) {
        this.ontology = ontology;
    }

    @Override
    public void selectionChanged(ArrayList<DefaultMutableTreeNode> arrayList) {
        this.selectedNodes = arrayList;
    }

    public ArrayList getOntologyClassesURIs() {
        return this.ontologyClassesURIs;
    }

    public void setOntologyClassesURIs(ArrayList<String> arrayList) {
        this.ontologyClassesURIs = arrayList;
    }
}

