/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.ontology;

import gate.creole.ontology.Ontology;
import gate.creole.ontology.URI;
import gate.gui.ontology.TreeNodeSelectionListener;
import gate.gui.ontology.Utils;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationPropertyAction
extends AbstractAction
implements TreeNodeSelectionListener {
    private static final long serialVersionUID = 3546358452780544048L;
    protected JPanel nsPanel;
    protected JPanel propertyPanel;
    protected JPanel propPanel;
    protected JPanel symTransPanel;
    protected JPanel commentPanel;
    protected JPanel panel;
    protected JTextField nameSpace = new JTextField(20);
    protected JTextField propertyName;
    protected ArrayList<DefaultMutableTreeNode> selectedNodes;
    protected Ontology ontology;

    public AnnotationPropertyAction(String string, Icon icon) {
        super(string, icon);
        this.nsPanel = new JPanel(new FlowLayout(0));
        this.nsPanel.add(new JLabel("Name Space:"));
        this.nsPanel.add(this.nameSpace);
        this.propertyName = new JTextField(20);
        this.propertyPanel = new JPanel(new FlowLayout(0));
        this.propertyPanel.add(new JLabel("Property Name:"));
        this.propertyPanel.add(this.propertyName);
        this.panel = new JPanel(new GridLayout(2, 1));
        ((GridLayout)this.panel.getLayout()).setVgap(0);
        this.panel.add(this.propertyPanel);
        this.panel.add(this.nsPanel);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>(this.selectedNodes);
        this.nameSpace.setText(this.ontology.getDefaultNameSpace());
        int n = JOptionPane.showOptionDialog(null, this.panel, "New Annotation Property", 2, 3, null, new String[]{"OK", "Cancel"}, "OK");
        if (n == 0) {
            String string = this.nameSpace.getText();
            if (!Utils.isValidNameSpace(string)) {
                JOptionPane.showMessageDialog(null, "Invalid NameSpace:" + string + "\n example: http://gate.ac.uk/example#");
                return;
            }
            if (!Utils.isValidOntologyResourceName(this.propertyName.getText())) {
                JOptionPane.showMessageDialog(null, "Invalid Annotation Property Name");
                return;
            }
            if (this.ontology.getOResourceFromMap(this.nameSpace.getText() + this.propertyName.getText()) != null) {
                JOptionPane.showMessageDialog(null, "A Resource with name \"" + (this.nameSpace.getText() + this.propertyName.getText()) + "\" already exists");
                return;
            }
            this.ontology.addAnnotationProperty(new URI(this.nameSpace.getText() + this.propertyName.getText(), false));
        }
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public void setOntology(Ontology ontology) {
        this.ontology = ontology;
    }

    @Override
    public void selectionChanged(ArrayList<DefaultMutableTreeNode> arrayList) {
        this.selectedNodes = arrayList;
    }
}

