/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.lexicon;

import com.ontotext.gate.vr.ClassNode;
import com.ontotext.gate.vr.OntoTreeModel;
import gate.Gate;
import gate.LanguageResource;
import gate.creole.AbstractVisualResource;
import gate.creole.ResourceInstantiationException;
import gate.creole.ontology.OClass;
import gate.creole.ontology.OInstance;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.OntologyUtilities;
import gate.gui.MainFrame;
import gate.gui.lexicon.ChooseSynsetPanel;
import gate.lexicon.LexKBSynset;
import gate.lexicon.LexicalKnowledgeBase;
import gate.lexicon.OntoLexLR;
import gate.util.Files;
import gate.util.GateRuntimeException;
import gate.util.Out;
import gate.util.protocols.gate.Handler;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class OntoLexEditorVR
extends AbstractVisualResource
implements ListSelectionListener,
TreeSelectionListener {
    protected JTree ontoEditor = new JTree();
    protected OntoTreeModel ontoModel;
    protected ChooseSynsetPanel synsetEditor;
    protected OntoLexLR ontoLex;
    protected Ontology theOntology;
    protected GridLayout gridLayout1 = new GridLayout(2, 1);
    protected JSplitPane mainBox;
    protected Box leftBox;
    protected Box rightBox;
    protected ChooseSynsetPanel chooseSynsetPanel;
    protected JScrollPane synsetScroller;
    protected LexKBSynset selectedSynset = null;
    protected JButton addMappingButton;
    protected JButton removeMappingButton;

    public OntoLexEditorVR() {
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        LexKBSynset lexKBSynset;
        Object e = ((JList)listSelectionEvent.getSource()).getSelectedValue();
        if (e == null || !(e instanceof LexKBSynset)) {
            this.ontoEditor.setSelectionRow(0);
            this.selectedSynset = null;
            return;
        }
        this.selectedSynset = lexKBSynset = (LexKBSynset)e;
        this.updateOntologySelection();
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath[] treePathArray = treeSelectionEvent.getPaths();
    }

    protected void updateOntologySelection() {
        if (this.selectedSynset == null) {
            this.ontoEditor.setSelectionRow(0);
            return;
        }
        List list = this.ontoLex.getConceptIds(this.selectedSynset.getId());
        if (list == null || list.isEmpty()) {
            this.ontoEditor.setSelectionRow(0);
            return;
        }
        if (this.theOntology == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            OClass oClass = (OClass)this.theOntology.getOResourceByName((String)e);
            TreePath treePath = this.treePath4Class(oClass);
            if (treePath == null) {
                this.ontoEditor.setSelectionRow(0);
                continue;
            }
            if (i == 0) {
                this.ontoEditor.getSelectionModel().setSelectionPath(treePath);
                continue;
            }
            this.ontoEditor.getSelectionModel().addSelectionPath(treePath);
        }
    }

    protected TreePath treePath4Class(OClass oClass) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.ontoModel.getRoot());
        TreePath treePath = null;
        Iterator iterator = ((ClassNode)this.ontoModel.getRoot()).getChildren();
        boolean bl = false;
        while (!bl && iterator.hasNext()) {
            ClassNode classNode = (ClassNode)iterator.next();
            OClass oClass2 = (OClass)classNode.getSource();
            if (!oClass2.getSubClasses((byte)1).contains(oClass)) continue;
            arrayList.add(classNode);
            this.getRemainingPath(classNode, oClass, arrayList);
            bl = true;
        }
        treePath = new TreePath(arrayList.toArray());
        return treePath;
    }

    protected void getRemainingPath(ClassNode classNode, OClass oClass, List list) {
        Iterator iterator = classNode.getChildren();
        while (iterator.hasNext()) {
            ClassNode classNode2 = (ClassNode)iterator.next();
            OClass oClass2 = (OClass)classNode2.getSource();
            if (oClass2.equals(oClass)) {
                list.add(classNode2);
                break;
            }
            if (!oClass2.getSubClasses((byte)1).contains(oClass)) continue;
            list.add(classNode2);
            this.getRemainingPath(classNode2, oClass, list);
        }
    }

    protected void initLocalData() {
    }

    protected void initGuiComponents() {
        this.mainBox = new JSplitPane(1);
        this.leftBox = Box.createVerticalBox();
        this.rightBox = Box.createVerticalBox();
        this.setLayout(this.gridLayout1);
        this.add((Component)this.mainBox, null);
        this.mainBox.add(this.leftBox);
        this.mainBox.add(this.rightBox);
        JScrollPane jScrollPane = new JScrollPane(this.ontoEditor);
        this.rightBox.add((Component)jScrollPane, null);
        this.ontoEditor.setVisible(false);
        this.ontoEditor.addTreeSelectionListener(this);
        this.ontoEditor.getSelectionModel().setSelectionMode(4);
        KnowledgeBaseTreeCellRenderer knowledgeBaseTreeCellRenderer = new KnowledgeBaseTreeCellRenderer();
        this.ontoEditor.setCellRenderer(knowledgeBaseTreeCellRenderer);
        this.synsetScroller = new JScrollPane();
        this.leftBox.add((Component)this.synsetScroller, null);
        this.synsetScroller.setVisible(false);
        this.addMappingButton = new JButton(new AddMappingAction());
        this.addMappingButton.setText("Add Mapping");
        this.removeMappingButton = new JButton(new RemoveMappingAction());
        this.removeMappingButton.setText("Remove Mapping");
        Box box = Box.createHorizontalBox();
        box.add(this.addMappingButton);
        box.add(Box.createHorizontalStrut(20));
        box.add(this.removeMappingButton);
        this.add(box);
    }

    protected void initListeners() {
    }

    public void setTarget(Object object) {
        if (object == null) {
            return;
        }
        if (!(object instanceof OntoLexLR)) {
            throw new GateRuntimeException(this.getClass().getName() + " can only be used to display " + OntoLexLR.class.getName() + "\n" + object.getClass().getName() + " is not a " + OntoLexLR.class.getName() + "!");
        }
        this.ontoLex = (OntoLexLR)object;
        this.updateGUI();
    }

    protected void updateGUI() {
        LexicalKnowledgeBase lexicalKnowledgeBase;
        Ontology ontology = this.loadOntology(this.ontoLex.getOntologyIdentifier());
        ClassNode classNode = ClassNode.createRootNode(ontology, true);
        this.ontoModel = new OntoTreeModel(classNode);
        this.ontoEditor.setModel(this.ontoModel);
        this.ontoEditor.setVisible(true);
        if (this.chooseSynsetPanel != null) {
            this.chooseSynsetPanel.removeSynsetSelectionListener(this);
        }
        if ((lexicalKnowledgeBase = this.loadLexicon(this.ontoLex.getLexKBIdentifier())) == null) {
            return;
        }
        this.chooseSynsetPanel = new ChooseSynsetPanel(lexicalKnowledgeBase, false);
        this.chooseSynsetPanel.addSynsetSelectionListener(this);
        this.selectedSynset = this.chooseSynsetPanel.getSelectedSynset();
        this.synsetScroller.getViewport().add(this.chooseSynsetPanel);
        this.synsetScroller.setVisible(true);
    }

    private Ontology loadOntology(Object object) {
        if (object instanceof URL && ((URL)object).getProtocol().indexOf("gate") >= 0) {
            object = Handler.class.getResource(Files.getResourcePath() + ((URL)object).getPath());
        }
        try {
            this.theOntology = OntologyUtilities.getOntology((URL)object);
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            throw new GateRuntimeException("Cannot load the ontology used in this OntoLex mapping!");
        }
        return this.theOntology;
    }

    private LexicalKnowledgeBase loadLexicon(Object object) {
        LexicalKnowledgeBase lexicalKnowledgeBase = null;
        List<LanguageResource> list = Gate.getCreoleRegister().getPublicLrInstances();
        for (LanguageResource languageResource : list) {
            LexicalKnowledgeBase lexicalKnowledgeBase2;
            if (!(languageResource instanceof LexicalKnowledgeBase) || !(lexicalKnowledgeBase2 = (LexicalKnowledgeBase)languageResource).getLexiconId().equals(object)) continue;
            lexicalKnowledgeBase = lexicalKnowledgeBase2;
            break;
        }
        if (lexicalKnowledgeBase == null) {
            throw new GateRuntimeException("Please load the lexicon first before trying to use/define a mapping for it!");
        }
        return lexicalKnowledgeBase;
    }

    protected class KnowledgeBaseTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (!(object instanceof ClassNode)) {
                return this;
            }
            ClassNode classNode = (ClassNode)object;
            if (classNode.getSource() instanceof OClass) {
                this.setIcon(MainFrame.getIcon("ontology-class"));
            } else if (classNode.getSource() instanceof OInstance) {
                this.setIcon(MainFrame.getIcon("ontology-instance"));
            }
            return this;
        }
    }

    protected class RemoveMappingAction
    extends AbstractAction {
        RemoveMappingAction() {
            super("RemoveMapping");
            this.putValue("ShortDescription", "Remove the selected mapping");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (OntoLexEditorVR.this.selectedSynset == null) {
                Out.prln("Select a synset first");
                return;
            }
            TreePath[] treePathArray = OntoLexEditorVR.this.ontoEditor.getSelectionPaths();
            if (treePathArray == null || treePathArray.length == 0) {
                Out.prln("Select an ontology concept first");
                return;
            }
            for (int i = 0; i < treePathArray.length; ++i) {
                ClassNode classNode = (ClassNode)treePathArray[i].getLastPathComponent();
                if (!(classNode.getSource() instanceof OClass)) continue;
                OntoLexEditorVR.this.ontoLex.remove(((OClass)classNode.getSource()).getName(), OntoLexEditorVR.this.selectedSynset.getId());
                OntoLexEditorVR.this.ontoEditor.getSelectionModel().removeSelectionPath(treePathArray[i]);
            }
            OntoLexEditorVR.this.updateOntologySelection();
        }
    }

    protected class AddMappingAction
    extends AbstractAction {
        AddMappingAction() {
            super("AddMapping");
            this.putValue("ShortDescription", "Add a new mapping");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (OntoLexEditorVR.this.selectedSynset == null) {
                JOptionPane.showMessageDialog(OntoLexEditorVR.this, "Please choose a synset and a corresponding concept first");
                return;
            }
            TreePath[] treePathArray = OntoLexEditorVR.this.ontoEditor.getSelectionPaths();
            if (treePathArray == null || treePathArray.length == 0) {
                JOptionPane.showMessageDialog(OntoLexEditorVR.this, "Please choose a synset and a corresponding concept first");
                return;
            }
            for (int i = 0; i < treePathArray.length; ++i) {
                ClassNode classNode = (ClassNode)treePathArray[i].getLastPathComponent();
                if (!(classNode.getSource() instanceof OClass)) continue;
                OntoLexEditorVR.this.ontoLex.add(((OClass)classNode.getSource()).getName(), OntoLexEditorVR.this.selectedSynset.getId());
            }
            OntoLexEditorVR.this.updateOntologySelection();
        }
    }
}

