/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.lexicon;

import gate.creole.AbstractVisualResource;
import gate.gui.OkCancelDialog;
import gate.gui.lexicon.ChooseSynsetPanel;
import gate.lexicon.LexKBSynset;
import gate.lexicon.LexKBWordSense;
import gate.lexicon.MutableLexKBSynset;
import gate.lexicon.MutableLexicalKnowledgeBase;
import gate.lexicon.MutableWord;
import gate.lexicon.Word;
import gate.util.GateRuntimeException;
import gate.util.Out;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class NLGLexiconVR
extends AbstractVisualResource {
    protected MutableLexicalKnowledgeBase lexKB;
    protected GridLayout gridLayout1 = new GridLayout();
    protected Box mainBox;
    protected Box leftBox;
    protected Box rightBox;
    protected Box buttonBox;
    protected JLabel lemmaTextLabel = new JLabel();
    protected JTextField lemmaTextField = new JTextField(30);
    protected JLabel SynsetTextLabel = new JLabel();
    protected JScrollPane synsetScrollPane = new JScrollPane();
    protected JLabel definitionTextLabel = new JLabel();
    protected JTextArea definitionTextArea = new JTextArea();
    protected JList synsetEntriesList = new JList();
    protected DefaultListModel synsetListModel;
    protected JLabel POSTextLabel = new JLabel();
    protected JTextField posString = new JTextField(30);
    protected JLabel sensesTextLabel = new JLabel();
    protected JScrollPane sensesScrollPane = new JScrollPane();
    protected JList sensesList;
    protected DefaultListModel sensesListModel;
    protected JButton addSenseButton;
    protected Action addSenseAction;
    protected JButton removeSenseButton;
    protected Action removeSenseAction;
    protected JButton lookupButton;
    protected Action lookupLemmaAction;
    protected JButton addWordButton;
    protected Action addWordAction;

    public NLGLexiconVR() {
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
    }

    protected void initLocalData() {
        this.addSenseAction = new AddSenseAction();
        this.lookupLemmaAction = new LookupLemmaAction();
        this.addWordAction = new AddWordAction();
        this.removeSenseAction = new RemoveSenseAction();
    }

    protected void initGuiComponents() {
        this.sensesListModel = new DefaultListModel();
        this.sensesList = new JList(this.sensesListModel);
        this.synsetListModel = new DefaultListModel();
        this.synsetEntriesList = new JList(this.synsetListModel);
        this.mainBox = Box.createHorizontalBox();
        this.leftBox = Box.createVerticalBox();
        this.rightBox = Box.createVerticalBox();
        this.buttonBox = Box.createHorizontalBox();
        this.definitionTextArea.setPreferredSize(new Dimension(69, 50));
        this.definitionTextArea.setToolTipText("");
        this.definitionTextArea.setText("");
        this.definitionTextArea.setWrapStyleWord(true);
        this.definitionTextLabel.setText("Definition");
        this.lemmaTextLabel.setText("Lemma");
        this.setLayout(this.gridLayout1);
        this.setAlignmentX(0.5f);
        this.setDebugGraphicsOptions(0);
        this.lemmaTextField.setText("");
        this.lemmaTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.lemmaTextField.getPreferredSize().height));
        this.SynsetTextLabel.setText("Synset Entries");
        this.synsetEntriesList.setSelectedIndex(-1);
        this.synsetEntriesList.setSelectionMode(0);
        this.POSTextLabel.setText("Part of Speech");
        this.posString.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.posString.getPreferredSize().height));
        this.sensesTextLabel.setText("Senses");
        this.addSenseButton = new JButton(this.addSenseAction);
        this.addSenseButton.setText("Add Sense");
        this.removeSenseButton = new JButton(this.removeSenseAction);
        this.removeSenseButton.setText("Remove Sense");
        this.addWordButton = new JButton(this.addWordAction);
        this.addWordButton.setText("Add Word");
        this.lookupButton = new JButton(this.lookupLemmaAction);
        this.lookupButton.setText("Lookup");
        this.add((Component)this.mainBox, null);
        this.mainBox.add((Component)this.leftBox, null);
        this.leftBox.add((Component)this.lemmaTextLabel, null);
        this.leftBox.add((Component)this.lemmaTextField, null);
        this.buttonBox.add(this.lookupButton);
        this.buttonBox.add(Box.createHorizontalStrut(20));
        this.buttonBox.add(this.addWordButton);
        this.leftBox.add(this.buttonBox);
        this.mainBox.add((Component)this.rightBox, null);
        this.rightBox.add((Component)this.POSTextLabel, null);
        this.rightBox.add((Component)this.posString, null);
        this.rightBox.add((Component)this.SynsetTextLabel, null);
        this.rightBox.add((Component)this.synsetScrollPane, null);
        this.synsetScrollPane.getViewport().add((Component)this.synsetEntriesList, null);
        this.rightBox.add((Component)this.definitionTextLabel, null);
        this.rightBox.add((Component)this.definitionTextArea, null);
        this.leftBox.add((Component)this.sensesTextLabel, null);
        this.leftBox.add((Component)this.sensesScrollPane, null);
        this.sensesScrollPane.getViewport().add((Component)this.sensesList, null);
        Box box = Box.createHorizontalBox();
        box.add((Component)this.addSenseButton, null);
        box.add(Box.createHorizontalStrut(20));
        box.add((Component)this.removeSenseButton, null);
        this.leftBox.add(box);
        this.leftBox.add(Box.createVerticalGlue());
        this.rightBox.add(Box.createVerticalGlue());
        this.mainBox.add(Box.createVerticalGlue());
    }

    protected void initListeners() {
        this.sensesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LexKBWordSense lexKBWordSense = (LexKBWordSense)NLGLexiconVR.this.sensesList.getSelectedValue();
                NLGLexiconVR.this.updateRightGUI(lexKBWordSense);
            }
        });
    }

    public void setTarget(Object object) {
        if (object == null) {
            return;
        }
        if (!(object instanceof MutableLexicalKnowledgeBase)) {
            throw new GateRuntimeException(this.getClass().getName() + " can only be used to display " + MutableLexicalKnowledgeBase.class.getName() + "\n" + object.getClass().getName() + " is not a " + MutableLexicalKnowledgeBase.class.getName() + "!");
        }
        this.lexKB = (MutableLexicalKnowledgeBase)object;
    }

    public void cleanup() {
        super.cleanup();
        this.lexKB = null;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setSize(250, 200);
        jFrame.setLocation(200, 300);
        jFrame.getContentPane().add(new NLGLexiconVR());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    protected void updateLeftGUI(String string) {
        if (this.lexKB == null) {
            return;
        }
        List list = this.lexKB.lookupWord(string);
        this.sensesListModel.clear();
        this.synsetListModel.clear();
        this.definitionTextArea.setText("");
        this.posString.setText("");
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                LexKBWordSense lexKBWordSense = (LexKBWordSense)list.get(i);
                this.sensesListModel.addElement(lexKBWordSense);
                if (list.size() != 1) continue;
                this.updateRightGUI(lexKBWordSense);
            }
        }
    }

    protected void updateRightGUI(LexKBWordSense lexKBWordSense) {
        this.synsetListModel.clear();
        this.posString.setText("");
        if (lexKBWordSense == null || this.lexKB == null) {
            return;
        }
        LexKBSynset lexKBSynset = lexKBWordSense.getSynset();
        this.definitionTextArea.setText(lexKBSynset.getDefinition());
        this.posString.setText(lexKBSynset.getPOS().toString());
        this.posString.setEnabled(false);
        for (int i = 0; i < lexKBSynset.getWordSenses().size(); ++i) {
            LexKBWordSense lexKBWordSense2 = lexKBSynset.getWordSense(i);
            this.synsetListModel.addElement(lexKBWordSense2);
        }
    }

    protected class LookupLemmaAction
    extends AbstractAction {
        LookupLemmaAction() {
            super("LookupLemma");
            this.putValue("ShortDescription", "Lookup a lemma");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = NLGLexiconVR.this.lemmaTextField.getText();
            NLGLexiconVR.this.updateLeftGUI(string);
        }
    }

    protected class AddWordAction
    extends AbstractAction {
        AddWordAction() {
            super("AddWord");
            this.putValue("ShortDescription", "Add a word to the lexicon");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (NLGLexiconVR.this.lexKB == null) {
                return;
            }
            String string = NLGLexiconVR.this.lemmaTextField.getText();
            MutableWord mutableWord = NLGLexiconVR.this.lexKB.addWord(string);
            ChooseSynsetPanel chooseSynsetPanel = new ChooseSynsetPanel(NLGLexiconVR.this.lexKB);
            boolean bl = OkCancelDialog.showDialog(NLGLexiconVR.this, chooseSynsetPanel, "Choose/Add synset for new word sense of: " + mutableWord.getLemma());
            if (!bl) {
                return;
            }
            LexKBSynset lexKBSynset = chooseSynsetPanel.getSelectedSynset();
            if (lexKBSynset == null) {
                return;
            }
            if (!(lexKBSynset instanceof MutableLexKBSynset)) {
                throw new GateRuntimeException("Cannot modify read-only lexicon!");
            }
            mutableWord.addSense((MutableLexKBSynset)lexKBSynset);
            NLGLexiconVR.this.updateLeftGUI(string);
        }
    }

    protected class RemoveSenseAction
    extends AbstractAction {
        RemoveSenseAction() {
            super("RemoveSense");
            this.putValue("ShortDescription", "Remove the selected sense");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (NLGLexiconVR.this.lexKB == null) {
                return;
            }
            LexKBWordSense lexKBWordSense = (LexKBWordSense)NLGLexiconVR.this.sensesList.getSelectedValue();
            Word word = lexKBWordSense.getWord();
            if (!(word instanceof MutableWord)) {
                Out.prln("Cannot edit a read-only word/lexicon");
                return;
            }
            ((MutableWord)word).removeSense(lexKBWordSense);
            NLGLexiconVR.this.updateLeftGUI(NLGLexiconVR.this.lemmaTextField.getText());
        }
    }

    protected class AddSenseAction
    extends AbstractAction {
        AddSenseAction() {
            super("AddSense");
            this.putValue("ShortDescription", "Add a sense");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (NLGLexiconVR.this.lexKB == null) {
                return;
            }
            String string = NLGLexiconVR.this.lemmaTextField.getText();
            List list = NLGLexiconVR.this.lexKB.lookupWord(string);
            if (list == null || list.isEmpty()) {
                JOptionPane.showMessageDialog(NLGLexiconVR.this, "Please add this word to the lexicon first", "Message", 1);
                return;
            }
            Word word = ((LexKBWordSense)list.get(0)).getWord();
            if (!(word instanceof MutableWord)) {
                throw new GateRuntimeException("Cannot modify read-only lexicon!");
            }
            MutableWord mutableWord = (MutableWord)word;
            ChooseSynsetPanel chooseSynsetPanel = new ChooseSynsetPanel(NLGLexiconVR.this.lexKB);
            OkCancelDialog.showDialog(NLGLexiconVR.this, chooseSynsetPanel, "Choose/Add synset for new word sense of: " + word.getLemma());
            LexKBSynset lexKBSynset = chooseSynsetPanel.getSelectedSynset();
            if (!(lexKBSynset instanceof MutableLexKBSynset)) {
                throw new GateRuntimeException("Cannot modify read-only lexicon!");
            }
            mutableWord.addSense((MutableLexKBSynset)lexKBSynset);
            NLGLexiconVR.this.updateLeftGUI(string);
        }
    }
}

