/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.lexicon;

import gate.gui.OkCancelDialog;
import gate.lexicon.LexKBSynset;
import gate.lexicon.LexicalKnowledgeBase;
import gate.lexicon.Lexicon;
import gate.lexicon.MutableLexKBSynset;
import gate.lexicon.MutableLexicalKnowledgeBase;
import gate.lexicon.NLGLexiconImpl;
import gate.util.GateRuntimeException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ChooseSynsetPanel
extends JPanel {
    protected LexicalKnowledgeBase lexKB;
    protected GridLayout gridLayout1 = new GridLayout();
    protected Box mainBox;
    protected Box leftBox;
    protected Box rightBox;
    protected JLabel definitionTextLabel = new JLabel();
    protected JTextArea definitionTextArea = new JTextArea();
    protected JLabel POSTextLabel = new JLabel();
    protected JComboBox posComboBox;
    protected JLabel SynsetTextLabel = new JLabel();
    protected JScrollPane synsetScrollPane = new JScrollPane();
    protected JList synsetList;
    protected DefaultListModel synsetListModel;
    protected JButton addSynsetButton;
    protected Action addSynsetAction;
    protected JButton removeSynsetButton;
    protected Action removeSynsetAction;
    protected boolean isEditable = true;

    public ChooseSynsetPanel(LexicalKnowledgeBase lexicalKnowledgeBase, boolean bl) {
        if (lexicalKnowledgeBase == null) {
            throw new GateRuntimeException("To view/edit synsets please provide a valid lexicon");
        }
        this.isEditable = bl;
        this.lexKB = lexicalKnowledgeBase;
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
    }

    public ChooseSynsetPanel(LexicalKnowledgeBase lexicalKnowledgeBase) {
        if (lexicalKnowledgeBase == null) {
            throw new GateRuntimeException("To view/edit synsets please provide a valid lexicon");
        }
        this.isEditable = true;
        this.lexKB = lexicalKnowledgeBase;
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
    }

    public LexKBSynset getSelectedSynset() {
        return (LexKBSynset)this.synsetList.getSelectedValue();
    }

    public void addSynsetSelectionListener(ListSelectionListener listSelectionListener) {
        if (listSelectionListener != null) {
            this.synsetList.addListSelectionListener(listSelectionListener);
        }
    }

    public void removeSynsetSelectionListener(ListSelectionListener listSelectionListener) {
        if (listSelectionListener != null) {
            this.synsetList.removeListSelectionListener(listSelectionListener);
        }
    }

    protected void initLocalData() {
        this.addSynsetAction = new AddSynsetAction();
        this.removeSynsetAction = new RemoveSynsetAction();
    }

    protected void initGuiComponents() {
        this.SynsetTextLabel.setText("Synset Entries");
        this.synsetListModel = new DefaultListModel();
        this.synsetList = new JList(this.synsetListModel);
        this.synsetList.setSelectionMode(0);
        this.posComboBox = new JComboBox<Object>(Lexicon.POS_TYPES);
        this.posComboBox.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.posComboBox.getPreferredSize().height));
        this.mainBox = Box.createHorizontalBox();
        this.leftBox = Box.createVerticalBox();
        this.rightBox = Box.createVerticalBox();
        this.definitionTextArea.setText("");
        this.definitionTextArea.setWrapStyleWord(true);
        this.definitionTextArea.setEditable(false);
        this.definitionTextLabel.setText("Definition");
        this.setLayout(this.gridLayout1);
        this.setAlignmentX(0.5f);
        this.setDebugGraphicsOptions(0);
        this.POSTextLabel.setText("Part of Speech");
        if (this.isEditable) {
            this.addSynsetButton = new JButton(this.addSynsetAction);
            this.addSynsetButton.setText("Add");
            this.removeSynsetButton = new JButton(this.removeSynsetAction);
            this.removeSynsetButton.setText("Remove");
        }
        this.add((Component)this.mainBox, null);
        this.mainBox.add((Component)this.leftBox, null);
        this.mainBox.add((Component)this.rightBox, null);
        this.leftBox.add((Component)this.POSTextLabel, null);
        this.leftBox.add((Component)this.posComboBox, null);
        this.leftBox.add((Component)this.SynsetTextLabel, null);
        this.leftBox.add((Component)this.synsetScrollPane, null);
        this.synsetScrollPane.getViewport().add((Component)this.synsetList, null);
        this.rightBox.add((Component)this.definitionTextLabel, null);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.definitionTextArea);
        jScrollPane.setPreferredSize(new Dimension(300, 150));
        jScrollPane.setMinimumSize(new Dimension(300, 150));
        this.rightBox.add((Component)jScrollPane, null);
        if (this.isEditable) {
            Box box = Box.createHorizontalBox();
            box.add((Component)this.addSynsetButton, null);
            box.add(Box.createHorizontalStrut(20));
            box.add((Component)this.removeSynsetButton, null);
            this.rightBox.add(box);
        }
        this.mainBox.add(Box.createVerticalGlue());
        this.updateGUI(null);
    }

    protected void initListeners() {
        this.posComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n = itemEvent.getStateChange();
                Object object = itemEvent.getItem();
                if (n == 1) {
                    ChooseSynsetPanel.this.updateGUI(null);
                }
            }
        });
        this.synsetList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LexKBSynset lexKBSynset = (LexKBSynset)ChooseSynsetPanel.this.synsetList.getSelectedValue();
                if (lexKBSynset != null) {
                    ChooseSynsetPanel.this.definitionTextArea.setText(lexKBSynset.getDefinition());
                }
            }
        });
    }

    protected void updateGUI(LexKBSynset lexKBSynset) {
        this.synsetListModel.clear();
        this.definitionTextArea.setText("");
        if (this.posComboBox.getSelectedItem() != null) {
            LexKBSynset lexKBSynset2;
            Iterator iterator = this.lexKB.getSynsets(this.posComboBox.getSelectedItem());
            int n = 0;
            while (iterator.hasNext()) {
                lexKBSynset2 = (LexKBSynset)iterator.next();
                this.synsetListModel.addElement(lexKBSynset2);
                if (!lexKBSynset2.equals(lexKBSynset)) continue;
                n = this.synsetListModel.size() - 1;
            }
            if (this.synsetList.getModel().getSize() == 0) {
                return;
            }
            this.synsetList.setSelectedIndex(n);
            lexKBSynset2 = (LexKBSynset)this.synsetList.getSelectedValue();
            if (lexKBSynset2 != null) {
                this.definitionTextArea.setText(lexKBSynset2.getDefinition());
            }
        }
    }

    protected void showInputDialog(MutableLexKBSynset mutableLexKBSynset) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel("Definition");
        JTextArea jTextArea = new JTextArea();
        jTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setPreferredSize(new Dimension(400, 150));
        jScrollPane.setMinimumSize(new Dimension(300, 150));
        JLabel jLabel2 = new JLabel("Part of speech");
        final JComboBox<Object> jComboBox = new JComboBox<Object>(this.lexKB.getPOSTypes());
        jComboBox.setEditable(true);
        jComboBox.getEditor().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = jComboBox.getEditor().getItem();
                if (!(ChooseSynsetPanel.this.lexKB instanceof MutableLexicalKnowledgeBase)) {
                    return;
                }
                jComboBox.addItem(object);
                jComboBox.setSelectedItem(object);
                ((MutableLexicalKnowledgeBase)ChooseSynsetPanel.this.lexKB).addPOSType(object);
            }
        });
        jPanel.add(jLabel);
        jPanel.add(jScrollPane);
        jPanel.add(jLabel2);
        jPanel.add(jComboBox);
        boolean bl = OkCancelDialog.showDialog(this, jPanel, "Please provide definition and POS of the new synset");
        if (!bl) {
            return;
        }
        mutableLexKBSynset.setDefinition(jTextArea.getText());
        mutableLexKBSynset.setPOS(jComboBox.getSelectedItem());
        if (jComboBox.getModel().getSize() != this.posComboBox.getModel().getSize()) {
            this.posComboBox.removeAllItems();
            Object[] objectArray = this.lexKB.getPOSTypes();
            for (int i = 0; i < objectArray.length; ++i) {
                this.posComboBox.addItem(objectArray[i]);
            }
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setSize(250, 200);
        jFrame.setLocation(200, 300);
        jFrame.getContentPane().add(new ChooseSynsetPanel(new NLGLexiconImpl(), false));
        jFrame.pack();
        jFrame.setVisible(true);
    }

    protected class RemoveSynsetAction
    extends AbstractAction {
        RemoveSynsetAction() {
            super("RemoveSynset");
            this.putValue("ShortDescription", "Removes a synset from the lexicon");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = JOptionPane.showConfirmDialog(ChooseSynsetPanel.this, "Deleting the synset will also delete all word senses it contains. Are you sure?", "Warning", 0);
            if (n == 1) {
                return;
            }
            if (ChooseSynsetPanel.this.lexKB == null || !(ChooseSynsetPanel.this.lexKB instanceof MutableLexicalKnowledgeBase)) {
                return;
            }
            MutableLexicalKnowledgeBase mutableLexicalKnowledgeBase = (MutableLexicalKnowledgeBase)ChooseSynsetPanel.this.lexKB;
            MutableLexKBSynset mutableLexKBSynset = (MutableLexKBSynset)ChooseSynsetPanel.this.synsetList.getSelectedValue();
            mutableLexicalKnowledgeBase.removeSynset(mutableLexKBSynset);
            ChooseSynsetPanel.this.updateGUI(null);
        }
    }

    protected class AddSynsetAction
    extends AbstractAction {
        AddSynsetAction() {
            super("AddSynset");
            this.putValue("ShortDescription", "Add a synset to the lexicon");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ChooseSynsetPanel.this.lexKB == null || !(ChooseSynsetPanel.this.lexKB instanceof MutableLexicalKnowledgeBase)) {
                return;
            }
            MutableLexicalKnowledgeBase mutableLexicalKnowledgeBase = (MutableLexicalKnowledgeBase)ChooseSynsetPanel.this.lexKB;
            MutableLexKBSynset mutableLexKBSynset = mutableLexicalKnowledgeBase.addSynset();
            ChooseSynsetPanel.this.showInputDialog(mutableLexKBSynset);
            if (mutableLexKBSynset.getPOS() != null) {
                ChooseSynsetPanel.this.posComboBox.setSelectedItem(mutableLexKBSynset.getPOS());
                ChooseSynsetPanel.this.updateGUI(mutableLexKBSynset);
            }
        }
    }
}

