/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.jape;

import gate.Resource;
import gate.creole.ANNIEConstants;
import gate.creole.AbstractVisualResource;
import gate.creole.Transducer;
import gate.event.ProgressListener;
import gate.util.GateRuntimeException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;

public class JapeViewer
extends AbstractVisualResource
implements ANNIEConstants,
ProgressListener {
    protected JTextArea textArea;
    protected JScrollPane textScroll;
    protected JToolBar toolbar;
    private boolean editable = false;
    private JButton saveButton;
    private JButton revertButton;
    private URL japeFileURL;
    private String japeFileContents;
    private Transducer transducer;

    public Resource init() {
        this.initGuiComponents();
        this.japeFileContents = new String();
        return this;
    }

    private void initGuiComponents() {
        this.setLayout(new BorderLayout());
        this.textArea = new JTextArea();
        this.textArea.setEditable(this.editable);
        this.textScroll = new JScrollPane(this.textArea, 20, 30);
        this.add((Component)this.textScroll, "Center");
    }

    public void setTarget(Object object) {
        if (!(object instanceof Transducer)) {
            throw new IllegalArgumentException("The GATE jape editor can only be used with a GATE jape transducer!\n" + object.getClass().toString() + " is not a GATE Jape Transducer!");
        }
        this.transducer = (Transducer)object;
        this.japeFileURL = this.transducer.getGrammarURL();
        this.readJAPEFileContents();
        ((Transducer)object).addProgressListener(this);
    }

    private void readJAPEFileContents() {
        try {
            if (this.japeFileURL != null) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(this.japeFileURL.getFile())));
                String string = bufferedReader.readLine();
                this.japeFileContents = "";
                while (string != null) {
                    this.japeFileContents = this.japeFileContents + string + "\n";
                    string = bufferedReader.readLine();
                }
                this.textArea.setEditable(true);
                this.textArea.setText(this.japeFileContents);
                this.textArea.updateUI();
                this.textArea.setEditable(false);
                bufferedReader.close();
            } else {
                this.textArea.setText("The JAPE Transducer Object was loaded from a serialised tranducer and therefore cannot show any text!");
            }
        }
        catch (IOException iOException) {
            throw new GateRuntimeException(iOException);
        }
    }

    public void processFinished() {
        this.readJAPEFileContents();
    }

    public void progressChanged(int n) {
    }
}

