/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.docview;

import gate.Annotation;
import gate.AnnotationSet;
import gate.corpora.DocumentContentImpl;
import gate.event.DocumentEvent;
import gate.gui.docview.AbstractDocumentView;
import gate.util.Err;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextualDocumentView
extends AbstractDocumentView {
    protected JScrollPane scroller;
    protected GateDocumentListener gateDocListener;
    protected Map<Integer, HighlightData> blinkingTagsForAnnotations = new HashMap<Integer, HighlightData>();
    protected Map tagsForHighlights;
    protected List<HighlightData> highlightsToAdd = new LinkedList<HighlightData>();
    protected List<HighlightData> highlightsToRemove = new LinkedList<HighlightData>();
    protected Timer highlightsMinder;
    protected JTextArea textView;
    protected static final int BLINK_DELAY = 400;
    protected static final int HIGHLIGHT_DELAY = 100;

    public TextualDocumentView() {
        this.gateDocListener = new GateDocumentListener();
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.highlightsMinder.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addHighlight(Annotation annotation, AnnotationSet annotationSet, Color color) {
        HighlightData highlightData = new HighlightData(annotation, annotationSet, color);
        TextualDocumentView textualDocumentView = this;
        synchronized (textualDocumentView) {
            this.highlightsToAdd.add(highlightData);
        }
        this.highlightsMinder.restart();
        return highlightData;
    }

    public List addHighlights(Collection<Annotation> collection, AnnotationSet annotationSet, Color color) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Annotation annotation : collection) {
            arrayList.add(this.addHighlight(annotation, annotationSet, color));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHighlight(Object object) {
        TextualDocumentView textualDocumentView = this;
        synchronized (textualDocumentView) {
            this.highlightsToRemove.add((HighlightData)object);
        }
        this.highlightsMinder.restart();
    }

    public void removeHighlights(Collection collection) {
        for (Object e : collection) {
            this.removeHighlight(e);
        }
    }

    public void scrollAnnotationToVisible(Annotation annotation) {
        Rectangle rectangle = this.scroller.getViewport().getViewRect();
        int n = this.textView.viewToModel(rectangle.getLocation());
        Point point = new Point(rectangle.getLocation());
        point.translate(rectangle.width, rectangle.height);
        int n2 = this.textView.viewToModel(point);
        int n3 = annotation.getStartNode().getOffset().intValue();
        int n4 = annotation.getEndNode().getOffset().intValue();
        if (n4 < n || n2 < n3) {
            try {
                this.textView.scrollRectToVisible(this.textView.modelToView(n3));
            }
            catch (BadLocationException badLocationException) {
                throw new GateRuntimeException(badLocationException);
            }
        }
    }

    public void moveHighlight(Object object, int n, int n2) throws BadLocationException {
        this.textView.getHighlighter().changeHighlight(object, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBlinkingHighlight(Annotation annotation) {
        Map<Integer, HighlightData> map = this.blinkingTagsForAnnotations;
        synchronized (map) {
            this.blinkingTagsForAnnotations.put(annotation.getId(), new HighlightData(annotation, null, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBlinkingHighlight(Annotation annotation) {
        Map<Integer, HighlightData> map = this.blinkingTagsForAnnotations;
        synchronized (map) {
            HighlightData highlightData = this.blinkingTagsForAnnotations.remove(annotation.getId());
            if (highlightData != null && highlightData.tag != null) {
                this.textView.getHighlighter().removeHighlight(highlightData.tag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllBlinkingHighlights() {
        Map<Integer, HighlightData> map = this.blinkingTagsForAnnotations;
        synchronized (map) {
            Iterator<Integer> iterator = new ArrayList<Integer>(this.blinkingTagsForAnnotations.keySet()).iterator();
            while (iterator.hasNext()) {
                HighlightData highlightData = this.blinkingTagsForAnnotations.remove(iterator.next());
                Annotation annotation = highlightData.annotation;
                Object object = highlightData.tag;
                if (object == null) continue;
                Highlighter highlighter = this.textView.getHighlighter();
                highlighter.removeHighlight(object);
            }
        }
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public void setTarget(Object object) {
        if (this.document != null) {
            this.document.removeDocumentListener(this.gateDocListener);
        }
        super.setTarget(object);
        this.document.addDocumentListener(this.gateDocListener);
    }

    public void setEditable(boolean bl) {
        this.textView.setEditable(bl);
    }

    @Override
    protected void initGUI() {
        this.textView = new JTextArea();
        this.textView.setAutoscrolls(false);
        this.textView.setLineWrap(true);
        this.textView.setWrapStyleWord(true);
        this.scroller = new JScrollPane(this.textView);
        this.textView.setText(this.document.getContent().toString());
        this.textView.getDocument().addDocumentListener(new SwingDocumentListener());
        this.scroller.getViewport().setViewPosition(new Point(0, 0));
        this.highlightsMinder = new Timer(400, new UpdateHighlightsAction());
        this.highlightsMinder.setInitialDelay(100);
        this.highlightsMinder.setDelay(400);
        this.highlightsMinder.setRepeats(true);
        this.highlightsMinder.setCoalesce(true);
        this.highlightsMinder.start();
        this.initListeners();
    }

    @Override
    public Component getGUI() {
        return this.scroller;
    }

    protected void initListeners() {
        this.textView.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                try {
                    TextualDocumentView.this.scroller.getViewport().setViewPosition(TextualDocumentView.this.textView.modelToView(0).getLocation());
                    TextualDocumentView.this.scroller.paintImmediately(TextualDocumentView.this.textView.getBounds());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    protected void unregisterHooks() {
    }

    @Override
    protected void registerHooks() {
    }

    protected class SwingDocumentListener
    implements DocumentListener {
        protected SwingDocumentListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insertUpdate(javax.swing.event.DocumentEvent documentEvent) {
            try {
                TextualDocumentView.this.gateDocListener.setActive(false);
                TextualDocumentView.this.document.edit(new Long(documentEvent.getOffset()), new Long(documentEvent.getOffset()), new DocumentContentImpl(documentEvent.getDocument().getText(documentEvent.getOffset(), documentEvent.getLength())));
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace(Err.getPrintWriter());
            }
            catch (InvalidOffsetException invalidOffsetException) {
                invalidOffsetException.printStackTrace(Err.getPrintWriter());
            }
            finally {
                TextualDocumentView.this.gateDocListener.setActive(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeUpdate(javax.swing.event.DocumentEvent documentEvent) {
            try {
                TextualDocumentView.this.gateDocListener.setActive(false);
                TextualDocumentView.this.document.edit(new Long(documentEvent.getOffset()), new Long(documentEvent.getOffset() + documentEvent.getLength()), new DocumentContentImpl(""));
            }
            catch (InvalidOffsetException invalidOffsetException) {
                invalidOffsetException.printStackTrace(Err.getPrintWriter());
            }
            finally {
                TextualDocumentView.this.gateDocListener.setActive(true);
            }
        }

        public void changedUpdate(javax.swing.event.DocumentEvent documentEvent) {
        }
    }

    protected class GateDocumentListener
    implements gate.event.DocumentListener {
        private boolean active = true;

        protected GateDocumentListener() {
        }

        public void annotationSetAdded(DocumentEvent documentEvent) {
        }

        public void annotationSetRemoved(DocumentEvent documentEvent) {
        }

        public void contentEdited(DocumentEvent documentEvent) {
            if (this.active) {
                TextualDocumentView.this.textView.setText(TextualDocumentView.this.document.getContent().toString());
            }
        }

        public void setActive(boolean bl) {
            this.active = bl;
        }
    }

    private class HighlightData {
        Annotation annotation;
        AnnotationSet set;
        Color colour;
        Object tag;

        public HighlightData(Annotation annotation, AnnotationSet annotationSet, Color color) {
            this.annotation = annotation;
            this.set = annotationSet;
            this.colour = color;
        }
    }

    protected class UpdateHighlightsAction
    extends AbstractAction {
        protected boolean highlightsShown = false;

        protected UpdateHighlightsAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.updateBlinkingHighlights();
            this.updateNormalHighlights();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateBlinkingHighlights() {
            Map<Integer, HighlightData> map = TextualDocumentView.this.blinkingTagsForAnnotations;
            synchronized (map) {
                if (TextualDocumentView.this.blinkingTagsForAnnotations.isEmpty()) {
                    return;
                }
                Iterator<Integer> iterator = new ArrayList<Integer>(TextualDocumentView.this.blinkingTagsForAnnotations.keySet()).iterator();
                Highlighter highlighter = TextualDocumentView.this.textView.getHighlighter();
                if (this.highlightsShown) {
                    while (iterator.hasNext()) {
                        HighlightData highlightData = TextualDocumentView.this.blinkingTagsForAnnotations.get(iterator.next());
                        Annotation annotation = highlightData.annotation;
                        Object object = highlightData.tag;
                        if (object != null) {
                            highlighter.removeHighlight(object);
                        }
                        highlightData.tag = null;
                    }
                    this.highlightsShown = false;
                } else {
                    while (iterator.hasNext()) {
                        HighlightData highlightData = TextualDocumentView.this.blinkingTagsForAnnotations.get(iterator.next());
                        Annotation annotation = highlightData.annotation;
                        try {
                            Object object;
                            highlightData.tag = object = highlighter.addHighlight(annotation.getStartNode().getOffset().intValue(), annotation.getEndNode().getOffset().intValue(), new DefaultHighlighter.DefaultHighlightPainter(TextualDocumentView.this.textView.getSelectionColor()));
                        }
                        catch (BadLocationException badLocationException) {
                            throw new GateRuntimeException(badLocationException);
                        }
                    }
                    this.highlightsShown = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateNormalHighlights() {
            TextualDocumentView textualDocumentView = TextualDocumentView.this;
            synchronized (textualDocumentView) {
                if (TextualDocumentView.this.highlightsToRemove.size() + TextualDocumentView.this.highlightsToAdd.size() > 0) {
                    HighlightData highlightData;
                    Point point = TextualDocumentView.this.scroller.getViewport().getViewPosition();
                    Highlighter highlighter = TextualDocumentView.this.textView.getHighlighter();
                    TextualDocumentView.this.textView.setVisible(false);
                    TextualDocumentView.this.scroller.getViewport().setView(new JLabel("Updating"));
                    while (TextualDocumentView.this.highlightsToAdd.size() > 0) {
                        highlightData = TextualDocumentView.this.highlightsToAdd.remove(0);
                        try {
                            highlightData.tag = highlighter.addHighlight(highlightData.annotation.getStartNode().getOffset().intValue(), highlightData.annotation.getEndNode().getOffset().intValue(), new DefaultHighlighter.DefaultHighlightPainter(highlightData.colour));
                        }
                        catch (BadLocationException badLocationException) {
                            badLocationException.printStackTrace();
                        }
                    }
                    while (TextualDocumentView.this.highlightsToRemove.size() > 0) {
                        highlightData = TextualDocumentView.this.highlightsToRemove.remove(0);
                        if (highlightData.tag == null) continue;
                        highlighter.removeHighlight(highlightData.tag);
                    }
                    TextualDocumentView.this.scroller.getViewport().setView(TextualDocumentView.this.textView);
                    TextualDocumentView.this.textView.setVisible(true);
                    TextualDocumentView.this.scroller.getViewport().setViewPosition(point);
                }
            }
        }
    }
}

