/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.docview;

import gate.Document;
import gate.Factory;
import gate.Gate;
import gate.Resource;
import gate.creole.AbstractVisualResource;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.gui.ActionsPublisher;
import gate.gui.MainFrame;
import gate.gui.docview.DocumentView;
import gate.util.GateRuntimeException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class DocumentEditor
extends AbstractVisualResource
implements ActionsPublisher {
    protected JSplitPane horizontalSplit;
    protected JSplitPane topSplit;
    protected JSplitPane bottomSplit;
    private SearchDialog searchDialog;
    protected JToolBar topBar;
    protected Document document;
    protected List centralViews;
    protected List verticalViews;
    protected List horizontalViews;
    protected int centralViewIdx = -1;
    protected int rightViewIdx = -1;
    protected int topViewIdx = -1;
    protected int bottomViewIdx = -1;
    protected boolean viewsInited = false;

    public List getActions() {
        Iterator iterator;
        ArrayList arrayList = new ArrayList();
        if (this.getCentralViews() != null) {
            iterator = this.getCentralViews().iterator();
            while (iterator.hasNext()) {
                arrayList.addAll(((DocumentView)iterator.next()).getActions());
            }
        }
        if (this.getHorizontalViews() != null) {
            iterator = this.getHorizontalViews().iterator();
            while (iterator.hasNext()) {
                arrayList.addAll(((DocumentView)iterator.next()).getActions());
            }
        }
        if (this.getVerticalViews() != null) {
            iterator = this.getVerticalViews().iterator();
            while (iterator.hasNext()) {
                arrayList.addAll(((DocumentView)iterator.next()).getActions());
            }
        }
        return arrayList;
    }

    public Resource init() throws ResourceInstantiationException {
        this.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                if (!DocumentEditor.this.viewsInited) {
                    DocumentEditor.this.initViews();
                }
            }

            public void componentShown(ComponentEvent componentEvent) {
                if (!DocumentEditor.this.viewsInited) {
                    DocumentEditor.this.initViews();
                }
            }
        });
        return this;
    }

    public void cleanup() {
        Iterator iterator;
        if (this.centralViews != null) {
            iterator = this.centralViews.iterator();
            while (iterator.hasNext()) {
                ((Resource)iterator.next()).cleanup();
            }
            this.centralViews.clear();
        }
        if (this.horizontalViews != null) {
            iterator = this.horizontalViews.iterator();
            while (iterator.hasNext()) {
                ((Resource)iterator.next()).cleanup();
            }
            this.horizontalViews.clear();
        }
        if (this.verticalViews != null) {
            iterator = this.verticalViews.iterator();
            while (iterator.hasNext()) {
                ((Resource)iterator.next()).cleanup();
            }
            this.verticalViews.clear();
        }
    }

    protected void initViews() {
        this.viewsInited = true;
        this.setLayout(new BorderLayout());
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setStringPainted(true);
        jProgressBar.setMaximumSize(new Dimension(Integer.MAX_VALUE, jProgressBar.getPreferredSize().height));
        this.add((Component)jProgressBar, "Center");
        jProgressBar.setString("Building views");
        jProgressBar.setValue(10);
        this.topSplit = new JSplitPane(0, null, null);
        this.topSplit.setResizeWeight(0.3);
        this.bottomSplit = new JSplitPane(0, this.topSplit, null);
        this.bottomSplit.setResizeWeight(0.7);
        this.horizontalSplit = new JSplitPane(1, this.bottomSplit, null);
        this.horizontalSplit.setResizeWeight(0.7);
        this.topBar = new JToolBar(0);
        this.topBar.setFloatable(false);
        this.add((Component)this.topBar, "North");
        jProgressBar.setValue(40);
        this.centralViews = new ArrayList();
        this.verticalViews = new ArrayList();
        this.horizontalViews = new ArrayList();
        Set<String> set = Gate.getCreoleRegister().getVrTypes();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get(iterator.next());
            try {
                if (!DocumentView.class.isAssignableFrom(resourceData.getResourceClass())) continue;
                arrayList.add(resourceData);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                ResourceData resourceData = (ResourceData)object;
                ResourceData resourceData2 = (ResourceData)object2;
                return resourceData.getName().compareTo(resourceData2.getName());
            }
        });
        for (ResourceData resourceData : arrayList) {
            try {
                DocumentView resourceInstantiationException = (DocumentView)Factory.createResource(resourceData.getClassName());
                resourceInstantiationException.setTarget(this.document);
                resourceInstantiationException.setOwner(this);
                this.addView(resourceInstantiationException, resourceData.getName());
            }
            catch (ResourceInstantiationException resourceInstantiationException) {
                resourceInstantiationException.printStackTrace();
            }
        }
        if (this.centralViews.size() > 0) {
            this.setCentralView(0);
        }
        this.remove(jProgressBar);
        this.add((Component)this.horizontalSplit, "Center");
        this.topBar.addSeparator();
        this.topBar.add(new SearchAction());
        this.validate();
    }

    public List getCentralViews() {
        return this.centralViews == null ? null : Collections.unmodifiableList(this.centralViews);
    }

    public List getHorizontalViews() {
        return this.horizontalViews == null ? null : Collections.unmodifiableList(this.horizontalViews);
    }

    public List getVerticalViews() {
        return this.verticalViews == null ? null : Collections.unmodifiableList(this.verticalViews);
    }

    protected void addView(DocumentView documentView, String string) {
        this.topBar.add(Box.createHorizontalStrut(5));
        switch (documentView.getType()) {
            case 0: {
                this.centralViews.add(documentView);
                this.topBar.add(new ViewButton(documentView, string));
                break;
            }
            case 1: {
                this.verticalViews.add(documentView);
                this.topBar.add(new ViewButton(documentView, string));
                break;
            }
            case 2: {
                this.horizontalViews.add(documentView);
                this.topBar.add(new ViewButton(documentView, string));
                break;
            }
            default: {
                throw new GateRuntimeException(this.getClass().getName() + ": Invalid view type");
            }
        }
    }

    protected DocumentView getTopView() {
        if (this.topViewIdx == -1) {
            return null;
        }
        return (DocumentView)this.horizontalViews.get(this.topViewIdx);
    }

    protected void setTopView(int n) {
        DocumentView documentView = this.getTopView();
        if (documentView != null) {
            documentView.setActive(false);
        }
        this.topViewIdx = n;
        if (this.topViewIdx == -1) {
            this.setTopView(null);
        } else {
            DocumentView documentView2 = (DocumentView)this.horizontalViews.get(this.topViewIdx);
            if (this.bottomViewIdx == this.topViewIdx) {
                this.setBottomView(null);
                this.bottomViewIdx = -1;
            }
            if (!documentView2.isActive()) {
                documentView2.setActive(true);
            }
            this.setTopView(documentView2);
        }
    }

    protected void setTopView(DocumentView documentView) {
        this.topSplit.setTopComponent(documentView == null ? null : documentView.getGUI());
        this.topSplit.resetToPreferredSizes();
        this.updateBar(this.topBar);
        this.validate();
    }

    protected DocumentView getCentralView() {
        if (this.centralViewIdx == -1) {
            return null;
        }
        return (DocumentView)this.centralViews.get(this.centralViewIdx);
    }

    protected void setCentralView(int n) {
        DocumentView documentView = this.getCentralView();
        if (documentView != null) {
            documentView.setActive(false);
        }
        this.centralViewIdx = n;
        if (this.centralViewIdx == -1) {
            this.setCentralView(null);
        } else {
            DocumentView documentView2 = (DocumentView)this.centralViews.get(this.centralViewIdx);
            if (!documentView2.isActive()) {
                documentView2.setActive(true);
            }
            this.setCentralView(documentView2);
        }
    }

    protected void setCentralView(DocumentView documentView) {
        this.topSplit.setBottomComponent(documentView == null ? null : documentView.getGUI());
        this.topSplit.resetToPreferredSizes();
        this.updateBar(this.topBar);
        this.validate();
    }

    protected DocumentView getBottomView() {
        if (this.bottomViewIdx == -1) {
            return null;
        }
        return (DocumentView)this.horizontalViews.get(this.bottomViewIdx);
    }

    protected void setBottomView(int n) {
        DocumentView documentView = this.getBottomView();
        if (documentView != null) {
            documentView.setActive(false);
        }
        this.bottomViewIdx = n;
        if (this.bottomViewIdx == -1) {
            this.setBottomView(null);
        } else {
            DocumentView documentView2 = (DocumentView)this.horizontalViews.get(this.bottomViewIdx);
            if (this.topViewIdx == this.bottomViewIdx) {
                this.setTopView(null);
                this.topViewIdx = -1;
            }
            if (!documentView2.isActive()) {
                documentView2.setActive(true);
            }
            this.setBottomView(documentView2);
        }
    }

    protected void setBottomView(DocumentView documentView) {
        this.bottomSplit.setBottomComponent(documentView == null ? null : documentView.getGUI());
        this.bottomSplit.resetToPreferredSizes();
        this.updateBar(this.topBar);
        this.validate();
    }

    protected DocumentView getRightView() {
        if (this.rightViewIdx == -1) {
            return null;
        }
        return (DocumentView)this.verticalViews.get(this.rightViewIdx);
    }

    protected void setRightView(int n) {
        DocumentView documentView = this.getRightView();
        if (documentView != null) {
            documentView.setActive(false);
        }
        this.rightViewIdx = n;
        if (this.rightViewIdx == -1) {
            this.setRightView(null);
        } else {
            DocumentView documentView2 = (DocumentView)this.verticalViews.get(this.rightViewIdx);
            if (!documentView2.isActive()) {
                documentView2.setActive(true);
            }
            this.setRightView(documentView2);
        }
    }

    protected void setRightView(DocumentView documentView) {
        this.horizontalSplit.setRightComponent(documentView == null ? null : documentView.getGUI());
        this.updateBar(this.topBar);
        this.validate();
    }

    protected void updateSplitLocation(JSplitPane jSplitPane, int n) {
        Component component = jSplitPane.getLeftComponent();
        Component component2 = jSplitPane.getRightComponent();
        if (component == null) {
            jSplitPane.setDividerLocation(0);
            return;
        }
        if (component2 == null) {
            jSplitPane.setDividerLocation(1);
            return;
        }
        Dimension dimension = component.getPreferredSize();
        Dimension dimension2 = component2.getPreferredSize();
        double d = jSplitPane.getOrientation() == 1 ? (double)dimension.width / (double)(dimension.width + dimension2.width) : (double)dimension.height / (double)(dimension.height + dimension2.height);
        jSplitPane.setDividerLocation(d);
    }

    public void setTarget(Object object) {
        this.document = (Document)object;
    }

    protected void updateBar(JToolBar jToolBar) {
        Component[] componentArray = jToolBar.getComponents();
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof ViewButton)) continue;
                ((ViewButton)componentArray[i]).updateSelected();
            }
        }
    }

    protected class ViewButton
    extends JToggleButton {
        DocumentView view;

        public ViewButton(DocumentView documentView, String string) {
            this.setSelected(false);
            this.view = documentView;
            this.setText(string);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ViewButton.this.isSelected()) {
                        switch (ViewButton.this.view.getType()) {
                            case 0: {
                                DocumentEditor.this.setCentralView(DocumentEditor.this.centralViews.indexOf(ViewButton.this.view));
                                break;
                            }
                            case 1: {
                                DocumentEditor.this.setRightView(DocumentEditor.this.verticalViews.indexOf(ViewButton.this.view));
                                break;
                            }
                            case 2: {
                                DocumentEditor.this.setBottomView(DocumentEditor.this.horizontalViews.indexOf(ViewButton.this.view));
                            }
                        }
                    } else {
                        switch (ViewButton.this.view.getType()) {
                            case 0: {
                                DocumentEditor.this.setCentralView(-1);
                                break;
                            }
                            case 1: {
                                DocumentEditor.this.setRightView(-1);
                                break;
                            }
                            case 2: {
                                DocumentEditor.this.setBottomView(-1);
                            }
                        }
                    }
                }
            });
        }

        public void updateSelected() {
            switch (this.view.getType()) {
                case 0: {
                    this.setSelected(DocumentEditor.this.getCentralView() == this.view);
                    break;
                }
                case 1: {
                    this.setSelected(DocumentEditor.this.getRightView() == this.view);
                    break;
                }
                case 2: {
                    this.setSelected(DocumentEditor.this.getBottomView() == this.view);
                }
            }
        }
    }

    protected class SearchDialog
    extends JDialog {
        JTextComponent textPane;
        JTextField patternTextField;
        JCheckBox ignoreCaseChk;
        JCheckBox wholeWordsChk;
        JCheckBox regularExpressionChk;
        Pattern pattern;
        int nextMatchStartsFrom;
        String content;
        Action findFirstAction;
        Action findNextAction;
        Action cancelAction;
        JButton findNextJButton;

        SearchDialog(Frame frame) {
            super(frame, false);
            this.textPane = (JTextComponent)((JScrollPane)DocumentEditor.this.getCentralView().getGUI()).getViewport().getView();
            this.setTitle("Find in \"" + DocumentEditor.this.document.getName() + "\"");
            this.initLocalData();
            this.initGuiComponents();
            this.initListeners();
        }

        SearchDialog(Dialog dialog) {
            super(dialog, false);
            this.textPane = (JTextComponent)((JScrollPane)DocumentEditor.this.getCentralView().getGUI()).getViewport().getView();
            this.setTitle("Find in \"" + DocumentEditor.this.document.getName() + "\"");
            this.initLocalData();
            this.initGuiComponents();
            this.initListeners();
        }

        protected void initLocalData() {
            this.pattern = null;
            this.nextMatchStartsFrom = 0;
            this.content = DocumentEditor.this.document.getContent().toString();
            this.findFirstAction = new AbstractAction("Find first"){
                {
                    this.putValue("ShortDescription", "Finds first match");
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    SearchDialog.this.refresh();
                    if (!SearchDialog.this.validateRE()) {
                        return;
                    }
                    SearchDialog.this.textPane.setCaretPosition(SearchDialog.this.textPane.getCaretPosition());
                    boolean bl = false;
                    int n = -1;
                    int n2 = -1;
                    SearchDialog.this.nextMatchStartsFrom = 0;
                    Matcher matcher = SearchDialog.this.pattern.matcher(SearchDialog.this.content);
                    while (matcher.find(SearchDialog.this.nextMatchStartsFrom) && !bl) {
                        n = matcher.start();
                        n2 = matcher.end();
                        bl = SearchDialog.this.wholeWordsChk.isSelected() ? !(n != 0 && Character.isLetterOrDigit(SearchDialog.this.content.charAt(n - 1)) || n2 != SearchDialog.this.content.length() && Character.isLetterOrDigit(SearchDialog.this.content.charAt(n2))) : true;
                        SearchDialog.this.nextMatchStartsFrom = n + 1;
                    }
                    if (bl) {
                        SearchDialog.this.textPane.setCaretPosition(n);
                        SearchDialog.this.textPane.moveCaretPosition(n2);
                        SearchDialog.this.textPane.requestFocusInWindow();
                        SwingUtilities.getWindowAncestor(SearchDialog.this.textPane).toFront();
                    } else {
                        JOptionPane.showMessageDialog(DocumentEditor.this.searchDialog, "String not found!", "GATE", 1);
                    }
                }
            };
            this.findNextAction = new AbstractAction("Find next"){
                {
                    this.putValue("ShortDescription", "Finds next match");
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    SearchDialog.this.refresh();
                    if (!SearchDialog.this.validateRE()) {
                        return;
                    }
                    SearchDialog.this.textPane.setCaretPosition(SearchDialog.this.textPane.getCaretPosition());
                    boolean bl = false;
                    int n = -1;
                    int n2 = -1;
                    Matcher matcher = SearchDialog.this.pattern.matcher(SearchDialog.this.content);
                    while (matcher.find(SearchDialog.this.nextMatchStartsFrom) && !bl) {
                        n = matcher.start();
                        n2 = matcher.end();
                        bl = SearchDialog.this.wholeWordsChk.isSelected() ? !(n != SearchDialog.this.nextMatchStartsFrom && Character.isLetterOrDigit(SearchDialog.this.content.charAt(n - 1)) || n2 != SearchDialog.this.content.length() && Character.isLetterOrDigit(SearchDialog.this.content.charAt(n2))) : true;
                        SearchDialog.this.nextMatchStartsFrom = n + 1;
                    }
                    if (bl) {
                        SearchDialog.this.textPane.setCaretPosition(n);
                        SearchDialog.this.textPane.moveCaretPosition(n2);
                        SearchDialog.this.textPane.requestFocusInWindow();
                    } else {
                        JOptionPane.showMessageDialog(DocumentEditor.this.searchDialog, "String not found!", "GATE", 1);
                    }
                }
            };
            this.cancelAction = new AbstractAction("Cancel"){
                {
                    this.putValue("ShortDescription", "Cancel");
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    DocumentEditor.this.searchDialog.setVisible(false);
                }
            };
        }

        protected void initGuiComponents() {
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            this.getContentPane().add(Box.createVerticalStrut(5));
            Box box = Box.createHorizontalBox();
            box.add(Box.createHorizontalStrut(5));
            box.add(new JLabel("Find what:"));
            box.add(Box.createHorizontalStrut(5));
            this.patternTextField = new JTextField(20);
            box.add(this.patternTextField);
            box.add(Box.createHorizontalStrut(5));
            box.add(Box.createHorizontalGlue());
            this.getContentPane().add(box);
            this.getContentPane().add(Box.createVerticalStrut(5));
            box = Box.createHorizontalBox();
            box.add(Box.createHorizontalStrut(5));
            this.ignoreCaseChk = new JCheckBox("Ignore case", false);
            box.add(this.ignoreCaseChk);
            box.add(Box.createHorizontalStrut(5));
            this.wholeWordsChk = new JCheckBox("Whole words", false);
            box.add(this.wholeWordsChk);
            box.add(Box.createHorizontalStrut(5));
            this.regularExpressionChk = new JCheckBox("Regular Expression", false);
            box.add(this.regularExpressionChk);
            box.add(Box.createHorizontalStrut(5));
            box.add(Box.createHorizontalGlue());
            this.getContentPane().add(box);
            this.getContentPane().add(Box.createVerticalStrut(5));
            box = Box.createHorizontalBox();
            box.add(Box.createHorizontalGlue());
            box.add(new JButton(this.findFirstAction));
            box.add(Box.createHorizontalStrut(5));
            this.findNextJButton = new JButton(this.findNextAction);
            box.add(this.findNextJButton);
            box.add(Box.createHorizontalStrut(5));
            box.add(new JButton(this.cancelAction));
            box.add(Box.createHorizontalGlue());
            this.getContentPane().add(box);
            this.getContentPane().add(Box.createVerticalStrut(5));
            this.getRootPane().setDefaultButton(this.findNextJButton);
        }

        protected void initListeners() {
            this.addComponentListener(new ComponentAdapter(){

                public void componentHidden(ComponentEvent componentEvent) {
                }

                public void componentMoved(ComponentEvent componentEvent) {
                }

                public void componentResized(ComponentEvent componentEvent) {
                }

                public void componentShown(ComponentEvent componentEvent) {
                    SearchDialog.this.refresh();
                }
            });
            this.patternTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    SearchDialog.this.refresh();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    SearchDialog.this.refresh();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    SearchDialog.this.refresh();
                }
            });
        }

        protected boolean validateRE() {
            String string = this.patternTextField.getText();
            boolean bl = true;
            try {
                this.pattern = this.regularExpressionChk.isSelected() ? (this.ignoreCaseChk.isSelected() ? Pattern.compile(string, 2) : Pattern.compile(string)) : (this.ignoreCaseChk.isSelected() ? Pattern.compile("\\Q" + string + "\\E", 2) : Pattern.compile("\\Q" + string + "\\E"));
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(DocumentEditor.this.searchDialog, "Invalid pattern!\n" + exception.toString(), "GATE", 0);
                bl = false;
            }
            return bl;
        }

        protected void refresh() {
            String string = this.patternTextField.getText();
            if (string != null && string.length() > 0) {
                this.findFirstAction.setEnabled(true);
                this.findNextAction.setEnabled(true);
            } else {
                this.findFirstAction.setEnabled(false);
                this.findNextAction.setEnabled(false);
            }
            if (this.pattern == null) {
                // empty if block
            }
        }
    }

    protected class SearchAction
    extends AbstractAction {
        public SearchAction() {
            super("Search text", MainFrame.getIcon("search"));
            this.putValue("ShortDescription", "Search within the text");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (DocumentEditor.this.searchDialog == null) {
                Window window = SwingUtilities.getWindowAncestor(DocumentEditor.this);
                DocumentEditor.this.searchDialog = window instanceof Dialog ? new SearchDialog((Dialog)window) : new SearchDialog((Frame)window);
                DocumentEditor.this.searchDialog.pack();
                DocumentEditor.this.searchDialog.setLocationRelativeTo(DocumentEditor.this);
                DocumentEditor.this.searchDialog.setResizable(false);
                MainFrame.getGuiRoots().add(DocumentEditor.this.searchDialog);
            }
            if (DocumentEditor.this.searchDialog.isVisible()) {
                DocumentEditor.this.searchDialog.toFront();
                ((DocumentEditor)DocumentEditor.this).searchDialog.patternTextField.selectAll();
            } else {
                DocumentEditor.this.searchDialog.setVisible(true);
                ((DocumentEditor)DocumentEditor.this).searchDialog.patternTextField.selectAll();
            }
        }
    }
}

