/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.docview;

import gate.Annotation;
import gate.AnnotationSet;
import gate.event.AnnotationSetEvent;
import gate.event.AnnotationSetListener;
import gate.event.DocumentEvent;
import gate.event.DocumentListener;
import gate.event.FeatureMapListener;
import gate.gui.MainFrame;
import gate.gui.docview.AbstractDocumentView;
import gate.gui.docview.DocumentView;
import gate.gui.docview.TextualDocumentView;
import gate.swing.ColorGenerator;
import gate.util.OffsetComparator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class CorefEditor
extends AbstractDocumentView
implements ActionListener,
FeatureMapListener,
DocumentListener,
AnnotationSetListener {
    private static final String DEFAULT_ANNOTSET_NAME = "Default";
    private JPanel mainPanel;
    private JPanel topPanel;
    private JPanel subPanel;
    private JToggleButton showAnnotations;
    private JComboBox annotSets;
    private JComboBox annotTypes;
    private DefaultComboBoxModel annotSetsModel;
    private DefaultComboBoxModel annotTypesModel;
    private JTree corefTree;
    private CorefTreeNode rootNode;
    private HashMap corefChains;
    private HashMap corefAnnotationSetNodesMap;
    private HashMap selectionChainsMap;
    private HashMap currentSelections;
    private HashMap colorChainsMap;
    private HashMap currentColors;
    private ColorGenerator colorGenerator;
    private TextualDocumentView textView;
    private JTextArea textPane;
    private HashMap highlightedTags;
    private ArrayList typeSpecificHighlightedTags;
    private TextPaneMouseListener textPaneMouseListener;
    private ArrayList highlightedChainAnnots = new ArrayList();
    private int[] highlightedChainAnnotsOffsets;
    private ArrayList highlightedTypeAnnots = new ArrayList();
    private int[] highlightedTypeAnnotsOffsets;
    private ChainToolTipAction chainToolTipAction;
    private Timer chainToolTipTimer;
    private NewCorefAction newCorefAction;
    private Timer newCorefActionTimer;
    private Annotation annotToConsiderForChain = null;
    private JWindow popupWindow;
    private boolean explicitCall = false;
    private Highlighter highlighter;

    protected void initGUI() {
        Object object;
        Object object2;
        Iterator iterator = this.owner.getCentralViews().iterator();
        while (this.textView == null && iterator.hasNext()) {
            object2 = (DocumentView)iterator.next();
            if (!(object2 instanceof TextualDocumentView)) continue;
            this.textView = (TextualDocumentView)object2;
        }
        this.textPane = (JTextArea)((JScrollPane)this.textView.getGUI()).getViewport().getView();
        this.highlighter = this.textPane.getHighlighter();
        this.chainToolTipAction = new ChainToolTipAction();
        this.chainToolTipTimer = new Timer(500, this.chainToolTipAction);
        this.chainToolTipTimer.setRepeats(false);
        this.newCorefAction = new NewCorefAction();
        this.newCorefActionTimer = new Timer(500, this.newCorefAction);
        this.newCorefActionTimer.setRepeats(false);
        this.colorGenerator = new ColorGenerator();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BorderLayout());
        this.subPanel = new JPanel();
        this.subPanel.setLayout(new FlowLayout(0));
        this.showAnnotations = new JToggleButton("Show");
        this.showAnnotations.addActionListener(this);
        this.annotSets = new JComboBox();
        this.annotSets.addActionListener(this);
        object2 = this.document.getNamedAnnotationSets();
        this.annotSetsModel = new DefaultComboBoxModel();
        if (object2 != null) {
            object = object2.keySet().toArray();
            for (int i = 0; i < ((Object[])object).length; ++i) {
                ((AnnotationSet)object2.get((String)object[i])).addAnnotationSetListener(this);
            }
            this.annotSetsModel = new DefaultComboBoxModel<Object>((E[])object);
        }
        this.document.getAnnotations().addAnnotationSetListener(this);
        this.annotSetsModel.insertElementAt(DEFAULT_ANNOTSET_NAME, 0);
        this.annotSets.setModel(this.annotSetsModel);
        this.annotTypesModel = new DefaultComboBoxModel();
        this.annotTypes = new JComboBox(this.annotTypesModel);
        this.annotTypes.addActionListener(this);
        this.subPanel.add(new JLabel("Sets : "));
        this.subPanel.add(this.annotSets);
        object = new JPanel(new FlowLayout(0));
        ((Container)object).add(new JLabel("Types : "));
        ((Container)object).add(this.annotTypes);
        ((Container)object).add(this.showAnnotations);
        this.initData();
        this.corefTree = new JTree(this.rootNode);
        this.corefTree.putClientProperty("JTree.lineStyle", "None");
        this.corefTree.setRowHeight(this.corefTree.getRowHeight() * 2);
        this.corefTree.setLargeModel(true);
        this.corefTree.setAutoscrolls(true);
        this.corefTree.addMouseListener(new CorefTreeMouseListener());
        this.corefTree.setCellRenderer(new CorefTreeCellRenderer());
        this.mainPanel.add((Component)this.topPanel, "North");
        this.mainPanel.add((Component)new JScrollPane(this.corefTree), "Center");
        this.topPanel.add((Component)this.subPanel, "Center");
        this.topPanel.add((Component)object, "South");
        this.textPaneMouseListener = new TextPaneMouseListener();
        this.annotSets.setSelectedIndex(0);
        this.document.addDocumentListener(this);
        this.document.getFeatures().addFeatureMapListener(this);
    }

    public void reinitAllVariables() {
        if (this.highlightedChainAnnots != null) {
            this.highlightedChainAnnots.clear();
        }
        if (this.highlightedTypeAnnots != null) {
            this.highlightedTypeAnnots.clear();
        }
        if (this.typeSpecificHighlightedTags != null) {
            this.typeSpecificHighlightedTags.clear();
        }
        this.highlightedChainAnnotsOffsets = null;
        this.highlightedTypeAnnotsOffsets = null;
        if (this.highlightedTags != null && this.highlightedTags.values() != null) {
            for (Cloneable cloneable : this.highlightedTags.values()) {
                for (int i = 0; i < ((ArrayList)cloneable).size(); ++i) {
                    this.highlighter.removeHighlight(((ArrayList)cloneable).get(i));
                }
            }
            this.highlightedTags.clear();
        }
        Iterator<Object> iterator = this.corefAnnotationSetNodesMap.keySet().iterator();
        while (iterator.hasNext()) {
            Cloneable cloneable;
            cloneable = (CorefTreeNode)this.corefAnnotationSetNodesMap.get(iterator.next());
            ((DefaultMutableTreeNode)cloneable).removeAllChildren();
            this.colorChainsMap.put(((DefaultMutableTreeNode)cloneable).toString(), new HashMap());
            this.selectionChainsMap.put(((DefaultMutableTreeNode)cloneable).toString(), new HashMap());
            this.corefChains.put(cloneable, new HashMap());
        }
    }

    public void cleanup() {
        this.document.removeDocumentListener(this);
        this.document.getFeatures().removeFeatureMapListener(this);
    }

    public Annotation findOutTheLongestAnnotation(ArrayList arrayList, AnnotationSet annotationSet) {
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            Annotation annotation = annotationSet.get((Integer)arrayList.get(i));
            int n3 = annotation.getStartNode().getOffset().intValue();
            int n4 = annotation.getEndNode().getOffset().intValue();
            if (n4 - n3 <= n) continue;
            n = n4 - n3;
            n2 = i;
        }
        return annotationSet.get((Integer)arrayList.get(n2));
    }

    public void annotationSetRemoved(DocumentEvent documentEvent) {
        String string = documentEvent.getAnnotationSetName();
        string = string == null ? DEFAULT_ANNOTSET_NAME : string;
        String string2 = (String)this.annotSets.getSelectedItem();
        this.corefChains.remove(this.corefAnnotationSetNodesMap.get(string));
        this.corefAnnotationSetNodesMap.remove(string);
        this.annotSetsModel.removeElement(string);
        this.annotSets.setModel(this.annotSetsModel);
        this.colorChainsMap.remove(string);
        this.selectionChainsMap.remove(string);
        if (this.annotSetsModel.getSize() == 0) {
            if (this.popupWindow != null && this.popupWindow.isVisible()) {
                this.popupWindow.setVisible(false);
            }
            this.corefTree.setVisible(false);
        } else if (string2.equals(string)) {
            if (this.popupWindow != null && this.popupWindow.isVisible()) {
                this.popupWindow.setVisible(false);
            }
            if (!this.corefTree.isVisible()) {
                this.corefTree.setVisible(true);
            }
            this.annotSets.setSelectedIndex(0);
        }
    }

    public void annotationSetAdded(DocumentEvent documentEvent) {
        String string = documentEvent.getAnnotationSetName();
        if (string == null) {
            this.document.getAnnotations().addAnnotationSetListener(this);
        } else {
            this.document.getAnnotations(string).addAnnotationSetListener(this);
        }
        string = string == null ? DEFAULT_ANNOTSET_NAME : string;
        String string2 = (String)this.annotSets.getSelectedItem();
        CorefTreeNode corefTreeNode = null;
        corefTreeNode = string.equals(DEFAULT_ANNOTSET_NAME) ? this.createAnnotSetNode(this.document.getAnnotations(), true) : this.createAnnotSetNode(this.document.getAnnotations(string), false);
        this.corefAnnotationSetNodesMap.put(string, corefTreeNode);
        if (string2 != null) {
            this.annotSets.setSelectedItem(string2);
        } else {
            this.annotSets.setSelectedIndex(0);
        }
    }

    public void contentEdited(DocumentEvent documentEvent) {
    }

    public void annotationAdded(AnnotationSetEvent annotationSetEvent) {
    }

    public void annotationRemoved(AnnotationSetEvent annotationSetEvent) {
        Annotation annotation = annotationSetEvent.getAnnotation();
        Integer n = annotation.getId();
        Map map = null;
        Object v = this.document.getFeatures().get("MatchesAnnots");
        if (!(v instanceof Map)) {
            return;
        }
        map = (Map)v;
        if (map == null) {
            return;
        }
        Set set = map.keySet();
        if (set == null) {
            return;
        }
        Iterator iterator = set.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List list = (List)map.get(string);
            if (list == null || list.size() == 0) continue;
            for (int i = 0; i < list.size(); ++i) {
                ArrayList arrayList = (ArrayList)list.get(i);
                if (!arrayList.contains(n)) continue;
                bl = true;
                arrayList.remove(n);
                list.set(i, arrayList);
                break;
            }
            if (!bl) continue;
            map.put(string, list);
            this.explicitCall = true;
            this.document.getFeatures().put("MatchesAnnots", map);
            this.explicitCall = false;
            break;
        }
        if (bl) {
            this.featureMapUpdated();
        }
    }

    public void featureMapUpdated() {
        Object object8;
        Iterator iterator;
        Object object22;
        if (this.explicitCall) {
            return;
        }
        String string = (String)this.annotSets.getSelectedItem();
        String string2 = (String)this.annotTypes.getSelectedItem();
        boolean bl = this.showAnnotations.isSelected();
        Map map = null;
        Object v = this.document.getFeatures().get("MatchesAnnots");
        if (!(v instanceof Map)) {
            this.reinitAllVariables();
            this.explicitCall = false;
            this.annotSets.setSelectedIndex(0);
            return;
        }
        map = (Map)v;
        if (map == null) {
            this.reinitAllVariables();
            this.explicitCall = false;
            this.annotSets.setSelectedIndex(0);
            return;
        }
        Iterator iterator2 = map.keySet().iterator();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        for (int i = 0; i < this.annotSets.getItemCount(); ++i) {
            hashMap.put((String)this.annotSets.getItemAt(i), new Boolean(false));
        }
        while (iterator2.hasNext()) {
            Serializable serializable;
            Serializable serializable2;
            Object object3;
            Object object42;
            Object object5;
            Object object6;
            Object object7;
            String string3 = (String)iterator2.next();
            object22 = (List)map.get(string3);
            String string4 = string3 = string3 == null ? DEFAULT_ANNOTSET_NAME : string3;
            if (object22 == null) continue;
            iterator = this.getAnnotationSet(string3);
            hashMap.put(string3, new Boolean(true));
            object8 = object22.iterator();
            if (this.corefAnnotationSetNodesMap.get(string3) == null) {
                if (string3.equals(DEFAULT_ANNOTSET_NAME)) {
                    this.corefAnnotationSetNodesMap.put(DEFAULT_ANNOTSET_NAME, this.createChain(this.document.getAnnotations(), true));
                    continue;
                }
                this.corefAnnotationSetNodesMap.put(string3, this.createChain(this.document.getAnnotations(string3), false));
                continue;
            }
            HashMap hashMap2 = (HashMap)this.corefChains.get(this.corefAnnotationSetNodesMap.get(string3));
            HashMap<Object, Boolean> hashMap3 = new HashMap<Object, Boolean>();
            if (hashMap2 == null) continue;
            Iterator iterator3 = hashMap2.keySet().iterator();
            while (iterator3.hasNext()) {
                hashMap3.put((CorefTreeNode)iterator3.next(), new Boolean(false));
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (object8.hasNext()) {
                HashMap hashMap4;
                object7 = (ArrayList)object8.next();
                if (object7 == null || ((ArrayList)object7).size() == 0) {
                    arrayList.add(object7);
                    continue;
                }
                object6 = null;
                for (int i = 0; i < ((ArrayList)object7).size(); ++i) {
                    object5 = (Integer)((ArrayList)object7).get(i);
                    object6 = this.findOutTheChainHead(iterator.get((Integer)object5), string3);
                    if (object6 == null) continue;
                    hashMap3.put(object6, new Boolean(true));
                    break;
                }
                if (object6 != null) {
                    object42 = this.findOutTheLongestAnnotation((ArrayList)object7, this.getAnnotationSet(string3));
                    if (this.getString((Annotation)object42).equals(((DefaultMutableTreeNode)object6).toString())) {
                        hashMap2.put(object6, object7);
                        this.corefChains.put(this.corefAnnotationSetNodesMap.get(string3), hashMap2);
                        continue;
                    }
                    if (this.currentColors.containsKey(this.getString((Annotation)object42))) {
                        object5 = this.getString((Annotation)object42);
                        object3 = this.findOutChainNode((String)object5, string3);
                        serializable2 = (ArrayList)hashMap2.get(object3);
                        serializable = (ArrayList)hashMap2.get(object6);
                        ((ArrayList)serializable2).addAll(serializable);
                        hashMap2.remove(object6);
                        hashMap2.put(object3, serializable2);
                        this.corefChains.put(this.corefAnnotationSetNodesMap.get(string3), hashMap2);
                        hashMap3.put(object6, new Boolean(false));
                        hashMap3.put(object3, new Boolean(true));
                        continue;
                    }
                    object5 = ((DefaultMutableTreeNode)object6).toString();
                    object3 = this.getString((Annotation)object42);
                    ((DefaultMutableTreeNode)object6).setUserObject(object3);
                    serializable2 = (Color)this.currentColors.get(object5);
                    this.currentColors.remove(object5);
                    this.currentColors.put(object3, serializable2);
                    this.colorChainsMap.put(object3, this.currentColors);
                    serializable = (Boolean)this.currentSelections.get(object5);
                    this.currentSelections.remove(object5);
                    this.currentSelections.put(object3, serializable);
                    this.selectionChainsMap.put(object3, this.currentSelections);
                    hashMap2.put(object6, object7);
                    this.corefChains.put(this.corefAnnotationSetNodesMap.get(string3), hashMap2);
                    continue;
                }
                object42 = (CorefTreeNode)this.corefAnnotationSetNodesMap.get(string3);
                object5 = this.getAnnotationSet(string3);
                object3 = this.findOutTheLongestAnnotation((ArrayList)object7, this.getAnnotationSet(string3));
                serializable2 = (HashMap)this.selectionChainsMap.get(string3);
                serializable = null;
                if (((HashMap)serializable2).containsKey(this.getString((Annotation)object3))) {
                    serializable = this.findOutChainNode(this.getString((Annotation)object3), string3);
                    hashMap4 = (HashMap)this.corefChains.get(object42);
                    hashMap4.put(serializable, object7);
                    this.corefChains.put(object42, hashMap4);
                    hashMap3.put(serializable, new Boolean(true));
                    continue;
                }
                serializable = new CorefTreeNode(this.getString((Annotation)object3), false, 2);
                ((DefaultMutableTreeNode)object42).add((MutableTreeNode)((Object)serializable));
                this.corefAnnotationSetNodesMap.put(string3, object42);
                hashMap4 = (HashMap)this.corefChains.get(object42);
                hashMap4.put(serializable, object7);
                this.corefChains.put(object42, hashMap4);
                boolean bl2 = false;
                if (string.equals(string3)) {
                    bl2 = true;
                }
                ((HashMap)serializable2).put(((DefaultMutableTreeNode)serializable).toString(), new Boolean(bl2));
                this.selectionChainsMap.put(string3, serializable2);
                float[] fArray = this.colorGenerator.getNextColor().getComponents(null);
                Color color = new Color(fArray[0], fArray[1], fArray[2], 0.5f);
                HashMap hashMap5 = (HashMap)this.colorChainsMap.get(string3);
                hashMap5.put(((DefaultMutableTreeNode)serializable).toString(), color);
                this.colorChainsMap.put(this.annotSets.getSelectedItem(), hashMap5);
            }
            object7 = arrayList.iterator();
            while (object7.hasNext()) {
                this.explicitCall = true;
                object6 = (ArrayList)object7.next();
                object22.remove(object6);
                object42 = string3.equals(DEFAULT_ANNOTSET_NAME) ? null : string3;
                map.put(object42, object22);
                this.explicitCall = false;
            }
            this.explicitCall = true;
            this.document.getFeatures().put("MatchesAnnots", map);
            this.explicitCall = false;
            for (Object object42 : hashMap3.keySet()) {
                if (((Boolean)hashMap3.get(object42)).booleanValue()) continue;
                object5 = (CorefTreeNode)this.corefAnnotationSetNodesMap.get(string3);
                ((DefaultMutableTreeNode)object5).remove((MutableTreeNode)object42);
                this.corefAnnotationSetNodesMap.put(string3, object5);
                object3 = (HashMap)this.corefChains.get(object5);
                ((HashMap)object3).remove(object42);
                this.corefChains.put(object5, object3);
                serializable2 = (HashMap)this.selectionChainsMap.get(string3);
                ((HashMap)serializable2).remove(((DefaultMutableTreeNode)object42).toString());
                this.selectionChainsMap.put(string3, serializable2);
                serializable = (HashMap)this.colorChainsMap.get(string3);
                ((HashMap)serializable).remove(((DefaultMutableTreeNode)object42).toString());
                this.colorChainsMap.put(string3, this.currentColors);
            }
        }
        for (Object object22 : hashMap.keySet()) {
            if (((Boolean)hashMap.get(object22)).booleanValue()) continue;
            iterator = object22;
            object8 = (String)this.annotSets.getSelectedItem();
            this.corefChains.remove(this.corefAnnotationSetNodesMap.get(iterator));
            this.corefAnnotationSetNodesMap.remove(iterator);
            this.annotSetsModel.removeElement(iterator);
            this.annotSets.setModel(this.annotSetsModel);
            this.annotSets.updateUI();
            this.colorChainsMap.remove(iterator);
            this.selectionChainsMap.remove(iterator);
        }
        if (this.annotSetsModel.getSize() == 0) {
            if (this.popupWindow != null && this.popupWindow.isVisible()) {
                this.popupWindow.setVisible(false);
            }
            this.corefTree.setVisible(false);
            object22 = new ArrayList();
            if (this.typeSpecificHighlightedTags != null) {
                ((ArrayList)object22).addAll(this.typeSpecificHighlightedTags);
            }
            if (this.highlightedTags != null) {
                for (Object object8 : this.highlightedTags.values()) {
                    ((ArrayList)object22).addAll(object8);
                }
            }
            for (int i = 0; i < ((ArrayList)object22).size(); ++i) {
                this.highlighter.removeHighlight(((ArrayList)object22).get(i));
            }
            this.highlightedTags = null;
            this.typeSpecificHighlightedTags = null;
            return;
        }
        if (this.popupWindow != null && this.popupWindow.isVisible()) {
            this.popupWindow.setVisible(false);
        }
        object22 = new ArrayList();
        if (this.typeSpecificHighlightedTags != null) {
            ((ArrayList)object22).addAll(this.typeSpecificHighlightedTags);
        }
        if (this.highlightedTags != null) {
            for (Object object8 : this.highlightedTags.values()) {
                ((ArrayList)object22).addAll(object8);
            }
        }
        for (int i = 0; i < ((ArrayList)object22).size(); ++i) {
            this.highlighter.removeHighlight(((ArrayList)object22).get(i));
        }
        this.highlightedTags = null;
        this.typeSpecificHighlightedTags = null;
        if (string != null) {
            this.annotSets.setSelectedItem(string);
            this.currentSelections = (HashMap)this.selectionChainsMap.get(string);
            this.currentColors = (HashMap)this.colorChainsMap.get(string);
            this.highlightAnnotations();
            this.showAnnotations.setSelected(bl);
            if (string2 != null) {
                this.annotTypes.setSelectedItem(string2);
            } else if (this.annotTypes.getModel().getSize() > 0) {
                this.annotTypes.setSelectedIndex(0);
            }
        } else {
            this.explicitCall = false;
            this.annotSets.setSelectedIndex(0);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.annotSets) {
            if (!this.explicitCall) {
                this.annotSetSelectionChanged();
            }
        } else if (actionEvent.getSource() == this.showAnnotations) {
            if (!this.explicitCall) {
                this.showTypeWiseAnnotations();
            }
        } else if (actionEvent.getSource() == this.annotTypes && !this.explicitCall) {
            if (this.typeSpecificHighlightedTags != null) {
                for (int i = 0; i < this.typeSpecificHighlightedTags.size(); ++i) {
                    this.highlighter.removeHighlight(this.typeSpecificHighlightedTags.get(i));
                }
            }
            this.typeSpecificHighlightedTags = null;
            this.showTypeWiseAnnotations();
        }
    }

    private void showTypeWiseAnnotations() {
        Serializable serializable;
        if (this.typeSpecificHighlightedTags == null) {
            this.highlightedTypeAnnots = new ArrayList();
            this.typeSpecificHighlightedTags = new ArrayList();
        }
        if (this.showAnnotations.isSelected()) {
            AnnotationSet annotationSet = this.getAnnotationSet((String)this.annotSets.getSelectedItem());
            String string = (String)this.annotTypes.getSelectedItem();
            if (string == null) {
                try {
                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "No annotation type found to display");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.showAnnotations.setSelected(false);
                return;
            }
            serializable = this.getColor(string);
            if (string != null) {
                AnnotationSet annotationSet2 = annotationSet.get(string);
                for (Annotation annotation : annotationSet2) {
                    this.highlightedTypeAnnots.add(annotation);
                    try {
                        this.typeSpecificHighlightedTags.add(this.highlighter.addHighlight(annotation.getStartNode().getOffset().intValue(), annotation.getEndNode().getOffset().intValue(), new DefaultHighlighter.DefaultHighlightPainter((Color)serializable)));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        } else {
            for (int i = 0; i < this.typeSpecificHighlightedTags.size(); ++i) {
                this.highlighter.removeHighlight(this.typeSpecificHighlightedTags.get(i));
            }
            this.typeSpecificHighlightedTags = new ArrayList();
            this.highlightedTypeAnnots = new ArrayList();
            this.highlightedTypeAnnotsOffsets = null;
        }
        Collections.sort(this.highlightedTypeAnnots, new OffsetComparator());
        this.highlightedTypeAnnotsOffsets = new int[this.highlightedTypeAnnots.size() * 2];
        int n = 0;
        for (int i = 0; i < this.highlightedTypeAnnots.size(); ++i) {
            serializable = (Annotation)this.highlightedTypeAnnots.get(i);
            this.highlightedTypeAnnotsOffsets[n] = serializable.getStartNode().getOffset().intValue();
            this.highlightedTypeAnnotsOffsets[n + 1] = serializable.getEndNode().getOffset().intValue();
            n += 2;
        }
    }

    private AnnotationSet getAnnotationSet(String string) {
        return string.equals(DEFAULT_ANNOTSET_NAME) ? this.document.getAnnotations() : this.document.getAnnotations(string);
    }

    private void annotSetSelectionChanged() {
        CorefTreeNode corefTreeNode;
        if (this.annotSets.getModel().getSize() == 0) {
            if (this.popupWindow != null && this.popupWindow.isVisible()) {
                this.popupWindow.setVisible(false);
            }
            this.corefTree.setVisible(false);
            return;
        }
        String string = (String)this.annotSets.getSelectedItem();
        if (string == null) {
            string = (String)this.annotSets.getItemAt(0);
        }
        AnnotationSet annotationSet = this.getAnnotationSet(string);
        Set<String> set = annotationSet.getAllTypes();
        this.annotTypesModel = new DefaultComboBoxModel();
        if (set != null) {
            this.annotTypesModel = new DefaultComboBoxModel<Object>(set.toArray());
        }
        this.annotTypes.setModel(this.annotTypesModel);
        this.annotTypes.updateUI();
        if (this.rootNode.getChildCount() > 0) {
            this.rootNode.removeAllChildren();
        }
        if ((corefTreeNode = (CorefTreeNode)this.corefAnnotationSetNodesMap.get(string)) != null) {
            this.rootNode.add(corefTreeNode);
            this.currentSelections = (HashMap)this.selectionChainsMap.get(string);
            this.currentColors = (HashMap)this.colorChainsMap.get(string);
            if (!this.corefTree.isVisible()) {
                if (this.popupWindow != null && this.popupWindow.isVisible()) {
                    this.popupWindow.setVisible(false);
                }
                this.corefTree.setVisible(true);
            }
            this.corefTree.repaint();
            this.corefTree.updateUI();
        } else {
            this.corefTree.setVisible(false);
        }
    }

    private void initData() {
        Map map;
        this.rootNode = new CorefTreeNode("Co-reference Data", true, 0);
        this.corefChains = new HashMap();
        this.selectionChainsMap = new HashMap();
        this.currentSelections = new HashMap();
        this.colorChainsMap = new HashMap();
        this.currentColors = new HashMap();
        this.corefAnnotationSetNodesMap = new HashMap();
        CorefTreeNode corefTreeNode = this.createChain(this.document.getAnnotations(), true);
        if (corefTreeNode != null) {
            this.corefAnnotationSetNodesMap.put(DEFAULT_ANNOTSET_NAME, corefTreeNode);
        }
        if ((map = this.document.getNamedAnnotationSets()) != null) {
            for (String string : map.keySet()) {
                corefTreeNode = this.createChain(this.document.getAnnotations(string), false);
                if (corefTreeNode == null) continue;
                this.corefAnnotationSetNodesMap.put(string, corefTreeNode);
            }
        }
    }

    private CorefTreeNode createAnnotSetNode(AnnotationSet annotationSet, boolean bl) {
        String string = bl ? DEFAULT_ANNOTSET_NAME : annotationSet.getName();
        CorefTreeNode corefTreeNode = new CorefTreeNode(string, true, 1);
        boolean bl2 = false;
        for (int i = 0; i < this.annotSets.getModel().getSize(); ++i) {
            if (!((String)this.annotSets.getModel().getElementAt(i)).equals(string)) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            this.explicitCall = true;
            this.annotSets.addItem(string);
            this.explicitCall = false;
        }
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        this.corefChains.put(corefTreeNode, hashMap);
        this.selectionChainsMap.put(string, hashMap2);
        this.colorChainsMap.put(string, hashMap3);
        return corefTreeNode;
    }

    private CorefTreeNode createChain(AnnotationSet annotationSet, boolean bl) {
        String string = bl ? DEFAULT_ANNOTSET_NAME : annotationSet.getName();
        CorefTreeNode corefTreeNode = new CorefTreeNode(string, true, 1);
        boolean bl2 = false;
        for (int i = 0; i < this.annotSets.getModel().getSize(); ++i) {
            if (!((String)this.annotSets.getModel().getElementAt(i)).equals(string)) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            this.explicitCall = true;
            this.annotSets.addItem(string);
            this.explicitCall = false;
        }
        HashMap hashMap = new HashMap();
        HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
        HashMap<String, Color> hashMap3 = new HashMap<String, Color>();
        Map map = null;
        Object v = this.document.getFeatures().get("MatchesAnnots");
        if (v instanceof Map) {
            map = (Map)v;
        }
        if (map == null) {
            this.corefChains.put(corefTreeNode, hashMap);
            this.selectionChainsMap.put(string, hashMap2);
            this.colorChainsMap.put(string, hashMap3);
            return corefTreeNode;
        }
        Iterator iterator = map.keySet().iterator();
        List list = (List)map.get(bl ? null : string);
        if (list == null) {
            this.corefChains.put(corefTreeNode, hashMap);
            this.selectionChainsMap.put(string, hashMap2);
            this.colorChainsMap.put(string, hashMap3);
            return corefTreeNode;
        }
        for (ArrayList arrayList : list) {
            boolean bl3 = false;
            boolean bl4 = false;
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            if (arrayList.size() <= 0 || annotationSet.size() <= 0) continue;
            String string2 = this.getString(this.findOutTheLongestAnnotation(arrayList, annotationSet));
            CorefTreeNode corefTreeNode2 = new CorefTreeNode(string2, false, 2);
            corefTreeNode.add(corefTreeNode2);
            hashMap.put(corefTreeNode2, arrayList);
            hashMap2.put(corefTreeNode2.toString(), new Boolean(false));
            float[] fArray = this.colorGenerator.getNextColor().getComponents(null);
            Color color = new Color(fArray[0], fArray[1], fArray[2], 0.5f);
            hashMap3.put(corefTreeNode2.toString(), color);
        }
        this.corefChains.put(corefTreeNode, hashMap);
        this.selectionChainsMap.put(string, hashMap2);
        this.colorChainsMap.put(string, hashMap3);
        return corefTreeNode;
    }

    public String getString(Annotation annotation) {
        return this.document.getContent().toString().substring(annotation.getStartNode().getOffset().intValue(), annotation.getEndNode().getOffset().intValue());
    }

    public void removeChainReference(Annotation annotation, CorefTreeNode corefTreeNode) {
        int n;
        CorefTreeNode corefTreeNode2 = corefTreeNode;
        ArrayList arrayList = (ArrayList)((HashMap)this.corefChains.get(this.corefAnnotationSetNodesMap.get(this.annotSets.getSelectedItem()))).get(corefTreeNode);
        String string = (String)this.annotSets.getSelectedItem();
        string = string.equals(DEFAULT_ANNOTSET_NAME) ? null : string;
        HashMap hashMap = null;
        ArrayList<ArrayList> arrayList2 = null;
        Object v = this.document.getFeatures().get("MatchesAnnots");
        if (v instanceof Map) {
            hashMap = (HashMap)v;
            arrayList2 = (ArrayList<ArrayList>)hashMap.get(string);
        } else {
            hashMap = new HashMap();
        }
        if (arrayList2 == null) {
            arrayList2 = new ArrayList<ArrayList>();
        }
        if ((n = arrayList2.indexOf(arrayList)) != -1) {
            arrayList.remove(annotation.getId());
            Annotation annotation2 = this.findOutTheLongestAnnotation(arrayList, this.getAnnotationSet((String)this.annotSets.getSelectedItem()));
            arrayList2.set(n, arrayList);
            hashMap.put(string, arrayList2);
            this.document.getFeatures().put("MatchesAnnots", hashMap);
        }
    }

    private CorefTreeNode findOutTheChainHead(Annotation annotation, String string) {
        HashMap hashMap = (HashMap)this.corefChains.get(this.corefAnnotationSetNodesMap.get(string));
        if (hashMap == null) {
            return null;
        }
        for (CorefTreeNode corefTreeNode : hashMap.keySet()) {
            if (!((ArrayList)hashMap.get(corefTreeNode)).contains(annotation.getId())) continue;
            return corefTreeNode;
        }
        return null;
    }

    public void highlightAnnotations() {
        Serializable serializable;
        if (this.highlightedTags == null) {
            this.highlightedTags = new HashMap();
            this.highlightedChainAnnots = new ArrayList();
        }
        AnnotationSet annotationSet = this.getAnnotationSet((String)this.annotSets.getSelectedItem());
        CorefTreeNode corefTreeNode = (CorefTreeNode)this.corefAnnotationSetNodesMap.get(this.annotSets.getSelectedItem());
        if (corefTreeNode == null) {
            return;
        }
        HashMap hashMap = (HashMap)this.corefChains.get(corefTreeNode);
        for (CorefTreeNode corefTreeNode2 : hashMap.keySet()) {
            Annotation annotation;
            int n;
            ArrayList arrayList;
            if (((Boolean)this.currentSelections.get(corefTreeNode2.toString())).booleanValue()) {
                if (this.highlightedTags.containsKey(corefTreeNode2)) continue;
                arrayList = (ArrayList)hashMap.get(corefTreeNode2);
                serializable = new ArrayList();
                if (arrayList == null) continue;
                for (n = 0; n < arrayList.size(); ++n) {
                    annotation = annotationSet.get((Integer)arrayList.get(n));
                    this.highlightedChainAnnots.add(annotation);
                    Color color = (Color)this.currentColors.get(corefTreeNode2.toString());
                    try {
                        ((ArrayList)serializable).add(this.highlighter.addHighlight(annotation.getStartNode().getOffset().intValue(), annotation.getEndNode().getOffset().intValue(), new DefaultHighlighter.DefaultHighlightPainter(color)));
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                this.highlightedTags.put(corefTreeNode2, serializable);
                continue;
            }
            if (!this.highlightedTags.containsKey(corefTreeNode2)) continue;
            arrayList = (ArrayList)this.highlightedTags.get(corefTreeNode2);
            for (int i = 0; i < arrayList.size(); ++i) {
                this.highlighter.removeHighlight(arrayList.get(i));
            }
            this.highlightedTags.remove(corefTreeNode2);
            serializable = (ArrayList)hashMap.get(corefTreeNode2);
            if (serializable == null) continue;
            for (n = 0; n < ((ArrayList)serializable).size(); ++n) {
                annotation = annotationSet.get((Integer)((ArrayList)serializable).get(n));
                this.highlightedChainAnnots.remove(annotation);
            }
        }
        Collections.sort(this.highlightedChainAnnots, new OffsetComparator());
        this.highlightedChainAnnotsOffsets = new int[this.highlightedChainAnnots.size() * 2];
        int n = 0;
        for (int i = 0; i < this.highlightedChainAnnots.size(); ++i) {
            serializable = (Annotation)this.highlightedChainAnnots.get(i);
            this.highlightedChainAnnotsOffsets[n] = serializable.getStartNode().getOffset().intValue();
            this.highlightedChainAnnotsOffsets[n + 1] = serializable.getEndNode().getOffset().intValue();
            n += 2;
        }
    }

    protected void registerHooks() {
        this.textPane.addMouseListener(this.textPaneMouseListener);
        this.textPane.addMouseMotionListener(this.textPaneMouseListener);
    }

    protected void unregisterHooks() {
        this.textPane.removeMouseListener(this.textPaneMouseListener);
        this.textPane.removeMouseMotionListener(this.textPaneMouseListener);
    }

    public Component getGUI() {
        return this.mainPanel;
    }

    public int getType() {
        return 1;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.popupWindow != null && this.popupWindow.isVisible()) {
            this.popupWindow.setVisible(false);
        }
    }

    public CorefTreeNode findOutChainNode(String string, String string2) {
        if (this.corefChains == null || this.corefAnnotationSetNodesMap == null) {
            return null;
        }
        HashMap hashMap = (HashMap)this.corefChains.get(this.corefAnnotationSetNodesMap.get(string2));
        if (hashMap == null) {
            return null;
        }
        for (CorefTreeNode corefTreeNode : hashMap.keySet()) {
            if (!corefTreeNode.toString().equals(string)) continue;
            return corefTreeNode;
        }
        return null;
    }

    private Color getColor(String string) {
        Color color;
        Preferences preferences = null;
        try {
            preferences = Preferences.userNodeForPackage(Class.forName("gate.gui.docview.AnnotationSetsView"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n = preferences.getInt(string, -1);
        if (n == -1) {
            float[] fArray = this.colorGenerator.getNextColor().getComponents(null);
            color = new Color(fArray[0], fArray[1], fArray[2], 0.5f);
            int n2 = color.getRGB();
            int n3 = color.getAlpha();
            n = n2 | n3 << 24;
            preferences.putInt(string, n);
        } else {
            color = new Color(n, true);
        }
        return color;
    }

    protected class CorefTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        private JCheckBox check;
        private JLabel label;

        public CorefTreeCellRenderer() {
            this.setOpaque(true);
            this.check = new JCheckBox();
            this.check.setBackground(Color.white);
            this.label = new JLabel();
            this.setLayout(new BorderLayout(5, 10));
            this.add((Component)this.check, "West");
            this.add((Component)this.label, "Center");
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            CorefTreeNode corefTreeNode = (CorefTreeNode)object;
            this.label.setText(corefTreeNode.toString());
            this.setSize(this.label.getWidth(), this.label.getFontMetrics(this.label.getFont()).getHeight() * 2);
            jTree.expandRow(n);
            if (corefTreeNode.getType() == 0 || corefTreeNode.getType() == 1) {
                this.setBackground(Color.white);
                this.check.setVisible(false);
                return this;
            }
            this.setBackground((Color)CorefEditor.this.currentColors.get(corefTreeNode.toString()));
            this.check.setVisible(true);
            this.check.setBackground(Color.white);
            boolean bl5 = (Boolean)CorefEditor.this.currentSelections.get(corefTreeNode.toString());
            this.check.setSelected(bl5);
            return this;
        }
    }

    protected class CorefTreeMouseListener
    extends MouseAdapter {
        protected CorefTreeMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (CorefEditor.this.popupWindow != null && CorefEditor.this.popupWindow.isVisible()) {
                CorefEditor.this.popupWindow.setVisible(false);
            }
            CorefEditor.this.textPane.removeAll();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = CorefEditor.this.corefTree.getRowForLocation(n, n2);
            TreePath treePath = CorefEditor.this.corefTree.getPathForRow(n3);
            if (treePath != null) {
                final CorefTreeNode corefTreeNode = (CorefTreeNode)treePath.getLastPathComponent();
                if (corefTreeNode.getType() != 2) {
                    return;
                }
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    final JPopupMenu jPopupMenu = new JPopupMenu();
                    JButton jButton = new JButton("Delete");
                    jButton.setToolTipText("Delete Chain");
                    ToolTipManager.sharedInstance().registerComponent(jButton);
                    JButton jButton2 = new JButton("Close");
                    jButton2.setToolTipText("Closes this popup");
                    JButton jButton3 = new JButton("Change Color");
                    jButton3.setToolTipText("Changes Color");
                    ToolTipManager.sharedInstance().registerComponent(jButton2);
                    ToolTipManager.sharedInstance().registerComponent(jButton3);
                    JPanel jPanel = new JPanel(new FlowLayout(0));
                    jPanel.setOpaque(false);
                    jPanel.add(jButton3);
                    jPanel.add(jButton);
                    jPanel.add(jButton2);
                    jPopupMenu.setLayout(new BorderLayout());
                    jPopupMenu.setOpaque(true);
                    jPopupMenu.setBackground(UIManager.getLookAndFeelDefaults().getColor("ToolTip.background"));
                    jPopupMenu.add((Component)new JLabel("Chain \"" + corefTreeNode.toString() + "\""), "North");
                    jPopupMenu.add((Component)jPanel, "South");
                    jButton3.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            String string = (String)CorefEditor.this.annotSets.getSelectedItem();
                            CorefEditor.this.currentColors = (HashMap)CorefEditor.this.colorChainsMap.get(string);
                            Color color = (Color)CorefEditor.this.currentColors.get(corefTreeNode.toString());
                            Color color2 = JColorChooser.showDialog(CorefEditor.this.getGUI(), "Select colour for \"" + corefTreeNode.toString() + "\"", color);
                            if (color2 != null) {
                                Color color3 = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), 128);
                                CorefEditor.this.currentColors.put(corefTreeNode.toString(), color3);
                                CorefEditor.this.colorChainsMap.put(string, CorefEditor.this.currentColors);
                                CorefEditor.this.corefTree.repaint();
                                ArrayList arrayList = new ArrayList();
                                if (CorefEditor.this.typeSpecificHighlightedTags != null) {
                                    arrayList.addAll(CorefEditor.this.typeSpecificHighlightedTags);
                                }
                                if (CorefEditor.this.highlightedTags != null) {
                                    for (ArrayList arrayList2 : CorefEditor.this.highlightedTags.values()) {
                                        arrayList.addAll(arrayList2);
                                    }
                                }
                                for (int i = 0; i < arrayList.size(); ++i) {
                                    CorefEditor.this.highlighter.removeHighlight(arrayList.get(i));
                                }
                                CorefEditor.this.highlightedTags = null;
                                CorefEditor.this.highlightAnnotations();
                                CorefEditor.this.typeSpecificHighlightedTags = null;
                                CorefEditor.this.showTypeWiseAnnotations();
                            }
                            jPopupMenu.setVisible(false);
                        }
                    });
                    jButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            int n;
                            HashMap hashMap = (HashMap)CorefEditor.this.corefChains.get(CorefEditor.this.corefAnnotationSetNodesMap.get(CorefEditor.this.annotSets.getSelectedItem()));
                            ArrayList arrayList = (ArrayList)hashMap.get(corefTreeNode);
                            String string = (String)CorefEditor.this.annotSets.getSelectedItem();
                            string = string.equals(CorefEditor.DEFAULT_ANNOTSET_NAME) ? null : string;
                            HashMap hashMap2 = null;
                            ArrayList arrayList2 = null;
                            Object v = CorefEditor.this.document.getFeatures().get("MatchesAnnots");
                            if (v instanceof Map) {
                                hashMap2 = (HashMap)v;
                                arrayList2 = (List)hashMap2.get(string);
                            }
                            if (hashMap2 == null) {
                                hashMap2 = new HashMap();
                            }
                            if (arrayList2 == null) {
                                arrayList2 = new ArrayList();
                            }
                            if ((n = arrayList2.indexOf(arrayList)) != -1) {
                                arrayList2.remove(n);
                                hashMap2.put(string, arrayList2);
                                CorefEditor.this.document.getFeatures().put("MatchesAnnots", hashMap2);
                            }
                            jPopupMenu.setVisible(false);
                        }
                    });
                    jButton2.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            jPopupMenu.setVisible(false);
                        }
                    });
                    jPopupMenu.setVisible(true);
                    jPopupMenu.show(CorefEditor.this.corefTree, n, n2);
                    return;
                }
                boolean bl = (Boolean)CorefEditor.this.currentSelections.get(corefTreeNode.toString()) == false;
                CorefEditor.this.currentSelections.put(corefTreeNode.toString(), new Boolean(bl));
                CorefEditor.this.highlightAnnotations();
                CorefEditor.this.corefTree.repaint();
                CorefEditor.this.corefTree.updateUI();
                CorefEditor.this.corefTree.repaint();
                CorefEditor.this.corefTree.updateUI();
            }
        }
    }

    protected class CorefTreeNode
    extends DefaultMutableTreeNode {
        public static final int ROOT_NODE = 0;
        public static final int ANNOTSET_NODE = 1;
        public static final int CHAIN_NODE = 2;
        private int type;

        public CorefTreeNode(Object object, boolean bl, int n) {
            super(object, bl);
            this.type = n;
        }

        public int getType() {
            return this.type;
        }
    }

    protected class ChainToolTipAction
    extends AbstractAction {
        int textLocation;
        Point mousePoint;
        JPopupMenu popup = new JPopupMenu();

        public ChainToolTipAction() {
            this.popup.setBackground(UIManager.getLookAndFeelDefaults().getColor("ToolTip.background"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2 = -1;
            if (CorefEditor.this.highlightedChainAnnotsOffsets != null) {
                for (n = 0; n < CorefEditor.this.highlightedChainAnnotsOffsets.length; n += 2) {
                    if (this.textLocation < CorefEditor.this.highlightedChainAnnotsOffsets[n] || this.textLocation > CorefEditor.this.highlightedChainAnnotsOffsets[n + 1]) continue;
                    n2 = n == 0 ? n : n / 2;
                    break;
                }
            }
            if (CorefEditor.this.highlightedChainAnnotsOffsets != null && n2 < CorefEditor.this.highlightedChainAnnotsOffsets.length && n2 >= 0) {
                if (CorefEditor.this.popupWindow != null && CorefEditor.this.popupWindow.isVisible()) {
                    CorefEditor.this.popupWindow.setVisible(false);
                }
                this.popup.setVisible(false);
                this.popup.removeAll();
                n = n2;
                CorefTreeNode corefTreeNode = CorefEditor.this.findOutTheChainHead((Annotation)CorefEditor.this.highlightedChainAnnots.get(n2), (String)CorefEditor.this.annotSets.getSelectedItem());
                final HashMap<String, CorefTreeNode> hashMap = new HashMap<String, CorefTreeNode>();
                this.popup.setLayout(new FlowLayout(0));
                if (corefTreeNode != null) {
                    JPanel jPanel = new JPanel();
                    jPanel.setLayout(new FlowLayout(0));
                    jPanel.add(new JLabel(corefTreeNode.toString()));
                    jPanel.setBackground(UIManager.getLookAndFeelDefaults().getColor("ToolTip.background"));
                    final JButton jButton = new JButton("Delete");
                    jPanel.add(jButton);
                    this.popup.add(jPanel);
                    jButton.setActionCommand(corefTreeNode.toString());
                    hashMap.put(corefTreeNode.toString(), corefTreeNode);
                    jButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                int n2 = JOptionPane.showConfirmDialog(MainFrame.getInstance(), "Are you sure?", "Removing reference...", 0);
                                if (n2 == 0) {
                                    ChainToolTipAction.this.popup.setVisible(false);
                                    CorefEditor.this.removeChainReference((Annotation)CorefEditor.this.highlightedChainAnnots.get(n), (CorefTreeNode)hashMap.get(jButton.getActionCommand()));
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    });
                }
                this.popup.revalidate();
                if (CorefEditor.this.popupWindow != null && CorefEditor.this.popupWindow.isVisible()) {
                    CorefEditor.this.popupWindow.setVisible(false);
                }
                this.popup.setVisible(true);
                this.popup.show(CorefEditor.this.textPane, (int)this.mousePoint.getX(), (int)this.mousePoint.getY());
            }
        }

        public void setTextLocation(int n) {
            this.textLocation = n;
        }

        public void setMousePointer(Point point) {
            this.mousePoint = point;
        }
    }

    protected class NewCorefAction
    implements ActionListener {
        int textLocation;
        Point mousePoint;
        JLabel label = new JLabel();
        JPanel panel = new JPanel();
        JPanel subPanel = new JPanel();
        String field = "";
        JButton add = new JButton("OK");
        JButton cancel = new JButton("Cancel");
        JComboBox list = new JComboBox();
        JPanel mainPanel = new JPanel();
        JPopupMenu popup1 = new JPopupMenu();
        ListEditor listEditor = null;
        ComboBoxModel model = new DefaultComboBoxModel();
        boolean firstTime = true;

        public NewCorefAction() {
            CorefEditor.this.popupWindow = new JWindow(SwingUtilities.getWindowAncestor(CorefEditor.this.textView.getGUI()));
            CorefEditor.this.popupWindow.setBackground(UIManager.getLookAndFeelDefaults().getColor("ToolTip.background"));
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.setOpaque(true);
            this.mainPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            this.mainPanel.setBackground(UIManager.getLookAndFeelDefaults().getColor("ToolTip.background"));
            CorefEditor.this.popupWindow.setContentPane(this.mainPanel);
            this.panel.setLayout(new BorderLayout());
            this.panel.setOpaque(false);
            this.panel.add((Component)new JScrollPane(this.list), "Center");
            this.subPanel.setLayout(new FlowLayout(0));
            this.subPanel.add(this.add);
            this.subPanel.add(this.cancel);
            this.subPanel.setOpaque(false);
            this.panel.add((Component)this.subPanel, "South");
            this.mainPanel.add((Component)this.label, "North");
            this.mainPanel.add((Component)this.panel, "Center");
            AddAction addAction = new AddAction();
            this.add.addActionListener(addAction);
            this.cancel.addActionListener(addAction);
            this.listEditor = new ListEditor(addAction);
            this.list.setMaximumRowCount(5);
            this.list.setEditable(true);
            this.list.setEditor(this.listEditor);
            this.list.setModel(this.model);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2 = -1;
            if (CorefEditor.this.highlightedChainAnnotsOffsets != null) {
                for (n = 0; n < CorefEditor.this.highlightedChainAnnotsOffsets.length; n += 2) {
                    if (this.textLocation < CorefEditor.this.highlightedChainAnnotsOffsets[n] || this.textLocation > CorefEditor.this.highlightedChainAnnotsOffsets[n + 1]) continue;
                    n2 = n == 0 ? n : n / 2;
                    break;
                }
            }
            if (CorefEditor.this.highlightedChainAnnotsOffsets != null && n2 < CorefEditor.this.highlightedChainAnnotsOffsets.length && n2 >= 0) {
                return;
            }
            if (CorefEditor.this.highlightedTypeAnnotsOffsets != null) {
                for (n = 0; n < CorefEditor.this.highlightedTypeAnnotsOffsets.length; n += 2) {
                    if (this.textLocation < CorefEditor.this.highlightedTypeAnnotsOffsets[n] || this.textLocation > CorefEditor.this.highlightedTypeAnnotsOffsets[n + 1]) continue;
                    n2 = n == 0 ? n : n / 2;
                    break;
                }
            }
            if (CorefEditor.this.highlightedTypeAnnotsOffsets != null && n2 < CorefEditor.this.highlightedTypeAnnotsOffsets.length && n2 >= 0) {
                CorefEditor.this.textPane.removeAll();
                CorefEditor.this.annotToConsiderForChain = (Annotation)CorefEditor.this.highlightedTypeAnnots.get(n2);
                CorefTreeNode corefTreeNode = CorefEditor.this.findOutTheChainHead(CorefEditor.this.annotToConsiderForChain, (String)CorefEditor.this.annotSets.getSelectedItem());
                if (corefTreeNode != null) {
                    this.popup1 = new JPopupMenu();
                    this.popup1.setBackground(UIManager.getLookAndFeelDefaults().getColor("ToolTip.background"));
                    JLabel jLabel = new JLabel("Annotation co-referenced to : \"" + corefTreeNode.toString() + "\"");
                    this.popup1.setLayout(new FlowLayout());
                    this.popup1.add(jLabel);
                    if (CorefEditor.this.popupWindow != null && CorefEditor.this.popupWindow.isVisible()) {
                        CorefEditor.this.popupWindow.setVisible(false);
                    }
                    this.popup1.setVisible(true);
                    this.popup1.show(CorefEditor.this.textPane, (int)this.mousePoint.getX(), (int)this.mousePoint.getY());
                } else {
                    CorefEditor.this.popupWindow.setVisible(false);
                    ArrayList arrayList = new ArrayList(CorefEditor.this.currentSelections.keySet());
                    Collections.sort(arrayList);
                    arrayList.add(0, "[New Chain]");
                    this.model = new DefaultComboBoxModel<Object>(arrayList.toArray());
                    this.list.setModel(this.model);
                    this.listEditor.setItem("");
                    this.label.setText("Add \"" + CorefEditor.this.getString(CorefEditor.this.annotToConsiderForChain) + "\" to ");
                    Point point = CorefEditor.this.textPane.getLocationOnScreen();
                    int n3 = point.x + (int)this.mousePoint.getX();
                    int n4 = point.y + (int)this.mousePoint.getY();
                    CorefEditor.this.popupWindow.setLocation(n3, n4);
                    if (this.popup1.isVisible()) {
                        this.popup1.setVisible(false);
                    }
                    CorefEditor.this.popupWindow.pack();
                    CorefEditor.this.popupWindow.setVisible(true);
                    this.listEditor.requestFocus();
                    if (this.firstTime) {
                        this.firstTime = false;
                        CorefEditor.this.popupWindow.pack();
                        CorefEditor.this.popupWindow.repaint();
                        this.listEditor.requestFocus();
                    }
                }
            }
        }

        public void setTextLocation(int n) {
            this.textLocation = n;
        }

        public void setMousePointer(Point point) {
            this.mousePoint = point;
        }

        private class AddAction
        extends AbstractAction {
            private AddAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == NewCorefAction.this.cancel) {
                    CorefEditor.this.popupWindow.setVisible(false);
                    return;
                }
                if (actionEvent.getSource() == NewCorefAction.this.add) {
                    int n;
                    String string;
                    ArrayList<ArrayList> arrayList;
                    if (NewCorefAction.this.field.length() == 0) {
                        try {
                            JOptionPane.showMessageDialog(MainFrame.getInstance(), "No Chain Selected", "New Chain - Error", 0);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        return;
                    }
                    Annotation annotation = CorefEditor.this.annotToConsiderForChain;
                    if (annotation == null) {
                        return;
                    }
                    if (NewCorefAction.this.field.equals("[New Chain]")) {
                        if (annotation == null) {
                            return;
                        }
                        CorefTreeNode corefTreeNode = CorefEditor.this.findOutChainNode(CorefEditor.this.getString(annotation), (String)CorefEditor.this.annotSets.getSelectedItem());
                        if (corefTreeNode != null) {
                            try {
                                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Chain with " + CorefEditor.this.getString(annotation) + " title already exists", "New Chain - Error", 0);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            return;
                        }
                        CorefEditor.this.popupWindow.setVisible(false);
                        String string2 = (String)CorefEditor.this.annotSets.getSelectedItem();
                        string2 = string2.equals(CorefEditor.DEFAULT_ANNOTSET_NAME) ? null : string2;
                        HashMap hashMap = null;
                        Object v = CorefEditor.this.document.getFeatures().get("MatchesAnnots");
                        if (v instanceof Map) {
                            hashMap = (HashMap)v;
                        }
                        if (hashMap == null) {
                            hashMap = new HashMap();
                        }
                        ArrayList arrayList2 = (ArrayList)hashMap.get(string2);
                        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
                        arrayList3.add(annotation.getId());
                        if (arrayList2 == null) {
                            arrayList2 = new ArrayList();
                        }
                        arrayList2.add(arrayList3);
                        hashMap.put(string2, arrayList2);
                        CorefEditor.this.document.getFeatures().put("MatchesAnnots", hashMap);
                        return;
                    }
                    CorefTreeNode corefTreeNode = CorefEditor.this.findOutChainNode(NewCorefAction.this.field, (String)CorefEditor.this.annotSets.getSelectedItem());
                    HashMap hashMap = (HashMap)CorefEditor.this.corefChains.get(CorefEditor.this.corefAnnotationSetNodesMap.get(CorefEditor.this.annotSets.getSelectedItem()));
                    if (corefTreeNode == null) {
                        try {
                            JOptionPane.showMessageDialog(MainFrame.getInstance(), "Incorrect Chain Title", "New Chain - Error", 0);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        return;
                    }
                    CorefEditor.this.popupWindow.setVisible(false);
                    ArrayList arrayList4 = (ArrayList)hashMap.get(corefTreeNode);
                    HashMap hashMap2 = null;
                    Object v = CorefEditor.this.document.getFeatures().get("MatchesAnnots");
                    if (v instanceof Map) {
                        hashMap2 = (HashMap)v;
                    }
                    if (hashMap2 == null) {
                        hashMap2 = new HashMap();
                    }
                    if ((arrayList = (ArrayList<ArrayList>)hashMap2.get(string = (string = (String)CorefEditor.this.annotSets.getSelectedItem()).equals(CorefEditor.DEFAULT_ANNOTSET_NAME) ? null : string)) == null) {
                        arrayList = new ArrayList<ArrayList>();
                    }
                    if ((n = arrayList.indexOf(arrayList4)) != -1) {
                        ArrayList arrayList5 = (ArrayList)arrayList.get(n);
                        arrayList5.add(annotation.getId());
                        arrayList.set(n, arrayList5);
                        hashMap2.put(string, arrayList);
                        CorefEditor.this.document.getFeatures().put("MatchesAnnots", hashMap2);
                    }
                    return;
                }
            }
        }

        private class ListEditor
        extends KeyAdapter
        implements ComboBoxEditor {
            JTextField myField = new JTextField(20);
            AddAction action = null;
            Vector myList = new Vector();

            public ListEditor(AddAction addAction) {
                this.action = addAction;
                this.myField.addKeyListener(this);
            }

            public void addActionListener(ActionListener actionListener) {
                this.myField.addActionListener(actionListener);
            }

            public void removeActionListener(ActionListener actionListener) {
                this.myField.removeActionListener(actionListener);
            }

            public Component getEditorComponent() {
                return this.myField;
            }

            public Object getItem() {
                return this.myField.getText();
            }

            public void selectAll() {
                if (this.myField.getText() != null && this.myField.getText().length() > 0) {
                    this.myField.setSelectionStart(0);
                    this.myField.setSelectionEnd(this.myField.getText().length());
                }
            }

            public void setItem(Object object) {
                this.myField.setText((String)object);
                NewCorefAction.this.field = this.myField.getText();
            }

            public void requestFocus() {
                this.myField.requestFocus();
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (this.myField.getText() == null) {
                    this.myField.setText("");
                    NewCorefAction.this.field = this.myField.getText();
                }
                if (keyEvent.getKeyCode() == 40) {
                    if (this.myList.size() == 1) {
                        this.myField.setText((String)this.myList.get(0));
                    } else if (NewCorefAction.this.list.getSelectedIndex() < NewCorefAction.this.list.getModel().getSize() - 1) {
                        NewCorefAction.this.list.setSelectedIndex(NewCorefAction.this.list.getSelectedIndex());
                        this.myField.setText((String)NewCorefAction.this.list.getSelectedItem());
                    }
                    NewCorefAction.this.field = this.myField.getText();
                    this.myField.requestFocus();
                    return;
                }
                if (keyEvent.getKeyCode() == 38) {
                    if (NewCorefAction.this.list.getSelectedIndex() > 0) {
                        NewCorefAction.this.list.setSelectedIndex(NewCorefAction.this.list.getSelectedIndex());
                    }
                    this.myField.setText((String)NewCorefAction.this.list.getSelectedItem());
                    NewCorefAction.this.field = this.myField.getText();
                    return;
                }
                if (keyEvent.getKeyCode() == 10) {
                    NewCorefAction.this.field = this.myField.getText();
                    this.action.actionPerformed(new ActionEvent(NewCorefAction.this.add, 1001, "add"));
                    return;
                }
                if (!(keyEvent.getKeyCode() == 8 || Character.isJavaIdentifierPart(keyEvent.getKeyChar()) || Character.isSpaceChar(keyEvent.getKeyChar()) || Character.isDefined(keyEvent.getKeyChar()))) {
                    return;
                }
                String string = this.myField.getText();
                this.myList = new Vector();
                ArrayList arrayList = new ArrayList(CorefEditor.this.currentSelections.keySet());
                Collections.sort(arrayList);
                arrayList.add(0, "[New Chain]");
                boolean bl = true;
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string2 = (String)arrayList.get(i);
                    if (!string2.toLowerCase().startsWith(string.toLowerCase())) continue;
                    if (bl) {
                        this.myField.setText(string2.substring(0, string.length()));
                        bl = false;
                    }
                    this.myList.add(string2);
                }
                DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(this.myList);
                NewCorefAction.this.list.setModel(defaultComboBoxModel);
                this.myField.setText(string);
                NewCorefAction.this.field = this.myField.getText();
                NewCorefAction.this.list.showPopup();
            }
        }
    }

    protected class TextPaneMouseListener
    extends MouseInputAdapter {
        public TextPaneMouseListener() {
            CorefEditor.this.chainToolTipTimer.setRepeats(false);
            CorefEditor.this.newCorefActionTimer.setRepeats(false);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = CorefEditor.this.textPane.viewToModel(mouseEvent.getPoint());
            CorefEditor.this.chainToolTipAction.setTextLocation(n);
            CorefEditor.this.chainToolTipAction.setMousePointer(mouseEvent.getPoint());
            CorefEditor.this.chainToolTipTimer.restart();
            CorefEditor.this.newCorefAction.setTextLocation(n);
            CorefEditor.this.newCorefAction.setMousePointer(mouseEvent.getPoint());
            CorefEditor.this.newCorefActionTimer.restart();
        }
    }
}

