/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.docview;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Factory;
import gate.Gate;
import gate.TextualDocument;
import gate.event.AnnotationSetEvent;
import gate.event.AnnotationSetListener;
import gate.event.DocumentEvent;
import gate.event.DocumentListener;
import gate.event.GateEvent;
import gate.event.StatusListener;
import gate.gui.MainFrame;
import gate.gui.docview.AbstractDocumentView;
import gate.gui.docview.AnnotationEditor;
import gate.gui.docview.AnnotationListView;
import gate.gui.docview.DocumentView;
import gate.gui.docview.TextualDocumentView;
import gate.swing.ColorGenerator;
import gate.swing.XJTable;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import gate.util.Out;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.MouseInputListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;

public class AnnotationSetsView
extends AbstractDocumentView
implements DocumentListener,
AnnotationSetListener {
    List<SetHandler> setHandlers = new ArrayList<SetHandler>();
    List tableRows = new ArrayList();
    XJTable mainTable;
    SetsTableModel tableModel;
    JScrollPane scroller;
    JPanel mainPanel;
    JTextField newSetNameTextField;
    TextualDocumentView textView;
    AnnotationListView listView;
    JTextArea textPane;
    AnnotationEditor annotationEditor;
    NewAnnotationSetAction newSetAction;
    protected TextMouseListener textMouseListener;
    protected List<TypeSpec> visibleAnnotationTypes = new ArrayList<TypeSpec>();
    protected Timer mouseMovementTimer;
    protected Timer eventMinder;
    protected Queue<GateEvent> pendingEvents;
    private static final int MOUSE_MOVEMENT_TIMER_DELAY = 500;
    protected AncestorListener textAncestorListener;
    protected MouseStoppedMovingAction mouseStoppedMovingAction;
    protected String lastAnnotationType = "_New_";
    protected List actions;
    protected ColorGenerator colourGenerator = new ColorGenerator();
    private static final int NAME_COL = 1;
    private static final int SELECTED_COL = 0;
    private static final int EVENTS_HANDLE_DELAY = 300;

    public AnnotationSetsView() {
        this.actions = new ArrayList();
        this.actions.add(new SavePreserveFormatAction());
        this.pendingEvents = new LinkedList<GateEvent>();
        this.eventMinder = new Timer(300, new HandleDocumentEventsAction());
        this.eventMinder.setRepeats(true);
        this.eventMinder.setCoalesce(true);
    }

    public List getActions() {
        return this.actions;
    }

    public int getType() {
        return 1;
    }

    protected void initGUI() {
        Object object;
        Object object2;
        Iterator iterator = this.owner.getCentralViews().iterator();
        while (this.textView == null && iterator.hasNext()) {
            object2 = (DocumentView)iterator.next();
            if (!(object2 instanceof TextualDocumentView)) continue;
            this.textView = (TextualDocumentView)object2;
        }
        this.textPane = (JTextArea)((JScrollPane)this.textView.getGUI()).getViewport().getView();
        object2 = this.owner.getHorizontalViews().iterator();
        while (this.listView == null && object2.hasNext()) {
            object = (DocumentView)object2.next();
            if (!(object instanceof AnnotationListView)) continue;
            this.listView = (AnnotationListView)object;
        }
        this.mainTable = new XJTable();
        this.tableModel = new SetsTableModel();
        this.mainTable.setSortable(false);
        this.mainTable.setModel(this.tableModel);
        this.mainTable.setRowMargin(0);
        this.mainTable.getColumnModel().setColumnMargin(0);
        object = new SetsTableCellRenderer();
        this.mainTable.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)object);
        this.mainTable.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)object);
        SetsTableCellEditor setsTableCellEditor = new SetsTableCellEditor();
        this.mainTable.getColumnModel().getColumn(0).setCellEditor(setsTableCellEditor);
        this.mainTable.setSelectionMode(0);
        this.mainTable.setColumnSelectionAllowed(false);
        this.mainTable.setRowSelectionAllowed(true);
        this.mainTable.setTableHeader(null);
        this.mainTable.setShowGrid(false);
        this.mainTable.setAutoResizeMode(0);
        Color color = this.mainTable.getBackground();
        color = new Color(color.getRGB());
        this.mainTable.setBackground(color);
        this.scroller = new JScrollPane(this.mainTable);
        this.scroller.getViewport().setOpaque(true);
        this.scroller.getViewport().setBackground(color);
        this.annotationEditor = this.createAnnotationEditor(this.textView, this);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.mainPanel.add((Component)this.scroller, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        this.newSetNameTextField = new JTextField();
        this.mainPanel.add((Component)this.newSetNameTextField, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        this.newSetAction = new NewAnnotationSetAction();
        this.mainPanel.add((Component)new JButton(this.newSetAction), gridBagConstraints);
        this.populateUI();
        this.tableModel.fireTableDataChanged();
        this.eventMinder.start();
        this.initListeners();
    }

    protected AnnotationEditor createAnnotationEditor(TextualDocumentView textualDocumentView, AnnotationSetsView annotationSetsView) {
        return new AnnotationEditor(textualDocumentView, annotationSetsView);
    }

    protected void populateUI() {
        this.setHandlers.add(new SetHandler(this.document.getAnnotations()));
        ArrayList arrayList = this.document.getNamedAnnotationSets() == null ? new ArrayList() : new ArrayList(this.document.getNamedAnnotationSets().keySet());
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.setHandlers.add(new SetHandler(this.document.getAnnotations((String)iterator.next())));
        }
        this.tableRows.addAll(this.setHandlers);
    }

    public Component getGUI() {
        return this.mainPanel;
    }

    protected Color getColor(String string) {
        Color color;
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        int n = preferences.getInt(string, -1);
        if (n == -1) {
            float[] fArray = this.colourGenerator.getNextColor().getComponents(null);
            color = new Color(fArray[0], fArray[1], fArray[2], 0.5f);
            int n2 = color.getRGB();
            int n3 = color.getAlpha();
            n = n2 | n3 << 24;
            preferences.putInt(string, n);
        } else {
            color = new Color(n, true);
        }
        return color;
    }

    protected void saveColor(String string, Color color) {
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        int n = color.getRGB();
        int n2 = color.getAlpha();
        int n3 = n | n2 << 24;
        preferences.putInt(string, n3);
    }

    public void setNewAnnSetCreationEnabled(boolean bl) {
        this.newSetAction.setEnabled(bl);
        this.newSetNameTextField.setEnabled(bl);
    }

    protected void registerHooks() {
        this.textPane.addMouseListener(this.textMouseListener);
        this.textPane.addMouseMotionListener(this.textMouseListener);
        this.textPane.addAncestorListener(this.textAncestorListener);
        this.restoreSelectedTypes();
    }

    protected void unregisterHooks() {
        this.textPane.removeMouseListener(this.textMouseListener);
        this.textPane.removeMouseMotionListener(this.textMouseListener);
        this.textPane.removeAncestorListener(this.textAncestorListener);
        this.storeSelectedTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeSelectedTypes() {
        AnnotationSetsView annotationSetsView = this;
        synchronized (annotationSetsView) {
            for (SetHandler setHandler : this.setHandlers) {
                for (TypeHandler typeHandler : setHandler.typeHandlers) {
                    if (!typeHandler.isSelected()) continue;
                    this.visibleAnnotationTypes.add(new TypeSpec(setHandler.set.getName(), typeHandler.name));
                    typeHandler.setSelected(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreSelectedTypes() {
        AnnotationSetsView annotationSetsView = this;
        synchronized (annotationSetsView) {
            for (TypeSpec typeSpec : this.visibleAnnotationTypes) {
                TypeHandler typeHandler = this.getTypeHandler(typeSpec.setName, typeSpec.type);
                typeHandler.setSelected(true);
            }
            this.visibleAnnotationTypes.clear();
        }
    }

    protected void initListeners() {
        this.document.addDocumentListener(this);
        this.mainTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Object e;
                int n = AnnotationSetsView.this.mainTable.rowAtPoint(mouseEvent.getPoint());
                int n2 = AnnotationSetsView.this.mainTable.columnAtPoint(mouseEvent.getPoint());
                if (n >= 0 && n2 == 1 && (e = AnnotationSetsView.this.tableRows.get(n)) instanceof TypeHandler) {
                    TypeHandler typeHandler = (TypeHandler)e;
                    if (mouseEvent.getClickCount() >= 2) {
                        typeHandler.changeColourAction.actionPerformed(null);
                    }
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                Object e;
                int n = AnnotationSetsView.this.mainTable.rowAtPoint(mouseEvent.getPoint());
                int n2 = AnnotationSetsView.this.mainTable.columnAtPoint(mouseEvent.getPoint());
                if (n >= 0 && n2 == 1 && (e = AnnotationSetsView.this.tableRows.get(n)) instanceof TypeHandler) {
                    TypeHandler typeHandler = (TypeHandler)e;
                    if (mouseEvent.isPopupTrigger()) {
                        JPopupMenu jPopupMenu = new JPopupMenu();
                        jPopupMenu.add(typeHandler.changeColourAction);
                        jPopupMenu.show(AnnotationSetsView.this.mainTable, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                Object e;
                int n = AnnotationSetsView.this.mainTable.rowAtPoint(mouseEvent.getPoint());
                int n2 = AnnotationSetsView.this.mainTable.columnAtPoint(mouseEvent.getPoint());
                if (n >= 0 && n2 == 1 && (e = AnnotationSetsView.this.tableRows.get(n)) instanceof TypeHandler) {
                    TypeHandler typeHandler = (TypeHandler)e;
                    if (mouseEvent.isPopupTrigger()) {
                        JPopupMenu jPopupMenu = new JPopupMenu();
                        jPopupMenu.add(typeHandler.changeColourAction);
                        jPopupMenu.show(AnnotationSetsView.this.mainTable, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        });
        this.mouseStoppedMovingAction = new MouseStoppedMovingAction();
        this.mouseMovementTimer = new Timer(500, this.mouseStoppedMovingAction);
        this.mouseMovementTimer.setRepeats(false);
        this.textMouseListener = new TextMouseListener();
        this.textAncestorListener = new AncestorListener(){
            private boolean wasShowing = false;

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                if (this.wasShowing) {
                    AnnotationSetsView.this.annotationEditor.show(false);
                }
                this.wasShowing = false;
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                if (AnnotationSetsView.this.annotationEditor.isShowing()) {
                    this.wasShowing = true;
                    AnnotationSetsView.this.annotationEditor.hide();
                }
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        };
        this.mainTable.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "deleteAll");
        this.mainTable.getActionMap().put("deleteAll", new DeleteSelectedAnnotationGroupAction());
        this.newSetNameTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "newSet");
        this.newSetNameTextField.getActionMap().put("newSet", this.newSetAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        this.document.removeDocumentListener(this);
        for (SetHandler setHandler : this.setHandlers) {
            setHandler.set.removeAnnotationSetListener(this);
        }
        this.eventMinder.stop();
        AnnotationSetsView annotationSetsView = this;
        synchronized (annotationSetsView) {
            this.pendingEvents.clear();
        }
        super.cleanup();
        this.document = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotationSetAdded(DocumentEvent documentEvent) {
        AnnotationSetsView annotationSetsView = this;
        synchronized (annotationSetsView) {
            this.pendingEvents.offer(documentEvent);
            this.eventMinder.restart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotationSetRemoved(DocumentEvent documentEvent) {
        AnnotationSetsView annotationSetsView = this;
        synchronized (annotationSetsView) {
            this.pendingEvents.offer(documentEvent);
            this.eventMinder.restart();
        }
    }

    public void contentEdited(DocumentEvent documentEvent) {
        for (SetHandler setHandler : this.setHandlers) {
            for (TypeHandler typeHandler : setHandler.typeHandlers) {
                if (!typeHandler.isSelected()) continue;
                typeHandler.repairHighlights(documentEvent.getEditStart().intValue(), documentEvent.getEditEnd().intValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotationAdded(AnnotationSetEvent annotationSetEvent) {
        AnnotationSetsView annotationSetsView = this;
        synchronized (annotationSetsView) {
            this.pendingEvents.offer(annotationSetEvent);
            this.eventMinder.restart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotationRemoved(AnnotationSetEvent annotationSetEvent) {
        AnnotationSetsView annotationSetsView = this;
        synchronized (annotationSetsView) {
            this.pendingEvents.offer(annotationSetEvent);
            this.eventMinder.restart();
        }
    }

    protected SetHandler getSetHandler(String string) {
        for (SetHandler setHandler : this.setHandlers) {
            if (!(string == null ? setHandler.set.getName() == null : string.equals(setHandler.set.getName()))) continue;
            return setHandler;
        }
        return null;
    }

    protected TypeHandler getTypeHandler(String string, String string2) {
        SetHandler setHandler = this.getSetHandler(string);
        TypeHandler typeHandler = null;
        Iterator<TypeHandler> iterator = setHandler.typeHandlers.iterator();
        while (typeHandler == null && iterator.hasNext()) {
            TypeHandler typeHandler2 = iterator.next();
            if (!typeHandler2.name.equals(string2)) continue;
            typeHandler = typeHandler2;
        }
        return typeHandler;
    }

    public void setTypeSelected(final String string, final String string2, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                TypeHandler typeHandler = AnnotationSetsView.this.getTypeHandler(string, string2);
                if (typeHandler != null) {
                    typeHandler.setSelected(bl);
                    int n = AnnotationSetsView.this.tableRows.indexOf(typeHandler);
                    AnnotationSetsView.this.tableModel.fireTableRowsUpdated(n, n);
                    AnnotationSetsView.this.mainTable.getSelectionModel().setSelectionInterval(n, n);
                } else {
                    AnnotationSetsView annotationSetsView = AnnotationSetsView.this;
                    synchronized (annotationSetsView) {
                        AnnotationSetsView.this.visibleAnnotationTypes.add(new TypeSpec(string, string2));
                    }
                }
            }
        });
    }

    void setLastAnnotationType(String string) {
        this.lastAnnotationType = string;
    }

    protected class DeleteSelectedAnnotationGroupAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            int n = AnnotationSetsView.this.mainTable.getSelectedRow();
            if (n >= 0) {
                Object e = AnnotationSetsView.this.tableRows.get(n);
                if (e instanceof TypeHandler) {
                    TypeHandler typeHandler = (TypeHandler)e;
                    AnnotationSet annotationSet = typeHandler.setHandler.set;
                    AnnotationSet annotationSet2 = annotationSet.get(typeHandler.name);
                    if (annotationSet2 != null) {
                        ArrayList<Annotation> arrayList = new ArrayList<Annotation>(annotationSet2);
                        annotationSet.removeAll(arrayList);
                    }
                } else if (e instanceof SetHandler) {
                    SetHandler setHandler = (SetHandler)e;
                    if (setHandler.set == AnnotationSetsView.this.document.getAnnotations()) {
                        setHandler.set.clear();
                    } else {
                        AnnotationSetsView.this.document.removeAnnotationSet(setHandler.set.getName());
                    }
                }
                if (AnnotationSetsView.this.mainTable.getRowCount() <= n) {
                    n = AnnotationSetsView.this.mainTable.getRowCount() - 1;
                }
                AnnotationSetsView.this.mainTable.getSelectionModel().setSelectionInterval(n, n);
            }
        }
    }

    protected class EditAnnotationAction
    extends AbstractAction {
        AnnotationHandler aHandler;

        public EditAnnotationAction(AnnotationHandler annotationHandler) {
            super(annotationHandler.ann.getType() + " [" + (annotationHandler.set.getName() == null ? "  " : annotationHandler.set.getName()) + "]");
            this.putValue("ShortDescription", annotationHandler.ann.getFeatures().toString());
            this.aHandler = annotationHandler;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TypeHandler typeHandler;
            AnnotationSetsView.this.annotationEditor.setAnnotation(this.aHandler.ann, this.aHandler.set);
            if (AnnotationSetsView.this.listView != null && AnnotationSetsView.this.listView.isActive() && AnnotationSetsView.this.listView.getGUI().isVisible() && (typeHandler = AnnotationSetsView.this.getTypeHandler(this.aHandler.set.getName(), this.aHandler.ann.getType())) != null) {
                AnnotationListView.AnnotationData annotationData = typeHandler.annListTagsForAnn.get(this.aHandler.ann.getId());
                AnnotationSetsView.this.listView.selectAnnotationForTag(annotationData);
            }
            AnnotationSetsView.this.annotationEditor.show(true);
        }
    }

    protected class HighlightMenuItem
    extends JMenuItem {
        int start;
        int end;
        Action action;
        Object highlight;

        public HighlightMenuItem(Action action, int n, int n2, JPopupMenu jPopupMenu) {
            super(action);
            this.start = n;
            this.end = n2;
            this.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    HighlightMenuItem.this.showHighlight();
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    HighlightMenuItem.this.removeHighlight();
                }
            });
            jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    HighlightMenuItem.this.removeHighlight();
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    HighlightMenuItem.this.removeHighlight();
                }
            });
        }

        protected void showHighlight() {
            try {
                this.highlight = AnnotationSetsView.this.textPane.getHighlighter().addHighlight(this.start, this.end, DefaultHighlighter.DefaultPainter);
            }
            catch (BadLocationException badLocationException) {
                throw new GateRuntimeException(badLocationException.toString());
            }
        }

        protected void removeHighlight() {
            if (this.highlight != null) {
                AnnotationSetsView.this.textPane.getHighlighter().removeHighlight(this.highlight);
                this.highlight = null;
            }
        }
    }

    protected class MouseStoppedMovingAction
    extends AbstractAction {
        int textLocation;

        protected MouseStoppedMovingAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AnnotationSetsView.this.textPane.getSelectionStart() <= this.textLocation && AnnotationSetsView.this.textPane.getSelectionEnd() >= this.textLocation) {
                new NewAnnotationAction().actionPerformed(actionEvent);
            } else {
                ArrayList<AnnotationHandler> arrayList = new ArrayList<AnnotationHandler>();
                for (SetHandler object : AnnotationSetsView.this.setHandlers) {
                    for (Annotation badLocationException : object.set.get(new Long(this.textLocation - 1), new Long(this.textLocation + 1))) {
                        TypeHandler typeHandler = object.getTypeHandler(badLocationException.getType());
                        if (object == null || !typeHandler.isSelected()) continue;
                        arrayList.add(new AnnotationHandler(object.set, badLocationException));
                    }
                }
                if (arrayList.size() > 0) {
                    if (arrayList.size() > 1) {
                        JPopupMenu jPopupMenu = new JPopupMenu();
                        for (AnnotationHandler annotationHandler : arrayList) {
                            jPopupMenu.add(new HighlightMenuItem(new EditAnnotationAction(annotationHandler), annotationHandler.ann.getStartNode().getOffset().intValue(), annotationHandler.ann.getEndNode().getOffset().intValue(), jPopupMenu));
                        }
                        try {
                            Rectangle rectangle = AnnotationSetsView.this.textPane.modelToView(this.textLocation);
                            jPopupMenu.show(AnnotationSetsView.this.textPane, rectangle.x + 10, rectangle.y);
                        }
                        catch (BadLocationException badLocationException) {
                            throw new GateRuntimeException(badLocationException);
                        }
                    } else {
                        new EditAnnotationAction((AnnotationHandler)arrayList.get(0)).actionPerformed(null);
                    }
                }
            }
        }

        public void setTextLocation(int n) {
            this.textLocation = n;
        }
    }

    protected class HandleDocumentEventsAction
    extends AbstractAction {
        boolean uiDirty = false;
        private static final int MAX_EVENTS = 300;

        protected HandleDocumentEventsAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.uiDirty) {
                this.rebuildDisplay();
                return;
            }
            AnnotationSetsView annotationSetsView = AnnotationSetsView.this;
            synchronized (annotationSetsView) {
                if (AnnotationSetsView.this.pendingEvents.size() > 300) {
                    this.rebuildDisplay();
                    return;
                }
                while (!AnnotationSetsView.this.pendingEvents.isEmpty()) {
                    TypeHandler typeHandler;
                    Object object;
                    Object object2;
                    GateEvent gateEvent;
                    GateEvent gateEvent2 = AnnotationSetsView.this.pendingEvents.remove();
                    if (gateEvent2 instanceof DocumentEvent) {
                        gateEvent = (DocumentEvent)gateEvent2;
                        if (gateEvent2.getType() == 101) {
                            object2 = ((DocumentEvent)gateEvent).getAnnotationSetName();
                            object = new SetHandler(AnnotationSetsView.this.document.getAnnotations((String)object2));
                            int n = 0;
                            if (object2 != null) {
                                for (n = 1; n < AnnotationSetsView.this.setHandlers.size() && AnnotationSetsView.this.setHandlers.get((int)n).set.getName().compareTo((String)object2) <= 0; ++n) {
                                }
                            }
                            AnnotationSetsView.this.setHandlers.add(n, (SetHandler)object);
                            int n2 = 0;
                            if (n > 0) {
                                SetHandler setHandler = AnnotationSetsView.this.setHandlers.get(n - 1);
                                while (AnnotationSetsView.this.tableRows.get(n2) != setHandler) {
                                    ++n2;
                                }
                                if (setHandler.isExpanded()) {
                                    n2 += setHandler.typeHandlers.size();
                                }
                                ++n2;
                            }
                            AnnotationSetsView.this.tableRows.add(n2, object);
                            AnnotationSetsView.this.tableModel.fireTableRowsInserted(n2, n2);
                            continue;
                        }
                        if (gateEvent2.getType() != 102 || (object = AnnotationSetsView.this.getSetHandler((String)(object2 = ((DocumentEvent)gateEvent).getAnnotationSetName()))) == null) continue;
                        ((SetHandler)object).set.removeAnnotationSetListener(AnnotationSetsView.this);
                        for (TypeHandler typeHandler2 : ((SetHandler)object).typeHandlers) {
                            typeHandler2.setSelected(false);
                        }
                        AnnotationSetsView.this.setHandlers.remove(object);
                        int n = AnnotationSetsView.this.tableRows.indexOf(object);
                        AnnotationSetsView.this.tableRows.remove(n);
                        int n3 = 1;
                        if (((SetHandler)object).isExpanded()) {
                            for (int i = 0; i < ((SetHandler)object).typeHandlers.size(); ++i) {
                                AnnotationSetsView.this.tableRows.remove(n);
                                ++n3;
                            }
                        }
                        AnnotationSetsView.this.tableModel.fireTableRowsDeleted(n, n + n3 - 1);
                        ((SetHandler)object).cleanup();
                        continue;
                    }
                    if (!(gateEvent2 instanceof AnnotationSetEvent)) continue;
                    gateEvent = (AnnotationSetEvent)gateEvent2;
                    object2 = (AnnotationSet)gateEvent.getSource();
                    object = ((AnnotationSetEvent)gateEvent).getAnnotation();
                    if (gateEvent2.getType() == 201) {
                        TypeHandler typeHandler3 = AnnotationSetsView.this.getTypeHandler(object2.getName(), object.getType());
                        if (typeHandler3 == null) {
                            SetHandler setHandler = AnnotationSetsView.this.getSetHandler(object2.getName());
                            typeHandler3 = setHandler.newType(object.getType());
                        }
                        typeHandler3.annotationAdded((Annotation)object);
                        continue;
                    }
                    if (gateEvent2.getType() != 202 || (typeHandler = AnnotationSetsView.this.getTypeHandler(object2.getName(), object.getType())) == null) continue;
                    typeHandler.annotationRemoved((Annotation)object);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void rebuildDisplay() {
            this.uiDirty = false;
            try {
                AnnotationSetsView annotationSetsView = AnnotationSetsView.this;
                synchronized (annotationSetsView) {
                    AnnotationSetsView.this.pendingEvents.clear();
                }
                AnnotationSetsView.this.storeSelectedTypes();
                for (SetHandler setHandler : AnnotationSetsView.this.setHandlers) {
                    setHandler.typeHandlers.clear();
                    setHandler.typeHandlersByType.clear();
                    setHandler.set.removeAnnotationSetListener(AnnotationSetsView.this);
                }
                AnnotationSetsView.this.setHandlers.clear();
                AnnotationSetsView.this.tableRows.clear();
                AnnotationSetsView.this.listView.removeAnnotations(AnnotationSetsView.this.listView.getAllAnnotations());
                AnnotationSetsView.this.populateUI();
                AnnotationSetsView.this.restoreSelectedTypes();
                AnnotationSetsView.this.tableModel.fireTableDataChanged();
            }
            catch (Throwable throwable) {
                this.uiDirty = true;
            }
        }
    }

    protected class SavePreserveFormatAction
    extends AbstractAction {
        public SavePreserveFormatAction() {
            super("Save preserving document format");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                public void run() {
                    JFileChooser jFileChooser = MainFrame.getFileChooser();
                    File file = null;
                    jFileChooser.setMultiSelectionEnabled(false);
                    jFileChooser.setFileSelectionMode(0);
                    jFileChooser.setDialogTitle("Select document to save ...");
                    jFileChooser.setSelectedFiles(null);
                    int n = jFileChooser.showDialog(AnnotationSetsView.this.owner, "Save");
                    if (n == 0) {
                        file = jFileChooser.getSelectedFile();
                        jFileChooser.setCurrentDirectory(jFileChooser.getCurrentDirectory());
                        if (file == null) {
                            return;
                        }
                        StatusListener statusListener = (StatusListener)MainFrame.getListeners().get("gate.event.StatusListener");
                        if (statusListener != null) {
                            statusListener.statusChanged("Please wait while dumping annotationsin the original format to " + file.toString() + " ...");
                        }
                        HashSet<Annotation> hashSet = new HashSet<Annotation>();
                        for (SetHandler object : AnnotationSetsView.this.setHandlers) {
                            for (TypeHandler typeHandler : object.typeHandlers) {
                                if (!typeHandler.isSelected()) continue;
                                hashSet.addAll(object.set.get(typeHandler.name));
                            }
                        }
                        try {
                            String exception = ((TextualDocument)AnnotationSetsView.this.document).getEncoding();
                            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), exception);
                            Boolean bl = Gate.getUserConfig().getBoolean("Save_features_when_preserving_format");
                            boolean bl2 = true;
                            if (bl != null) {
                                bl2 = bl;
                            }
                            outputStreamWriter.write(AnnotationSetsView.this.document.toXml(hashSet, bl2));
                            outputStreamWriter.flush();
                            outputStreamWriter.close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(Out.getPrintWriter());
                        }
                        if (statusListener != null) {
                            statusListener.statusChanged("Finished dumping into the file : " + file.toString());
                        }
                    }
                }
            };
            Thread thread = new Thread(runnable, "");
            thread.setPriority(1);
            thread.start();
        }
    }

    protected class NewAnnotationAction
    extends AbstractAction {
        protected NewAnnotationAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2 = AnnotationSetsView.this.textPane.getSelectionStart();
            if (n2 != (n = AnnotationSetsView.this.textPane.getSelectionEnd())) {
                AnnotationSetsView.this.textPane.setSelectionStart(n2);
                AnnotationSetsView.this.textPane.setSelectionEnd(n2);
                int n3 = AnnotationSetsView.this.mainTable.getSelectedRow();
                if (n3 < 0) {
                    n3 = 0;
                }
                while (!(AnnotationSetsView.this.tableRows.get(n3) instanceof SetHandler)) {
                    --n3;
                }
                AnnotationSet annotationSet = ((SetHandler)AnnotationSetsView.this.tableRows.get((int)n3)).set;
                try {
                    Integer n4 = annotationSet.add(new Long(n2), new Long(n), AnnotationSetsView.this.lastAnnotationType, Factory.newFeatureMap());
                    Annotation annotation = annotationSet.get(n4);
                    AnnotationSetsView.this.setTypeSelected(annotationSet.getName(), annotation.getType(), true);
                    AnnotationSetsView.this.annotationEditor.setAnnotation(annotation, annotationSet);
                    AnnotationSetsView.this.annotationEditor.show(true);
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    throw new GateRuntimeException(invalidOffsetException);
                }
            }
        }
    }

    protected class NewAnnotationSetAction
    extends AbstractAction {
        public NewAnnotationSetAction() {
            super("New");
            this.putValue("ShortDescription", "Creates a new annotation set");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = AnnotationSetsView.this.newSetNameTextField.getText();
            AnnotationSetsView.this.newSetNameTextField.setText("");
            if (string != null && string.length() > 0) {
                AnnotationSet annotationSet = AnnotationSetsView.this.document.getAnnotations(string);
                Iterator iterator = AnnotationSetsView.this.tableRows.iterator();
                int n = -1;
                for (int i = 0; i < AnnotationSetsView.this.tableRows.size() && n < 0; ++i) {
                    if (!(AnnotationSetsView.this.tableRows.get(i) instanceof SetHandler) || ((SetHandler)AnnotationSetsView.this.tableRows.get((int)i)).set != annotationSet) continue;
                    n = i;
                }
                if (n >= 0) {
                    AnnotationSetsView.this.mainTable.getSelectionModel().setSelectionInterval(n, n);
                }
            }
        }
    }

    protected class TextMouseListener
    implements MouseInputListener {
        protected TextMouseListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            AnnotationSetsView.this.mouseMovementTimer.stop();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiersEx();
            if ((n & 0x80) != 0) {
                AnnotationSetsView.this.mouseMovementTimer.stop();
                return;
            }
            if ((n & 0x400) != 0) {
                AnnotationSetsView.this.mouseMovementTimer.stop();
                return;
            }
            AnnotationSetsView.this.mouseStoppedMovingAction.setTextLocation(AnnotationSetsView.this.textPane.viewToModel(mouseEvent.getPoint()));
            AnnotationSetsView.this.mouseMovementTimer.restart();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            AnnotationSetsView.this.mouseMovementTimer.stop();
        }
    }

    protected static class AnnotationHandler {
        Annotation ann;
        AnnotationSet set;

        public AnnotationHandler(AnnotationSet annotationSet, Annotation annotation) {
            this.ann = annotation;
            this.set = annotationSet;
        }
    }

    private static class TypeSpec {
        private String setName;
        private String type;

        public TypeSpec(String string, String string2) {
            this.setName = string;
            this.type = string2;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.setName == null ? 0 : this.setName.hashCode());
            n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            TypeSpec typeSpec = (TypeSpec)object;
            if (this.setName == null ? typeSpec.setName != null : !this.setName.equals(typeSpec.setName)) {
                return false;
            }
            return !(this.type == null ? typeSpec.type != null : !this.type.equals(typeSpec.type));
        }
    }

    protected class TypeHandler {
        ChangeColourAction changeColourAction;
        boolean selected;
        Map hghltTagsForAnn;
        Map<Integer, AnnotationListView.AnnotationData> annListTagsForAnn;
        String name;
        SetHandler setHandler;
        Color colour;
        int annotationCount;

        TypeHandler(SetHandler setHandler, String string) {
            this.setHandler = setHandler;
            this.name = string;
            this.colour = AnnotationSetsView.this.getColor(string);
            this.hghltTagsForAnn = new HashMap();
            this.annListTagsForAnn = new HashMap<Integer, AnnotationListView.AnnotationData>();
            this.changeColourAction = new ChangeColourAction();
            this.annotationCount = 0;
        }

        public void setColour(Color color) {
            int n;
            if (this.colour.equals(color)) {
                return;
            }
            this.colour = color;
            AnnotationSetsView.this.saveColor(this.name, color);
            if (this.isSelected()) {
                AnnotationSetsView.this.textView.removeHighlights(this.hghltTagsForAnn.values());
                this.hghltTagsForAnn.clear();
                ArrayList<Annotation> arrayList = new ArrayList<Annotation>(this.setHandler.set.get(this.name));
                List list = AnnotationSetsView.this.textView.addHighlights(arrayList, this.setHandler.set, this.colour);
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.hghltTagsForAnn.put(((Annotation)arrayList.get(i)).getId(), list.get(i));
                }
            }
            if ((n = AnnotationSetsView.this.tableRows.indexOf(this)) >= 0) {
                AnnotationSetsView.this.tableModel.fireTableRowsUpdated(n, n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSelected(boolean bl) {
            if (this.selected == bl) {
                return;
            }
            this.selected = bl;
            ArrayList<Annotation> arrayList = new ArrayList<Annotation>(this.setHandler.set.get(this.name));
            if (bl) {
                this.setHandler.setExpanded(true);
                this.hghltTagsForAnn.clear();
                List list = AnnotationSetsView.this.textView.addHighlights(arrayList, this.setHandler.set, this.colour);
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.hghltTagsForAnn.put(((Annotation)arrayList.get(i)).getId(), list.get(i));
                }
                this.annListTagsForAnn.clear();
                List<AnnotationListView.AnnotationData> list2 = AnnotationSetsView.this.listView.addAnnotations(arrayList, this.setHandler.set);
                for (AnnotationListView.AnnotationData annotationData : list2) {
                    this.annListTagsForAnn.put(annotationData.ann.getId(), annotationData);
                }
            } else {
                try {
                    AnnotationSetsView.this.textView.removeHighlights(this.hghltTagsForAnn.values());
                    AnnotationSetsView.this.listView.removeAnnotations(this.annListTagsForAnn.values());
                }
                finally {
                    this.hghltTagsForAnn.clear();
                    this.annListTagsForAnn.clear();
                }
            }
            int n = AnnotationSetsView.this.tableRows.indexOf(this);
            AnnotationSetsView.this.tableModel.fireTableRowsUpdated(n, n);
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void annotationAdded(Annotation annotation) {
            ++this.annotationCount;
            if (this.selected) {
                if (!this.hghltTagsForAnn.containsKey(annotation.getId())) {
                    this.hghltTagsForAnn.put(annotation.getId(), AnnotationSetsView.this.textView.addHighlight(annotation, this.setHandler.set, this.colour));
                }
                if (!this.annListTagsForAnn.containsKey(annotation.getId())) {
                    this.annListTagsForAnn.put(annotation.getId(), AnnotationSetsView.this.listView.addAnnotation(annotation, this.setHandler.set));
                }
            }
        }

        public void annotationRemoved(Annotation annotation) {
            --this.annotationCount;
            if (this.selected) {
                Object v = this.hghltTagsForAnn.remove(annotation.getId());
                if (v != null) {
                    AnnotationSetsView.this.textView.removeHighlight(v);
                }
                AnnotationListView.AnnotationData annotationData = this.annListTagsForAnn.remove(annotation.getId());
                if (v != null) {
                    AnnotationSetsView.this.listView.removeAnnotation(annotationData);
                }
            }
            if (this.annotationCount == 0) {
                this.setHandler.removeType(this);
            }
        }

        protected void repairHighlights(int n, int n2) {
            ArrayList arrayList = new ArrayList(this.hghltTagsForAnn.size());
            ArrayList<Annotation> arrayList2 = new ArrayList<Annotation>(this.hghltTagsForAnn.size());
            Iterator iterator = this.hghltTagsForAnn.keySet().iterator();
            while (iterator.hasNext()) {
                Annotation annotation = this.setHandler.set.get((Integer)iterator.next());
                int n3 = annotation.getStartNode().getOffset().intValue();
                int n4 = annotation.getEndNode().getOffset().intValue();
                if ((n3 > n || n > n4) && (n > n3 || n3 > n2)) continue;
                if (!this.hghltTagsForAnn.containsKey(annotation.getId())) {
                    System.out.println("Error!!!");
                }
                arrayList.add(this.hghltTagsForAnn.get(annotation.getId()));
                arrayList2.add(annotation);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                Object e = arrayList.get(i);
                Annotation annotation = (Annotation)arrayList2.get(i);
                try {
                    AnnotationSetsView.this.textView.moveHighlight(e, annotation.getStartNode().getOffset().intValue(), annotation.getEndNode().getOffset().intValue());
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        protected class ChangeColourAction
        extends AbstractAction {
            public ChangeColourAction() {
                super("Change colour");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(AnnotationSetsView.this.mainTable, "Select colour for \"" + TypeHandler.this.name + "\"", TypeHandler.this.colour);
                if (color != null) {
                    Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
                    TypeHandler.this.setColour(color2);
                }
            }
        }
    }

    protected class SetHandler {
        AnnotationSet set;
        List<TypeHandler> typeHandlers;
        Map typeHandlersByType;
        private boolean expanded = false;

        SetHandler(AnnotationSet annotationSet) {
            this.set = annotationSet;
            this.typeHandlers = new ArrayList<TypeHandler>();
            this.typeHandlersByType = new HashMap();
            ArrayList<String> arrayList = new ArrayList<String>(annotationSet.getAllTypes());
            Collections.sort(arrayList);
            for (String string : arrayList) {
                TypeHandler typeHandler = new TypeHandler(this, string);
                typeHandler.annotationCount = annotationSet.get(string).size();
                this.typeHandlers.add(typeHandler);
                this.typeHandlersByType.put(string, typeHandler);
            }
            annotationSet.addAnnotationSetListener(AnnotationSetsView.this);
        }

        public void cleanup() {
            this.set.removeAnnotationSetListener(AnnotationSetsView.this);
            this.typeHandlers.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TypeHandler newType(String string) {
            int n;
            TypeHandler typeHandler = new TypeHandler(this, string);
            for (n = 0; n < this.typeHandlers.size() && this.typeHandlers.get((int)n).name.compareTo(string) <= 0; ++n) {
            }
            this.typeHandlers.add(n, typeHandler);
            this.typeHandlersByType.put(string, typeHandler);
            int n2 = AnnotationSetsView.this.mainTable.getSelectedRow();
            int n3 = AnnotationSetsView.this.tableRows.indexOf(this);
            if (this.typeHandlers.size() == 1) {
                AnnotationSetsView.this.tableModel.fireTableRowsUpdated(n3, n3);
            }
            if (this.expanded) {
                AnnotationSetsView.this.tableRows.add(n3 + n + 1, typeHandler);
                AnnotationSetsView.this.tableModel.fireTableRowsInserted(n3 + n + 1, n3 + n + 1);
            }
            if (n2 != -1) {
                AnnotationSetsView.this.mainTable.getSelectionModel().setSelectionInterval(n2, n2);
            }
            TypeSpec typeSpec = new TypeSpec(this.set.getName(), string);
            AnnotationSetsView annotationSetsView = AnnotationSetsView.this;
            synchronized (annotationSetsView) {
                if (AnnotationSetsView.this.visibleAnnotationTypes.remove(typeSpec)) {
                    typeHandler.setSelected(true);
                }
            }
            return typeHandler;
        }

        public void removeType(TypeHandler typeHandler) {
            int n = AnnotationSetsView.this.tableRows.indexOf(this);
            int n2 = this.typeHandlers.indexOf(typeHandler);
            if (n != -1 && n2 != -1) {
                this.typeHandlers.remove(n2);
                this.typeHandlersByType.remove(typeHandler.name);
                int n3 = AnnotationSetsView.this.mainTable.getSelectedRow();
                if (this.expanded) {
                    AnnotationSetsView.this.tableRows.remove(n + n2 + 1);
                    AnnotationSetsView.this.tableModel.fireTableRowsDeleted(n + n2 + 1, n + n2 + 1);
                }
                if (this.typeHandlers.isEmpty()) {
                    this.setExpanded(false);
                    AnnotationSetsView.this.tableModel.fireTableRowsUpdated(n, n);
                }
                if (n3 != -1) {
                    if (AnnotationSetsView.this.mainTable.getRowCount() <= n3) {
                        n3 = AnnotationSetsView.this.mainTable.getRowCount() - 1;
                    }
                    AnnotationSetsView.this.mainTable.getSelectionModel().setSelectionInterval(n3, n3);
                }
            }
        }

        public void removeType(String string) {
            this.removeType((TypeHandler)this.typeHandlersByType.get(string));
        }

        public TypeHandler getTypeHandler(String string) {
            return (TypeHandler)this.typeHandlersByType.get(string);
        }

        public void setExpanded(boolean bl) {
            if (this.expanded == bl) {
                return;
            }
            this.expanded = bl;
            int n = AnnotationSetsView.this.tableRows.indexOf(this);
            if (bl) {
                AnnotationSetsView.this.tableRows.addAll(n + 1, this.typeHandlers);
                AnnotationSetsView.this.tableModel.fireTableRowsInserted(n + 1, n + 1 + this.typeHandlers.size());
            } else {
                for (int i = 0; i < this.typeHandlers.size(); ++i) {
                    AnnotationSetsView.this.tableRows.remove(n + 1);
                }
                AnnotationSetsView.this.tableModel.fireTableRowsDeleted(n + 1, n + 1 + this.typeHandlers.size());
            }
            AnnotationSetsView.this.tableModel.fireTableRowsUpdated(n, n);
        }

        public boolean isExpanded() {
            return this.expanded;
        }
    }

    protected class SetsTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JCheckBox currentChk;
        JCheckBox setChk = new JCheckBox();
        JCheckBox typeChk;

        public SetsTableCellEditor() {
            this.setChk.setSelectedIcon(MainFrame.getIcon("expanded"));
            this.setChk.setIcon(MainFrame.getIcon("closed"));
            this.setChk.setOpaque(true);
            this.setChk.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SetsTableCellEditor.this.fireEditingStopped();
                }
            });
            this.typeChk = new JCheckBox();
            this.typeChk.setOpaque(false);
            this.typeChk.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SetsTableCellEditor.this.fireEditingStopped();
                }
            });
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            object = AnnotationSetsView.this.tableRows.get(n);
            if (object instanceof SetHandler) {
                SetHandler setHandler = (SetHandler)object;
                switch (n2) {
                    case 1: {
                        return null;
                    }
                    case 0: {
                        this.setChk.setSelected(setHandler.isExpanded());
                        this.setChk.setEnabled(setHandler.typeHandlers.size() > 0);
                        this.setChk.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
                        this.currentChk = this.setChk;
                        return this.setChk;
                    }
                }
            } else if (object instanceof TypeHandler) {
                TypeHandler typeHandler = (TypeHandler)object;
                switch (n2) {
                    case 1: {
                        return null;
                    }
                    case 0: {
                        this.typeChk.setSelected(typeHandler.isSelected());
                        this.currentChk = this.typeChk;
                        return this.typeChk;
                    }
                }
            }
            return null;
        }

        public boolean stopCellEditing() {
            return true;
        }

        public Object getCellEditorValue() {
            return new Boolean(this.currentChk.isSelected());
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }
    }

    protected class SetsTableCellRenderer
    implements TableCellRenderer {
        protected JLabel typeLabel = new JLabel(){

            public void repaint(long l, int n, int n2, int n3, int n4) {
            }

            public void repaint(Rectangle rectangle) {
            }

            public void validate() {
            }

            public void revalidate() {
            }

            protected void firePropertyChange(String string, Object object, Object object2) {
            }
        };
        protected JLabel setLabel;
        protected JCheckBox setChk;
        protected JCheckBox typeChk;
        protected Border selectedBorder;
        protected Border normalBorder;

        public SetsTableCellRenderer() {
            this.typeLabel.setOpaque(true);
            this.typeLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 5, 0, 0, AnnotationSetsView.this.mainTable.getBackground()), BorderFactory.createEmptyBorder(0, 5, 0, 5)));
            this.setLabel = new JLabel(){

                public void repaint(long l, int n, int n2, int n3, int n4) {
                }

                public void repaint(Rectangle rectangle) {
                }

                public void validate() {
                }

                public void revalidate() {
                }

                protected void firePropertyChange(String string, Object object, Object object2) {
                }
            };
            this.setLabel.setOpaque(true);
            this.setLabel.setFont(this.setLabel.getFont().deriveFont(1));
            this.setLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            this.typeChk = new JCheckBox(){

                public void repaint(long l, int n, int n2, int n3, int n4) {
                }

                public void repaint(Rectangle rectangle) {
                }

                public void validate() {
                }

                public void revalidate() {
                }

                protected void firePropertyChange(String string, Object object, Object object2) {
                }
            };
            this.typeChk.setOpaque(true);
            this.setChk = new JCheckBox(){

                public void repaint(long l, int n, int n2, int n3, int n4) {
                }

                public void repaint(Rectangle rectangle) {
                }

                public void validate() {
                }

                public void revalidate() {
                }

                protected void firePropertyChange(String string, Object object, Object object2) {
                }
            };
            this.setChk.setSelectedIcon(MainFrame.getIcon("expanded"));
            this.setChk.setIcon(MainFrame.getIcon("closed"));
            this.setChk.setMaximumSize(this.setChk.getMinimumSize());
            this.setChk.setOpaque(true);
            this.normalBorder = BorderFactory.createLineBorder(AnnotationSetsView.this.mainTable.getBackground(), 2);
            this.selectedBorder = BorderFactory.createLineBorder(AnnotationSetsView.this.mainTable.getSelectionBackground(), 2);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            object = AnnotationSetsView.this.tableRows.get(n);
            if (object instanceof SetHandler) {
                SetHandler setHandler = (SetHandler)object;
                switch (n2) {
                    case 1: {
                        this.setLabel.setText(setHandler.set.getName());
                        this.setLabel.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
                        return this.setLabel;
                    }
                    case 0: {
                        this.setChk.setSelected(setHandler.isExpanded());
                        this.setChk.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
                        this.setChk.setEnabled(setHandler.typeHandlers.size() > 0);
                        return this.setChk;
                    }
                }
            } else if (object instanceof TypeHandler) {
                TypeHandler typeHandler = (TypeHandler)object;
                switch (n2) {
                    case 1: {
                        this.typeLabel.setBackground(typeHandler.colour);
                        this.typeLabel.setText(typeHandler.name);
                        this.typeLabel.setBorder(bl ? this.selectedBorder : this.normalBorder);
                        return this.typeLabel;
                    }
                    case 0: {
                        this.typeChk.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
                        this.typeChk.setSelected(typeHandler.isSelected());
                        return this.typeChk;
                    }
                }
            }
            this.typeLabel.setText("?");
            return this.typeLabel;
        }
    }

    protected class SetsTableModel
    extends AbstractTableModel {
        protected SetsTableModel() {
        }

        public int getRowCount() {
            return AnnotationSetsView.this.tableRows.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int n, int n2) {
            Object e = AnnotationSetsView.this.tableRows.get(n);
            switch (n2) {
                case 1: {
                    return e;
                }
                case 0: {
                    if (e instanceof SetHandler) {
                        return new Boolean(((SetHandler)e).isExpanded());
                    }
                    if (!(e instanceof TypeHandler)) break;
                    return new Boolean(((TypeHandler)e).isSelected());
                }
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            Object e = AnnotationSetsView.this.tableRows.get(n);
            switch (n2) {
                case 1: {
                    return false;
                }
                case 0: {
                    if (e instanceof SetHandler) {
                        return ((SetHandler)e).typeHandlers.size() > 0;
                    }
                    if (!(e instanceof TypeHandler)) break;
                    return true;
                }
            }
            return n2 == 0;
        }

        public void setValueAt(Object object, int n, int n2) {
            Object e = AnnotationSetsView.this.tableRows.get(n);
            switch (n2) {
                case 0: {
                    if (e instanceof SetHandler) {
                        ((SetHandler)e).setExpanded((Boolean)object);
                        break;
                    }
                    if (!(e instanceof TypeHandler)) break;
                    ((TypeHandler)e).setSelected((Boolean)object);
                    break;
                }
            }
        }
    }
}

