/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.docview;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.creole.AnnotationVisualResource;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.event.AnnotationEvent;
import gate.event.AnnotationListener;
import gate.gui.docview.AbstractDocumentView;
import gate.gui.docview.DocumentView;
import gate.gui.docview.TextualDocumentView;
import gate.swing.XJTable;
import gate.util.Err;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationListView
extends AbstractDocumentView
implements AnnotationListener {
    protected XJTable table;
    protected AnnotationTableModel tableModel;
    protected JScrollPane scroller;
    protected List<AnnotationData> annDataList = new ArrayList<AnnotationData>();
    protected JPanel mainPanel;
    protected JLabel statusLabel;
    protected TextualDocumentView textView;
    protected Map editorsCache;
    private static final int TYPE_COL = 0;
    private static final int SET_COL = 1;
    private static final int START_COL = 2;
    private static final int END_COL = 3;
    private static final int FEATURES_COL = 4;

    @Override
    public void cleanup() {
        super.cleanup();
        for (AnnotationData annotationData : this.annDataList) {
            annotationData.ann.removeAnnotationListener(this);
        }
        this.annDataList.clear();
        this.textView = null;
    }

    @Override
    protected void initGUI() {
        this.editorsCache = new HashMap();
        this.tableModel = new AnnotationTableModel();
        this.table = new XJTable(this.tableModel);
        this.table.setAutoResizeMode(0);
        this.table.setSortable(true);
        this.table.setSortedColumn(2);
        this.table.setIntercellSpacing(new Dimension(2, 0));
        Color color = this.table.getBackground();
        color = new Color(color.getRGB());
        this.table.setBackground(color);
        this.scroller = new JScrollPane(this.table);
        this.scroller.getViewport().setOpaque(true);
        this.scroller.getViewport().setBackground(color);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mainPanel.add((Component)this.scroller, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.statusLabel = new JLabel();
        this.mainPanel.add((Component)this.statusLabel, gridBagConstraints);
        Iterator iterator = this.owner.getCentralViews().iterator();
        while (this.textView == null && iterator.hasNext()) {
            DocumentView documentView = (DocumentView)iterator.next();
            if (!(documentView instanceof TextualDocumentView)) continue;
            this.textView = (TextualDocumentView)documentView;
        }
        this.initListeners();
    }

    @Override
    public Component getGUI() {
        return this.mainPanel;
    }

    protected void initListeners() {
        this.tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                AnnotationListView.this.statusLabel.setText(Integer.toString(AnnotationListView.this.tableModel.getRowCount()) + " Annotations (" + Integer.toString(AnnotationListView.this.table.getSelectedRowCount()) + " selected)");
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!AnnotationListView.this.isActive()) {
                    return;
                }
                AnnotationListView.this.statusLabel.setText(Integer.toString(AnnotationListView.this.tableModel.getRowCount()) + " Annotations (" + Integer.toString(AnnotationListView.this.table.getSelectedRowCount()) + "selected)");
                AnnotationListView.this.textView.removeAllBlinkingHighlights();
                AnnotationListView.this.showHighlights();
            }
        });
        this.table.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            protected void processMouseEvent(MouseEvent mouseEvent) {
                int n;
                int n2 = AnnotationListView.this.table.rowAtPoint(mouseEvent.getPoint());
                int n3 = n = n2 == -1 ? n2 : AnnotationListView.this.table.rowViewToModel(n2);
                if (mouseEvent.isPopupTrigger()) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    AbstractAction abstractAction = new AbstractAction("Delete"){

                        public void actionPerformed(ActionEvent actionEvent) {
                            int[] nArray = AnnotationListView.this.table.getSelectedRows();
                            AnnotationListView.this.table.clearSelection();
                            if (nArray == null || nArray.length == 0) {
                                if (n == -1) {
                                    return;
                                }
                                nArray = new int[]{n};
                            }
                            for (int i = 0; i < nArray.length; ++i) {
                                AnnotationData annotationData = AnnotationListView.this.annDataList.get(AnnotationListView.this.table.rowViewToModel(nArray[i]));
                                annotationData.set.remove(annotationData.ann);
                            }
                        }
                    };
                    jPopupMenu.add(abstractAction);
                    if (n != -1) {
                        AnnotationData annotationData = AnnotationListView.this.annDataList.get(n);
                        List<String> list = Gate.getCreoleRegister().getAnnotationVRs(annotationData.ann.getType());
                        if (list != null && list.size() > 0) {
                            jPopupMenu.addSeparator();
                            for (String string : list) {
                                AnnotationVisualResource annotationVisualResource = (AnnotationVisualResource)AnnotationListView.this.editorsCache.get(string);
                                if (annotationVisualResource == null) {
                                    try {
                                        annotationVisualResource = (AnnotationVisualResource)Factory.createResource(string);
                                        AnnotationListView.this.editorsCache.put(string, annotationVisualResource);
                                    }
                                    catch (ResourceInstantiationException resourceInstantiationException) {
                                        resourceInstantiationException.printStackTrace(Err.getPrintWriter());
                                    }
                                }
                                jPopupMenu.add(new EditAnnotationAction(annotationData.set, annotationData.ann, annotationVisualResource));
                            }
                        }
                    }
                    jPopupMenu.show(AnnotationListView.this.table, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    @Override
    protected void registerHooks() {
        this.showHighlights();
    }

    @Override
    protected void unregisterHooks() {
        this.textView.removeAllBlinkingHighlights();
    }

    @Override
    public int getType() {
        return 2;
    }

    protected void guiShown() {
        this.tableModel.fireTableDataChanged();
    }

    protected void showHighlights() {
        int[] nArray = this.table.getSelectedRows();
        AnnotationData annotationData = null;
        for (int i = 0; i < nArray.length; ++i) {
            annotationData = this.annDataList.get(this.table.rowViewToModel(nArray[i]));
            this.textView.addBlinkingHighlight(annotationData.ann);
        }
        if (annotationData != null && annotationData.ann != null) {
            this.textView.scrollAnnotationToVisible(annotationData.ann);
        }
    }

    public AnnotationData addAnnotation(Annotation annotation, AnnotationSet annotationSet) {
        AnnotationData annotationData = new AnnotationData(annotationSet, annotation);
        this.annDataList.add(annotationData);
        int n = this.annDataList.size() - 1;
        if (this.tableModel != null) {
            this.tableModel.fireTableRowsInserted(n, n);
        }
        annotationData.ann.addAnnotationListener(this);
        return annotationData;
    }

    public void removeAnnotation(AnnotationData annotationData) {
        int n = this.annDataList.indexOf(annotationData);
        if (n >= 0) {
            int n2;
            if (this.table != null && this.table.isRowSelected(n2 = this.table.rowModelToView(n))) {
                this.table.getSelectionModel().removeIndexInterval(n2, n2);
            }
            AnnotationData annotationData2 = this.annDataList.get(n);
            annotationData2.ann.removeAnnotationListener(this);
            this.annDataList.remove(n);
            if (this.tableModel != null) {
                this.tableModel.fireTableRowsDeleted(n, n);
            }
        }
    }

    public void removeAnnotations(Collection<AnnotationData> collection) {
        for (AnnotationData annotationData : collection) {
            this.removeAnnotation(annotationData);
        }
    }

    public List<AnnotationData> addAnnotations(List<Annotation> list, AnnotationSet annotationSet) {
        ArrayList<AnnotationData> arrayList = new ArrayList<AnnotationData>();
        for (Annotation object : list) {
            arrayList.add(new AnnotationData(annotationSet, object));
        }
        this.annDataList.addAll(arrayList);
        for (AnnotationData annotationData : arrayList) {
            annotationData.ann.addAnnotationListener(this);
        }
        if (this.tableModel != null) {
            this.tableModel.fireTableDataChanged();
        }
        return arrayList;
    }

    public List<AnnotationData> getAllAnnotations() {
        return this.annDataList;
    }

    @Override
    public void annotationUpdated(AnnotationEvent annotationEvent) {
        int n;
        if (this.table == null) {
            return;
        }
        int[] nArray = this.table.getSelectedRows();
        Annotation annotation = (Annotation)annotationEvent.getSource();
        if (this.tableModel != null) {
            for (n = 0; n < this.annDataList.size(); ++n) {
                AnnotationData annotationData = this.annDataList.get(n);
                if (annotationData.ann != annotation) continue;
                this.tableModel.fireTableRowsUpdated(n, n);
            }
        }
        this.table.clearSelection();
        if (nArray != null) {
            for (n = 0; n < nArray.length; ++n) {
                this.table.getSelectionModel().addSelectionInterval(nArray[n], nArray[n]);
            }
        }
    }

    public void selectAnnotationForTag(Object object) {
        int n = this.annDataList.indexOf(object);
        if (n != -1) {
            int n2 = this.table.rowModelToView(n);
            this.table.getSelectionModel().setSelectionInterval(n2, n2);
            this.table.scrollRectToVisible(this.table.getCellRect(n2, 0, false));
        }
    }

    protected class EditAnnotationAction
    extends AbstractAction {
        String title;
        Annotation ann;
        AnnotationSet set;
        AnnotationVisualResource editor;

        public EditAnnotationAction(AnnotationSet annotationSet, Annotation annotation, AnnotationVisualResource annotationVisualResource) {
            this.set = annotationSet;
            this.ann = annotation;
            this.editor = annotationVisualResource;
            ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get(annotationVisualResource.getClass().getName());
            if (resourceData != null) {
                this.title = resourceData.getName();
                this.putValue("Name", "Edit with " + this.title);
                this.putValue("ShortDescription", resourceData.getComment());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.editor));
            this.editor.setTarget(this.set);
            this.editor.setAnnotation(this.ann);
            JOptionPane jOptionPane = new JOptionPane(jScrollPane, 3, 2, null, new String[]{"OK", "Cancel"});
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            jScrollPane.setMaximumSize(new Dimension((int)((double)dimension.width * 0.75), (int)((double)dimension.height * 0.75)));
            JDialog jDialog = jOptionPane.createDialog(AnnotationListView.this.getGUI(), this.title);
            jDialog.setModal(true);
            jDialog.setResizable(true);
            jDialog.setVisible(true);
            try {
                if (jOptionPane.getValue().equals("OK")) {
                    this.editor.okAction();
                } else {
                    this.editor.cancelAction();
                }
            }
            catch (GateException gateException) {
                throw new GateRuntimeException(gateException);
            }
        }
    }

    public static class AnnotationData {
        Annotation ann;
        AnnotationSet set;

        public AnnotationData(AnnotationSet annotationSet, Annotation annotation) {
            this.ann = annotation;
            this.set = annotationSet;
        }
    }

    class AnnotationTableModel
    extends AbstractTableModel {
        AnnotationTableModel() {
        }

        public int getRowCount() {
            return AnnotationListView.this.annDataList.size();
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Type";
                }
                case 1: {
                    return "Set";
                }
                case 2: {
                    return "Start";
                }
                case 3: {
                    return "End";
                }
                case 4: {
                    return "Features";
                }
            }
            return "?";
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Long.class;
                }
                case 3: {
                    return Long.class;
                }
                case 4: {
                    return String.class;
                }
            }
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Object getValueAt(int n, int n2) {
            if (n >= AnnotationListView.this.annDataList.size()) {
                return null;
            }
            AnnotationData annotationData = AnnotationListView.this.annDataList.get(n);
            switch (n2) {
                case 0: {
                    return annotationData.ann.getType();
                }
                case 1: {
                    return annotationData.set.getName();
                }
                case 2: {
                    return annotationData.ann.getStartNode().getOffset();
                }
                case 3: {
                    return annotationData.ann.getEndNode().getOffset();
                }
                case 4: {
                    FeatureMap featureMap = annotationData.ann.getFeatures();
                    ArrayList arrayList = new ArrayList(featureMap.keySet());
                    Collections.sort(arrayList);
                    StringBuffer stringBuffer = new StringBuffer("{");
                    Iterator iterator = arrayList.iterator();
                    boolean bl = true;
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        Object v = featureMap.get(e);
                        if (bl) {
                            bl = false;
                        } else {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(e.toString());
                        stringBuffer.append("=");
                        stringBuffer.append(v == null ? "[null]" : v.toString());
                    }
                    stringBuffer.append("}");
                    return stringBuffer.toString();
                }
            }
            return "?";
        }
    }
}

