/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.docview;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Gate;
import gate.LanguageResource;
import gate.Resource;
import gate.creole.AnnotationSchema;
import gate.creole.ResourceInstantiationException;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.gui.FeaturesSchemaEditor;
import gate.gui.MainFrame;
import gate.gui.docview.AnnotationSetsView;
import gate.gui.docview.TextualDocumentView;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;

public class AnnotationEditor {
    protected JWindow bottomWindow;
    protected JComboBox typeCombo;
    protected FeaturesSchemaEditor featuresEditor;
    protected JScrollPane scroller;
    protected StartOffsetLeftAction solAction;
    protected StartOffsetRightAction sorAction;
    protected EndOffsetLeftAction eolAction;
    protected EndOffsetRightAction eorAction;
    protected DismissAction dismissAction;
    protected DeleteAnnotationAction delAction;
    protected Timer hideTimer;
    protected static final int HIDE_DELAY = 1500;
    protected static final int SHIFT_INCREMENT = 5;
    protected static final int CTRL_SHIFT_INCREMENT = 10;
    protected Object highlight;
    protected Map schemasByType;
    protected TextualDocumentView textView;
    protected AnnotationSetsView setsView;
    protected JTextArea textPane;
    protected Annotation ann;
    protected AnnotationSet set;

    public AnnotationEditor(TextualDocumentView textualDocumentView, AnnotationSetsView annotationSetsView) {
        this.textView = textualDocumentView;
        this.textPane = (JTextArea)((JScrollPane)textualDocumentView.getGUI()).getViewport().getView();
        this.setsView = annotationSetsView;
        this.initGUI();
    }

    protected void initData() {
        this.schemasByType = new HashMap();
        List<LanguageResource> list = Gate.getCreoleRegister().getLrInstances("gate.creole.AnnotationSchema");
        for (AnnotationSchema annotationSchema : list) {
            this.schemasByType.put(annotationSchema.getAnnotationName(), annotationSchema);
        }
        CreoleListener creoleListener = new CreoleListener(){

            public void resourceLoaded(CreoleEvent creoleEvent) {
                Resource resource = creoleEvent.getResource();
                if (resource instanceof AnnotationSchema) {
                    AnnotationSchema annotationSchema = (AnnotationSchema)resource;
                    AnnotationEditor.this.schemasByType.put(annotationSchema.getAnnotationName(), annotationSchema);
                }
            }

            public void resourceUnloaded(CreoleEvent creoleEvent) {
                AnnotationSchema annotationSchema;
                Resource resource = creoleEvent.getResource();
                if (resource instanceof AnnotationSchema && AnnotationEditor.this.schemasByType.containsValue(annotationSchema = (AnnotationSchema)resource)) {
                    AnnotationEditor.this.schemasByType.remove(annotationSchema.getAnnotationName());
                }
            }

            public void datastoreOpened(CreoleEvent creoleEvent) {
            }

            public void datastoreCreated(CreoleEvent creoleEvent) {
            }

            public void datastoreClosed(CreoleEvent creoleEvent) {
            }

            public void resourceRenamed(Resource resource, String string, String string2) {
            }
        };
        Gate.getCreoleRegister().addCreoleListener(creoleListener);
    }

    protected void initBottomWindow(Window window) {
        this.bottomWindow = new JWindow(window);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBackground(UIManager.getLookAndFeelDefaults().getColor("ToolTip.background"));
        this.bottomWindow.setContentPane(jPanel);
        Insets insets = new Insets(0, 0, 0, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = insets;
        JButton jButton = new JButton(this.solAction);
        jButton.setContentAreaFilled(false);
        jButton.setBorderPainted(false);
        jButton.setMargin(insets);
        jPanel.add((Component)jButton, gridBagConstraints);
        jButton = new JButton(this.sorAction);
        jButton.setContentAreaFilled(false);
        jButton.setBorderPainted(false);
        jButton.setMargin(insets);
        jPanel.add((Component)jButton, gridBagConstraints);
        jButton = new JButton(this.delAction);
        jButton.setContentAreaFilled(false);
        jButton.setBorderPainted(false);
        jButton.setMargin(insets);
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.insets = insets;
        jButton = new JButton(this.eolAction);
        jButton.setContentAreaFilled(false);
        jButton.setBorderPainted(false);
        jButton.setMargin(insets);
        jPanel.add((Component)jButton, gridBagConstraints);
        jButton = new JButton(this.eorAction);
        jButton.setContentAreaFilled(false);
        jButton.setBorderPainted(false);
        jButton.setMargin(insets);
        jPanel.add((Component)jButton, gridBagConstraints);
        this.dismissAction = new DismissAction();
        jButton = new JButton(this.dismissAction);
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        jButton.setBorder(null);
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = insets;
        this.typeCombo = new JComboBox();
        this.typeCombo.setEditable(true);
        this.typeCombo.setBackground(UIManager.getLookAndFeelDefaults().getColor("ToolTip.background"));
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 2, 2, 2);
        jPanel.add((Component)this.typeCombo, gridBagConstraints);
        this.featuresEditor = new FeaturesSchemaEditor();
        this.featuresEditor.setBackground(UIManager.getLookAndFeelDefaults().getColor("ToolTip.background"));
        try {
            this.featuresEditor.init();
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            throw new GateRuntimeException(resourceInstantiationException);
        }
        this.scroller = new JScrollPane(this.featuresEditor.getTable());
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.scroller, gridBagConstraints);
    }

    protected void initListeners() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                AnnotationEditor.this.hideTimer.stop();
            }
        };
        this.bottomWindow.getRootPane().addMouseListener(mouseAdapter);
        ((JComponent)this.bottomWindow.getContentPane()).getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "dismiss");
        ((JComponent)this.bottomWindow.getContentPane()).getActionMap().put("dismiss", this.dismissAction);
        this.typeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = AnnotationEditor.this.typeCombo.getSelectedItem().toString();
                if (AnnotationEditor.this.ann != null && AnnotationEditor.this.ann.getType().equals(string)) {
                    return;
                }
                Integer n = AnnotationEditor.this.ann.getId();
                Annotation annotation = AnnotationEditor.this.ann;
                AnnotationEditor.this.set.remove(AnnotationEditor.this.ann);
                try {
                    AnnotationEditor.this.set.add(n, annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset(), string, annotation.getFeatures());
                    AnnotationEditor.this.setAnnotation(AnnotationEditor.this.set.get(n), AnnotationEditor.this.set);
                    AnnotationEditor.this.setsView.setTypeSelected(AnnotationEditor.this.set.getName(), string, true);
                    AnnotationEditor.this.setsView.setLastAnnotationType(string);
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    throw new GateRuntimeException(invalidOffsetException);
                }
            }
        });
    }

    protected void initGUI() {
        this.solAction = new StartOffsetLeftAction();
        this.sorAction = new StartOffsetRightAction();
        this.eolAction = new EndOffsetLeftAction();
        this.eorAction = new EndOffsetRightAction();
        this.delAction = new DeleteAnnotationAction();
        this.initData();
        this.initBottomWindow(SwingUtilities.getWindowAncestor(this.textView.getGUI()));
        this.initListeners();
        this.hideTimer = new Timer(1500, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnnotationEditor.this.hide();
            }
        });
        this.hideTimer.setRepeats(false);
    }

    public void setAnnotation(Annotation annotation, AnnotationSet annotationSet) {
        this.ann = annotation;
        this.set = annotationSet;
        String string = annotation.getType();
        HashSet hashSet = new HashSet(this.schemasByType.keySet());
        hashSet.add(string);
        hashSet.addAll(annotationSet.getAllTypes());
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList);
        this.typeCombo.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        this.typeCombo.setSelectedItem(string);
        this.featuresEditor.setSchema((AnnotationSchema)this.schemasByType.get(string));
        this.featuresEditor.setTargetFeatures(annotation.getFeatures());
        this.bottomWindow.doLayout();
    }

    public boolean isShowing() {
        return this.bottomWindow.isShowing();
    }

    public void show(boolean bl) {
        this.placeWindows();
        this.bottomWindow.setVisible(true);
        if (bl) {
            this.hideTimer.restart();
        }
    }

    protected void placeWindows() {
        try {
            Rectangle rectangle = this.textPane.modelToView(this.ann.getStartNode().getOffset().intValue());
            Rectangle rectangle2 = this.textPane.modelToView(this.ann.getEndNode().getOffset().intValue());
            Point point = this.textPane.getLocationOnScreen();
            int n = point.x + rectangle.x;
            int n2 = point.y + rectangle2.y + rectangle2.height;
            Rectangle rectangle3 = this.textPane.getVisibleRect();
            int n3 = point.y + rectangle3.y + rectangle3.height;
            this.bottomWindow.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            boolean bl = false;
            if (this.bottomWindow.getSize().width > dimension.width) {
                this.bottomWindow.setSize(dimension.width, this.bottomWindow.getSize().height);
                bl = true;
            }
            if (this.bottomWindow.getSize().height > dimension.height) {
                this.bottomWindow.setSize(this.bottomWindow.getSize().width, dimension.height);
                bl = true;
            }
            if (bl) {
                this.bottomWindow.validate();
            }
            int n4 = dimension.width - this.bottomWindow.getSize().width;
            if (n3 + this.bottomWindow.getSize().height > dimension.height) {
                n3 = dimension.height - this.bottomWindow.getSize().height;
            }
            if (n2 > n3) {
                n2 = n3;
            }
            if (n > n4) {
                n = n4;
            }
            this.bottomWindow.setLocation(n, n2);
        }
        catch (BadLocationException badLocationException) {
            throw new GateRuntimeException(badLocationException);
        }
    }

    protected void moveAnnotation(AnnotationSet annotationSet, Annotation annotation, Long l, Long l2) throws InvalidOffsetException {
        AnnotationSetsView.TypeHandler typeHandler = this.setsView.getTypeHandler(annotationSet.getName(), annotation.getType());
        Integer n = annotation.getId();
        annotationSet.remove(annotation);
        annotationSet.add(n, l, l2, annotation.getType(), annotation.getFeatures());
        this.setAnnotation(annotationSet.get(n), annotationSet);
        AnnotationSetsView.TypeHandler typeHandler2 = this.setsView.getTypeHandler(annotationSet.getName(), annotation.getType());
        if (typeHandler2 != typeHandler) {
            typeHandler2.setSelected(false);
            typeHandler2.colour = typeHandler.colour;
            typeHandler2.setSelected(typeHandler.isSelected());
        }
    }

    public void hide() {
        this.bottomWindow.setVisible(false);
    }

    protected class ApplyAction
    extends AbstractAction {
        public ApplyAction() {
            super("Apply");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AnnotationEditor.this.hide();
        }
    }

    protected class DismissAction
    extends AbstractAction {
        public DismissAction() {
            super("");
            Icon icon = UIManager.getIcon("InternalFrame.closeIcon");
            if (icon == null) {
                icon = MainFrame.getIcon("exit");
            }
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Dismiss");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AnnotationEditor.this.hide();
        }
    }

    protected class DeleteAnnotationAction
    extends AnnotationAction {
        public DeleteAnnotationAction() {
            super("Delete", MainFrame.getIcon("remove-annotation"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AnnotationEditor.this.set.remove(AnnotationEditor.this.ann);
            AnnotationEditor.this.hide();
        }
    }

    protected class EndOffsetRightAction
    extends AnnotationAction {
        public EndOffsetRightAction() {
            super("<html><b>Extend</b><br><small>SHIFT = 5 characters, CTRL-SHIFT = 10 characters</small></html>", MainFrame.getIcon("extend-right"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            long l;
            long l2 = AnnotationEditor.this.textView.getDocument().getContent().size() - 1L;
            int n = 1;
            if ((actionEvent.getModifiers() & 1) > 0) {
                n = 5;
                if ((actionEvent.getModifiers() & 2) > 0) {
                    n = 10;
                }
            }
            if ((l = AnnotationEditor.this.ann.getEndNode().getOffset() + (long)n) > l2) {
                l = l2;
            }
            try {
                AnnotationEditor.this.moveAnnotation(AnnotationEditor.this.set, AnnotationEditor.this.ann, AnnotationEditor.this.ann.getStartNode().getOffset(), new Long(l));
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new GateRuntimeException(invalidOffsetException);
            }
        }
    }

    protected class EndOffsetLeftAction
    extends AnnotationAction {
        public EndOffsetLeftAction() {
            super("<html><b>Shrink</b><br><small>SHIFT = 5 characters, CTRL-SHIFT = 10 characters</small></html>", MainFrame.getIcon("extend-left"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            long l;
            long l2 = AnnotationEditor.this.ann.getStartNode().getOffset();
            int n = 1;
            if ((actionEvent.getModifiers() & 1) > 0) {
                n = 5;
                if ((actionEvent.getModifiers() & 2) > 0) {
                    n = 10;
                }
            }
            if ((l = AnnotationEditor.this.ann.getEndNode().getOffset() - (long)n) < l2) {
                l = l2;
            }
            try {
                AnnotationEditor.this.moveAnnotation(AnnotationEditor.this.set, AnnotationEditor.this.ann, AnnotationEditor.this.ann.getStartNode().getOffset(), new Long(l));
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new GateRuntimeException(invalidOffsetException);
            }
        }
    }

    protected class StartOffsetRightAction
    extends AnnotationAction {
        public StartOffsetRightAction() {
            super("<html><b>Shrink</b><br><small>SHIFT = 5 characters, CTRL-SHIFT = 10 characters</small></html>", MainFrame.getIcon("extend-right"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            long l;
            long l2 = AnnotationEditor.this.ann.getEndNode().getOffset();
            int n = 1;
            if ((actionEvent.getModifiers() & 1) > 0) {
                n = 5;
                if ((actionEvent.getModifiers() & 2) > 0) {
                    n = 10;
                }
            }
            if ((l = AnnotationEditor.this.ann.getStartNode().getOffset() + (long)n) > l2) {
                l = l2;
            }
            try {
                AnnotationEditor.this.moveAnnotation(AnnotationEditor.this.set, AnnotationEditor.this.ann, new Long(l), AnnotationEditor.this.ann.getEndNode().getOffset());
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new GateRuntimeException(invalidOffsetException);
            }
        }
    }

    protected class StartOffsetLeftAction
    extends AnnotationAction {
        public StartOffsetLeftAction() {
            super("<html><b>Extend</b><br><small>SHIFT = 5 characters, CTRL-SHIFT = 10 characters</small></html>", MainFrame.getIcon("extend-left"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            long l;
            Annotation annotation = AnnotationEditor.this.ann;
            int n = 1;
            if ((actionEvent.getModifiers() & 1) > 0) {
                n = 5;
                if ((actionEvent.getModifiers() & 2) > 0) {
                    n = 10;
                }
            }
            if ((l = AnnotationEditor.this.ann.getStartNode().getOffset() - (long)n) < 0L) {
                l = 0L;
            }
            try {
                AnnotationEditor.this.moveAnnotation(AnnotationEditor.this.set, AnnotationEditor.this.ann, new Long(l), AnnotationEditor.this.ann.getEndNode().getOffset());
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new GateRuntimeException(invalidOffsetException);
            }
        }
    }

    protected abstract class AnnotationAction
    extends AbstractAction {
        public AnnotationAction(String string, Icon icon) {
            super("", icon);
            this.putValue("ShortDescription", string);
        }
    }
}

